/* Project SWORD
   V2.0

   SubSystem : Quite sofisticated tools
   File      : Src/Tools/Phases.CC
   Author    : Eric NICOLAS
   Overview  : Execution phases trace
   UpDate    : Oct 23, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"
#include "Tools/WinTools.H"
#include "Tools/Phases.H"

//---------------------------------------------------------------------------
// TPhaseWindow : Fenetre d'affichage des phases

short RegTPhaseWindow;
char *IdentTPhaseWindow = "TPhaseWindow";

TPhaseWindow::TPhaseWindow() : TToolWindow(200,90,"Execution...")
{ Init(NULL);
}

TPhaseWindow::TPhaseWindow(char *Name) :
    TToolWindow(200,90,"Execution...")
{ Init(Name);
}

void TPhaseWindow::Init(char *Name)
{ Register=RegTPhaseWindow;
  Ident=IdentTPhaseWindow;
  Insert(new TStaticText(10, 31, 180, 15, Name));
  Insert(Gauge=new TGauge(10, 60, 180, 20));
}

TPhaseWindow::~TPhaseWindow(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TPhaseWindow::Draw(TRect& )
{ SetSysColor(GetColor(LightGray));
  Bar(5,26,9,84);
  Bar(190,26,194,84);
  Bar(10,26,189,30);
  Bar(10,46,189,59);
  Bar(10,80,189,84);
}

//---------------------------------------------------------------------------
// Variables locales

#define MaxPhaseWindows 20

static int           NbPhaseWindows;
static TPhaseWindow *PhaseWindows[MaxPhaseWindows];

//---------------------------------------------------------------------------
// Utilisation des phases d'excution

void BeginPhase(char *Name)
{ if (NbPhaseWindows==MaxPhaseWindows)
  { // Erreur : plus de phases disponibles
  }
  PhaseWindows[NbPhaseWindows]=new TPhaseWindow(Name);
  Desktop->Insert(PhaseWindows[NbPhaseWindows]);
  Desktop->ShowDrawingNow();
  NbPhaseWindows++;
}

void AvancePhase(int Avance)
{ if (NbPhaseWindows==0)
  { // Erreur : aucune phase en cours
  }
  PhaseWindows[NbPhaseWindows-1]->Gauge->SetValue(Avance);
  Desktop->ShowDrawingNow();
}

void EndPhase(void)
{ if (NbPhaseWindows==0)
  { // Erreur : aucune phase en cours
  }
  NbPhaseWindows--;
  delete PhaseWindows[NbPhaseWindows];
  Desktop->ShowDrawingNow();
  if (NbPhaseWindows==0) Desktop->SetCommand(cmUpdateMouse);
}

//---------------------------------------------------------------------------
// Init/Done de l'unit PHASE

void InitPhases(void)
{ NbPhaseWindows=0;
}

void DonePhases(void)
{
}
