// choosedr.h - defines directory browse class - choose_dir.
//    Copyright (C) 2000 Laurynas Biveinis <lauras@softhome.net>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
#ifndef CHOOSEDR_H_
#define CHOOSEDR_H_

#include "global.h"

#ifdef HAVE_TV_H
#  define Uses_TDialog
#  define Uses_TDirListBox
#  define Uses_TEvent
#  define Uses_TInputLine
#  include <tv.h>
#endif

class choose_dir : public TDialog
{
   public:
      enum { no_new_button = 0, with_new_button };
      
      choose_dir(const char * start_dir, const int new_button);
      bool            get_dir(char * directory);
      virtual void    handleEvent(TEvent & event);
      virtual void    shutDown();
      virtual Boolean valid(ushort command);

   private:

      TInputLine  * dir_input;
      TDirListBox * dir_list;
};

#endif // #ifndef CHOOSEDR_H_
