#! /bin/bash
#
# $Id: pmstub.sh,v 1.2 2001/04/18 00:11:22 richdawe Exp $
#
# pmstub.sh, Copyright (C) 1999, 2001 by Richard Dawe
#
# Add a specified protected-mode stub to a specified file. For DJGPP programs
# this can be used to allow the program to run without requiring a DPMI server
# to be installed, by having the server built into the program.

INPUT_IMAGE=$1
HOST_OS=$2
PMODE_STUB=$3

# No host OS => no idea what we should do.
if [ "a$HOST_OS" = "a" ]; then
    exit 0
fi

# Can we find the P-mode stub? If not, abort.
if [ ! -x $PMODE_STUB ]; then
    echo "ABORTED: Protected mode stub '$PMODE_STUB' not found/executable"
    exit 0
fi

# Don't do anything if there's no P-mode stub.
if [ "a$PMODE_STUB" = "a" ]; then
    echo "ABORTED: No protected mode stub specified"
    exit 0
fi

# Handle the operation appropriately
case $HOST_OS in
    msdosdjgpp)
	OUTPUT_IMAGE="$INPUT_IMAGE.exe"
	echo "Adding DPMI server stub to $OUTPUT_IMAGE"
	exe2coff $OUTPUT_IMAGE
	cat $PMODE_STUB $INPUT_IMAGE > $OUTPUT_IMAGE
	;;

    *)
    exit 0
    ;;
esac

exit 0
