/* Copyright (C) 1996,1997,1998,1999 by Salvador E. Tropea (SET),
   see copyrigh file for details */
// That's the first include because is used to configure the editor.
#include <ceditint.h>

#include <stdlib.h>
#include <stdio.h>

#define Uses_TDialog
#define Uses_TDeskTop
#define Uses_TProgram
#define Uses_TApplication
#define Uses_TObject
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_THistory
#define Uses_TRect
#define Uses_TCheckBoxes
#define Uses_TRadioButtons
#define Uses_TButton
#define Uses_MsgBox
#define Uses_TSItem
#define Uses_TStringCollection
#define Uses_fpstream
#define Uses_TKeys
#define Uses_TStaticText
#define Uses_TCEditor_Internal
#define Uses_TCEditWindow
#define Uses_TInputLinePiped
#define Uses_TCEditor_Commands

// EasyDiag requests
#define Uses_TSButton
#define Uses_TSStaticText
#define Uses_TSHzGroup
#define Uses_TSInputLinePiped
#define Uses_TSInputLine
#define Uses_TSCheckBoxes
#define Uses_TSRadioButtons
#define Uses_TSLabel
#define Uses_TSSortedListBox
#define Uses_TSVeGroup
#define Uses_TSLabelCheck
#define Uses_TSLabelRadio
#define Uses_TSStringableListBox

// First include creates the dependencies
#include <easydia1.h>
#include <ceditor.h>
// Second request the headers
#include <easydiag.h>

#include <edhists.h>

#include <setconst.h>
#include <editcoma.h>

#include <stdarg.h>
#include <strstream.h>
#include <iomanip.h>

#define Uses_SETAppConst
#include <setapp.h>

/**[txh]********************************************************************

  Description:
  This dialog is used to configure the RegEx options. They are: style
(basic,extended and perl), replace (normal or tagged) and optimize (allow
optimization of the regex when the search isn't a regex).

***************************************************************************/

TDialog *createRegExOpsDialog()
{
 TSViewCol *col=new TSViewCol(new TDialog(TRect(1,1,1,1),_("Regular Expressions Options")));

 TSLabel *Style=new TSLabel(_("RegEx style"),
                            new TSRadioButtons(new TSItem(_("~B~asic POSIX"),
                                               new TSItem(_("~E~xtended POSIX"),
 #ifdef SUP_PCRE
                                               new TSItem(_("~P~erl Compatible"),
                                                          0)))));
 #else
                                                          0))));
 #endif

 TSLabel *Replace=new TSLabel(_("Replace text"),
                            new TSRadioButtons(new TSItem(_("~N~ormal text"),
                                               new TSItem(_("~D~olar tags"),
                                                          0))));

 TSLabel *Optimize=new TSLabel(_("Optimize"),
                            new TSRadioButtons(new TSItem(_("~T~ry to use normal search"),
                                               new TSItem(_("E~v~er use RegEx"),
                                                          0))));

 TSVeGroup *rightG=new TSVeGroup(Replace,Optimize);
 rightG->makeSameW();
/* int w=max(Replace->w,Optimize->w);
 Replace->w=Optimize->w=w;*/

 col->insert(2,2,Style);
 col->insert(xTSRightOf,2,rightG,Style);
 /*col->insert(xTSRightOf,2,Replace,Style);
 col->insert(xTSRightOf,yTSUnder,Optimize,Style,Replace);*/
 EasyInsertOKCancel(col);

 TDialog *d=col->doIt();
 delete col;

 d->options|=ofCentered;
 d->helpCtx=hcRegExOptions;
 return d;
}

const int cmRegExOptions=0x2218;

class TDialogFind : public TDialog
{
public:
 TDialogFind(const TRect& bounds, const char *aTitle, void *aBox) :
   TDialog(bounds,aTitle),
   TWindowInit(&TDialogFind::initFrame),
   boxRegEx(aBox) {}
 virtual void handleEvent(TEvent& event);

protected:
 void *boxRegEx;
};

void TDialogFind::handleEvent(TEvent& event)
{
 TDialog::handleEvent(event);
 if (event.what==evCommand && event.message.command==cmRegExOptions)
   {
    execDialog(createRegExOpsDialog(),boxRegEx);
    clearEvent(event);
    return;
   }
}

#define findFixWidth 42

// Eng: CEFGIKOSTUWX
TDialog *createFindDialog(void *regexBox)
{
 TSViewCol *col=new TSViewCol(new TDialogFind(TRect(1,1,1,1),_("Find"),regexBox));

 TSView::yDefSep=0;
 TSInputLinePiped *textF=new TSInputLinePiped(80,1,hID_TextSearchEditor,findFixWidth);
 TSLabel *TextToFind=new TSLabel(_("~T~ext to find"),textF);

 TSLabel *Options=TSLabelCheck(__("Options"),__("~C~ase sensitive"),
                               __("~W~hole words only"),__("Regular e~x~pressions"),
                               __("Only ~i~nside comments"),__("Only o~u~tside comments"),
                               0);
 Options->setWidth(findFixWidth);

 TSRadioButtons *origin = new TSRadioButtons(
                          new TSItem( _("~G~lobal"),
                          new TSItem( _("~S~elected text"), 0 )),findFixWidth);
 TSLabel *Origin=new TSLabel(_("Scope"),origin);

 TSRadioButtons *scope =new TSRadioButtons(
                        new TSItem( _("~F~rom cursor"),
                        new TSItem( _("~E~ntire scope"), 0 )),findFixWidth);
 TSLabel *Scope=new TSLabel(_("Origin"),scope);
 TSView::yDefSep=1;

 TSHzGroup *but123=new TSHzGroup(new TSButton(_("O~K~"),cmOK,bfDefault),
                   new TSHzGroup(new TSButton(_("Cancel"),cmCancel),
                   new TSButton(_("RegEx ~O~ps"),cmRegExOptions)));

 col->insert(2,2,TextToFind);
 col->insert(2,yTSUnder,Options,0,TextToFind);
 col->insert(2,yTSUnder,Origin,0,Options);
 col->insert(2,yTSUnder,Scope,0,Origin);
 col->insert(xTSCenter,yTSDown,but123);

 TDialog *d=col->doIt();
 delete col;

 d->options|=ofCentered;
 d->helpCtx=cmcFind;
 return d;
}


#define FixWTest 34

// Eng: ACEFGIKNOPRSTWX
TDialog *createReplaceDialog(void *regexBox)
{
 TSViewCol *col=new TSViewCol(new TDialogFind(TRect(1,1,1,1),_("Replace"),regexBox));

 TSInputLinePiped *textF=new TSInputLinePiped(80,1,hID_TextSearchEditor,FixWTest);
 TSLabel *TextToFind=new TSLabel(_("~T~ext to find"),textF);

 TSInputLinePiped *textN=new TSInputLinePiped(80,1,hID_TextReplaceEditor,FixWTest);
 TSLabel *newText=new TSLabel(_("~N~ew text"),textN);

 TSLabel *Options=TSLabelCheck(
                  __("Options"),__("~C~ase sensitive"),__("~W~hole words only"),
                  __("Regular e~x~pressions"),__("Only ~i~nside comments"),
                  __("Only o~u~tside comments"),__("~P~rompt on replace"),
                  __("~R~eplace all"),0);
 Options->setWidth(FixWTest);

 TSRadioButtons *origin = new TSRadioButtons(
                          new TSItem( _("~G~lobal"),
                          new TSItem( _("~S~elected text"), 0 )),FixWTest);
 TSLabel *Origin=new TSLabel(_("Scope"),origin);

 TSRadioButtons *scope =new TSRadioButtons(
                        new TSItem( _("~F~rom cursor"),
                        new TSItem( _("~E~ntire scope"), 0 )),FixWTest);
 TSLabel *Scope=new TSLabel(_("Or~i~gin"),scope);

 TSHzGroup *but123=new TSHzGroup(new TSButton(_("O~K~"),cmOK,bfDefault),
                   new TSHzGroup(new TSButton(_("Replace ~A~ll"),cmYes),
                   new TSHzGroup(new TSButton(_("Cancel"),cmCancel),
                   new TSButton(_("RegEx ~O~ps"),cmRegExOptions))));

 col->insert(2,2,TextToFind);
 col->insert(xTSRightOf,2,newText,TextToFind);
 col->insert(2,yTSUnder,Options,0,TextToFind);
 col->insert(xTSRightOf,yTSUnder,Origin,TextToFind,newText);
 col->insert(xTSRightOf,yTSUnder,Scope,TextToFind,Origin);
 col->insert(xTSCenter,yTSDown,but123);

 TDialog *d=col->doIt();
 delete col;

 d->options|=ofCentered;
 d->helpCtx=cmcReplace;
 return d;
}


TDialog *createGotoLineDialog()
{
 TSViewCol *col=new TSViewCol(new TDialog(TRect(1,1,1,1),_("Goto Line")));

 TSInputLine *lineInp=new TSInputLine(10,(ushort)hID_GotoLine);
 TSHzLabel *lineLabel=new TSHzLabel(_("Desired line"),lineInp);

 col->insert(2,2,lineLabel);
 EasyInsertOKCancel(col,3);

 TDialog *d=col->doIt();
 delete col;

 d->options|=ofCentered;
 d->helpCtx=cmcGotoEditorLine;
 return d;
}


TDialog *createSetLocalOptions()
{ // English: ABCDEFHIKLMNOPRSTUWY 12345
  // BEGJQVXZ
 TSViewCol *col=new TSViewCol(new TDialog(TRect(1,1,1,1),_("Local Options")));

 TSLabel *Options=TSLabelCheck(__("Options ~3~"),__("~O~verwrite"),__("~A~utoindent"),
         __("~U~se real tabs (ASCII 9)"),__("~P~ersistent blocks"),__("~I~ntelligent C indent"),
         __("~C~olumn cursor"),__("~R~ow cursor"),__("~M~atch pair highlight"),
         __("Match pair on the fly ~4~"),__("Tra~n~sparent Blocks"),
         __("Optimal ~F~ill"),__("~W~rap words"),__("S~e~e tabs"),
         __("Don't move inside ta~b~s"),__("Tab indents ~5~"),0);

 #define VeSHLW 30
 TSRadioButtons *shl=new TSRadioButtons(
     new TSItem(_("Off ~1~"),
     new TSItem(_("C++ st~y~le"),
     new TSItem(_("Pa~s~cal style"),
     new TSItem(_("C~l~ipper style"),
     new TSItem(_("User ~d~efined"),0))))),VeSHLW);
 TSLabel *Shl=new TSLabel(_("Syntax ~H~ighlight"),shl);
 TSSortedListBox *ListaH=new TSSortedListBox(VeSHLW,Options->h-Shl->h,tsslbVertical);
 TSVeGroup *ShlVe=new TSVeGroup(Shl,ListaH,0);

 TSInputLine *tab=new TSInputLine(3);
 TSHzLabel *Tab=new TSHzLabel(_("~T~ab size"),tab);

 TSInputLine *wcol=new TSInputLine(4);
 TSHzLabel *Wcol=new TSHzLabel(_("Wrap column ~2~"),wcol);

 col->insert(2,1,Options);
 col->insert(xTSRightOf,1,ShlVe,Options);
 col->insert(2,yTSUnder,Tab,0,Options);
 col->insert(xTSRightOf,yTSUnder,Wcol,Tab,Options);
 EasyInsertOKCancel(col,6);

 TDialog *d=col->doIt();
 delete col;

 d->options|=ofCentered;
 d->helpCtx=cmcSetLocalOptions;
 return d;
}


// Shortcuts: English: ABCDEFIKLMNOPRSTUW 1
TDialog *createSetGlobalOptions()
{
 TSViewCol *col=new TSViewCol(new TDialog(TRect(1,1,1,1),_("Global Options")));

 TSLabel *Options=TSLabelCheck(__("Options"),
          __("~A~utoindent"),
          __("~U~se tabs"),
          __("~P~ersistent blocks"),
          __("~I~ntelligent C indent"),
          __("~C~olumn cursor"),
          __("~R~ow cursor"),
          __("~M~atch pair highlight"),
          __("Match pair on the fly ~1~"),
          __("~D~on't move the cursor on Paste"),
          __("Tra~n~sparent Blocks"),
          __("Optimal ~F~ill"),
          __("~W~rap words"),
          __("~S~croll Lock centers"),
          __("S~e~e tabs"),
          __("Don't move inside ta~b~s"),
          0);

 TSLabel *Tab=new TSLabel(_("~T~ab size"),new TSInputLine(3));
 TSLabel *Wcol=new TSLabel(_("Wrap co~l~umn"),new TSInputLine(4));
 TSHzGroup *Inputs=new TSHzGroup(Tab,Wcol,3);
 Inputs->ySep=0;

 TSHzGroup *but123=new TSHzGroup(new TSButton(_("T~o~ all"), cmYes),
                   new TSHzGroup(new TSButton(_("O~K~"), cmOK, bfDefault),
                   new TSButton(_("Cancel"), cmCancel)));

 col->insert(2,1,Options);
 col->insert(xTSCenter,yTSUnder,Inputs,0,Options);
 col->insert(xTSCenter,yTSDown,but123);

 TDialog *d=col->doIt();
 delete col;

 d->options|=ofCentered;
 d->helpCtx=cmcSetGlobalOptions;
 return d;
}

TDialog *createYesNoAllCancel(TPoint *size, TPoint *cursor)
{
 TSViewCol *col=new TSViewCol(new TDialog(TRect(0,0,0,0),_("Search hit")));

 TSStaticText *text=new TSStaticText(_("Replace this occurence?"));
 TSHzGroup *buttons=new TSHzGroup(new TSButton(_("~Y~es"),cmYes,bfDefault),
                    new TSHzGroup(new TSButton(_("~N~o"),cmNo),
                    new TSHzGroup(new TSButton(_("~A~ll"),cmOK),
                                  new TSButton(_("Cancel"),cmCancel))));

 col->insert(xTSCenter,2,text);
 col->insert(xTSCenter,yTSUnder,buttons,0,text);
 TDialog *d=col->doIt();
 delete col;

 // Avoid placing the dialog over the cursor
 int xOff=(size->x-d->size.x)/2;
 int yOff=(size->y-d->size.y)/2;
 // +1 because the shadow
 if (yOff<=cursor->y && yOff+d->size.y+1>=cursor->y)
    yOff=cursor->y+1;
 d->moveTo(xOff,yOff);
 return d;
}


TDialog *createHTMLExportOps()
{// BCDFLMO
 TSViewCol *col=new TSViewCol(new TDialog(TRect(0,0,0,0),_("Export Options")));

 TSVeGroup *Ops=new TSVeGroup(
                TSLabelCheck(__("~O~ptions"),
                             __("~F~ile name as title"),
                             __("Same ~b~ackground color as the editor"),
                             __("~M~onospacied font"),
                             __("Bo~l~d attribute"),0),
                TSLabelRadio(__("Colors"),__("Use ~c~olors"),
                             __("~D~on't use colors"),0)
                );

 Ops->makeSameW();

 col->insert(2,1,Ops);
 EasyInsertOKCancel(col);

 TDialog *d=col->doIt();
 delete col;

 d->options|=ofCentered;
 d->helpCtx=cmeExportAsHTML;
 return d;
}

TDialog *createPMChoose()
{// BFLMO
 TSViewCol *col=new TSViewCol(new TDialog(TRect(0,0,0,0),_("Pseudo Macros")));

 col->insert(2,1,new TSStringableListBox(40,16,tsslbVertical));
 EasyInsertOKCancel(col);

 TDialog *d=col->doIt();
 delete col;

 d->options|=ofCentered;
 d->helpCtx=cmcChoosePMacrosList;
 return d;
}

TDialog *createArbitraryIndent(int len)
{
 TSViewCol *col=new TSViewCol(new TDialog(TRect(1,1,1,1),_("Arbitrary indent")));
 TSLabel *label=new TSLabel(_("Indentation text"),new TSInputLinePiped(len,60));
 col->insert(2,1,label);
 EasyInsertOKCancel(col);
 TDialog *d=col->doIt(); delete col; d->options|=ofCentered;
 d->helpCtx=cmcArbitraryIndent;
 return d;
}
