/*

  TEST1.C tilemap example --- Copyright 1999, Henrik Stokseth.

  This example shows how to scroll a tilemap.

*/

#include <allegro.h>
#include <stdio.h>
#include "tilemap.h"
#include "sample.h"

int main()
{
  // declare & perhaps initialize some variables
  BITMAP   *screenbuffer;
  TILEMAP  *mymap;
  DATAFILE *mydata;
  int      layer, x = 0, y = 0;
  int      wanttoexit = FALSE;

  // initialize allegro
  allegro_init();
  install_keyboard();
  set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0);
  screenbuffer = create_bitmap(SCREEN_W, SCREEN_H);

  // load map, palette and sprites
  mydata = load_datafile("sample.dat");
  mymap  = load_tilemap("sample.map");

  correct_tilemap(mymap, mydata);

  // if there are some errors with the loading, quit with a message
  if(!mymap || !mydata)
  {
    set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
    printf("error loading files ...");
    exit(1);
  }

  // view tilemap
  set_palette(mydata[PAL_GAME].dat);
  while(!wanttoexit)
  {
    // display tilemap
    clear(screenbuffer);
    for(layer=0; layer < mymap->layers; layer++)
    {
      draw_tilemap_layer(screenbuffer, mydata, mymap, layer, x, y);
    }
    blit(screenbuffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    
    // await user input
    while(!keypressed());

    // check user input
    if(key[KEY_UP])    y++;
    if(key[KEY_DOWN])  y--;
    if(key[KEY_LEFT])  x++;
    if(key[KEY_RIGHT]) x--;
    if(key[KEY_ESC])   wanttoexit = TRUE;
  }

  // flush keyboard buffer
  clear_keybuf();
  
  // unload map and sprites
  destroy_tilemap(mymap);
  destroy_bitmap(screenbuffer);
  unload_datafile(mydata);

  return 0;
}

