/*

  TEST2.C tilemap example --- Copyright 1999, Henrik Stokseth.

  This example show how to use tilemaps in a simple game.

*/

#include <allegro.h>
#include <stdio.h>
#include "tilemap.h"
#include "sample.h"

#define  UP        1
#define  DOWN      2
#define  LEFT      3
#define  RIGHT     4
#define  FADESPEED 5

BITMAP     *screenbuffer;
TILEMAP    *mymap;
DATAFILE   *mydata;
RLE_SPRITE *character;

int x = 16*10, y = 16*10;
int wanttoexit = FALSE;
int mx=0,my=0;
int tile_type;
  
void update_screen()
{
  clear(screenbuffer);
  draw_tilemap_layer(screenbuffer, mydata, mymap, 0, mx, my);
  draw_rle_sprite(screenbuffer, character, mx+x, my+y);
  blit(screenbuffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}

void move_hero(int direction)
{
  int frame=0;
  
  // bounds checking
  switch(direction)
  {
    case UP:
      if(y <= 0) return;
    break;
    case DOWN:
      if(y+character->w >= mymap->ysize*mymap->ygrid) return;
    break;
    case LEFT:
      if(x <= 0) return;
    break;
    case RIGHT:
      if(x+character->h >= mymap->xsize*mymap->xgrid) return;
    break;
  }

  // what tile type will we be stepping on?
  switch(direction)
  {
    case UP:
      tile_type = get_sprite_number(mymap,0,x/mymap->xgrid,y/mymap->ygrid-1);
    break;
    case DOWN:
      tile_type = get_sprite_number(mymap,0,x/mymap->xgrid,y/mymap->ygrid+1);
    break;
    case LEFT:
      tile_type = get_sprite_number(mymap,0,x/mymap->xgrid-1,y/mymap->ygrid);
    break;
    case RIGHT:
      tile_type = get_sprite_number(mymap,0,x/mymap->xgrid+1,y/mymap->ygrid);
    break;
  }
    
  // don't allow character to walk on certain tiles...
  switch(tile_type)
  {
    case RLE_FOREST:
    case RLE_MOUNTAIN:
    case RLE_OCEAN:
    case RLE_OCEAN_N:
    case RLE_OCEAN_S:
    case RLE_OCEAN_W:
    case RLE_OCEAN_E:
    case RLE_OCEAN_SW:
    case RLE_OCEAN_SE:
    case RLE_OCEAN_NW:
    case RLE_OCEAN_NE:
      return;
    break;
  }

  // well ok, then go...
  switch(direction)
  {
    case UP:
      for(frame=0;frame<16; frame++)
      {
        character=mydata[RLE_HERO_UP1].dat;
        y--;
        if(my+y<40) my++;
        update_screen();
      }
    break;
    case DOWN:
      for(frame=0; frame<16; frame++)
      {
        character=mydata[RLE_HERO_DOWN1].dat;
        y++;
        if(my+y>SCREEN_H-40) my--;
        update_screen();
      }
    break;
    case LEFT:
      for(frame=0; frame<16; frame++)
      {
        character=mydata[RLE_HERO_LEFT1].dat;
        x--;
        if(mx+x<40) mx++;
        update_screen();
      }
    break;
    case RIGHT:
      for(frame=0; frame<16; frame++)
      {
        character=mydata[RLE_HERO_RIGHT1].dat;
        x++;
        if(mx+x>SCREEN_W-40) mx--;
        update_screen();
      }
    break;
  }
}

void use_sword()
{
}

int main()
{
  // initialize allegro
  allegro_init();
  install_keyboard();
  set_gfx_mode(GFX_AUTODETECT, 320, 240, 0, 0);
  screenbuffer = create_bitmap(SCREEN_W, SCREEN_H);

  // load map, palette and sprites
  mydata = load_datafile("sample.dat");
  mymap  = load_tilemap("sample.map");

  correct_tilemap(mymap, mydata);

  // if there are some errors with the loading, quit with a message
  if(!mymap || !mydata)
  {
    set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
    printf("error loading files ...");
    exit(1);
  }

  // do some other initializations
  set_palette(mydata[PAL_GAME].dat);
  character = mydata[RLE_HERO_DOWN1].dat;

  while(!wanttoexit)
  {
    // display tilemap
    update_screen();

    // await user input
    while(!keypressed());

    // process user input
    if(key[KEY_UP])         move_hero(UP);
    else if(key[KEY_DOWN])  move_hero(DOWN);
    else if(key[KEY_LEFT])  move_hero(LEFT);
    else if(key[KEY_RIGHT]) move_hero(RIGHT);
    if(key[KEY_ESC])        wanttoexit = TRUE;
    if(key[KEY_SPACE])      use_sword();
  }

  // flush keyboard buffer & fade out
  fade_out(FADESPEED);
  clear_keybuf();

  // unload map and sprites
  destroy_tilemap(mymap);
  destroy_bitmap(screenbuffer);
  unload_datafile(mydata);
  allegro_exit();

  return 0;
}

