/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
/*
 $Id: gpr2mak.cc,v 1.2 1997-09-08 22:51:57+00 rho Exp rho $
*/
#define Uses_TProject
#define Uses_TOptions
#define Uses_TDependency
#define Uses_TDepCollection
#include <libide.h>
#include <stdio.h>

#include <rhutils.h>

#include <rhide.h>

#include <stdlib.h>
#include <locale.h>
#include <string.h>
#ifdef __DJGPP__
#include <crt0.h>
#endif

extern int recursive_make;
Boolean ReadProject(const char *);

Boolean PushProject(const char *,const char *)
{
  return False;
}

void PopProject()
{
}

static __attribute__ ((constructor))
void init_gpr2mak()
{
#ifdef __DJGPP__
  __crt0_load_environment_file("rhide");
#endif
  rhide_load_environment_file("rhide","rhide.env");
}

int main(int argc,char *argv[])
{
  char *outname = NULL;
  char *pname = NULL;
  int i,all_deps=0;
  char *locale_dir = expand_spec("$(LOCALEDIR)",NULL);
#ifndef __DJGPP__
  if (!*locale_dir)
  {
    string_free(locale_dir);
    // get the system default localedir
    char *_locale_dir = BINDTEXTDOMAIN("rhide",NULL);
    if (_locale_dir)
      locale_dir = string_dup(_locale_dir);
    else
      locale_dir = string_dup("");
  }
#endif
  if (!*locale_dir)
  {
    string_free(locale_dir);
    locale_dir = expand_spec("$(DJDIR)",NULL);
    if (*locale_dir)
    {
      string_cat(locale_dir,"/share/locale");
    }
    else
    {
      string_free(locale_dir);
      locale_dir = string_dup("/usr/local/share/locale");
    }
  }
  setlocale(LC_ALL,"");
  BINDTEXTDOMAIN("rhide",locale_dir);
  TEXTDOMAIN("rhide");
  recursive_make = 0;
  for (i=1;i<argc;i++)
  {
    if (strcmp(argv[i],"-r") == 0)
    {
      recursive_make = 1;
    }
    if (strcmp(argv[i],"-r-") == 0)
    {
      recursive_make = 0;
    }
    else if (strcmp(argv[i],"-d") == 0)
    {
      all_deps=1;
    }
    else if (strcmp(argv[i],"-d-") == 0)
    {
      all_deps=0;
    }
    else if (strcmp(argv[i],"-o") == 0)
    {
      i++;
      if (i>=argc)
      {
        fprintf(stderr,_("-o needs an argument\n"));
        return -1;
      }
      outname = argv[i];
    }
    else if (argv[i][0] != '-')
    {
      pname = argv[i];
      break;
    }
  }
  if (!pname)
  {
    fprintf(stderr,_("a projectfile must be given\n"));
    return -2;
  }
  string_dup(project_name,pname);
  if (ReadProject(project_name) == False)
  {
    fprintf(stderr,_("error reading projectfile %s\n"),project_name);
    return -3;
  }
  AllDeps = all_deps;
  WriteMake(outname,argc,argv);
  if (recursive_make && Project.dependencies)
  {
    for (i=0;i<Project.dependencies->getCount();i++)
    {
      TDependency *_dep = (TDependency *)Project.dependencies->at(i);
      if (_dep->compile_id == COMPILE_PROJECT)
      {
        char *dir,*name,*ext,*cmd;
        split_fname(FName(_dep->dest_name),dir,name,ext);
        string_dup(cmd,argv[0]);
        string_cat(cmd," -o");
        string_cat(cmd,dir);
        string_cat(cmd,name);
        string_cat(cmd,".mak ");
        string_cat(cmd,dir);
        string_cat(cmd,name);
        string_cat(cmd,PROJECT_EXT);
        if (recursive_make) string_cat(cmd," -r");
        else string_cat(cmd," -r-");
        if (all_deps) string_cat(cmd," -d");
        else string_cat(cmd," -d-");
        fprintf(stderr,"%s\n",cmd);
        system(cmd);
        string_free(dir);
        string_free(name);
        string_free(ext);
        string_free(cmd);
      }
    }
  }
  return 0;
}

char *WUC()
{
  return NULL;
}

