/***************************************************************

   (c) 1996,1997 by Salvador Eduardo Tropea (SET).
   e-mail: salvador@inti.edu.ar

   You can use this code for any purpose if you don't remove the
original copyright.

 Filename -       Inf.h

 Functions
                  Member functions of following classes
                      THisCollection
                      TStrListBox
                      THelpControlDialog
                      TInfViewer
                      TInfWindow
                      TFindInfDialogRec

***************************************************************/

#if !defined( __Inf_H )
#define __Inf_H

#define Uses_TStreamable
#define Uses_TObject
#define Uses_TPoint
#define Uses_TRect
#define Uses_TEvent
#define Uses_TScroller
#define Uses_TScrollBar
#define Uses_TWindow
#define Uses_TCollection
#define Uses_TListBox
#define Uses_TDialog
#include <tv.h>

#define Uses_TNoCaseStringCollection
#include <infbase.h>

#define MAX_HIST_DEEP 40
#define MAX_NODE_NAME 90


const hcInfView   = 0x2100,
      hcInfSearch = 0x2101,
      hcInfControl= 0x2102,
      hcInfGoto   = 0x2103,
      hcInfChoose = 0x2104,
      hcInfConfig = 0x2105,
      hcInfBookMark = 0x2106;
const cmInfHelp    = 0x2100,
      cmInfControl = 0x2101,
      cmInfBack    = 0x2102,
      cmInfPasteIn = 0x2103,
      cmInfBookM   = 0x2104;

typedef struct
{
 char Name[MAX_NODE_NAME];
 TPoint HisPos;
 int HisSel;
} stHisto;


/***************************************************************

 class THisCollection

 Una TCollection de stHisto.
 It's a TCollection of stHisto.

***************************************************************/

class THisCollection : public TCollection
{

public:

    THisCollection( short aLimit, short aDelta ) :
         TCollection(aLimit, aDelta) {};

private:

    virtual void freeItem( void *item )
        { delete item; }
    virtual const char *streamableName() const
        { return name; }
    virtual void *readItem( ipstream& is );
    virtual void writeItem( void *obj, opstream& os );

protected:

    THisCollection( StreamableInit ) : TCollection ( streamableInit ) {};

public:

    static const char * const name;
    static TStreamable *build() {return new THisCollection( streamableInit );};

};

inline ipstream& operator >> ( ipstream& is, THisCollection& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, THisCollection*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, THisCollection& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, THisCollection* cl )
    { return os << (TStreamable *)cl; }


// TStrListBox

class TStrListBox : public TListBox
{
 public:
 TStrListBox(const TRect& r,ushort l,TScrollBar *a) : TListBox(r,l,a) {};
 void handleEvent(TEvent& event);
};

const cmStrChoose=0x2110;



// THelpControlDialog

const chcdNext=0x2111,
      chcdPrev=0x2112,
      chcdUp=0x2113,
      chcdPrevH=0x2114,
      chcdHide=0x2115,
      chcdHistSel=0x2116;

class THelpControlDialog : public TDialog
{
 public:
 THelpControlDialog(THisCollection *oCol);
 void handleEvent(TEvent& event);
 void getData(void *rec) { *(int *)rec=Comando; };
 void setData(void *rec) { Comando=*(int *)rec; };

 private:
 int Comando;
};

// TBookMarkDialog

const cmbmAddToBookMark=0x2118,
      cmbmDeleteFromBookMark=0x2117,
      cmbmGoTo=0x2119;

class TBookMarkDialog : public TDialog
{
 public:
 TBookMarkDialog(TNoCaseStringCollection *oCol);
 void handleEvent(TEvent& event);
};


// TInfViewer

class TInfViewer : public TScroller
{
public:

    TInfViewer( const TRect&, TScrollBar*, TScrollBar*, TInfFile*, char *,
                char *match );
    ~TInfViewer();

    virtual void changeBounds( const TRect& );
    virtual void draw();
    virtual void scrollDraw();
    virtual void resetCursor();
    virtual TPalette& getPalette() const;
    virtual void handleEvent( TEvent& );
    void makeSelectVisible();
    void makeVisible(TPoint&,int largo);
    void GoEndOfLine(void);
    void UpdateSelection(int X, int Y);
    void MoveToMouse( TPoint m, uchar selMode );
    void lock() { lockCount++; };
    void unlock();

    void switchToTopic( char *, TPoint );
    void switchToTopic( char * );
    void switchToTopic( stHisto *h );

    TInfFile *hFile;
    TInfTopic *topic;
    int selected;

    // Search stuff
    void find();
    void makeSearch();
    int  searchInCurrentTopic(int Linea,int Col,int largo);
    int searchInCurrentFile(int Linea,int Col,int largo);
    int LineStartSelect;
    int LineEndSelect;
    int ColStartSelect;
    int ColEndSelect;
    char *lastSearch;
    char findStr[MAX_NODE_NAME];
    ushort findType;
    ushort findWhere;
    int    TopicInSearch;
    int    FileInSearch;
    Boolean TextSelected;
    stHisto OriginalPlace;
    int OpenVerbose;       // 1 normally, 0 if no warning on open (search)
    int SearchArmed;

    int selRowStart,selRowEnd,selRowStartPoint;
    int selColStart,selColEnd,selColStartPoint;
    Boolean selecting;
    static void (*InsertRoutine)(char *b, long l);
    void PasteToClipboard(void);
    void PasteInclude(void);
    int modeFlags;

    static TNoCaseStringCollection *BookMark;
    void BookMarksDialog(void);

    static int version;

    THisCollection *History;
    int HistPoint;
private:
    void  AddToHistory(char *);
    char *TakeFromHistory(TPoint& Pos);
    void SetTitle(char *File, char *Node);
    char QuickSearch[MAX_NODE_NAME];
    int  QuickLen;
    int  QuickVisPos;
    int  lockCount;
    Boolean mustBeRedrawed;

private:

    virtual const char *streamableName() const
	{ return name; }

protected:

    TInfViewer( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const name;
    static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TInfViewer& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TInfViewer*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TInfViewer& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TInfViewer* cl )
    { return os << (TStreamable *)cl; }


const fitWWord=2, fitCaseSens=1;
const fitInTopic=0, fitInFile=1, fitInDir=2;
const fitNotInTopic=-1;


// TInfWindow

class TInfWindow : public TWindow
{
public:

 TInfWindow( TInfFile*, char *context, char *match=0,
             void (*ir)(char *b, long l)=NULL, Boolean IsTheOne=False );

 virtual TPalette& getPalette() const;
 virtual void close();
 TInfViewer *viewer;
 Boolean isTheOne;

private:

    virtual const char *streamableName() const
	{ return name; }

protected:

    TInfWindow( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const name;
    static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TInfWindow& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TInfWindow*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TInfWindow& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TInfWindow* cl )
    { return os << (TStreamable *)cl; }


// Structure to hold the info returned by the dialog
struct TFindInfDialogRec
{
 TFindInfDialogRec(char *findStr, ushort flags1, ushort flags2)
  {
   strcpy(find,findStr);
   options=flags1;
   ops2=flags2;
  }
 char find[MAX_NODE_NAME];  // for TInputLine of MAX_NODE_NAME
 ushort options; // for TCheckBoxes   Type
 ushort ops2;    // for TRadioButtons Where
};

TDialog *createGoToDialog();

#endif  // __Inf_H
