#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define Uses_TPMCollection
#define Uses_MsgBox
#include <ceditor.h>

/****************************************************************************

   Pseudo Macros

****************************************************************************/

void TPMCollection::freeItem(void *p)
{
 PMacroStr *s=(PMacroStr *)p;
 delete s->str;
 delete s;
}

void *TPMCollection::keyOf(void *p)
{
 return ((PMacroStr *)p)->trigger;
}

static int MeassureTriLine(char *b,unsigned &s,unsigned &e)
{
 int l;
 int in_slash=0;
 char *p=b;

 for (; *b && *b!='"'; b++);
 if (*b==0) return -1;
 s=(unsigned)(b-p);
 b++;
 for (l=0; *b && (*b!='"' || in_slash); b++)
    {
     if (*b=='\\')
        in_slash=1;
     else
       {
        in_slash=0;
        l++;
       }
    }
 if (*b==0) return -2;
 e=(unsigned)(b-p);
 return l;
}

Boolean LoadPseudoMacroFile(char *name, TPMCollection &coll)
{
 FILE *f;
 char buf[256];
 char *sep="\"",*s;
 int Trs=0,partial;
 unsigned l,start,end,total=0;
 unsigned mode,bit;
 PMacroStr *nDef;
 long startDef;

 if (!(&coll) || (f=fopen(name,"rt"))==NULL)
    return False;

 fgets(buf,250,f);
 do
  {
   if (buf[0]==0 || buf[0]==';' || buf[0]=='\n')
     {
      fgets(buf,250,f);
      continue;
     }
   if (strncmp(buf,"Trigger:",8)!=0)
     {
      messageBox(_("Macro definition don't start with Trigger"),mfError | mfOKButton);
      fclose(f);
      return False;
     }
   strtok(buf,sep);
   s=strtok(NULL,sep);
   if (s==NULL || strlen(s)!=2)
     {
      messageBox(_("Missing Trigger sequence or too short"),mfError | mfOKButton);
      fclose(f);
      return False;
     }
   nDef=new PMacroStr;
   if (!nDef)
     {
      fclose(f);
      return False;
     }
   nDef->trigger[0]=s[0];
   nDef->trigger[1]=s[1];
   nDef->trigger[2]=0;

   // Process the mode keyword
   fgets(buf,250,f);
   if (strncmp(buf,"Mode:",5)!=0)
     {
      messageBox(_("Macro definition without mode keyword"),mfError | mfOKButton);
      fclose(f);
      return False;
     }
   for (s=buf+5; *s!=0 && isspace(*s); s++);
   for (l=0,mode=0,bit=1; l<5; l++,bit<<=1)
      {
       if ((*s!='0' && *s!='1') || (l!=4 && s[1]!=','))
         {
          messageBox(_("Wrong mode definition in pseudo macro."),mfError | mfOKButton);
          fclose(f);
          return False;
         }
       if (*s=='1')
          mode|=bit;
       s+=2;
      }
   nDef->flags=mode;
   nDef->str=0; // Is loaded later

   l=0;
   startDef=ftell(f);
   while (!feof(f))
     {
      fgets(buf,250,f);
      if (feof(f)) break;
      if (buf[0]==0 || buf[0]==';' || buf[0]=='\n')
         continue;
      if (buf[0]=='T') break;
      partial=MeassureTriLine(buf,start,end);
      switch (partial)
        {
         case -1:
              messageBox(_("Missing start in pseudo macro"),mfError | mfOKButton);
              fclose(f);
              return False;

         case -2:
              messageBox(_("Missing end in pseudo macro"),mfError | mfOKButton);
              fclose(f);
              return False;

         default: l+=partial;
        }
     }
   if (l==0)
     {
      messageBox(_("Empty pseudo macro"),mfError | mfOKButton);
      fclose(f);
      return False;
     }
   fseek(f,startDef,SEEK_SET);
   s=nDef->str=new char[l+1];
   while (!feof(f))
     {
      fgets(buf,250,f);
      if (feof(f)) break;
      if (buf[0]==0 || buf[0]==';' || buf[0]=='\n')
         continue;
      if (buf[0]=='T') break;
      MeassureTriLine(buf,start,end);
      int in_slash;
      for (in_slash=0,l=start+1; l<end; l++)
         {
          if (!in_slash && buf[l]=='\\')
             in_slash=1;
          else
            {
             if (in_slash)
               {
                in_slash=0;
                switch (buf[l])
                  {
                   case 'a': *s='\a';
                             break;
                   case 'f': *s='\f';
                             break;
                   case 'v': *s='\v';
                             break;
                   case '\\': *s='\\';
                             break;
                   case 'n': *s='\n';
                             break;
                   case 'b': *s='\b';
                             break;
                   case 't': *s='\t';
                             break;
                   default: *s=buf[l];
                  }
               }
             else
                *s=buf[l];
             s++;
            }
         }
     }
   *s=0;
   coll.insert(nDef);
   Trs++;
   total+=l+1;
  }
 while (!feof(f));
 fclose(f);
 return True;
}


