@17140@
@13830@
@13245@
@13635@
@13440@
@13245@

Modified by Robert Hhne to be used for RHIDE.

@13245@
@13245@
@14024@

#ifdef __DJGPP__

@14293@
@14317@
@16849@

@16697@
@16745@

@21318@
@19084@
Boolean THWMouse::noMouse = False;

#if defined( DJGPP ) && ( DJGPP > 1 )
#include <dpmi.h>
#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)
@15193@
#define REGS union REGS
#define INTR(nr,r) int86(nr,&r,&r)
@15582@
@16675@
#include <sys/farptr.h>
#include <go32.h>

#define AX r.x.ax
#define BX r.x.bx
#define CX r.x.cx
#define DX r.x.dx
#define ES r.x.es

static unsigned short mouse_char;
static int last_x = 0,last_y = 0;
static int cols;
static int visible = 0;
int emulate_mouse = 0;
int dual_display = 0;

#define SC_BASE (dual_display ? 0xb0000 : ScreenPrimary)

static volatile
void get_mouse_char()
@23372@
  mouse_char = _farpeekw(_dos_ds,SC_BASE+(last_y*cols+last_x)*2);
@24151@

static volatile
void set_mouse_char()
@23372@
  unsigned short c = mouse_char ^ 0x7F00;
  _farpokew(_dos_ds,SC_BASE+(last_y*cols+last_x)*2,c);
@24151@

static volatile
void reset_mouse_char()
@23372@
  _farpokew(_dos_ds,SC_BASE+(last_y*cols+last_x)*2,mouse_char);
@24151@

static volatile
void show_mouse_char()
@23372@
  if (!visible) return;
  get_mouse_char();
  set_mouse_char();
@24151@

volatile
int draw_mouse(int x,int y)
@23372@
  if (x != last_x || y != last_y)
@12966@
    if (!emulate_mouse) return 1;
    if (visible) reset_mouse_char();
    last_x = x;
    last_y = y;
    show_mouse_char();
@09947@
@12978@
@12873@
}   

_go32_dpmi_seginfo mouseIntInfo;

void THWMouse::registerHandler( unsigned mask, void (*func)() )
@23372@
  REGS r;
#if 1
  static int oldes = 0;
  static int olddx = 0;
@15582@
  if (func == NULL)
@12966@
#if 1
    DX = olddx;
    ES = oldes;
    AX = 0x0018;
@15193@
    DX = ES = 0;
    AX = 0x000C;
@15582@
    CX = mask;
    INTR(0x33,r);
@10327@
@12978@
@12774@
@12966@
    DX = mouseIntInfo.rm_offset;
    ES = mouseIntInfo.rm_segment;
#if 1
    AX = 0x0014;
@15193@
    AX = 0x000C;
@15582@
    CX = mask;
    INTR(0x33,r);
#if 1
    oldes = ES;
    olddx = DX;
@15582@
@12978@
@24151@
extern _go32_dpmi_registers mouseIntRegs;
extern MouseEventType tempMouse;

static ushort mx = 0;
static ushort my = 0;

#define LD(x) _go32_dpmi_lock_data(&x,sizeof(x))

static int mouse_buffer_segment;
static int mouse_buffer_selector;
static int mouse_buffer_size;
static int mouse_buffer_allocated = 0;

#define SHOW_COUNT() ((short)(_farpeekw(mouse_buffer_selector,118)))

static void restore_mouse_state()
@23372@
  REGS r;
  if (mouse_buffer_allocated)
@12966@
    AX = 0x0017;
    BX = mouse_buffer_size;
    ES = mouse_buffer_segment;
    DX = 0;
    INTR(0x33,r);
@12978@
@24151@

static void save_mouse_state()
@23372@
  REGS r;
  if (!mouse_buffer_allocated)
@12966@
    AX = 0x0015;
    INTR(0x33,r);
    mouse_buffer_size = BX;
    mouse_buffer_segment = __dpmi_allocate_dos_memory(
                             (mouse_buffer_size+15)>>4,
                             &mouse_buffer_selector);
    if (mouse_buffer_segment != -1)
      mouse_buffer_allocated = 1;
@12978@
  if (mouse_buffer_allocated)
@12966@
    AX = 0x0016;
    BX = mouse_buffer_size;
    ES = mouse_buffer_segment;
    DX = 0;
    INTR(0x33,r);
@12978@
@24151@

static int my_mouse_buffer_segment;
static int my_mouse_buffer_selector;
static int my_mouse_buffer_size;
static int my_mouse_buffer_allocated = 0;
static int my_buttonCount;
static int mouse_is_shown = 0;

static int restore_my_mouse_state()
@23372@
  REGS r;
  if (my_mouse_buffer_allocated)
@12966@
    AX = 0x0017;
    BX = my_mouse_buffer_size;
    ES = my_mouse_buffer_segment;
    DX = 0;
    INTR(0x33,r);
@09947@
@12978@
@12873@
@24151@

static void save_my_mouse_state()
@23372@
  REGS r;
  if (!my_mouse_buffer_allocated)
@12966@
    AX = 0x0015;
    INTR(0x33,r);
    my_mouse_buffer_size = BX;
    my_mouse_buffer_segment = __dpmi_allocate_dos_memory(
                             (my_mouse_buffer_size+15)>>4,
                             &my_mouse_buffer_selector);
    if (my_mouse_buffer_segment != -1)
      my_mouse_buffer_allocated = 1;
@12978@
  if (my_mouse_buffer_allocated)
@12966@
    AX = 0x0016;
    BX = my_mouse_buffer_size;
    ES = my_mouse_buffer_segment;
    DX = 0;
    INTR(0x33,r);
@12978@
@24151@

@21656@
@23372@
  REGS r;
  save_mouse_state();
  buttonCount = my_buttonCount;
  if (!restore_my_mouse_state())
@12966@
    AX = 4;
    CX = mx;
    DX = my;
    INTR(0x33,r);
@12978@
  show();
@24151@

int use_mouse_handler = 1;

@19363@
@23372@
  REGS r;
  AX = 0;
  INTR(0x33,r);
  if (!AX)
      return;
  my_buttonCount = buttonCount = BX & 0x00ff;
  if (handlerInstalled == False && use_mouse_handler)
@12966@
    LD(mouseIntRegs);
    LD(tempMouse);
    LD(mouse_char);
    LD(last_x);
    LD(last_y);
    LD(visible);
    LD(emulate_mouse);
    LD(cols);
    LD(dual_display);
    LD(TEventQueue::eventCount);
    LD(TEventQueue::curMouse);
    LD(TEventQueue::eventQueue);
    LD(TEventQueue::mouseIntFlag);
    LD(TEventQueue::eventQTail);
    _go32_dpmi_lock_data(TEventQueue::eventQueue,eventQSize*sizeof(TEvent));
    _go32_dpmi_lock_code(get_mouse_char,(int)THWMouse::registerHandler -
                                        (int)get_mouse_char);
    _go32_dpmi_lock_code(TEventQueue::mouseInt,500);
    _go32_dpmi_lock_code(TICKS,100);
    mouseIntInfo.pm_offset = (int)TEventQueue::mouseInt;
    _go32_dpmi_allocate_real_mode_callback_retf(&mouseIntInfo,&mouseIntRegs);
@08472@
@12978@
  resume();
  hide();
  if (handlerInstalled == True)
    registerHandler( 0xFFFF, TEventQueue::mouseInt );
@24151@

@19364@
@23372@
  suspend();
  if (handlerInstalled == True)
    registerHandler( 0xFFFF, 0 );
@24151@

@21659@
@23372@
  if (!present()) return;
  hide();
  save_my_mouse_state();
  my_buttonCount = buttonCount;
  buttonCount = 0;
  restore_mouse_state();
@24151@

@21658@
@23372@
  if (!present()) return;
  if (mouse_is_shown) return;
  mouse_is_shown = 1;
  if (!emulate_mouse)
@12966@
    REGS r;
    if ( present() )
@12247@
      AX = 1;
      INTR(0x33,r);
@12539@
@12978@
@12774@
@12966@
    if (!present() || visible) return;
    visible = 1;
    show_mouse_char();
@12978@
@24151@

@21654@
@23372@
  if (!present()) return;
  if (!mouse_is_shown) return;
  mouse_is_shown = 0;
  if (!emulate_mouse)
@12966@
    REGS r;
    if ( buttonCount != 0 )
@12247@
      AX = 2;
      INTR(0x33,r);
@12539@
@12978@
@12774@
@12966@
    if (!present() || !visible) return;
    visible = 0;
    reset_mouse_char();
@12978@
@24151@

@21657@
@23372@
    cols = (int)rx+1;
    REGS r;
    DX = rx << 3;
    CX = 0;
    AX = 7;
    INTR(0x33,r);
    DX = ry << 3;
    CX = 0;
    AX = 8;
    INTR(0x33,r);
@24151@

@21653@
@23372@
  if (handlerInstalled == True)
@12966@
    me = TEventQueue::curMouse;
@12978@
@12774@
@12966@
    REGS r;
@09223@
    AX = 3;
    INTR(0x33,r);
    me.buttons = BX & 0x00ff;
    x = me.where.x = (CX >> 3) & 0xFF;
    y = me.where.y = (DX >> 3) & 0xFF;
    me.doubleClick = False;
    // curMouse must be set, because it used by other functions
    TEventQueue::curMouse = me;
    draw_mouse(x,y);
@12978@
@24151@

#endif // __DJGPP__

