@17140@
@13830@
@13245@
@13635@
@13440@
@13245@

Modified by Robert Hhne to be used for RHIDE.

@13245@
@13245@
@14024@

@14141@
@14414@
@14628@
@14244@
@14585@
@14558@
@14213@
@14706@
#define Uses_TFileViewer
@14324@
@16849@
@16745@
@16751@
@16746@
@16679@
@16703@
#include <sys/stat.h>
#include <unistd.h>

#if !defined( NO_STREAM )

@16706@

__link(RScroller)
__link(RScrollBar)

const char * const TFileViewer::name = "TFileViewer";

TStreamableClass RFileView( TFileViewer::name,
                            TFileViewer::build,
                              __DELTA(TFileViewer)
@00451@

void *TFileViewer::read(ipstream& is)
@23372@
    char *fName;

    TScroller::read(is);
    fName = is.readString();
@08204@
    readFile(fName);
    delete fName; 
@10299@
@24151@

void TFileViewer::write(opstream& os)
@23372@
    TScroller::write(os);
    os.writeString(fileName);
@24151@

TStreamable *TFileViewer::build()
@23372@
    return new TFileViewer( streamableInit );
@24151@

#endif // NO_STREAM

void TFileViewer::changeBounds(const TRect & bounds)
@23372@
  TScroller::changeBounds(bounds);
  setLimit(size.x + width,size.y + count);
@24151@

TFileViewer::TFileViewer( const TRect& bounds,
@00460@
@00463@
                          const char *aFileName) :
    TScroller( bounds, aHScrollBar, aVScrollBar ),
    buffer(NULL), real_bufsize(0), width(0), count(0)
@23372@
@08452@
    isValid = True;
@08204@
    helpCtx = hcFileViewer;
    readFile( aFileName );
@24151@

TFileViewer::~TFileViewer()
@23372@
     if (buffer) delete buffer;
     delete fileName;
     fileLines->removeAll();
     destroy (fileLines);
@24151@

void TFileViewer::draw()
@23372@
    const char *p;

    ushort c =  getColor(0x0301);
    for( int i = 0; i < size.y; i++ )
@05453@
@03526@
	b.moveChar( 0, ' ', c, size.x );

        if( delta.y + i < fileLines->getCount() )
@03116@
            char s[size.x+1];
            p = operator[](delta.y+i);
            if( p == 0 || strlen(p) < (unsigned)delta.x )
                s[0] = EOS;
@02484@
		{
		strncpy( s, p+delta.x, size.x );
                s[size.x] = EOS;
@02046@
            b.moveStr( 0, s, c );
@03214@
        writeBuf( 0, i, size.x, 1, b );
@05843@
@24151@

void TFileViewer::scrollDraw()
@23372@
    TScroller::scrollDraw();
    draw();
@24151@

void TFileViewer::readFile( const char *fName )
@23372@
  if (fileName) delete fileName;

  limit.x = 0;
  fileName = newStr( fName );
#if defined( __DJGPP__ )
  int fileToView = open(fName, O_RDONLY | O_TEXT);
@15193@
  int fileToView = open(fName, O_RDONLY);
@15582@
  if (fileToView <= 0)
@12966@
    messageBox(mfError | mfOKButton ,
               _("Could not open '%s' for reading"),fName);
    isValid = False;
@12978@
@12774@
@12966@
    int bufsize = filelength(fileToView) + 1;
    buffer = (char *)malloc(bufsize);
    real_bufsize = ::read(fileToView,buffer,bufsize);
    char *start,*end,*bufend = buffer + real_bufsize;
    start = buffer;
    while (start < bufend)
@12247@
      end = start;
      while (end < bufend && *end != '\n') end++;
      *end = 0;
      width = max( width, strlen( start ) );
      count++;
      start = end + 1;
@12539@
@09143@
    fileLines = new TLineCollection(count, 5);
    fileLines->count = count;
    for (i=0,start = buffer;i<count;i++)
@12247@
      fileLines->items[i] = (void *)((int)start-(int)buffer);
      while (*start++);
@12539@
    isValid = True;
@12978@
  count = fileLines->getCount();
  setLimit(size.x + width, size.y + count);
  close(fileToView);
@24151@

void TFileViewer::saveFile(const char *fname)
@23372@
  FILE *f;
  f = fopen(fname,"wt+");
  for (int i=0;i<count;i++)
    fprintf(f,"%s\n",operator[](i));
  fclose(f);
@24151@

void TFileViewer::handleEvent(TEvent &event)
@23372@
@12680@
@12931@
@12966@
    case evBroadcast:
      switch (event.message.command)
@06184@
        case cmFileViewAnswer:
          clearEvent(event);
@03296@
@03883@
@03296@
@06196@
      break;
    case evCommand:
      switch (event.message.command)
@06184@
        case cmSaveFile:
@05453@
          char fname[256];
          TFileDialog *dialog;
          dialog = new TFileDialog("*",_("Save to file"),
                                   _("~N~ame"),fdOKButton,0);
          if (TProgram::deskTop->execView(dialog) != cmCancel)
@03348@
            dialog->getData(fname);
            saveFile(fname);
@03360@
          destroy(dialog);
@03296@
@05843@
@03883@
@03296@
@06196@
      break;
    default:
      break;
@12978@
@24151@

void TFileViewer::insertLine(const char *line)
@23372@
  int len = strlen(line)+1;
  buffer = (char *)realloc(buffer,real_bufsize+len);
  memcpy(buffer+real_bufsize,line,len);
  fileLines->insert((void*)real_bufsize);
  real_bufsize += len;
  count++;
  len--;
  width = width < len ? len : width;
  setLimit(size.x + width, size.y + count);
@24151@

void TFileViewer::setState( ushort aState, Boolean enable )
@23372@
    TScroller::setState( aState, enable );
    if( enable && (aState & sfExposed) )
        setLimit( limit.x, limit.y );
@24151@

Boolean TFileViewer::valid( ushort )
@23372@
    return isValid;
@24151@

const char * const TFileViewer::operator [](int index)
@23372@
  if (index >= count) return NULL;
  return (const char *)(buffer + (int)fileLines->at(index));
@24151@




static int winNumber = 0;

TFileWindow::TFileWindow( const char *fileName ) :
    TWindow( TProgram::deskTop->getExtent(), fileName, winNumber++ ),
    TWindowInit( &TFileWindow::initFrame )
@23372@
@09672@
@06992@
@09852@
    insert(new TFileViewer( r,
                            standardScrollBar(sbHorizontal | sbHandleKeyboard),
                            standardScrollBar(sbVertical | sbHandleKeyboard),
                            fileName) );
@24151@


