#! /bin/sh

# Change certain Binutils files to be SFN friendly

case ${LFN} in
  N | n ) echo "You need a LFN environment to run this script." ; exit 1 ;;
  *) ;;
esac

cd ..

# Fixup the ChangeLogs.

if test -f bfd/ChangeLog-9193 ; then

echo "Fixing the Changelogs..."

mv -f bfd/ChangeLog-9193 bfd/ChangeLog.9193
mv -f bfd/ChangeLog-9495 bfd/ChangeLog.9495
mv -f bfd/ChangeLog-9697 bfd/ChangeLog.9697
mv -f gas/ChangeLog-9295 gas/Changelog.9295
mv -f gas/ChangeLog-9697 gas/ChangeLog.9697
fi


# Fixup the ld/emulparams directory.

if test -f ld/emulparams/avrmega161.sh ; then

echo "Fixing the ld/emulparams directory..."

for f in \
  ld/Makefile.am \
  ld/Makefile.in \
  ld/configure.tgt
do
  sed -e "s|avrmega161.sh|avrmga161.sh|" \
      -e "s|elf32bmipn32.sh|elfbmipn32.sh|" \
      -e "s|elf32ppclinux.sh|elfppclinux.sh|" \
      -e "s|elf_i386_be.sh|elfi386be.sh|" < $f > fix.tmp
  mv -f fix.tmp $f
done

mv -f ld/emulparams/avrmega161.sh ld/emulparams/avrmga161.sh
mv -f ld/emulparams/elf32bmipn32.sh ld/emulparams/elfbmipn32.sh
mv -f ld/emulparams/elf32ppclinux.sh ld/emulparams/elfppclinux.sh
mv -f ld/emulparams/elf_i386_be.sh ld/emulparams/elfi386be.sh

fi


# Fixup the bfd directory.

if test -f bfd/coff-tic80.c ; then

echo "Fixing the BFD directory..."

for f in \
  bfd/Makefile.am \
  bfd/Makefile.in \
  bfd/configure.in
do
  sed -e "s|coff-tic80.|coff-ti80.|" \
      -e "s|elf32-i370.|elf32i370.|" < $f > fix.tmp
  mv -f fix.tmp $f
done

mv -f bfd/coff-tic80.c bfd/coff-ti80.c
mv -f bfd/elf32-i370.c bfd/elf32i370.c

fi


# Fixup the gas testsuite.

if test -f gas/testsuite/gas/mips/elf_e_flags1.d ; then

echo "Fixing the gas testsuite..."

for f in \
  gas/testsuite/gas/mips/mips.exp
do
  sed -e "s|elf_e_flags|elf_fl|" \
      -e "s|ld-ilocks-addr32|ld-addr32|" < $f > fix.tmp
  mv -f fix.tmp $f
done

mv -f gas/testsuite/gas/mips/elf_e_flags1.d gas/testsuite/gas/mips/elf_fl1.d
mv -f gas/testsuite/gas/mips/elf_e_flags2.d gas/testsuite/gas/mips/elf_fl2.d
mv -f gas/testsuite/gas/mips/elf_e_flags3.d gas/testsuite/gas/mips/elf_fl3.d
mv -f gas/testsuite/gas/mips/elf_e_flags4.d gas/testsuite/gas/mips/elf_fl4.d
mv -f gas/testsuite/gas/mips/ld-ilocks-addr32.d gas/testsuite/gas/mips/ld-addr32.d

fi


# Fixup the intl directory.

if test -f intl/po2tbl.sed.in ; then

echo "Fixing the intl directory..."

for f in \
  intl/Makefile.in \
  intl/aclocal.m4 \
  intl/configure
do
  sed -e "s|intlh.inst.in|intlh-inst.in|" \
      -e "s|po2tbl.sed.in|po2tbl-sed.in|" < $f > fix.tmp
  mv -f fix.tmp $f
done

mv -f intl/intlh.inst.in intl/intlh-inst.in
mv -f intl/po2tbl.sed.in intl/po2tbl-sed.in

fi


echo "Fixing info files..."

# Fix info files
for file in \
  bfd/doc/bfd.inf* \
  binutils/binutils.inf* \
  gas/doc/as.inf* \
  gas/doc/gasp.inf* \
  gprof/gprof.inf* \
  ld/ld.inf* 
do
  if ! test -f $file ; then
    continue;
  fi
  fixed_file=${file/info-/i}
  sed -e "s%\.info\-%\.i%" < $file > fixed.tmp
  mv -f fixed.tmp $fixed_file
  if test $fixed_file != $file ; then
    rm -f $file
  fi
done
