This is as.info, produced by makeinfo version 4.0 from as.texinfo.

START-INFO-DIR-ENTRY
* As: (as).                     The GNU assembler.
END-INFO-DIR-ENTRY

   This file documents the GNU Assembler "as".

   Copyright (C) 1991, 92, 93, 94, 95, 96, 97, 98, 99, 2000 Free
Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided that
the entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions.


File: as.info,  Node: Irp,  Next: Irpc,  Prev: Int,  Up: Pseudo Ops

`.irp SYMBOL,VALUES'...
=======================

   Evaluate a sequence of statements assigning different values to
SYMBOL.  The sequence of statements starts at the `.irp' directive, and
is terminated by an `.endr' directive.  For each VALUE, SYMBOL is set
to VALUE, and the sequence of statements is assembled.  If no VALUE is
listed, the sequence of statements is assembled once, with SYMBOL set
to the null string.  To refer to SYMBOL within the sequence of
statements, use \SYMBOL.

   For example, assembling

             .irp    param,1,2,3
             move    d\param,sp@-
             .endr

   is equivalent to assembling

             move    d1,sp@-
             move    d2,sp@-
             move    d3,sp@-


File: as.info,  Node: Irpc,  Next: Lcomm,  Prev: Irp,  Up: Pseudo Ops

`.irpc SYMBOL,VALUES'...
========================

   Evaluate a sequence of statements assigning different values to
SYMBOL.  The sequence of statements starts at the `.irpc' directive,
and is terminated by an `.endr' directive.  For each character in VALUE,
SYMBOL is set to the character, and the sequence of statements is
assembled.  If no VALUE is listed, the sequence of statements is
assembled once, with SYMBOL set to the null string.  To refer to SYMBOL
within the sequence of statements, use \SYMBOL.

   For example, assembling

             .irpc    param,123
             move    d\param,sp@-
             .endr

   is equivalent to assembling

             move    d1,sp@-
             move    d2,sp@-
             move    d3,sp@-


File: as.info,  Node: Lcomm,  Next: Lflags,  Prev: Irpc,  Up: Pseudo Ops

`.lcomm SYMBOL , LENGTH'
========================

   Reserve LENGTH (an absolute expression) bytes for a local common
denoted by SYMBOL.  The section and value of SYMBOL are those of the
new local common.  The addresses are allocated in the bss section, so
that at run-time the bytes start off zeroed.  SYMBOL is not declared
global (*note `.global': Global.), so is normally not visible to `ld'.

   Some targets permit a third argument to be used with `.lcomm'.  This
argument specifies the desired alignment of the symbol in the bss
section.

   The syntax for `.lcomm' differs slightly on the HPPA.  The syntax is
`SYMBOL .lcomm, LENGTH'; SYMBOL is optional.


File: as.info,  Node: Lflags,  Next: Line,  Prev: Lcomm,  Up: Pseudo Ops

`.lflags'
=========

   `as' accepts this directive, for compatibility with other
assemblers, but ignores it.


File: as.info,  Node: Line,  Next: Ln,  Prev: Lflags,  Up: Pseudo Ops

`.line LINE-NUMBER'
===================

   Change the logical line number.  LINE-NUMBER must be an absolute
expression.  The next line has that logical line number.  Therefore any
other statements on the current line (after a statement separator
character) are reported as on logical line number LINE-NUMBER - 1.  One
day `as' will no longer support this directive: it is recognized only
for compatibility with existing assembler programs.

   _Warning:_ In the AMD29K configuration of as, this command is not
available; use the synonym `.ln' in that context.

   Even though this is a directive associated with the `a.out' or
`b.out' object-code formats, `as' still recognizes it when producing
COFF output, and treats `.line' as though it were the COFF `.ln' _if_
it is found outside a `.def'/`.endef' pair.

   Inside a `.def', `.line' is, instead, one of the directives used by
compilers to generate auxiliary symbol information for debugging.


File: as.info,  Node: Linkonce,  Next: List,  Prev: Ln,  Up: Pseudo Ops

`.linkonce [TYPE]'
==================

   Mark the current section so that the linker only includes a single
copy of it.  This may be used to include the same section in several
different object files, but ensure that the linker will only include it
once in the final output file.  The `.linkonce' pseudo-op must be used
for each instance of the section.  Duplicate sections are detected
based on the section name, so it should be unique.

   This directive is only supported by a few object file formats; as of
this writing, the only object file format which supports it is the
Portable Executable format used on Windows NT.

   The TYPE argument is optional.  If specified, it must be one of the
following strings.  For example:
     .linkonce same_size
   Not all types may be supported on all object file formats.

`discard'
     Silently discard duplicate sections.  This is the default.

`one_only'
     Warn if there are duplicate sections, but still keep only one copy.

`same_size'
     Warn if any of the duplicates have different sizes.

`same_contents'
     Warn if any of the duplicates do not have exactly the same
     contents.


File: as.info,  Node: Ln,  Next: Linkonce,  Prev: Line,  Up: Pseudo Ops

`.ln LINE-NUMBER'
=================

   `.ln' is a synonym for `.line'.


File: as.info,  Node: MRI,  Next: Nolist,  Prev: Macro,  Up: Pseudo Ops

`.mri VAL'
==========

   If VAL is non-zero, this tells `as' to enter MRI mode.  If VAL is
zero, this tells `as' to exit MRI mode.  This change affects code
assembled until the next `.mri' directive, or until the end of the
file.  *Note MRI mode: M.


File: as.info,  Node: List,  Next: Long,  Prev: Linkonce,  Up: Pseudo Ops

`.list'
=======

   Control (in conjunction with the `.nolist' directive) whether or not
assembly listings are generated.  These two directives maintain an
internal counter (which is zero initially).   `.list' increments the
counter, and `.nolist' decrements it.  Assembly listings are generated
whenever the counter is greater than zero.

   By default, listings are disabled.  When you enable them (with the
`-a' command line option; *note Command-Line Options: Invoking.), the
initial value of the listing counter is one.


File: as.info,  Node: Long,  Next: Macro,  Prev: List,  Up: Pseudo Ops

`.long EXPRESSIONS'
===================

   `.long' is the same as `.int', *note `.int': Int..


File: as.info,  Node: Macro,  Next: MRI,  Prev: Long,  Up: Pseudo Ops

`.macro'
========

   The commands `.macro' and `.endm' allow you to define macros that
generate assembly output.  For example, this definition specifies a
macro `sum' that puts a sequence of numbers into memory:

             .macro  sum from=0, to=5
             .long   \from
             .if     \to-\from
             sum     "(\from+1)",\to
             .endif
             .endm

With that definition, `SUM 0,5' is equivalent to this assembly input:

             .long   0
             .long   1
             .long   2
             .long   3
             .long   4
             .long   5

`.macro MACNAME'
`.macro MACNAME MACARGS ...'
     Begin the definition of a macro called MACNAME.  If your macro
     definition requires arguments, specify their names after the macro
     name, separated by commas or spaces.  You can supply a default
     value for any macro argument by following the name with `=DEFLT'.
     For example, these are all valid `.macro' statements:

    `.macro comm'
          Begin the definition of a macro called `comm', which takes no
          arguments.

    `.macro plus1 p, p1'
    `.macro plus1 p p1'
          Either statement begins the definition of a macro called
          `plus1', which takes two arguments; within the macro
          definition, write `\p' or `\p1' to evaluate the arguments.

    `.macro reserve_str p1=0 p2'
          Begin the definition of a macro called `reserve_str', with two
          arguments.  The first argument has a default value, but not
          the second.  After the definition is complete, you can call
          the macro either as `reserve_str A,B' (with `\p1' evaluating
          to A and `\p2' evaluating to B), or as `reserve_str ,B' (with
          `\p1' evaluating as the default, in this case `0', and `\p2'
          evaluating to B).

     When you call a macro, you can specify the argument values either
     by position, or by keyword.  For example, `sum 9,17' is equivalent
     to `sum to=17, from=9'.

`.endm'
     Mark the end of a macro definition.

`.exitm'
     Exit early from the current macro definition.

`\@'
     `as' maintains a counter of how many macros it has executed in
     this pseudo-variable; you can copy that number to your output with
     `\@', but _only within a macro definition_.


File: as.info,  Node: Nolist,  Next: Octa,  Prev: MRI,  Up: Pseudo Ops

`.nolist'
=========

   Control (in conjunction with the `.list' directive) whether or not
assembly listings are generated.  These two directives maintain an
internal counter (which is zero initially).   `.list' increments the
counter, and `.nolist' decrements it.  Assembly listings are generated
whenever the counter is greater than zero.


File: as.info,  Node: Octa,  Next: Org,  Prev: Nolist,  Up: Pseudo Ops

`.octa BIGNUMS'
===============

   This directive expects zero or more bignums, separated by commas.
For each bignum, it emits a 16-byte integer.

   The term "octa" comes from contexts in which a "word" is two bytes;
hence _octa_-word for 16 bytes.


File: as.info,  Node: Org,  Next: P2align,  Prev: Octa,  Up: Pseudo Ops

`.org NEW-LC , FILL'
====================

   Advance the location counter of the current section to NEW-LC.
NEW-LC is either an absolute expression or an expression with the same
section as the current subsection.  That is, you can't use `.org' to
cross sections: if NEW-LC has the wrong section, the `.org' directive
is ignored.  To be compatible with former assemblers, if the section of
NEW-LC is absolute, `as' issues a warning, then pretends the section of
NEW-LC is the same as the current subsection.

   `.org' may only increase the location counter, or leave it
unchanged; you cannot use `.org' to move the location counter backwards.

   Because `as' tries to assemble programs in one pass, NEW-LC may not
be undefined.  If you really detest this restriction we eagerly await a
chance to share your improved assembler.

   Beware that the origin is relative to the start of the section, not
to the start of the subsection.  This is compatible with other people's
assemblers.

   When the location counter (of the current subsection) is advanced,
the intervening bytes are filled with FILL which should be an absolute
expression.  If the comma and FILL are omitted, FILL defaults to zero.


File: as.info,  Node: P2align,  Next: Print,  Prev: Org,  Up: Pseudo Ops

`.p2align[wl] ABS-EXPR, ABS-EXPR, ABS-EXPR'
===========================================

   Pad the location counter (in the current subsection) to a particular
storage boundary.  The first expression (which must be absolute) is the
number of low-order zero bits the location counter must have after
advancement.  For example `.p2align 3' advances the location counter
until it a multiple of 8.  If the location counter is already a
multiple of 8, no change is needed.

   The second expression (also absolute) gives the fill value to be
stored in the padding bytes.  It (and the comma) may be omitted.  If it
is omitted, the padding bytes are normally zero.  However, on some
systems, if the section is marked as containing code and the fill value
is omitted, the space is filled with no-op instructions.

   The third expression is also absolute, and is also optional.  If it
is present, it is the maximum number of bytes that should be skipped by
this alignment directive.  If doing the alignment would require
skipping more bytes than the specified maximum, then the alignment is
not done at all.  You can omit the fill value (the second argument)
entirely by simply using two commas after the required alignment; this
can be useful if you want the alignment to be filled with no-op
instructions when appropriate.

   The `.p2alignw' and `.p2alignl' directives are variants of the
`.p2align' directive.  The `.p2alignw' directive treats the fill
pattern as a two byte word value.  The `.p2alignl' directives treats the
fill pattern as a four byte longword value.  For example, `.p2alignw
2,0x368d' will align to a multiple of 4.  If it skips two bytes, they
will be filled in with the value 0x368d (the exact placement of the
bytes depends upon the endianness of the processor).  If it skips 1 or
3 bytes, the fill value is undefined.


File: as.info,  Node: Print,  Next: Psize,  Prev: P2align,  Up: Pseudo Ops

`.print STRING'
===============

   `as' will print STRING on the standard output during assembly.  You
must put STRING in double quotes.


File: as.info,  Node: Psize,  Next: Purgem,  Prev: Print,  Up: Pseudo Ops

`.psize LINES , COLUMNS'
========================

   Use this directive to declare the number of lines--and, optionally,
the number of columns--to use for each page, when generating listings.

   If you do not use `.psize', listings use a default line-count of 60.
You may omit the comma and COLUMNS specification; the default width is
200 columns.

   `as' generates formfeeds whenever the specified number of lines is
exceeded (or whenever you explicitly request one, using `.eject').

   If you specify LINES as `0', no formfeeds are generated save those
explicitly specified with `.eject'.


File: as.info,  Node: Purgem,  Next: Quad,  Prev: Psize,  Up: Pseudo Ops

`.purgem NAME'
==============

   Undefine the macro NAME, so that later uses of the string will not be
expanded.  *Note Macro::.


File: as.info,  Node: Quad,  Next: Rept,  Prev: Purgem,  Up: Pseudo Ops

`.quad BIGNUMS'
===============

   `.quad' expects zero or more bignums, separated by commas.  For each
bignum, it emits an 8-byte integer.  If the bignum won't fit in 8
bytes, it prints a warning message; and just takes the lowest order 8
bytes of the bignum.

   The term "quad" comes from contexts in which a "word" is two bytes;
hence _quad_-word for 8 bytes.


File: as.info,  Node: Rept,  Next: Sbttl,  Prev: Quad,  Up: Pseudo Ops

`.rept COUNT'
=============

   Repeat the sequence of lines between the `.rept' directive and the
next `.endr' directive COUNT times.

   For example, assembling

             .rept   3
             .long   0
             .endr

   is equivalent to assembling

             .long   0
             .long   0
             .long   0


File: as.info,  Node: Sbttl,  Next: Scl,  Prev: Rept,  Up: Pseudo Ops

`.sbttl "SUBHEADING"'
=====================

   Use SUBHEADING as the title (third line, immediately after the title
line) when generating assembly listings.

   This directive affects subsequent pages, as well as the current page
if it appears within ten lines of the top of a page.


File: as.info,  Node: Scl,  Next: Section,  Prev: Sbttl,  Up: Pseudo Ops

`.scl CLASS'
============

   Set the storage-class value for a symbol.  This directive may only be
used inside a `.def'/`.endef' pair.  Storage class may flag whether a
symbol is static or external, or it may record further symbolic
debugging information.

   The `.scl' directive is primarily associated with COFF output; when
configured to generate `b.out' output format, `as' accepts this
directive but ignores it.


File: as.info,  Node: Section,  Next: Set,  Prev: Scl,  Up: Pseudo Ops

`.section NAME'
===============

   Use the `.section' directive to assemble the following code into a
section named NAME.

   This directive is only supported for targets that actually support
arbitrarily named sections; on `a.out' targets, for example, it is not
accepted, even with a standard `a.out' section name.

   For COFF targets, the `.section' directive is used in one of the
following ways:
     .section NAME[, "FLAGS"]
     .section NAME[, SUBSEGMENT]

   If the optional argument is quoted, it is taken as flags to use for
the section.  Each flag is a single character.  The following flags are
recognized:
`b'
     bss section (uninitialized data)

`n'
     section is not loaded

`w'
     writable section

`d'
     data section

`r'
     read-only section

`x'
     executable section

`s'
     shared section (meaningful for PE targets)

   If no flags are specified, the default flags depend upon the section
name.  If the section name is not recognized, the default will be for
the section to be loaded and writable.

   If the optional argument to the `.section' directive is not quoted,
it is taken as a subsegment number (*note Sub-Sections::).

   For ELF targets, the `.section' directive is used like this:
     .section NAME[, "FLAGS"[, @TYPE]]
   The optional FLAGS argument is a quoted string which may contain any
combintion of the following characters:
`a'
     section is allocatable

`w'
     section is writable

`x'
     section is executable

   The optional TYPE argument may contain one of the following
constants:
`@progbits'
     section contains data

`@nobits'
     section does not contain data (i.e., section only occupies space)

   If no flags are specified, the default flags depend upon the section
name.  If the section name is not recognized, the default will be for
the section to have none of the above flags: it will not be allocated
in memory, nor writable, nor executable.  The section will contain data.

   For ELF targets, the assembler supports another type of `.section'
directive for compatibility with the Solaris assembler:
     .section "NAME"[, FLAGS...]
   Note that the section name is quoted.  There may be a sequence of
comma separated flags:
`#alloc'
     section is allocatable

`#write'
     section is writable

`#execinstr'
     section is executable


File: as.info,  Node: Set,  Next: Short,  Prev: Section,  Up: Pseudo Ops

`.set SYMBOL, EXPRESSION'
=========================

   Set the value of SYMBOL to EXPRESSION.  This changes SYMBOL's value
and type to conform to EXPRESSION.  If SYMBOL was flagged as external,
it remains flagged (*note Symbol Attributes::).

   You may `.set' a symbol many times in the same assembly.

   If you `.set' a global symbol, the value stored in the object file
is the last value stored into it.

   The syntax for `set' on the HPPA is `SYMBOL .set EXPRESSION'.


File: as.info,  Node: Short,  Next: Single,  Prev: Set,  Up: Pseudo Ops

`.short EXPRESSIONS'
====================

   `.short' is normally the same as `.word'.  *Note `.word': Word.

   In some configurations, however, `.short' and `.word' generate
numbers of different lengths; *note Machine Dependencies::.


File: as.info,  Node: Single,  Next: Size,  Prev: Short,  Up: Pseudo Ops

`.single FLONUMS'
=================

   This directive assembles zero or more flonums, separated by commas.
It has the same effect as `.float'.  The exact kind of floating point
numbers emitted depends on how `as' is configured.  *Note Machine
Dependencies::.


File: as.info,  Node: Size,  Next: Skip,  Prev: Single,  Up: Pseudo Ops

`.size'
=======

   This directive is generated by compilers to include auxiliary
debugging information in the symbol table.  It is only permitted inside
`.def'/`.endef' pairs.

   `.size' is only meaningful when generating COFF format output; when
`as' is generating `b.out', it accepts this directive but ignores it.


File: as.info,  Node: Sleb128,  Next: Space,  Prev: Skip,  Up: Pseudo Ops

`.sleb128 EXPRESSIONS'
======================

   SLEB128 stands for "signed little endian base 128."  This is a
compact, variable length representation of numbers used by the DWARF
symbolic debugging format.  *Note `.uleb128': Uleb128.


File: as.info,  Node: Skip,  Next: Sleb128,  Prev: Size,  Up: Pseudo Ops

`.skip SIZE , FILL'
===================

   This directive emits SIZE bytes, each of value FILL.  Both SIZE and
FILL are absolute expressions.  If the comma and FILL are omitted, FILL
is assumed to be zero.  This is the same as `.space'.


File: as.info,  Node: Space,  Next: Stab,  Prev: Sleb128,  Up: Pseudo Ops

`.space SIZE , FILL'
====================

   This directive emits SIZE bytes, each of value FILL.  Both SIZE and
FILL are absolute expressions.  If the comma and FILL are omitted, FILL
is assumed to be zero.  This is the same as `.skip'.

     _Warning:_ `.space' has a completely different meaning for HPPA
     targets; use `.block' as a substitute.  See `HP9000 Series 800
     Assembly Language Reference Manual' (HP 92432-90001) for the
     meaning of the `.space' directive.  *Note HPPA Assembler
     Directives: HPPA Directives, for a summary.

   On the AMD 29K, this directive is ignored; it is accepted for
compatibility with other AMD 29K assemblers.

     _Warning:_ In most versions of the GNU assembler, the directive
     `.space' has the effect of `.block'  *Note Machine Dependencies::.


File: as.info,  Node: Stab,  Next: String,  Prev: Space,  Up: Pseudo Ops

`.stabd, .stabn, .stabs'
========================

   There are three directives that begin `.stab'.  All emit symbols
(*note Symbols::), for use by symbolic debuggers.  The symbols are not
entered in the `as' hash table: they cannot be referenced elsewhere in
the source file.  Up to five fields are required:

STRING
     This is the symbol's name.  It may contain any character except
     `\000', so is more general than ordinary symbol names.  Some
     debuggers used to code arbitrarily complex structures into symbol
     names using this field.

TYPE
     An absolute expression.  The symbol's type is set to the low 8
     bits of this expression.  Any bit pattern is permitted, but `ld'
     and debuggers choke on silly bit patterns.

OTHER
     An absolute expression.  The symbol's "other" attribute is set to
     the low 8 bits of this expression.

DESC
     An absolute expression.  The symbol's descriptor is set to the low
     16 bits of this expression.

VALUE
     An absolute expression which becomes the symbol's value.

   If a warning is detected while reading a `.stabd', `.stabn', or
`.stabs' statement, the symbol has probably already been created; you
get a half-formed symbol in your object file.  This is compatible with
earlier assemblers!

`.stabd TYPE , OTHER , DESC'
     The "name" of the symbol generated is not even an empty string.
     It is a null pointer, for compatibility.  Older assemblers used a
     null pointer so they didn't waste space in object files with empty
     strings.

     The symbol's value is set to the location counter, relocatably.
     When your program is linked, the value of this symbol is the
     address of the location counter when the `.stabd' was assembled.

`.stabn TYPE , OTHER , DESC , VALUE'
     The name of the symbol is set to the empty string `""'.

`.stabs STRING ,  TYPE , OTHER , DESC , VALUE'
     All five fields are specified.


File: as.info,  Node: String,  Next: Struct,  Prev: Stab,  Up: Pseudo Ops

`.string' "STR"
===============

   Copy the characters in STR to the object file.  You may specify more
than one string to copy, separated by commas.  Unless otherwise
specified for a particular machine, the assembler marks the end of each
string with a 0 byte.  You can use any of the escape sequences
described in *Note Strings: Strings.


File: as.info,  Node: Struct,  Next: Symver,  Prev: String,  Up: Pseudo Ops

`.struct EXPRESSION'
====================

   Switch to the absolute section, and set the section offset to
EXPRESSION, which must be an absolute expression.  You might use this
as follows:
             .struct 0
     field1:
             .struct field1 + 4
     field2:
             .struct field2 + 4
     field3:
   This would define the symbol `field1' to have the value 0, the symbol
`field2' to have the value 4, and the symbol `field3' to have the value
8.  Assembly would be left in the absolute section, and you would need
to use a `.section' directive of some sort to change to some other
section before further assembly.


File: as.info,  Node: Symver,  Next: Tag,  Prev: Struct,  Up: Pseudo Ops

`.symver'
=========

   Use the `.symver' directive to bind symbols to specific version nodes
within a source file.  This is only supported on ELF platforms, and is
typically used when assembling files to be linked into a shared library.
There are cases where it may make sense to use this in objects to be
bound into an application itself so as to override a versioned symbol
from a shared library.

   For ELF targets, the `.symver' directive is used like this:
     .symver NAME, NAME2@NODENAME
   In this case, the symbol NAME must exist and be defined within the
file being assembled.  The `.versym' directive effectively creates a
symbol alias with the name NAME2@NODENAME, and in fact the main reason
that we just don't try and create a regular alias is that the @
character isn't permitted in symbol names.  The NAME2 part of the name
is the actual name of the symbol by which it will be externally
referenced.  The name NAME itself is merely a name of convenience that
is used so that it is possible to have definitions for multiple
versions of a function within a single source file, and so that the
compiler can unambiguously know which version of a function is being
mentioned.  The NODENAME portion of the alias should be the name of a
node specified in the version script supplied to the linker when
building a shared library.  If you are attempting to override a
versioned symbol from a shared library, then NODENAME should correspond
to the nodename of the symbol you are trying to override.


File: as.info,  Node: Tag,  Next: Text,  Prev: Symver,  Up: Pseudo Ops

`.tag STRUCTNAME'
=================

   This directive is generated by compilers to include auxiliary
debugging information in the symbol table.  It is only permitted inside
`.def'/`.endef' pairs.  Tags are used to link structure definitions in
the symbol table with instances of those structures.

   `.tag' is only used when generating COFF format output; when `as' is
generating `b.out', it accepts this directive but ignores it.


File: as.info,  Node: Text,  Next: Title,  Prev: Tag,  Up: Pseudo Ops

`.text SUBSECTION'
==================

   Tells `as' to assemble the following statements onto the end of the
text subsection numbered SUBSECTION, which is an absolute expression.
If SUBSECTION is omitted, subsection number zero is used.


File: as.info,  Node: Title,  Next: Type,  Prev: Text,  Up: Pseudo Ops

`.title "HEADING"'
==================

   Use HEADING as the title (second line, immediately after the source
file name and pagenumber) when generating assembly listings.

   This directive affects subsequent pages, as well as the current page
if it appears within ten lines of the top of a page.


File: as.info,  Node: Type,  Next: Val,  Prev: Title,  Up: Pseudo Ops

`.type INT'
===========

   This directive, permitted only within `.def'/`.endef' pairs, records
the integer INT as the type attribute of a symbol table entry.

   `.type' is associated only with COFF format output; when `as' is
configured for `b.out' output, it accepts this directive but ignores it.


File: as.info,  Node: Val,  Next: Visibility,  Prev: Type,  Up: Pseudo Ops

`.val ADDR'
===========

   This directive, permitted only within `.def'/`.endef' pairs, records
the address ADDR as the value attribute of a symbol table entry.

   `.val' is used only for COFF output; when `as' is configured for
`b.out', it accepts this directive but ignores it.


File: as.info,  Node: Uleb128,  Next: Word,  Prev: Visibility,  Up: Pseudo Ops

`.uleb128 EXPRESSIONS'
======================

   ULEB128 stands for "unsigned little endian base 128."  This is a
compact, variable length representation of numbers used by the DWARF
symbolic debugging format.  *Note `.sleb128': Sleb128.


File: as.info,  Node: Visibility,  Next: Uleb128,  Prev: Val,  Up: Pseudo Ops

`.internal', `.hidden', `.protected'
====================================

   These directives can be used to set the visibility of a specified
symbol.  By default a symbol's visibility is set by its binding (local,
global or weak), but these directives can be used to override that.

   A visibility of `protected' means that any references to the symbol
from within the component that defines the symbol must be resolved to
the definition in that component, even if a definition in another
component would normally preempt this.

   A visibility of `hidden' means that the symbol is not visible to
other components.  Such a symbol is always considered to be protected
as well.

   A visibility of `internal' is the same as a visibility of `hidden',
except that some extra, processor specific processing must also be
performed upon the symbol.

   For ELF targets, the directives are used like this:

     .internal NAME
     .hidden NAME
     .protected NAME


File: as.info,  Node: Word,  Next: Deprecated,  Prev: Uleb128,  Up: Pseudo Ops

`.word EXPRESSIONS'
===================

   This directive expects zero or more EXPRESSIONS, of any section,
separated by commas.

   The size of the number emitted, and its byte order, depend on what
target computer the assembly is for.

     _Warning: Special Treatment to support Compilers_

   Machines with a 32-bit address space, but that do less than 32-bit
addressing, require the following special treatment.  If the machine of
interest to you does 32-bit addressing (or doesn't require it; *note
Machine Dependencies::), you can ignore this issue.

   In order to assemble compiler output into something that works, `as'
occasionlly does strange things to `.word' directives.  Directives of
the form `.word sym1-sym2' are often emitted by compilers as part of
jump tables.  Therefore, when `as' assembles a directive of the form
`.word sym1-sym2', and the difference between `sym1' and `sym2' does
not fit in 16 bits, `as' creates a "secondary jump table", immediately
before the next label.  This secondary jump table is preceded by a
short-jump to the first byte after the secondary table.  This
short-jump prevents the flow of control from accidentally falling into
the new table.  Inside the table is a long-jump to `sym2'.  The
original `.word' contains `sym1' minus the address of the long-jump to
`sym2'.

   If there were several occurrences of `.word sym1-sym2' before the
secondary jump table, all of them are adjusted.  If there was a `.word
sym3-sym4', that also did not fit in sixteen bits, a long-jump to
`sym4' is included in the secondary jump table, and the `.word'
directives are adjusted to contain `sym3' minus the address of the
long-jump to `sym4'; and so on, for as many entries in the original
jump table as necessary.


File: as.info,  Node: Deprecated,  Prev: Word,  Up: Pseudo Ops

Deprecated Directives
=====================

   One day these directives won't work.  They are included for
compatibility with older assemblers.
.abort

.line

File: as.info,  Node: Machine Dependencies,  Next: Reporting Bugs,  Prev: Pseudo Ops,  Up: Top

Machine Dependent Features
**************************

   The machine instruction sets are (almost by definition) different on
each machine where `as' runs.  Floating point representations vary as
well, and `as' often supports a few additional directives or
command-line options for compatibility with other assemblers on a
particular platform.  Finally, some versions of `as' support special
pseudo-instructions for branch optimization.

   This chapter discusses most of these differences, though it does not
include details on any machine's instruction set.  For details on that
subject, see the hardware manufacturer's manual.

* Menu:


* AMD29K-Dependent::            AMD 29K Dependent Features

* ARC-Dependent::               ARC Dependent Features

* ARM-Dependent::               ARM Dependent Features

* D10V-Dependent::              D10V Dependent Features

* D30V-Dependent::              D30V Dependent Features

* H8/300-Dependent::            Hitachi H8/300 Dependent Features

* H8/500-Dependent::            Hitachi H8/500 Dependent Features

* HPPA-Dependent::              HPPA Dependent Features

* ESA/390-Dependent::           IBM ESA/390 Dependent Features

* i386-Dependent::              Intel 80386 Dependent Features

* i960-Dependent::              Intel 80960 Dependent Features

* M68K-Dependent::              M680x0 Dependent Features

* MIPS-Dependent::              MIPS Dependent Features

* SH-Dependent::                Hitachi SH Dependent Features

* PJ-Dependent::                picoJava Dependent Features

* Sparc-Dependent::             SPARC Dependent Features

* V850-Dependent::              V850 Dependent Features

* Z8000-Dependent::             Z8000 Dependent Features

* Vax-Dependent::               VAX Dependent Features


File: as.info,  Node: ARC-Dependent,  Next: ARM-Dependent,  Prev: AMD29K-Dependent,  Up: Machine Dependencies

ARC Dependent Features
======================

* Menu:

* ARC-Opts::                    Options
* ARC-Float::                   Floating Point
* ARC-Directives::              Sparc Machine Directives


File: as.info,  Node: ARC-Opts,  Next: ARC-Float,  Up: ARC-Dependent

Options
-------

   The ARC chip family includes several successive levels (or other
variants) of chip, using the same core instruction set, but including a
few additional instructions at each level.

   By default, `as' assumes the core instruction set (ARC base).  The
`.cpu' pseudo-op is intended to be used to select the variant.

`-mbig-endian'
`-mlittle-endian'
     Any ARC configuration of `as' can select big-endian or
     little-endian output at run time (unlike most other GNU development
     tools, which must be configured for one or the other).  Use
     `-mbig-endian' to select big-endian output, and `-mlittle-endian'
     for little-endian.


File: as.info,  Node: ARC-Float,  Next: ARC-Directives,  Prev: ARC-Opts,  Up: ARC-Dependent

Floating Point
--------------

   The ARC cpu family currently does not have hardware floating point
support.  Software floating point support is provided by `GCC' and uses
IEEE floating-point numbers.


File: as.info,  Node: ARC-Directives,  Prev: ARC-Float,  Up: ARC-Dependent

ARC Machine Directives
----------------------

   The ARC version of `as' supports the following additional machine
directives:

`.cpu'
     This must be followed by the desired cpu.  The ARC is intended to
     be customizable, `.cpu' is used to select the desired variant
     [though currently there are none].


File: as.info,  Node: AMD29K-Dependent,  Next: ARC-Dependent,  Up: Machine Dependencies

AMD 29K Dependent Features
==========================

* Menu:

* AMD29K Options::              Options
* AMD29K Syntax::               Syntax
* AMD29K Floating Point::       Floating Point
* AMD29K Directives::           AMD 29K Machine Directives
* AMD29K Opcodes::              Opcodes


File: as.info,  Node: AMD29K Options,  Next: AMD29K Syntax,  Up: AMD29K-Dependent

Options
-------

   `as' has no additional command-line options for the AMD 29K family.


File: as.info,  Node: AMD29K Syntax,  Next: AMD29K Floating Point,  Prev: AMD29K Options,  Up: AMD29K-Dependent

Syntax
------

* Menu:

* AMD29K-Macros::		Macros
* AMD29K-Chars::                Special Characters
* AMD29K-Regs::                 Register Names


File: as.info,  Node: AMD29K-Macros,  Next: AMD29K-Chars,  Up: AMD29K Syntax

Macros
......

   The macro syntax used on the AMD 29K is like that described in the
AMD 29K Family Macro Assembler Specification.  Normal `as' macros
should still work.


File: as.info,  Node: AMD29K-Chars,  Next: AMD29K-Regs,  Prev: AMD29K-Macros,  Up: AMD29K Syntax

Special Characters
..................

   `;' is the line comment character.

   The character `?' is permitted in identifiers (but may not begin an
identifier).


File: as.info,  Node: AMD29K-Regs,  Prev: AMD29K-Chars,  Up: AMD29K Syntax

Register Names
..............

   General-purpose registers are represented by predefined symbols of
the form `GRNNN' (for global registers) or `LRNNN' (for local
registers), where NNN represents a number between `0' and `127',
written with no leading zeros.  The leading letters may be in either
upper or lower case; for example, `gr13' and `LR7' are both valid
register names.

   You may also refer to general-purpose registers by specifying the
register number as the result of an expression (prefixed with `%%' to
flag the expression as a register number):
     %%EXPRESSION

--where EXPRESSION must be an absolute expression evaluating to a
number between `0' and `255'.  The range [0, 127] refers to global
registers, and the range [128, 255] to local registers.

   In addition, `as' understands the following protected
special-purpose register names for the AMD 29K family:

       vab    chd    pc0
       ops    chc    pc1
       cps    rbp    pc2
       cfg    tmc    mmu
       cha    tmr    lru

   These unprotected special-purpose register names are also recognized:
       ipc    alu    fpe
       ipa    bp     inte
       ipb    fc     fps
       q      cr     exop


File: as.info,  Node: AMD29K Floating Point,  Next: AMD29K Directives,  Prev: AMD29K Syntax,  Up: AMD29K-Dependent

Floating Point
--------------

   The AMD 29K family uses IEEE floating-point numbers.


File: as.info,  Node: AMD29K Directives,  Next: AMD29K Opcodes,  Prev: AMD29K Floating Point,  Up: AMD29K-Dependent

AMD 29K Machine Directives
--------------------------

`.block SIZE , FILL'
     This directive emits SIZE bytes, each of value FILL.  Both SIZE
     and FILL are absolute expressions.  If the comma and FILL are
     omitted, FILL is assumed to be zero.

     In other versions of the GNU assembler, this directive is called
     `.space'.

`.cputype'
     This directive is ignored; it is accepted for compatibility with
     other AMD 29K assemblers.

`.file'
     This directive is ignored; it is accepted for compatibility with
     other AMD 29K assemblers.

          _Warning:_ in other versions of the GNU assembler, `.file' is
          used for the directive called `.app-file' in the AMD 29K
          support.

`.line'
     This directive is ignored; it is accepted for compatibility with
     other AMD 29K assemblers.

`.sect'
     This directive is ignored; it is accepted for compatibility with
     other AMD 29K assemblers.

`.use SECTION NAME'
     Establishes the section and subsection for the following code;
     SECTION NAME may be one of `.text', `.data', `.data1', or `.lit'.
     With one of the first three SECTION NAME options, `.use' is
     equivalent to the machine directive SECTION NAME; the remaining
     case, `.use .lit', is the same as `.data 200'.


File: as.info,  Node: AMD29K Opcodes,  Prev: AMD29K Directives,  Up: AMD29K-Dependent

Opcodes
-------

   `as' implements all the standard AMD 29K opcodes.  No additional
pseudo-instructions are needed on this family.

   For information on the 29K machine instruction set, see `Am29000
User's Manual', Advanced Micro Devices, Inc.


File: as.info,  Node: ARM-Dependent,  Next: D10V-Dependent,  Prev: ARC-Dependent,  Up: Machine Dependencies

ARM Dependent Features
======================

* Menu:

* ARM Options::              Options
* ARM Syntax::               Syntax
* ARM Floating Point::       Floating Point
* ARM Directives::           ARM Machine Directives
* ARM Opcodes::              Opcodes


File: as.info,  Node: ARM Options,  Next: ARM Syntax,  Up: ARM-Dependent

Options
-------

`-marm`[2|250|3|6|60|600|610|620|7|7m|7d|7dm|7di|7dmi|70|700|700i|710|710c|7100|7500|7500fe|7tdmi|8|810|9|9tdmi|920|strongarm|strongarm110|strongarm1100]''
     This option specifies the target processor.  The assembler will
     issue an error message if an attempt is made to assemble an
     instruction which will not execute on the target processor.

`-marmv`[2|2a|3|3m|4|4t|5|5t]''
     This option specifies the target architecture.  The assembler will
     issue an error message if an attempt is made to assemble an
     instruction which will not execute on the target architecture.

`-mthumb'
     This option specifies that only Thumb instructions should be
     assembled.

`-mall'
     This option specifies that any Arm or Thumb instruction should be
     assembled.

`-mfpa [10|11]'
     This option specifies the floating point architecture in use on the
     target processor.

`-mfpe-old'
     Do not allow the assemble of floating point multiple instructions.

`-mno-fpu'
     Do not allow the assembly of any floating point instructions.

`-mthumb-interwork'
     This option specifies that the output generated by the assembler
     should be marked as supporting interworking.

`-mapcs [26|32]'
     This option specifies that the output generated by the assembler
     should be marked as supporting the indicated version of the Arm
     Procedure.  Calling Standard.

`-mapcs-float'
     This indicates the the floating point variant of the APCS should be
     used.  In this variant floating point arguments are passed in FP
     registers rather than integer registers.

`-mapcs-reentrant'
     This indicates that the reentrant variant of the APCS should be
     used.  This variant supports position independent code.

`-EB'
     This option specifies that the output generated by the assembler
     should be marked as being encoded for a big-endian processor.

`-EL'
     This option specifies that the output generated by the assembler
     should be marked as being encoded for a little-endian processor.

`-k'
     This option enables the generation of PIC (position independent
     code).

`-moabi'
     This indicates that the code should be assembled using the old ARM
     ELF conventions, based on a beta release release of the ARM-ELF
     specifications, rather than the default conventions which are
     based on the final release of the ARM-ELF specifications.


File: as.info,  Node: ARM Syntax,  Next: ARM Floating Point,  Prev: ARM Options,  Up: ARM-Dependent

Syntax
------

* Menu:

* ARM-Chars::                Special Characters
* ARM-Regs::                 Register Names


File: as.info,  Node: ARM-Chars,  Next: ARM-Regs,  Up: ARM Syntax

Special Characters
..................

   The presence of a `@' on a line indicates the start of a comment
that extends to the end of the current line.  If a `#' appears as the
first character of a line, the whole line is treated as a comment.

   On ARM systems running the GNU/Linux operating system, `;' can be
used instead of a newline to separate statements.

   Either `#' or `$' can be used to indicate immediate operands.

   *TODO* Explain about /data modifier on symbols.


File: as.info,  Node: ARM-Regs,  Prev: ARM-Chars,  Up: ARM Syntax

Register Names
..............

   *TODO* Explain about ARM register naming, and the predefined names.


File: as.info,  Node: ARM Floating Point,  Next: ARM Directives,  Prev: ARM Syntax,  Up: ARM-Dependent

Floating Point
--------------

   The ARM family uses IEEE floating-point numbers.


File: as.info,  Node: ARM Directives,  Next: ARM Opcodes,  Prev: ARM Floating Point,  Up: ARM-Dependent

ARM Machine Directives
----------------------

`.align EXPRESSION [, EXPRESSION]'
     This is the generic .ALIGN directive.  For the ARM however if the
     first argument is zero (ie no alignment is needed) the assembler
     will behave as if the argument had been 2 (ie pad to the next four
     byte boundary).  This is for compatability with ARM's own
     assembler.

`NAME .req REGISTER NAME'
     This creates an alias for REGISTER NAME called NAME.  For example:

                  foo .req r0

`.code [16|32]'
     This directive selects the instruction set being generated. The
     value 16 selects Thumb, with the value 32 selecting ARM.

`.thumb'
     This performs the same action as .CODE 16.

`.arm'
     This performs the same action as .CODE 32.

`.force_thumb'
     This directive forces the selection of Thumb instructions, even if
     the target processor does not support those instructions

`.thumb_func'
     This directive specifies that the following symbol is the name of a
     Thumb encoded function.  This information is necessary in order to
     allow the assembler and linker to generate correct code for
     interworking between Arm and Thumb instructions and should be used
     even if interworking is not going to be performed.

`.thumb_set'
     This performs the equivalent of a `.set' directive in that it
     creates a symbol which is an alias for another symbol (possibly
     not yet defined).  This directive also has the added property in
     that it marks the aliased symbol as being a thumb function entry
     point, in the same way that the `.thumb_func' directive does.

`.ltorg'
     This directive causes the current contents of the literal pool to
     be dumped into the current section (which is assumed to be the
     .text section) at the current location (aligned to a word
     boundary).

`.pool'
     This is a synonym for .ltorg.


File: as.info,  Node: ARM Opcodes,  Prev: ARM Directives,  Up: ARM-Dependent

Opcodes
-------

   `as' implements all the standard ARM opcodes.  It also implements
several pseudo opcodes, including several synthetic load instructions.

`NOP'
            nop

     This pseudo op will always evaluate to a legal ARM instruction
     that does nothing.  Currently it will evaluate to MOV r0, r0.

`LDR'
            ldr <register> , = <expression>

     If expression evaluates to a numeric constant then a MOV or MVN
     instruction will be used in place of the LDR instruction, if the
     constant can be generated by either of these instructions.
     Otherwise the constant will be placed into the nearest literal
     pool (if it not already there) and a PC relative LDR instruction
     will be generated.

`ADR'
            adr <register> <label>

     This instruction will load the address of LABEL into the indicated
     register.  The instruction will evaluate to a PC relative ADD or
     SUB instruction depending upon where the label is located.  If the
     label is out of range, or if it is not defined in the same file
     (and section) as the ADR instruction, then an error will be
     generated.  This instruction will not make use of the literal pool.

`ADRL'
            adrl <register> <label>

     This instruction will load the address of LABEL into the indicated
     register.  The instruction will evaluate to one or two a PC
     relative ADD or SUB instructions depending upon where the label is
     located.  If a second instruction is not needed a NOP instruction
     will be generated in its place, so that this instruction is always
     8 bytes long.

     If the label is out of range, or if it is not defined in the same
     file (and section) as the ADRL instruction, then an error will be
     generated.  This instruction will not make use of the literal pool.

   For information on the ARM or Thumb instruction sets, see `ARM
Software Development Toolkit Reference Manual', Advanced RISC Machines
Ltd.


File: as.info,  Node: D10V-Dependent,  Next: D30V-Dependent,  Prev: ARM-Dependent,  Up: Machine Dependencies

D10V Dependent Features
=======================

* Menu:

* D10V-Opts::                   D10V Options
* D10V-Syntax::                 Syntax
* D10V-Float::                  Floating Point
* D10V-Opcodes::                Opcodes


File: as.info,  Node: D10V-Opts,  Next: D10V-Syntax,  Up: D10V-Dependent

D10V Options
------------

   The Mitsubishi D10V version of `as' has a few machine dependent
options.

`-O'
     The D10V can often execute two sub-instructions in parallel. When
     this option is used, `as' will attempt to optimize its output by
     detecting when instructions can be executed in parallel.

`--nowarnswap'
     To optimize execution performance, `as' will sometimes swap the
     order of instructions. Normally this generates a warning. When
     this option is used, no warning will be generated when
     instructions are swapped.


File: as.info,  Node: D10V-Syntax,  Next: D10V-Float,  Prev: D10V-Opts,  Up: D10V-Dependent

Syntax
------

   The D10V syntax is based on the syntax in Mitsubishi's D10V
architecture manual.  The differences are detailed below.

* Menu:

* D10V-Size::                 Size Modifiers
* D10V-Subs::                 Sub-Instructions
* D10V-Chars::                Special Characters
* D10V-Regs::                 Register Names
* D10V-Addressing::           Addressing Modes
* D10V-Word::                 @WORD Modifier


File: as.info,  Node: D10V-Size,  Next: D10V-Subs,  Up: D10V-Syntax

Size Modifiers
..............

   The D10V version of `as' uses the instruction names in the D10V
Architecture Manual.  However, the names in the manual are sometimes
ambiguous.  There are instruction names that can assemble to a short or
long form opcode.  How does the assembler pick the correct form?  `as'
will always pick the smallest form if it can.  When dealing with a
symbol that is not defined yet when a line is being assembled, it will
always use the long form.  If you need to force the assembler to use
either the short or long form of the instruction, you can append either
`.s' (short) or `.l' (long) to it.  For example, if you are writing an
assembly program and you want to do a branch to a symbol that is
defined later in your program, you can write `bra.s   foo'.  Objdump
and GDB will always append `.s' or `.l' to instructions which have both
short and long forms.

