This is as.info, produced by makeinfo version 4.0 from
/djgpp/gnu/binutl-2.112/gas/doc/as.texinfo.

START-INFO-DIR-ENTRY
* As: (as).                     The GNU assembler.
END-INFO-DIR-ENTRY

   This file documents the GNU Assembler "as".

   Copyright (C) 1991, 92, 93, 94, 95, 96, 97, 98, 99, 2000, 2001 Free
Software Foundation, Inc.

   Permission is granted to copy, distribute and/or modify this document
     under the terms of the GNU Free Documentation License, Version 1.1
     or any later version published by the Free Software Foundation;
   with no Invariant Sections, with no Front-Cover Texts, and with no
    Back-Cover Texts.  A copy of the license is included in the
section entitled "GNU Free Documentation License".


File: as.info,  Node: Global,  Next: Hidden,  Prev: Func,  Up: Pseudo Ops

`.global SYMBOL', `.globl SYMBOL'
=================================

   `.global' makes the symbol visible to `ld'.  If you define SYMBOL in
your partial program, its value is made available to other partial
programs that are linked with it.  Otherwise, SYMBOL takes its
attributes from a symbol of the same name from another file linked into
the same program.

   Both spellings (`.globl' and `.global') are accepted, for
compatibility with other assemblers.

   On the HPPA, `.global' is not always enough to make it accessible to
other partial programs.  You may need the HPPA-only `.EXPORT' directive
as well.  *Note HPPA Assembler Directives: HPPA Directives.


File: as.info,  Node: Hidden,  Next: hword,  Prev: Global,  Up: Pseudo Ops

`.hidden NAMES'
===============

   This one of the ELF visibility directives.  The other two are
`.internal' (*note `.internal': Internal.) and `.protected' (*note
`.protected': Protected.).

   This directive overrides the named symbols default visibility (which
is set by their binding: local, global or weak).  The directive sets
the visibility to `hidden' which means that the symbols are not visible
to other components.  Such symbols are always considered to be
`protected' as well.


File: as.info,  Node: hword,  Next: Ident,  Prev: Hidden,  Up: Pseudo Ops

`.hword EXPRESSIONS'
====================

   This expects zero or more EXPRESSIONS, and emits a 16 bit number for
each.

   This directive is a synonym for `.short'; depending on the target
architecture, it may also be a synonym for `.word'.


File: as.info,  Node: Ident,  Next: If,  Prev: hword,  Up: Pseudo Ops

`.ident'
========

   This directive is used by some assemblers to place tags in object
files.  `as' simply accepts the directive for source-file compatibility
with such assemblers, but does not actually emit anything for it.


File: as.info,  Node: If,  Next: Include,  Prev: Ident,  Up: Pseudo Ops

`.if ABSOLUTE EXPRESSION'
=========================

   `.if' marks the beginning of a section of code which is only
considered part of the source program being assembled if the argument
(which must be an ABSOLUTE EXPRESSION) is non-zero.  The end of the
conditional section of code must be marked by `.endif' (*note `.endif':
Endif.); optionally, you may include code for the alternative
condition, flagged by `.else' (*note `.else': Else.).  If you have
several conditions to check, `.elseif' may be used to avoid nesting
blocks if/else within each subsequent `.else' block.

   The following variants of `.if' are also supported:
`.ifdef SYMBOL'
     Assembles the following section of code if the specified SYMBOL
     has been defined.

`.ifc STRING1,STRING2'
     Assembles the following section of code if the two strings are the
     same.  The strings may be optionally quoted with single quotes.
     If they are not quoted, the first string stops at the first comma,
     and the second string stops at the end of the line.  Strings which
     contain whitespace should be quoted.  The string comparison is
     case sensitive.

`.ifeq ABSOLUTE EXPRESSION'
     Assembles the following section of code if the argument is zero.

`.ifeqs STRING1,STRING2'
     Another form of `.ifc'.  The strings must be quoted using double
     quotes.

`.ifge ABSOLUTE EXPRESSION'
     Assembles the following section of code if the argument is greater
     than or equal to zero.

`.ifgt ABSOLUTE EXPRESSION'
     Assembles the following section of code if the argument is greater
     than zero.

`.ifle ABSOLUTE EXPRESSION'
     Assembles the following section of code if the argument is less
     than or equal to zero.

`.iflt ABSOLUTE EXPRESSION'
     Assembles the following section of code if the argument is less
     than zero.

`.ifnc STRING1,STRING2.'
     Like `.ifc', but the sense of the test is reversed: this assembles
     the following section of code if the two strings are not the same.

`.ifndef SYMBOL'
`.ifnotdef SYMBOL'
     Assembles the following section of code if the specified SYMBOL
     has not been defined.  Both spelling variants are equivalent.

`.ifne ABSOLUTE EXPRESSION'
     Assembles the following section of code if the argument is not
     equal to zero (in other words, this is equivalent to `.if').

`.ifnes STRING1,STRING2'
     Like `.ifeqs', but the sense of the test is reversed: this
     assembles the following section of code if the two strings are not
     the same.


File: as.info,  Node: Include,  Next: Int,  Prev: If,  Up: Pseudo Ops

`.include "FILE"'
=================

   This directive provides a way to include supporting files at
specified points in your source program.  The code from FILE is
assembled as if it followed the point of the `.include'; when the end
of the included file is reached, assembly of the original file
continues.  You can control the search paths used with the `-I'
command-line option (*note Command-Line Options: Invoking.).  Quotation
marks are required around FILE.


File: as.info,  Node: Int,  Next: Internal,  Prev: Include,  Up: Pseudo Ops

`.int EXPRESSIONS'
==================

   Expect zero or more EXPRESSIONS, of any section, separated by commas.
For each expression, emit a number that, at run time, is the value of
that expression.  The byte order and bit size of the number depends on
what kind of target the assembly is for.


File: as.info,  Node: Internal,  Next: Irp,  Prev: Int,  Up: Pseudo Ops

`.internal NAMES'
=================

   This one of the ELF visibility directives.  The other two are
`.hidden' (*note `.hidden': Hidden.) and `.protected' (*note
`.protected': Protected.).

   This directive overrides the named symbols default visibility (which
is set by their binding: local, global or weak).  The directive sets
the visibility to `internal' which means that the symbols are
considered to be `hidden' (ie not visible to other components), and
that some extra, processor specific processing must also be performed
upon the  symbols as well.


File: as.info,  Node: Irp,  Next: Irpc,  Prev: Internal,  Up: Pseudo Ops

`.irp SYMBOL,VALUES'...
=======================

   Evaluate a sequence of statements assigning different values to
SYMBOL.  The sequence of statements starts at the `.irp' directive, and
is terminated by an `.endr' directive.  For each VALUE, SYMBOL is set
to VALUE, and the sequence of statements is assembled.  If no VALUE is
listed, the sequence of statements is assembled once, with SYMBOL set
to the null string.  To refer to SYMBOL within the sequence of
statements, use \SYMBOL.

   For example, assembling

             .irp    param,1,2,3
             move    d\param,sp@-
             .endr

   is equivalent to assembling

             move    d1,sp@-
             move    d2,sp@-
             move    d3,sp@-


File: as.info,  Node: Irpc,  Next: Lcomm,  Prev: Irp,  Up: Pseudo Ops

`.irpc SYMBOL,VALUES'...
========================

   Evaluate a sequence of statements assigning different values to
SYMBOL.  The sequence of statements starts at the `.irpc' directive,
and is terminated by an `.endr' directive.  For each character in VALUE,
SYMBOL is set to the character, and the sequence of statements is
assembled.  If no VALUE is listed, the sequence of statements is
assembled once, with SYMBOL set to the null string.  To refer to SYMBOL
within the sequence of statements, use \SYMBOL.

   For example, assembling

             .irpc    param,123
             move    d\param,sp@-
             .endr

   is equivalent to assembling

             move    d1,sp@-
             move    d2,sp@-
             move    d3,sp@-


File: as.info,  Node: Lcomm,  Next: Lflags,  Prev: Irpc,  Up: Pseudo Ops

`.lcomm SYMBOL , LENGTH'
========================

   Reserve LENGTH (an absolute expression) bytes for a local common
denoted by SYMBOL.  The section and value of SYMBOL are those of the
new local common.  The addresses are allocated in the bss section, so
that at run-time the bytes start off zeroed.  SYMBOL is not declared
global (*note `.global': Global.), so is normally not visible to `ld'.

   Some targets permit a third argument to be used with `.lcomm'.  This
argument specifies the desired alignment of the symbol in the bss
section.

   The syntax for `.lcomm' differs slightly on the HPPA.  The syntax is
`SYMBOL .lcomm, LENGTH'; SYMBOL is optional.


File: as.info,  Node: Lflags,  Next: Line,  Prev: Lcomm,  Up: Pseudo Ops

`.lflags'
=========

   `as' accepts this directive, for compatibility with other
assemblers, but ignores it.


File: as.info,  Node: Line,  Next: Ln,  Prev: Lflags,  Up: Pseudo Ops

`.line LINE-NUMBER'
===================

   Change the logical line number.  LINE-NUMBER must be an absolute
expression.  The next line has that logical line number.  Therefore any
other statements on the current line (after a statement separator
character) are reported as on logical line number LINE-NUMBER - 1.  One
day `as' will no longer support this directive: it is recognized only
for compatibility with existing assembler programs.

   _Warning:_ In the AMD29K configuration of as, this command is not
available; use the synonym `.ln' in that context.

   Even though this is a directive associated with the `a.out' or
`b.out' object-code formats, `as' still recognizes it when producing
COFF output, and treats `.line' as though it were the COFF `.ln' _if_
it is found outside a `.def'/`.endef' pair.

   Inside a `.def', `.line' is, instead, one of the directives used by
compilers to generate auxiliary symbol information for debugging.


File: as.info,  Node: Linkonce,  Next: List,  Prev: Ln,  Up: Pseudo Ops

`.linkonce [TYPE]'
==================

   Mark the current section so that the linker only includes a single
copy of it.  This may be used to include the same section in several
different object files, but ensure that the linker will only include it
once in the final output file.  The `.linkonce' pseudo-op must be used
for each instance of the section.  Duplicate sections are detected
based on the section name, so it should be unique.

   This directive is only supported by a few object file formats; as of
this writing, the only object file format which supports it is the
Portable Executable format used on Windows NT.

   The TYPE argument is optional.  If specified, it must be one of the
following strings.  For example:
     .linkonce same_size
   Not all types may be supported on all object file formats.

`discard'
     Silently discard duplicate sections.  This is the default.

`one_only'
     Warn if there are duplicate sections, but still keep only one copy.

`same_size'
     Warn if any of the duplicates have different sizes.

`same_contents'
     Warn if any of the duplicates do not have exactly the same
     contents.


File: as.info,  Node: Ln,  Next: Linkonce,  Prev: Line,  Up: Pseudo Ops

`.ln LINE-NUMBER'
=================

   `.ln' is a synonym for `.line'.


File: as.info,  Node: MRI,  Next: Nolist,  Prev: Macro,  Up: Pseudo Ops

`.mri VAL'
==========

   If VAL is non-zero, this tells `as' to enter MRI mode.  If VAL is
zero, this tells `as' to exit MRI mode.  This change affects code
assembled until the next `.mri' directive, or until the end of the
file.  *Note MRI mode: M.


File: as.info,  Node: List,  Next: Long,  Prev: Linkonce,  Up: Pseudo Ops

`.list'
=======

   Control (in conjunction with the `.nolist' directive) whether or not
assembly listings are generated.  These two directives maintain an
internal counter (which is zero initially).   `.list' increments the
counter, and `.nolist' decrements it.  Assembly listings are generated
whenever the counter is greater than zero.

   By default, listings are disabled.  When you enable them (with the
`-a' command line option; *note Command-Line Options: Invoking.), the
initial value of the listing counter is one.


File: as.info,  Node: Long,  Next: Macro,  Prev: List,  Up: Pseudo Ops

`.long EXPRESSIONS'
===================

   `.long' is the same as `.int', *note `.int': Int..


File: as.info,  Node: Macro,  Next: MRI,  Prev: Long,  Up: Pseudo Ops

`.macro'
========

   The commands `.macro' and `.endm' allow you to define macros that
generate assembly output.  For example, this definition specifies a
macro `sum' that puts a sequence of numbers into memory:

             .macro  sum from=0, to=5
             .long   \from
             .if     \to-\from
             sum     "(\from+1)",\to
             .endif
             .endm

With that definition, `SUM 0,5' is equivalent to this assembly input:

             .long   0
             .long   1
             .long   2
             .long   3
             .long   4
             .long   5

`.macro MACNAME'
`.macro MACNAME MACARGS ...'
     Begin the definition of a macro called MACNAME.  If your macro
     definition requires arguments, specify their names after the macro
     name, separated by commas or spaces.  You can supply a default
     value for any macro argument by following the name with `=DEFLT'.
     For example, these are all valid `.macro' statements:

    `.macro comm'
          Begin the definition of a macro called `comm', which takes no
          arguments.

    `.macro plus1 p, p1'
    `.macro plus1 p p1'
          Either statement begins the definition of a macro called
          `plus1', which takes two arguments; within the macro
          definition, write `\p' or `\p1' to evaluate the arguments.

    `.macro reserve_str p1=0 p2'
          Begin the definition of a macro called `reserve_str', with two
          arguments.  The first argument has a default value, but not
          the second.  After the definition is complete, you can call
          the macro either as `reserve_str A,B' (with `\p1' evaluating
          to A and `\p2' evaluating to B), or as `reserve_str ,B' (with
          `\p1' evaluating as the default, in this case `0', and `\p2'
          evaluating to B).

     When you call a macro, you can specify the argument values either
     by position, or by keyword.  For example, `sum 9,17' is equivalent
     to `sum to=17, from=9'.

`.endm'
     Mark the end of a macro definition.

`.exitm'
     Exit early from the current macro definition.

`\@'
     `as' maintains a counter of how many macros it has executed in
     this pseudo-variable; you can copy that number to your output with
     `\@', but _only within a macro definition_.


File: as.info,  Node: Nolist,  Next: Octa,  Prev: MRI,  Up: Pseudo Ops

`.nolist'
=========

   Control (in conjunction with the `.list' directive) whether or not
assembly listings are generated.  These two directives maintain an
internal counter (which is zero initially).   `.list' increments the
counter, and `.nolist' decrements it.  Assembly listings are generated
whenever the counter is greater than zero.


File: as.info,  Node: Octa,  Next: Org,  Prev: Nolist,  Up: Pseudo Ops

`.octa BIGNUMS'
===============

   This directive expects zero or more bignums, separated by commas.
For each bignum, it emits a 16-byte integer.

   The term "octa" comes from contexts in which a "word" is two bytes;
hence _octa_-word for 16 bytes.


File: as.info,  Node: Org,  Next: P2align,  Prev: Octa,  Up: Pseudo Ops

`.org NEW-LC , FILL'
====================

   Advance the location counter of the current section to NEW-LC.
NEW-LC is either an absolute expression or an expression with the same
section as the current subsection.  That is, you can't use `.org' to
cross sections: if NEW-LC has the wrong section, the `.org' directive
is ignored.  To be compatible with former assemblers, if the section of
NEW-LC is absolute, `as' issues a warning, then pretends the section of
NEW-LC is the same as the current subsection.

   `.org' may only increase the location counter, or leave it
unchanged; you cannot use `.org' to move the location counter backwards.

   Because `as' tries to assemble programs in one pass, NEW-LC may not
be undefined.  If you really detest this restriction we eagerly await a
chance to share your improved assembler.

   Beware that the origin is relative to the start of the section, not
to the start of the subsection.  This is compatible with other people's
assemblers.

   When the location counter (of the current subsection) is advanced,
the intervening bytes are filled with FILL which should be an absolute
expression.  If the comma and FILL are omitted, FILL defaults to zero.


File: as.info,  Node: P2align,  Next: PopSection,  Prev: Org,  Up: Pseudo Ops

`.p2align[wl] ABS-EXPR, ABS-EXPR, ABS-EXPR'
===========================================

   Pad the location counter (in the current subsection) to a particular
storage boundary.  The first expression (which must be absolute) is the
number of low-order zero bits the location counter must have after
advancement.  For example `.p2align 3' advances the location counter
until it a multiple of 8.  If the location counter is already a
multiple of 8, no change is needed.

   The second expression (also absolute) gives the fill value to be
stored in the padding bytes.  It (and the comma) may be omitted.  If it
is omitted, the padding bytes are normally zero.  However, on some
systems, if the section is marked as containing code and the fill value
is omitted, the space is filled with no-op instructions.

   The third expression is also absolute, and is also optional.  If it
is present, it is the maximum number of bytes that should be skipped by
this alignment directive.  If doing the alignment would require
skipping more bytes than the specified maximum, then the alignment is
not done at all.  You can omit the fill value (the second argument)
entirely by simply using two commas after the required alignment; this
can be useful if you want the alignment to be filled with no-op
instructions when appropriate.

   The `.p2alignw' and `.p2alignl' directives are variants of the
`.p2align' directive.  The `.p2alignw' directive treats the fill
pattern as a two byte word value.  The `.p2alignl' directives treats the
fill pattern as a four byte longword value.  For example, `.p2alignw
2,0x368d' will align to a multiple of 4.  If it skips two bytes, they
will be filled in with the value 0x368d (the exact placement of the
bytes depends upon the endianness of the processor).  If it skips 1 or
3 bytes, the fill value is undefined.


File: as.info,  Node: Previous,  Next: Print,  Prev: PopSection,  Up: Pseudo Ops

`.previous'
===========

   This is one of the ELF section stack manipulation directives.  The
others are `.section' (*note Section::), `.subsection' (*note
SubSection::), `.pushsection' (*note PushSection::), and `.popsection'
(*note PopSection::).

   This directive swaps the current section (and subsection) with most
recently referenced section (and subsection) prior to this one.
Multiple `.previous' directives in a row will flip between two sections
(and their subsections).

   In terms of the section stack, this directive swaps the current
section with the top section on the section stack.


File: as.info,  Node: PopSection,  Next: Previous,  Prev: P2align,  Up: Pseudo Ops

`.popsection'
=============

   This is one of the ELF section stack manipulation directives.  The
others are `.section' (*note Section::), `.subsection' (*note
SubSection::), `.pushsection' (*note PushSection::), and `.previous'
(*note Previous::).

   This directive replaces the current section (and subsection) with
the top section (and subsection) on the section stack.  This section is
popped off the stack.


File: as.info,  Node: Print,  Next: Protected,  Prev: Previous,  Up: Pseudo Ops

`.print STRING'
===============

   `as' will print STRING on the standard output during assembly.  You
must put STRING in double quotes.


File: as.info,  Node: Protected,  Next: Psize,  Prev: Print,  Up: Pseudo Ops

`.protected NAMES'
==================

   This one of the ELF visibility directives.  The other two are
`.hidden' (*note Hidden::) and `.internal' (*note Internal::).

   This directive overrides the named symbols default visibility (which
is set by their binding: local, global or weak).  The directive sets
the visibility to `protected' which means that any references to the
symbols from within the components that defines them must be resolved
to the definition in that component, even if a definition in another
component would normally preempt this.


File: as.info,  Node: Psize,  Next: Purgem,  Prev: Protected,  Up: Pseudo Ops

`.psize LINES , COLUMNS'
========================

   Use this directive to declare the number of lines--and, optionally,
the number of columns--to use for each page, when generating listings.

   If you do not use `.psize', listings use a default line-count of 60.
You may omit the comma and COLUMNS specification; the default width is
200 columns.

   `as' generates formfeeds whenever the specified number of lines is
exceeded (or whenever you explicitly request one, using `.eject').

   If you specify LINES as `0', no formfeeds are generated save those
explicitly specified with `.eject'.


File: as.info,  Node: Purgem,  Next: PushSection,  Prev: Psize,  Up: Pseudo Ops

`.purgem NAME'
==============

   Undefine the macro NAME, so that later uses of the string will not be
expanded.  *Note Macro::.


File: as.info,  Node: PushSection,  Next: Quad,  Prev: Purgem,  Up: Pseudo Ops

`.pushsection NAME , SUBSECTION'
================================

   This is one of the ELF section stack manipulation directives.  The
others are `.section' (*note Section::), `.subsection' (*note
SubSection::), `.popsection' (*note PopSection::), and `.previous'
(*note Previous::).

   This directive is a synonym for `.section'.  It pushes the current
section (and subsection) onto the top of the section stack, and then
replaces the current section and subsection with `name' and
`subsection'.


File: as.info,  Node: Quad,  Next: Rept,  Prev: PushSection,  Up: Pseudo Ops

`.quad BIGNUMS'
===============

   `.quad' expects zero or more bignums, separated by commas.  For each
bignum, it emits an 8-byte integer.  If the bignum won't fit in 8
bytes, it prints a warning message; and just takes the lowest order 8
bytes of the bignum.

   The term "quad" comes from contexts in which a "word" is two bytes;
hence _quad_-word for 8 bytes.


File: as.info,  Node: Rept,  Next: Sbttl,  Prev: Quad,  Up: Pseudo Ops

`.rept COUNT'
=============

   Repeat the sequence of lines between the `.rept' directive and the
next `.endr' directive COUNT times.

   For example, assembling

             .rept   3
             .long   0
             .endr

   is equivalent to assembling

             .long   0
             .long   0
             .long   0


File: as.info,  Node: Sbttl,  Next: Scl,  Prev: Rept,  Up: Pseudo Ops

`.sbttl "SUBHEADING"'
=====================

   Use SUBHEADING as the title (third line, immediately after the title
line) when generating assembly listings.

   This directive affects subsequent pages, as well as the current page
if it appears within ten lines of the top of a page.


File: as.info,  Node: Scl,  Next: Section,  Prev: Sbttl,  Up: Pseudo Ops

`.scl CLASS'
============

   Set the storage-class value for a symbol.  This directive may only be
used inside a `.def'/`.endef' pair.  Storage class may flag whether a
symbol is static or external, or it may record further symbolic
debugging information.

   The `.scl' directive is primarily associated with COFF output; when
configured to generate `b.out' output format, `as' accepts this
directive but ignores it.


File: as.info,  Node: Section,  Next: Set,  Prev: Scl,  Up: Pseudo Ops

`.section NAME' (COFF version)
==============================

   Use the `.section' directive to assemble the following code into a
section named NAME.

   This directive is only supported for targets that actually support
arbitrarily named sections; on `a.out' targets, for example, it is not
accepted, even with a standard `a.out' section name.

   For COFF targets, the `.section' directive is used in one of the
following ways:

     .section NAME[, "FLAGS"]
     .section NAME[, SUBSEGMENT]

   If the optional argument is quoted, it is taken as flags to use for
the section.  Each flag is a single character.  The following flags are
recognized:
`b'
     bss section (uninitialized data)

`n'
     section is not loaded

`w'
     writable section

`d'
     data section

`r'
     read-only section

`x'
     executable section

`s'
     shared section (meaningful for PE targets)

   If no flags are specified, the default flags depend upon the section
name.  If the section name is not recognized, the default will be for
the section to be loaded and writable.

   If the optional argument to the `.section' directive is not quoted,
it is taken as a subsegment number (*note Sub-Sections::).

`.section NAME' (ELF version)
=============================

   This is one of the ELF section stack manipulation directives.  The
others are `.subsection' (*note SubSection::), `.pushsection' (*note
PushSection::), `.popsection' (*note PopSection::), and `.previous'
(*note Previous::).

   For ELF targets, the `.section' directive is used like this:

     .section NAME [, "FLAGS"[, @TYPE]]

   The optional FLAGS argument is a quoted string which may contain any
combination of the following characters:
`a'
     section is allocatable

`w'
     section is writable

`x'
     section is executable

   The optional TYPE argument may contain one of the following
constants:
`@progbits'
     section contains data

`@nobits'
     section does not contain data (i.e., section only occupies space)

   If no flags are specified, the default flags depend upon the section
name.  If the section name is not recognized, the default will be for
the section to have none of the above flags: it will not be allocated
in memory, nor writable, nor executable.  The section will contain data.

   For ELF targets, the assembler supports another type of `.section'
directive for compatibility with the Solaris assembler:

     .section "NAME"[, FLAGS...]

   Note that the section name is quoted.  There may be a sequence of
comma separated flags:
`#alloc'
     section is allocatable

`#write'
     section is writable

`#execinstr'
     section is executable

   This directive replaces the current section and subsection.  The
replaced section and subsection are pushed onto the section stack.  See
the contents of the gas testsuite directory `gas/testsuite/gas/elf' for
some examples of how this directive and the other section stack
directives work.


File: as.info,  Node: Set,  Next: Short,  Prev: Section,  Up: Pseudo Ops

`.set SYMBOL, EXPRESSION'
=========================

   Set the value of SYMBOL to EXPRESSION.  This changes SYMBOL's value
and type to conform to EXPRESSION.  If SYMBOL was flagged as external,
it remains flagged (*note Symbol Attributes::).

   You may `.set' a symbol many times in the same assembly.

   If you `.set' a global symbol, the value stored in the object file
is the last value stored into it.

   The syntax for `set' on the HPPA is `SYMBOL .set EXPRESSION'.


File: as.info,  Node: Short,  Next: Single,  Prev: Set,  Up: Pseudo Ops

`.short EXPRESSIONS'
====================

   `.short' is normally the same as `.word'.  *Note `.word': Word.

   In some configurations, however, `.short' and `.word' generate
numbers of different lengths; *note Machine Dependencies::.


File: as.info,  Node: Single,  Next: Size,  Prev: Short,  Up: Pseudo Ops

`.single FLONUMS'
=================

   This directive assembles zero or more flonums, separated by commas.
It has the same effect as `.float'.  The exact kind of floating point
numbers emitted depends on how `as' is configured.  *Note Machine
Dependencies::.


File: as.info,  Node: Size,  Next: Skip,  Prev: Single,  Up: Pseudo Ops

`.size' (COFF version)
======================

   This directive is generated by compilers to include auxiliary
debugging information in the symbol table.  It is only permitted inside
`.def'/`.endef' pairs.

   `.size' is only meaningful when generating COFF format output; when
`as' is generating `b.out', it accepts this directive but ignores it.

`.size NAME , EXPRESSION' (ELF version)
=======================================

   This directive is used to set the size associated with a symbol NAME.
The size in bytes is computed from EXPRESSION which can make use of
label arithmetic.  This directive is typically used to set the size of
function symbols.


File: as.info,  Node: Sleb128,  Next: Space,  Prev: Skip,  Up: Pseudo Ops

`.sleb128 EXPRESSIONS'
======================

   SLEB128 stands for "signed little endian base 128."  This is a
compact, variable length representation of numbers used by the DWARF
symbolic debugging format.  *Note `.uleb128': Uleb128.


File: as.info,  Node: Skip,  Next: Sleb128,  Prev: Size,  Up: Pseudo Ops

`.skip SIZE , FILL'
===================

   This directive emits SIZE bytes, each of value FILL.  Both SIZE and
FILL are absolute expressions.  If the comma and FILL are omitted, FILL
is assumed to be zero.  This is the same as `.space'.


File: as.info,  Node: Space,  Next: Stab,  Prev: Sleb128,  Up: Pseudo Ops

`.space SIZE , FILL'
====================

   This directive emits SIZE bytes, each of value FILL.  Both SIZE and
FILL are absolute expressions.  If the comma and FILL are omitted, FILL
is assumed to be zero.  This is the same as `.skip'.

     _Warning:_ `.space' has a completely different meaning for HPPA
     targets; use `.block' as a substitute.  See `HP9000 Series 800
     Assembly Language Reference Manual' (HP 92432-90001) for the
     meaning of the `.space' directive.  *Note HPPA Assembler
     Directives: HPPA Directives, for a summary.

   On the AMD 29K, this directive is ignored; it is accepted for
compatibility with other AMD 29K assemblers.

     _Warning:_ In most versions of the GNU assembler, the directive
     `.space' has the effect of `.block'  *Note Machine Dependencies::.


File: as.info,  Node: Stab,  Next: String,  Prev: Space,  Up: Pseudo Ops

`.stabd, .stabn, .stabs'
========================

   There are three directives that begin `.stab'.  All emit symbols
(*note Symbols::), for use by symbolic debuggers.  The symbols are not
entered in the `as' hash table: they cannot be referenced elsewhere in
the source file.  Up to five fields are required:

STRING
     This is the symbol's name.  It may contain any character except
     `\000', so is more general than ordinary symbol names.  Some
     debuggers used to code arbitrarily complex structures into symbol
     names using this field.

TYPE
     An absolute expression.  The symbol's type is set to the low 8
     bits of this expression.  Any bit pattern is permitted, but `ld'
     and debuggers choke on silly bit patterns.

OTHER
     An absolute expression.  The symbol's "other" attribute is set to
     the low 8 bits of this expression.

DESC
     An absolute expression.  The symbol's descriptor is set to the low
     16 bits of this expression.

VALUE
     An absolute expression which becomes the symbol's value.

   If a warning is detected while reading a `.stabd', `.stabn', or
`.stabs' statement, the symbol has probably already been created; you
get a half-formed symbol in your object file.  This is compatible with
earlier assemblers!

`.stabd TYPE , OTHER , DESC'
     The "name" of the symbol generated is not even an empty string.
     It is a null pointer, for compatibility.  Older assemblers used a
     null pointer so they didn't waste space in object files with empty
     strings.

     The symbol's value is set to the location counter, relocatably.
     When your program is linked, the value of this symbol is the
     address of the location counter when the `.stabd' was assembled.

`.stabn TYPE , OTHER , DESC , VALUE'
     The name of the symbol is set to the empty string `""'.

`.stabs STRING ,  TYPE , OTHER , DESC , VALUE'
     All five fields are specified.


File: as.info,  Node: String,  Next: Struct,  Prev: Stab,  Up: Pseudo Ops

`.string' "STR"
===============

   Copy the characters in STR to the object file.  You may specify more
than one string to copy, separated by commas.  Unless otherwise
specified for a particular machine, the assembler marks the end of each
string with a 0 byte.  You can use any of the escape sequences
described in *Note Strings: Strings.


File: as.info,  Node: Struct,  Next: SubSection,  Prev: String,  Up: Pseudo Ops

`.struct EXPRESSION'
====================

   Switch to the absolute section, and set the section offset to
EXPRESSION, which must be an absolute expression.  You might use this
as follows:
             .struct 0
     field1:
             .struct field1 + 4
     field2:
             .struct field2 + 4
     field3:
   This would define the symbol `field1' to have the value 0, the symbol
`field2' to have the value 4, and the symbol `field3' to have the value
8.  Assembly would be left in the absolute section, and you would need
to use a `.section' directive of some sort to change to some other
section before further assembly.


File: as.info,  Node: SubSection,  Next: Symver,  Prev: Struct,  Up: Pseudo Ops

`.subsection NAME'
==================

   This is one of the ELF section stack manipulation directives.  The
others are `.section' (*note Section::), `.pushsection' (*note
PushSection::), `.popsection' (*note PopSection::), and `.previous'
(*note Previous::).

   This directive replaces the current subsection with `name'.  The
current section is not changed.  The replaced subsection is put onto
the section stack in place of the then current top of stack subsection.


File: as.info,  Node: Symver,  Next: Tag,  Prev: SubSection,  Up: Pseudo Ops

`.symver'
=========

   Use the `.symver' directive to bind symbols to specific version nodes
within a source file.  This is only supported on ELF platforms, and is
typically used when assembling files to be linked into a shared library.
There are cases where it may make sense to use this in objects to be
bound into an application itself so as to override a versioned symbol
from a shared library.

   For ELF targets, the `.symver' directive can be used like this:
     .symver NAME, NAME2@NODENAME
   If the symbol NAME is defined within the file being assembled, the
`.symver' directive effectively creates a symbol alias with the name
NAME2@NODENAME, and in fact the main reason that we just don't try and
create a regular alias is that the @ character isn't permitted in
symbol names.  The NAME2 part of the name is the actual name of the
symbol by which it will be externally referenced.  The name NAME itself
is merely a name of convenience that is used so that it is possible to
have definitions for multiple versions of a function within a single
source file, and so that the compiler can unambiguously know which
version of a function is being mentioned.  The NODENAME portion of the
alias should be the name of a node specified in the version script
supplied to the linker when building a shared library.  If you are
attempting to override a versioned symbol from a shared library, then
NODENAME should correspond to the nodename of the symbol you are trying
to override.

   If the symbol NAME is not defined within the file being assembled,
all references to NAME will be changed to NAME2@NODENAME.  If no
reference to NAME is made, NAME2@NODENAME will be removed from the
symbol table.

   Another usage of the `.symver' directive is:
     .symver NAME, NAME2@@NODENAME
   In this case, the symbol NAME must exist and be defined within the
file being assembled. It is similar to NAME2@NODENAME. The difference
is NAME2@@NODENAME will also be used to resolve references to NAME2 by
the linker.

   The third usage of the `.symver' directive is:
     .symver NAME, NAME2@@@NODENAME
   When NAME is not defined within the file being assembled, it is
treated as NAME2@NODENAME. When NAME is defined within the file being
assembled, the symbol name, NAME, will be changed to NAME2@@NODENAME.


File: as.info,  Node: Tag,  Next: Text,  Prev: Symver,  Up: Pseudo Ops

`.tag STRUCTNAME'
=================

   This directive is generated by compilers to include auxiliary
debugging information in the symbol table.  It is only permitted inside
`.def'/`.endef' pairs.  Tags are used to link structure definitions in
the symbol table with instances of those structures.

   `.tag' is only used when generating COFF format output; when `as' is
generating `b.out', it accepts this directive but ignores it.


File: as.info,  Node: Text,  Next: Title,  Prev: Tag,  Up: Pseudo Ops

`.text SUBSECTION'
==================

   Tells `as' to assemble the following statements onto the end of the
text subsection numbered SUBSECTION, which is an absolute expression.
If SUBSECTION is omitted, subsection number zero is used.


File: as.info,  Node: Title,  Next: Type,  Prev: Text,  Up: Pseudo Ops

`.title "HEADING"'
==================

   Use HEADING as the title (second line, immediately after the source
file name and pagenumber) when generating assembly listings.

   This directive affects subsequent pages, as well as the current page
if it appears within ten lines of the top of a page.


File: as.info,  Node: Type,  Next: Uleb128,  Prev: Title,  Up: Pseudo Ops

`.type INT' (COFF version)
==========================

   This directive, permitted only within `.def'/`.endef' pairs, records
the integer INT as the type attribute of a symbol table entry.

   `.type' is associated only with COFF format output; when `as' is
configured for `b.out' output, it accepts this directive but ignores it.

`.type NAME , TYPE DESCRIPTION' (ELF version)
=============================================

   This directive is used to set the type of symbol NAME to be either a
function symbol or an object symbol.  There are five different syntaxes
supported for the TYPE DESCRIPTION field, in order to provide
compatibility with various other assemblers.  The syntaxes supported
are:

       .type <name>,#function
       .type <name>,#object
     
       .type <name>,@function
       .type <name>,@object
     
       .type <name>,%function
       .type <name>,%object
     
       .type <name>,"function"
       .type <name>,"object"
     
       .type <name> STT_FUNCTION
       .type <name> STT_OBJECT


File: as.info,  Node: Uleb128,  Next: Val,  Prev: Type,  Up: Pseudo Ops

`.uleb128 EXPRESSIONS'
======================

   ULEB128 stands for "unsigned little endian base 128."  This is a
compact, variable length representation of numbers used by the DWARF
symbolic debugging format.  *Note `.sleb128': Sleb128.


File: as.info,  Node: Val,  Next: Version,  Prev: Uleb128,  Up: Pseudo Ops

`.val ADDR'
===========

   This directive, permitted only within `.def'/`.endef' pairs, records
the address ADDR as the value attribute of a symbol table entry.

   `.val' is used only for COFF output; when `as' is configured for
`b.out', it accepts this directive but ignores it.


File: as.info,  Node: Version,  Next: VTableEntry,  Prev: Val,  Up: Pseudo Ops

`.version "STRING"'
===================

   This directive creates a `.note' section and places into it an ELF
formatted note of type NT_VERSION.  The note's name is set to `string'.


File: as.info,  Node: VTableEntry,  Next: VTableInherit,  Prev: Version,  Up: Pseudo Ops

`.vtable_entry TABLE, OFFSET'
=============================

   This directive finds or creates a symbol `table' and creates a
`VTABLE_ENTRY' relocation for it with an addend of `offset'.


File: as.info,  Node: VTableInherit,  Next: Weak,  Prev: VTableEntry,  Up: Pseudo Ops

`.vtable_inherit CHILD, PARENT'
===============================

   This directive finds the symbol `child' and finds or creates the
symbol `parent' and then creates a `VTABLE_INHERIT' relocation for the
parent whose addend is the value of the child symbol.  As a special
case the parent name of `0' is treated as refering the `*ABS*' section.


File: as.info,  Node: Weak,  Next: Word,  Prev: VTableInherit,  Up: Pseudo Ops

`.weak NAMES'
=============

   This directive sets the weak attribute on the comma separated list
of symbol `names'.  If the symbols do not already exist, they will be
created.


File: as.info,  Node: Word,  Next: Deprecated,  Prev: Weak,  Up: Pseudo Ops

`.word EXPRESSIONS'
===================

   This directive expects zero or more EXPRESSIONS, of any section,
separated by commas.

   The size of the number emitted, and its byte order, depend on what
target computer the assembly is for.

     _Warning: Special Treatment to support Compilers_

   Machines with a 32-bit address space, but that do less than 32-bit
addressing, require the following special treatment.  If the machine of
interest to you does 32-bit addressing (or doesn't require it; *note
Machine Dependencies::), you can ignore this issue.

   In order to assemble compiler output into something that works, `as'
occasionally does strange things to `.word' directives.  Directives of
the form `.word sym1-sym2' are often emitted by compilers as part of
jump tables.  Therefore, when `as' assembles a directive of the form
`.word sym1-sym2', and the difference between `sym1' and `sym2' does
not fit in 16 bits, `as' creates a "secondary jump table", immediately
before the next label.  This secondary jump table is preceded by a
short-jump to the first byte after the secondary table.  This
short-jump prevents the flow of control from accidentally falling into
the new table.  Inside the table is a long-jump to `sym2'.  The
original `.word' contains `sym1' minus the address of the long-jump to
`sym2'.

   If there were several occurrences of `.word sym1-sym2' before the
secondary jump table, all of them are adjusted.  If there was a `.word
sym3-sym4', that also did not fit in sixteen bits, a long-jump to
`sym4' is included in the secondary jump table, and the `.word'
directives are adjusted to contain `sym3' minus the address of the
long-jump to `sym4'; and so on, for as many entries in the original
jump table as necessary.


File: as.info,  Node: Deprecated,  Prev: Word,  Up: Pseudo Ops

Deprecated Directives
=====================

   One day these directives won't work.  They are included for
compatibility with older assemblers.
.abort

.line

File: as.info,  Node: Machine Dependencies,  Next: Reporting Bugs,  Prev: Pseudo Ops,  Up: Top

Machine Dependent Features
**************************

   The machine instruction sets are (almost by definition) different on
each machine where `as' runs.  Floating point representations vary as
well, and `as' often supports a few additional directives or
command-line options for compatibility with other assemblers on a
particular platform.  Finally, some versions of `as' support special
pseudo-instructions for branch optimization.

   This chapter discusses most of these differences, though it does not
include details on any machine's instruction set.  For details on that
subject, see the hardware manufacturer's manual.

* Menu:


* AMD29K-Dependent::            AMD 29K Dependent Features

* ARC-Dependent::               ARC Dependent Features

* ARM-Dependent::               ARM Dependent Features

* D10V-Dependent::              D10V Dependent Features

* D30V-Dependent::              D30V Dependent Features

* H8/300-Dependent::            Hitachi H8/300 Dependent Features

* H8/500-Dependent::            Hitachi H8/500 Dependent Features

* HPPA-Dependent::              HPPA Dependent Features

* ESA/390-Dependent::           IBM ESA/390 Dependent Features

* i386-Dependent::              Intel 80386 and AMD x86-64 Dependent Features

* i860-Dependent::              Intel 80860 Dependent Features

* i960-Dependent::              Intel 80960 Dependent Features

* M32R-Dependent::              M32R Dependent Features

* M68K-Dependent::              M680x0 Dependent Features

* M68HC11-Dependent::           M68HC11 and 68HC12 Dependent Features

* MIPS-Dependent::              MIPS Dependent Features

* SH-Dependent::                Hitachi SH Dependent Features

* PJ-Dependent::                picoJava Dependent Features

* Sparc-Dependent::             SPARC Dependent Features

* V850-Dependent::              V850 Dependent Features

* Z8000-Dependent::             Z8000 Dependent Features

* Vax-Dependent::               VAX Dependent Features


File: as.info,  Node: ARC-Dependent,  Next: ARM-Dependent,  Prev: AMD29K-Dependent,  Up: Machine Dependencies

ARC Dependent Features
======================

* Menu:

* ARC Options::              Options
* ARC Syntax::               Syntax
* ARC Floating Point::       Floating Point
* ARC Directives::           ARC Machine Directives
* ARC Opcodes::              Opcodes


File: as.info,  Node: ARC Options,  Next: ARC Syntax,  Up: ARC-Dependent

Options
-------

`-marc[5|6|7|8]'
     This option selects the core processor variant. Using `-marc' is
     the same as `-marc6', which is also the default.

    `arc5'
          Base instruction set.

    `arc6'
          Jump-and-link (jl) instruction. No requirement of an
          instruction between setting flags and conditional jump. For
          example:

                 mov.f r0,r1
                 beq   foo

    `arc7'
          Break (brk) and sleep (sleep) instructions.

    `arc8'
          Software interrupt (swi) instruction.

     Note: the `.option' directive can to be used to select a core
     variant from within assembly code.

`-EB'
     This option specifies that the output generated by the assembler
     should be marked as being encoded for a big-endian processor.

`-EL'
     This option specifies that the output generated by the assembler
     should be marked as being encoded for a little-endian processor -
     this is the default.


File: as.info,  Node: ARC Syntax,  Next: ARC Floating Point,  Prev: ARC Options,  Up: ARC-Dependent

Syntax
------

* Menu:

* ARC-Chars::                Special Characters
* ARC-Regs::                 Register Names


File: as.info,  Node: ARC-Chars,  Next: ARC-Regs,  Up: ARC Syntax

Special Characters
..................

   *TODO*


File: as.info,  Node: ARC-Regs,  Prev: ARC-Chars,  Up: ARC Syntax

Register Names
..............

   *TODO*


File: as.info,  Node: ARC Floating Point,  Next: ARC Directives,  Prev: ARC Syntax,  Up: ARC-Dependent

Floating Point
--------------

   The ARC core does not currently have hardware floating point
support. Software floating point support is provided by `GCC' and uses
IEEE floating-point numbers.


File: as.info,  Node: ARC Directives,  Next: ARC Opcodes,  Prev: ARC Floating Point,  Up: ARC-Dependent

ARC Machine Directives
----------------------

   The ARC version of `as' supports the following additional machine
directives:

`.2byte EXPRESSIONS'
     *TODO*

`.3byte EXPRESSIONS'
     *TODO*

`.4byte EXPRESSIONS'
     *TODO*

`.extAuxRegister NAME,ADDRESS,MODE'
     *TODO*

            .extAuxRegister mulhi,0x12,w

`.extCondCode SUFFIX,VALUE'
     *TODO*

            .extCondCode is_busy,0x14

`.extCoreRegister NAME,REGNUM,MODE,SHORTCUT'
     *TODO*

            .extCoreRegister mlo,57,r,can_shortcut

`.extInstruction NAME,OPCODE,SUBOPCODE,SUFFIXCLASS,SYNTAXCLASS'
     *TODO*

            .extInstruction mul64,0x14,0x0,SUFFIX_COND,SYNTAX_3OP|OP1_MUST_BE_IMM

`.half EXPRESSIONS'
     *TODO*

`.long EXPRESSIONS'
     *TODO*

`.option ARC|ARC5|ARC6|ARC7|ARC8'
     The `.option' directive must be followed by the desired core
     version. Again `arc' is an alias for `arc6'.

     Note: the `.option' directive overrides the command line option
     `-marc'; a warning is emitted when the version is not consistent
     between the two - even for the implicit default core version
     (arc6).

`.short EXPRESSIONS'
     *TODO*

`.word EXPRESSIONS'
     *TODO*


File: as.info,  Node: ARC Opcodes,  Prev: ARC Directives,  Up: ARC-Dependent

Opcodes
-------

   For information on the ARC instruction set, see `ARC Programmers
Reference Manual', ARC Cores Ltd.


File: as.info,  Node: AMD29K-Dependent,  Next: ARC-Dependent,  Up: Machine Dependencies

AMD 29K Dependent Features
==========================

* Menu:

* AMD29K Options::              Options
* AMD29K Syntax::               Syntax
* AMD29K Floating Point::       Floating Point
* AMD29K Directives::           AMD 29K Machine Directives
* AMD29K Opcodes::              Opcodes


File: as.info,  Node: AMD29K Options,  Next: AMD29K Syntax,  Up: AMD29K-Dependent

Options
-------

   `as' has no additional command-line options for the AMD 29K family.


File: as.info,  Node: AMD29K Syntax,  Next: AMD29K Floating Point,  Prev: AMD29K Options,  Up: AMD29K-Dependent

Syntax
------

* Menu:

* AMD29K-Macros::		Macros
* AMD29K-Chars::                Special Characters
* AMD29K-Regs::                 Register Names


File: as.info,  Node: AMD29K-Macros,  Next: AMD29K-Chars,  Up: AMD29K Syntax

Macros
......

   The macro syntax used on the AMD 29K is like that described in the
AMD 29K Family Macro Assembler Specification.  Normal `as' macros
should still work.


File: as.info,  Node: AMD29K-Chars,  Next: AMD29K-Regs,  Prev: AMD29K-Macros,  Up: AMD29K Syntax

Special Characters
..................

   `;' is the line comment character.

   The character `?' is permitted in identifiers (but may not begin an
identifier).

