This is bfd.info, produced by makeinfo version 4.0 from bfd.texinfo.

START-INFO-DIR-ENTRY
* Bfd: (bfd).                   The Binary File Descriptor library.
END-INFO-DIR-ENTRY

   This file documents the BFD library.

   Copyright (C) 1991, 2000 Free Software Foundation, Inc.

   Permission is granted to copy, distribute and/or modify this document
     under the terms of the GNU Free Documentation License, Version 1.1
     or any later version published by the Free Software Foundation;
   with no Invariant Sections, with no Front-Cover Texts, and with no
    Back-Cover Texts.  A copy of the license is included in the
section entitled "GNU Free Documentation License".


File: bfd.info,  Node: typedef arelent,  Next: howto manager,  Prev: Relocations,  Up: Relocations

typedef arelent
---------------

   This is the structure of a relocation entry:


     typedef enum bfd_reloc_status
     {
            /* No errors detected */
       bfd_reloc_ok,
     
            /* The relocation was performed, but there was an overflow. */
       bfd_reloc_overflow,
     
            /* The address to relocate was not within the section supplied. */
       bfd_reloc_outofrange,
     
            /* Used by special functions */
       bfd_reloc_continue,
     
            /* Unsupported relocation size requested. */
       bfd_reloc_notsupported,
     
            /* Unused */
       bfd_reloc_other,
     
            /* The symbol to relocate against was undefined. */
       bfd_reloc_undefined,
     
            /* The relocation was performed, but may not be ok - presently
               generated only when linking i960 coff files with i960 b.out
               symbols.  If this type is returned, the error_message argument
               to bfd_perform_relocation will be set.  */
       bfd_reloc_dangerous
      }
      bfd_reloc_status_type;
     
     
     typedef struct reloc_cache_entry
     {
            /* A pointer into the canonical table of pointers  */
       struct symbol_cache_entry **sym_ptr_ptr;
     
            /* offset in section */
       bfd_size_type address;
     
            /* addend for relocation value */
       bfd_vma addend;
     
            /* Pointer to how to perform the required relocation */
       reloc_howto_type *howto;
     
     } arelent;
   *Description*
Here is a description of each of the fields within an `arelent':

   * `sym_ptr_ptr'
   The symbol table pointer points to a pointer to the symbol
associated with the relocation request.  It is the pointer into the
table returned by the back end's `get_symtab' action. *Note Symbols::.
The symbol is referenced through a pointer to a pointer so that tools
like the linker can fix up all the symbols of the same name by
modifying only one pointer. The relocation routine looks in the symbol
and uses the base of the section the symbol is attached to and the
value of the symbol as the initial relocation offset. If the symbol
pointer is zero, then the section provided is looked up.

   * `address'
   The `address' field gives the offset in bytes from the base of the
section data which owns the relocation record to the first byte of
relocatable information. The actual data relocated will be relative to
this point; for example, a relocation type which modifies the bottom
two bytes of a four byte word would not touch the first byte pointed to
in a big endian world.

   * `addend'
   The `addend' is a value provided by the back end to be added (!)  to
the relocation offset. Its interpretation is dependent upon the howto.
For example, on the 68k the code:

             char foo[];
             main()
                     {
                     return foo[0x12345678];
                     }

   Could be compiled into:

             linkw fp,#-4
             moveb @#12345678,d0
             extbl d0
             unlk fp
             rts

   This could create a reloc pointing to `foo', but leave the offset in
the data, something like:

     RELOCATION RECORDS FOR [.text]:
     offset   type      value
     00000006 32        _foo
     
     00000000 4e56 fffc          ; linkw fp,#-4
     00000004 1039 1234 5678     ; moveb @#12345678,d0
     0000000a 49c0               ; extbl d0
     0000000c 4e5e               ; unlk fp
     0000000e 4e75               ; rts

   Using coff and an 88k, some instructions don't have enough space in
them to represent the full address range, and pointers have to be
loaded in two parts. So you'd get something like:

             or.u     r13,r0,hi16(_foo+0x12345678)
             ld.b     r2,r13,lo16(_foo+0x12345678)
             jmp      r1

   This should create two relocs, both pointing to `_foo', and with
0x12340000 in their addend field. The data would consist of:

     RELOCATION RECORDS FOR [.text]:
     offset   type      value
     00000002 HVRT16    _foo+0x12340000
     00000006 LVRT16    _foo+0x12340000
     
     00000000 5da05678           ; or.u r13,r0,0x5678
     00000004 1c4d5678           ; ld.b r2,r13,0x5678
     00000008 f400c001           ; jmp r1

   The relocation routine digs out the value from the data, adds it to
the addend to get the original offset, and then adds the value of
`_foo'. Note that all 32 bits have to be kept around somewhere, to cope
with carry from bit 15 to bit 16.

   One further example is the sparc and the a.out format. The sparc has
a similar problem to the 88k, in that some instructions don't have room
for an entire offset, but on the sparc the parts are created in odd
sized lumps. The designers of the a.out format chose to not use the
data within the section for storing part of the offset; all the offset
is kept within the reloc. Anything in the data should be ignored.

             save %sp,-112,%sp
             sethi %hi(_foo+0x12345678),%g2
             ldsb [%g2+%lo(_foo+0x12345678)],%i0
             ret
             restore

   Both relocs contain a pointer to `foo', and the offsets contain junk.

     RELOCATION RECORDS FOR [.text]:
     offset   type      value
     00000004 HI22      _foo+0x12345678
     00000008 LO10      _foo+0x12345678
     
     00000000 9de3bf90     ; save %sp,-112,%sp
     00000004 05000000     ; sethi %hi(_foo+0),%g2
     00000008 f048a000     ; ldsb [%g2+%lo(_foo+0)],%i0
     0000000c 81c7e008     ; ret
     00000010 81e80000     ; restore

   * `howto'
   The `howto' field can be imagined as a relocation instruction. It is
a pointer to a structure which contains information on what to do with
all of the other information in the reloc record and data section. A
back end would normally have a relocation instruction set and turn
relocations into pointers to the correct structure on input - but it
would be possible to create each howto field on demand.

`enum complain_overflow'
........................

   Indicates what sort of overflow checking should be done when
performing a relocation.


     enum complain_overflow
     {
            /* Do not complain on overflow. */
       complain_overflow_dont,
     
            /* Complain if the bitfield overflows, whether it is considered
               as signed or unsigned. */
       complain_overflow_bitfield,
     
            /* Complain if the value overflows when considered as signed
               number. */
       complain_overflow_signed,
     
            /* Complain if the value overflows when considered as an
               unsigned number. */
       complain_overflow_unsigned
     };

`reloc_howto_type'
..................

   The `reloc_howto_type' is a structure which contains all the
information that libbfd needs to know to tie up a back end's data.

     struct symbol_cache_entry;             /* Forward declaration */
     
     struct reloc_howto_struct
     {
            /*  The type field has mainly a documentary use - the back end can
                do what it wants with it, though normally the back end's
                external idea of what a reloc number is stored
                in this field. For example, a PC relative word relocation
                in a coff environment has the type 023 - because that's
                what the outside world calls a R_PCRWORD reloc. */
       unsigned int type;
     
            /*  The value the final relocation is shifted right by. This drops
                unwanted data from the relocation.  */
       unsigned int rightshift;
     
            /*  The size of the item to be relocated.  This is *not* a
                power-of-two measure.  To get the number of bytes operated
                on by a type of relocation, use bfd_get_reloc_size.  */
       int size;
     
            /*  The number of bits in the item to be relocated.  This is used
                when doing overflow checking.  */
       unsigned int bitsize;
     
            /*  Notes that the relocation is relative to the location in the
                data section of the addend. The relocation function will
                subtract from the relocation value the address of the location
                being relocated. */
       boolean pc_relative;
     
            /*  The bit position of the reloc value in the destination.
                The relocated value is left shifted by this amount. */
       unsigned int bitpos;
     
            /* What type of overflow error should be checked for when
               relocating. */
       enum complain_overflow complain_on_overflow;
     
            /* If this field is non null, then the supplied function is
               called rather than the normal function. This allows really
               strange relocation methods to be accomodated (e.g., i960 callj
               instructions). */
       bfd_reloc_status_type (*special_function)
                                        PARAMS ((bfd *abfd,
                                                 arelent *reloc_entry,
                                                 struct symbol_cache_entry *symbol,
                                                 PTR data,
                                                 asection *input_section,
                                                 bfd *output_bfd,
                                                 char **error_message));
     
            /* The textual name of the relocation type. */
       char *name;
     
            /* Some formats record a relocation addend in the section contents
               rather than with the relocation.  For ELF formats this is the
               distinction between USE_REL and USE_RELA (though the code checks
               for USE_REL == 1/0).  The value of this field is TRUE if the
               addend is recorded with the section contents; when performing a
               partial link (ld -r) the section contents (the data) will be
               modified.  The value of this field is FALSE if addends are
               recorded with the relocation (in arelent.addend); when performing
               a partial link the relocation will be modified.
               All relocations for all ELF USE_RELA targets should set this field
               to FALSE (values of TRUE should be looked on with suspicion).
               However, the converse is not true: not all relocations of all ELF
               USE_REL targets set this field to TRUE.  Why this is so is peculiar
               to each particular target.  For relocs that aren't used in partial
               links (e.g. GOT stuff) it doesn't matter what this is set to.  */
       boolean partial_inplace;
     
            /* The src_mask selects which parts of the read in data
               are to be used in the relocation sum.  E.g., if this was an 8 bit
               byte of data which we read and relocated, this would be
               0x000000ff. When we have relocs which have an addend, such as
               sun4 extended relocs, the value in the offset part of a
               relocating field is garbage so we never use it. In this case
               the mask would be 0x00000000. */
       bfd_vma src_mask;
     
            /* The dst_mask selects which parts of the instruction are replaced
               into the instruction. In most cases src_mask == dst_mask,
               except in the above special case, where dst_mask would be
               0x000000ff, and src_mask would be 0x00000000.   */
       bfd_vma dst_mask;
     
            /* When some formats create PC relative instructions, they leave
               the value of the pc of the place being relocated in the offset
               slot of the instruction, so that a PC relative relocation can
               be made just by adding in an ordinary offset (e.g., sun3 a.out).
               Some formats leave the displacement part of an instruction
               empty (e.g., m88k bcs); this flag signals the fact.*/
       boolean pcrel_offset;
     
     };

`The HOWTO Macro'
.................

   *Description*
The HOWTO define is horrible and will go away.
     #define HOWTO(C, R,S,B, P, BI, O, SF, NAME, INPLACE, MASKSRC, MASKDST, PC) \
       {(unsigned)C,R,S,B, P, BI, O,SF,NAME,INPLACE,MASKSRC,MASKDST,PC}

   *Description*
And will be replaced with the totally magic way. But for the moment, we
are compatible, so do it this way.
     #define NEWHOWTO( FUNCTION, NAME,SIZE,REL,IN) HOWTO(0,0,SIZE,0,REL,0,complain_overflow_dont,FUNCTION, NAME,false,0,0,IN)

   *Description*
This is used to fill in an empty howto entry in an array.
     #define EMPTY_HOWTO(C) \
       HOWTO((C),0,0,0,false,0,complain_overflow_dont,NULL,NULL,false,0,0,false)

   *Description*
Helper routine to turn a symbol into a relocation value.
     #define HOWTO_PREPARE(relocation, symbol)      \
       {                                            \
       if (symbol != (asymbol *)NULL) {             \
         if (bfd_is_com_section (symbol->section)) { \
           relocation = 0;                          \
         }                                          \
         else {                                     \
           relocation = symbol->value;              \
         }                                          \
       }                                            \
     }

`bfd_get_reloc_size'
....................

   *Synopsis*
     unsigned int bfd_get_reloc_size (reloc_howto_type *);
   *Description*
For a reloc_howto_type that operates on a fixed number of bytes, this
returns the number of bytes operated on.

`arelent_chain'
...............

   *Description*
How relocs are tied together in an `asection':
     typedef struct relent_chain {
       arelent relent;
       struct   relent_chain *next;
     } arelent_chain;

`bfd_check_overflow'
....................

   *Synopsis*
     bfd_reloc_status_type
     bfd_check_overflow
        (enum complain_overflow how,
         unsigned int bitsize,
         unsigned int rightshift,
         unsigned int addrsize,
         bfd_vma relocation);
   *Description*
Perform overflow checking on RELOCATION which has BITSIZE significant
bits and will be shifted right by RIGHTSHIFT bits, on a machine with
addresses containing ADDRSIZE significant bits.  The result is either of
`bfd_reloc_ok' or `bfd_reloc_overflow'.

`bfd_perform_relocation'
........................

   *Synopsis*
     bfd_reloc_status_type
     bfd_perform_relocation
        (bfd *abfd,
         arelent *reloc_entry,
         PTR data,
         asection *input_section,
         bfd *output_bfd,
         char **error_message);
   *Description*
If OUTPUT_BFD is supplied to this function, the generated image will be
relocatable; the relocations are copied to the output file after they
have been changed to reflect the new state of the world. There are two
ways of reflecting the results of partial linkage in an output file: by
modifying the output data in place, and by modifying the relocation
record.  Some native formats (e.g., basic a.out and basic coff) have no
way of specifying an addend in the relocation type, so the addend has
to go in the output data.  This is no big deal since in these formats
the output data slot will always be big enough for the addend. Complex
reloc types with addends were invented to solve just this problem.  The
ERROR_MESSAGE argument is set to an error message if this return
`bfd_reloc_dangerous'.

`bfd_install_relocation'
........................

   *Synopsis*
     bfd_reloc_status_type
     bfd_install_relocation
        (bfd *abfd,
         arelent *reloc_entry,
         PTR data, bfd_vma data_start,
         asection *input_section,
         char **error_message);
   *Description*
This looks remarkably like `bfd_perform_relocation', except it does not
expect that the section contents have been filled in.  I.e., it's
suitable for use when creating, rather than applying a relocation.

   For now, this function should be considered reserved for the
assembler.


File: bfd.info,  Node: howto manager,  Prev: typedef arelent,  Up: Relocations

The howto manager
=================

   When an application wants to create a relocation, but doesn't know
what the target machine might call it, it can find out by using this
bit of code.

`bfd_reloc_code_type'
.....................

   *Description*
The insides of a reloc code.  The idea is that, eventually, there will
be one enumerator for every type of relocation we ever do.  Pass one of
these values to `bfd_reloc_type_lookup', and it'll return a howto
pointer.

   This does mean that the application must determine the correct
enumerator value; you can't get a howto pointer from a random set of
attributes.

   Here are the possible values for `enum bfd_reloc_code_real':

 - : BFD_RELOC_64
 - : BFD_RELOC_32
 - : BFD_RELOC_26
 - : BFD_RELOC_24
 - : BFD_RELOC_16
 - : BFD_RELOC_14
 - : BFD_RELOC_8
     Basic absolute relocations of N bits.

 - : BFD_RELOC_64_PCREL
 - : BFD_RELOC_32_PCREL
 - : BFD_RELOC_24_PCREL
 - : BFD_RELOC_16_PCREL
 - : BFD_RELOC_12_PCREL
 - : BFD_RELOC_8_PCREL
     PC-relative relocations.  Sometimes these are relative to the
     address of the relocation itself; sometimes they are relative to
     the start of the section containing the relocation.  It depends on
     the specific target.

     The 24-bit relocation is used in some Intel 960 configurations.

 - : BFD_RELOC_32_GOT_PCREL
 - : BFD_RELOC_16_GOT_PCREL
 - : BFD_RELOC_8_GOT_PCREL
 - : BFD_RELOC_32_GOTOFF
 - : BFD_RELOC_16_GOTOFF
 - : BFD_RELOC_LO16_GOTOFF
 - : BFD_RELOC_HI16_GOTOFF
 - : BFD_RELOC_HI16_S_GOTOFF
 - : BFD_RELOC_8_GOTOFF
 - : BFD_RELOC_32_PLT_PCREL
 - : BFD_RELOC_24_PLT_PCREL
 - : BFD_RELOC_16_PLT_PCREL
 - : BFD_RELOC_8_PLT_PCREL
 - : BFD_RELOC_32_PLTOFF
 - : BFD_RELOC_16_PLTOFF
 - : BFD_RELOC_LO16_PLTOFF
 - : BFD_RELOC_HI16_PLTOFF
 - : BFD_RELOC_HI16_S_PLTOFF
 - : BFD_RELOC_8_PLTOFF
     For ELF.

 - : BFD_RELOC_68K_GLOB_DAT
 - : BFD_RELOC_68K_JMP_SLOT
 - : BFD_RELOC_68K_RELATIVE
     Relocations used by 68K ELF.

 - : BFD_RELOC_32_BASEREL
 - : BFD_RELOC_16_BASEREL
 - : BFD_RELOC_LO16_BASEREL
 - : BFD_RELOC_HI16_BASEREL
 - : BFD_RELOC_HI16_S_BASEREL
 - : BFD_RELOC_8_BASEREL
 - : BFD_RELOC_RVA
     Linkage-table relative.

 - : BFD_RELOC_8_FFnn
     Absolute 8-bit relocation, but used to form an address like 0xFFnn.

 - : BFD_RELOC_32_PCREL_S2
 - : BFD_RELOC_16_PCREL_S2
 - : BFD_RELOC_23_PCREL_S2
     These PC-relative relocations are stored as word displacements -
     i.e., byte displacements shifted right two bits.  The 30-bit word
     displacement (<<32_PCREL_S2>> - 32 bits, shifted 2) is used on the
     SPARC.  (SPARC tools generally refer to this as <<WDISP30>>.)  The
     signed 16-bit displacement is used on the MIPS, and the 23-bit
     displacement is used on the Alpha.

 - : BFD_RELOC_HI22
 - : BFD_RELOC_LO10
     High 22 bits and low 10 bits of 32-bit value, placed into lower
     bits of the target word.  These are used on the SPARC.

 - : BFD_RELOC_GPREL16
 - : BFD_RELOC_GPREL32
     For systems that allocate a Global Pointer register, these are
     displacements off that register.  These relocation types are
     handled specially, because the value the register will have is
     decided relatively late.

 - : BFD_RELOC_I960_CALLJ
     Reloc types used for i960/b.out.

 - : BFD_RELOC_NONE
 - : BFD_RELOC_SPARC_WDISP22
 - : BFD_RELOC_SPARC22
 - : BFD_RELOC_SPARC13
 - : BFD_RELOC_SPARC_GOT10
 - : BFD_RELOC_SPARC_GOT13
 - : BFD_RELOC_SPARC_GOT22
 - : BFD_RELOC_SPARC_PC10
 - : BFD_RELOC_SPARC_PC22
 - : BFD_RELOC_SPARC_WPLT30
 - : BFD_RELOC_SPARC_COPY
 - : BFD_RELOC_SPARC_GLOB_DAT
 - : BFD_RELOC_SPARC_JMP_SLOT
 - : BFD_RELOC_SPARC_RELATIVE
 - : BFD_RELOC_SPARC_UA32
     SPARC ELF relocations.  There is probably some overlap with other
     relocation types already defined.

 - : BFD_RELOC_SPARC_BASE13
 - : BFD_RELOC_SPARC_BASE22
     I think these are specific to SPARC a.out (e.g., Sun 4).

 - : BFD_RELOC_SPARC_64
 - : BFD_RELOC_SPARC_10
 - : BFD_RELOC_SPARC_11
 - : BFD_RELOC_SPARC_OLO10
 - : BFD_RELOC_SPARC_HH22
 - : BFD_RELOC_SPARC_HM10
 - : BFD_RELOC_SPARC_LM22
 - : BFD_RELOC_SPARC_PC_HH22
 - : BFD_RELOC_SPARC_PC_HM10
 - : BFD_RELOC_SPARC_PC_LM22
 - : BFD_RELOC_SPARC_WDISP16
 - : BFD_RELOC_SPARC_WDISP19
 - : BFD_RELOC_SPARC_7
 - : BFD_RELOC_SPARC_6
 - : BFD_RELOC_SPARC_5
 - : BFD_RELOC_SPARC_DISP64
 - : BFD_RELOC_SPARC_PLT64
 - : BFD_RELOC_SPARC_HIX22
 - : BFD_RELOC_SPARC_LOX10
 - : BFD_RELOC_SPARC_H44
 - : BFD_RELOC_SPARC_M44
 - : BFD_RELOC_SPARC_L44
 - : BFD_RELOC_SPARC_REGISTER
     SPARC64 relocations

 - : BFD_RELOC_SPARC_REV32
     SPARC little endian relocation

 - : BFD_RELOC_ALPHA_GPDISP_HI16
     Alpha ECOFF and ELF relocations.  Some of these treat the symbol or
     "addend" in some special way.  For GPDISP_HI16 ("gpdisp")
     relocations, the symbol is ignored when writing; when reading, it
     will be the absolute section symbol.  The addend is the
     displacement in bytes of the "lda" instruction from the "ldah"
     instruction (which is at the address of this reloc).

 - : BFD_RELOC_ALPHA_GPDISP_LO16
     For GPDISP_LO16 ("ignore") relocations, the symbol is handled as
     with GPDISP_HI16 relocs.  The addend is ignored when writing the
     relocations out, and is filled in with the file's GP value on
     reading, for convenience.

 - : BFD_RELOC_ALPHA_GPDISP
     The ELF GPDISP relocation is exactly the same as the GPDISP_HI16
     relocation except that there is no accompanying GPDISP_LO16
     relocation.

 - : BFD_RELOC_ALPHA_LITERAL
 - : BFD_RELOC_ALPHA_ELF_LITERAL
 - : BFD_RELOC_ALPHA_LITUSE
     The Alpha LITERAL/LITUSE relocs are produced by a symbol reference;
     the assembler turns it into a LDQ instruction to load the address
     of the symbol, and then fills in a register in the real
     instruction.

     The LITERAL reloc, at the LDQ instruction, refers to the .lita
     section symbol.  The addend is ignored when writing, but is filled
     in with the file's GP value on reading, for convenience, as with
     the GPDISP_LO16 reloc.

     The ELF_LITERAL reloc is somewhere between 16_GOTOFF and
     GPDISP_LO16.  It should refer to the symbol to be referenced, as
     with 16_GOTOFF, but it generates output not based on the position
     within the .got section, but relative to the GP value chosen for
     the file during the final link stage.

     The LITUSE reloc, on the instruction using the loaded address,
     gives information to the linker that it might be able to use to
     optimize away some literal section references.  The symbol is
     ignored (read as the absolute section symbol), and the "addend"
     indicates the type of instruction using the register: 1 - "memory"
     fmt insn 2 - byte-manipulation (byte offset reg) 3 - jsr (target
     of branch)

     The GNU linker currently doesn't do any of this optimizing.

 - : BFD_RELOC_ALPHA_USER_LITERAL
 - : BFD_RELOC_ALPHA_USER_LITUSE_BASE
 - : BFD_RELOC_ALPHA_USER_LITUSE_BYTOFF
 - : BFD_RELOC_ALPHA_USER_LITUSE_JSR
 - : BFD_RELOC_ALPHA_USER_GPDISP
 - : BFD_RELOC_ALPHA_USER_GPRELHIGH
 - : BFD_RELOC_ALPHA_USER_GPRELLOW
     The BFD_RELOC_ALPHA_USER_* relocations are used by the assembler to
     process the explicit !<reloc>!sequence relocations, and are mapped
     into the normal relocations at the end of processing.

 - : BFD_RELOC_ALPHA_HINT
     The HINT relocation indicates a value that should be filled into
     the "hint" field of a jmp/jsr/ret instruction, for possible branch-
     prediction logic which may be provided on some processors.

 - : BFD_RELOC_ALPHA_LINKAGE
     The LINKAGE relocation outputs a linkage pair in the object file,
     which is filled by the linker.

 - : BFD_RELOC_ALPHA_CODEADDR
     The CODEADDR relocation outputs a STO_CA in the object file, which
     is filled by the linker.

 - : BFD_RELOC_MIPS_JMP
     Bits 27..2 of the relocation address shifted right 2 bits; simple
     reloc otherwise.

 - : BFD_RELOC_MIPS16_JMP
     The MIPS16 jump instruction.

 - : BFD_RELOC_MIPS16_GPREL
     MIPS16 GP relative reloc.

 - : BFD_RELOC_HI16
     High 16 bits of 32-bit value; simple reloc.

 - : BFD_RELOC_HI16_S
     High 16 bits of 32-bit value but the low 16 bits will be sign
     extended and added to form the final result.  If the low 16 bits
     form a negative number, we need to add one to the high value to
     compensate for the borrow when the low bits are added.

 - : BFD_RELOC_LO16
     Low 16 bits.

 - : BFD_RELOC_PCREL_HI16_S
     Like BFD_RELOC_HI16_S, but PC relative.

 - : BFD_RELOC_PCREL_LO16
     Like BFD_RELOC_LO16, but PC relative.

 - : BFD_RELOC_MIPS_GPREL
     Relocation relative to the global pointer.

 - : BFD_RELOC_MIPS_LITERAL
     Relocation against a MIPS literal section.

 - : BFD_RELOC_MIPS_GOT16
 - : BFD_RELOC_MIPS_CALL16
 - : BFD_RELOC_MIPS_GPREL32
 - : BFD_RELOC_MIPS_GOT_HI16
 - : BFD_RELOC_MIPS_GOT_LO16
 - : BFD_RELOC_MIPS_CALL_HI16
 - : BFD_RELOC_MIPS_CALL_LO16
 - : BFD_RELOC_MIPS_SUB
 - : BFD_RELOC_MIPS_GOT_PAGE
 - : BFD_RELOC_MIPS_GOT_OFST
 - : BFD_RELOC_MIPS_GOT_DISP
     MIPS ELF relocations.

 - : BFD_RELOC_386_GOT32
 - : BFD_RELOC_386_PLT32
 - : BFD_RELOC_386_COPY
 - : BFD_RELOC_386_GLOB_DAT
 - : BFD_RELOC_386_JUMP_SLOT
 - : BFD_RELOC_386_RELATIVE
 - : BFD_RELOC_386_GOTOFF
 - : BFD_RELOC_386_GOTPC
     i386/elf relocations

 - : BFD_RELOC_X86_64_GOT32
 - : BFD_RELOC_X86_64_PLT32
 - : BFD_RELOC_X86_64_COPY
 - : BFD_RELOC_X86_64_GLOB_DAT
 - : BFD_RELOC_X86_64_JUMP_SLOT
 - : BFD_RELOC_X86_64_RELATIVE
 - : BFD_RELOC_X86_64_GOTPCREL
 - : BFD_RELOC_X86_64_32S
     x86-64/elf relocations

 - : BFD_RELOC_NS32K_IMM_8
 - : BFD_RELOC_NS32K_IMM_16
 - : BFD_RELOC_NS32K_IMM_32
 - : BFD_RELOC_NS32K_IMM_8_PCREL
 - : BFD_RELOC_NS32K_IMM_16_PCREL
 - : BFD_RELOC_NS32K_IMM_32_PCREL
 - : BFD_RELOC_NS32K_DISP_8
 - : BFD_RELOC_NS32K_DISP_16
 - : BFD_RELOC_NS32K_DISP_32
 - : BFD_RELOC_NS32K_DISP_8_PCREL
 - : BFD_RELOC_NS32K_DISP_16_PCREL
 - : BFD_RELOC_NS32K_DISP_32_PCREL
     ns32k relocations

 - : BFD_RELOC_PJ_CODE_HI16
 - : BFD_RELOC_PJ_CODE_LO16
 - : BFD_RELOC_PJ_CODE_DIR16
 - : BFD_RELOC_PJ_CODE_DIR32
 - : BFD_RELOC_PJ_CODE_REL16
 - : BFD_RELOC_PJ_CODE_REL32
     Picojava relocs.  Not all of these appear in object files.

 - : BFD_RELOC_PPC_B26
 - : BFD_RELOC_PPC_BA26
 - : BFD_RELOC_PPC_TOC16
 - : BFD_RELOC_PPC_B16
 - : BFD_RELOC_PPC_B16_BRTAKEN
 - : BFD_RELOC_PPC_B16_BRNTAKEN
 - : BFD_RELOC_PPC_BA16
 - : BFD_RELOC_PPC_BA16_BRTAKEN
 - : BFD_RELOC_PPC_BA16_BRNTAKEN
 - : BFD_RELOC_PPC_COPY
 - : BFD_RELOC_PPC_GLOB_DAT
 - : BFD_RELOC_PPC_JMP_SLOT
 - : BFD_RELOC_PPC_RELATIVE
 - : BFD_RELOC_PPC_LOCAL24PC
 - : BFD_RELOC_PPC_EMB_NADDR32
 - : BFD_RELOC_PPC_EMB_NADDR16
 - : BFD_RELOC_PPC_EMB_NADDR16_LO
 - : BFD_RELOC_PPC_EMB_NADDR16_HI
 - : BFD_RELOC_PPC_EMB_NADDR16_HA
 - : BFD_RELOC_PPC_EMB_SDAI16
 - : BFD_RELOC_PPC_EMB_SDA2I16
 - : BFD_RELOC_PPC_EMB_SDA2REL
 - : BFD_RELOC_PPC_EMB_SDA21
 - : BFD_RELOC_PPC_EMB_MRKREF
 - : BFD_RELOC_PPC_EMB_RELSEC16
 - : BFD_RELOC_PPC_EMB_RELST_LO
 - : BFD_RELOC_PPC_EMB_RELST_HI
 - : BFD_RELOC_PPC_EMB_RELST_HA
 - : BFD_RELOC_PPC_EMB_BIT_FLD
 - : BFD_RELOC_PPC_EMB_RELSDA
     Power(rs6000) and PowerPC relocations.

 - : BFD_RELOC_I370_D12
     IBM 370/390 relocations

 - : BFD_RELOC_CTOR
     The type of reloc used to build a contructor table - at the moment
     probably a 32 bit wide absolute relocation, but the target can
     choose.  It generally does map to one of the other relocation
     types.

 - : BFD_RELOC_ARM_PCREL_BRANCH
     ARM 26 bit pc-relative branch.  The lowest two bits must be zero
     and are not stored in the instruction.

 - : BFD_RELOC_ARM_PCREL_BLX
     ARM 26 bit pc-relative branch.  The lowest bit must be zero and is
     not stored in the instruction.  The 2nd lowest bit comes from a 1
     bit field in the instruction.

 - : BFD_RELOC_THUMB_PCREL_BLX
     Thumb 22 bit pc-relative branch.  The lowest bit must be zero and
     is not stored in the instruction.  The 2nd lowest bit comes from a
     1 bit field in the instruction.

 - : BFD_RELOC_ARM_IMMEDIATE
 - : BFD_RELOC_ARM_ADRL_IMMEDIATE
 - : BFD_RELOC_ARM_OFFSET_IMM
 - : BFD_RELOC_ARM_SHIFT_IMM
 - : BFD_RELOC_ARM_SWI
 - : BFD_RELOC_ARM_MULTI
 - : BFD_RELOC_ARM_CP_OFF_IMM
 - : BFD_RELOC_ARM_ADR_IMM
 - : BFD_RELOC_ARM_LDR_IMM
 - : BFD_RELOC_ARM_LITERAL
 - : BFD_RELOC_ARM_IN_POOL
 - : BFD_RELOC_ARM_OFFSET_IMM8
 - : BFD_RELOC_ARM_HWLITERAL
 - : BFD_RELOC_ARM_THUMB_ADD
 - : BFD_RELOC_ARM_THUMB_IMM
 - : BFD_RELOC_ARM_THUMB_SHIFT
 - : BFD_RELOC_ARM_THUMB_OFFSET
 - : BFD_RELOC_ARM_GOT12
 - : BFD_RELOC_ARM_GOT32
 - : BFD_RELOC_ARM_JUMP_SLOT
 - : BFD_RELOC_ARM_COPY
 - : BFD_RELOC_ARM_GLOB_DAT
 - : BFD_RELOC_ARM_PLT32
 - : BFD_RELOC_ARM_RELATIVE
 - : BFD_RELOC_ARM_GOTOFF
 - : BFD_RELOC_ARM_GOTPC
     These relocs are only used within the ARM assembler.  They are not
     (at present) written to any object files.

 - : BFD_RELOC_SH_PCDISP8BY2
 - : BFD_RELOC_SH_PCDISP12BY2
 - : BFD_RELOC_SH_IMM4
 - : BFD_RELOC_SH_IMM4BY2
 - : BFD_RELOC_SH_IMM4BY4
 - : BFD_RELOC_SH_IMM8
 - : BFD_RELOC_SH_IMM8BY2
 - : BFD_RELOC_SH_IMM8BY4
 - : BFD_RELOC_SH_PCRELIMM8BY2
 - : BFD_RELOC_SH_PCRELIMM8BY4
 - : BFD_RELOC_SH_SWITCH16
 - : BFD_RELOC_SH_SWITCH32
 - : BFD_RELOC_SH_USES
 - : BFD_RELOC_SH_COUNT
 - : BFD_RELOC_SH_ALIGN
 - : BFD_RELOC_SH_CODE
 - : BFD_RELOC_SH_DATA
 - : BFD_RELOC_SH_LABEL
 - : BFD_RELOC_SH_LOOP_START
 - : BFD_RELOC_SH_LOOP_END
 - : BFD_RELOC_SH_COPY
 - : BFD_RELOC_SH_GLOB_DAT
 - : BFD_RELOC_SH_JMP_SLOT
 - : BFD_RELOC_SH_RELATIVE
 - : BFD_RELOC_SH_GOTPC
     Hitachi SH relocs.  Not all of these appear in object files.

 - : BFD_RELOC_THUMB_PCREL_BRANCH9
 - : BFD_RELOC_THUMB_PCREL_BRANCH12
 - : BFD_RELOC_THUMB_PCREL_BRANCH23
     Thumb 23-, 12- and 9-bit pc-relative branches.  The lowest bit must
     be zero and is not stored in the instruction.

 - : BFD_RELOC_ARC_B22_PCREL
     ARC Cores relocs.  ARC 22 bit pc-relative branch.  The lowest two
     bits must be zero and are not stored in the instruction.  The high
     20 bits are installed in bits 26 through 7 of the instruction.

 - : BFD_RELOC_ARC_B26
     ARC 26 bit absolute branch.  The lowest two bits must be zero and
     are not stored in the instruction.  The high 24 bits are installed
     in bits 23 through 0.

 - : BFD_RELOC_D10V_10_PCREL_R
     Mitsubishi D10V relocs.  This is a 10-bit reloc with the right 2
     bits assumed to be 0.

 - : BFD_RELOC_D10V_10_PCREL_L
     Mitsubishi D10V relocs.  This is a 10-bit reloc with the right 2
     bits assumed to be 0.  This is the same as the previous reloc
     except it is in the left container, i.e., shifted left 15 bits.

 - : BFD_RELOC_D10V_18
     This is an 18-bit reloc with the right 2 bits assumed to be 0.

 - : BFD_RELOC_D10V_18_PCREL
     This is an 18-bit reloc with the right 2 bits assumed to be 0.

 - : BFD_RELOC_D30V_6
     Mitsubishi D30V relocs.  This is a 6-bit absolute reloc.

 - : BFD_RELOC_D30V_9_PCREL
     This is a 6-bit pc-relative reloc with the right 3 bits assumed to
     be 0.

 - : BFD_RELOC_D30V_9_PCREL_R
     This is a 6-bit pc-relative reloc with the right 3 bits assumed to
     be 0. Same as the previous reloc but on the right side of the
     container.

 - : BFD_RELOC_D30V_15
     This is a 12-bit absolute reloc with the right 3 bitsassumed to be
     0.

 - : BFD_RELOC_D30V_15_PCREL
     This is a 12-bit pc-relative reloc with the right 3 bits assumed
     to be 0.

 - : BFD_RELOC_D30V_15_PCREL_R
     This is a 12-bit pc-relative reloc with the right 3 bits assumed
     to be 0. Same as the previous reloc but on the right side of the
     container.

 - : BFD_RELOC_D30V_21
     This is an 18-bit absolute reloc with the right 3 bits assumed to
     be 0.

 - : BFD_RELOC_D30V_21_PCREL
     This is an 18-bit pc-relative reloc with the right 3 bits assumed
     to be 0.

 - : BFD_RELOC_D30V_21_PCREL_R
     This is an 18-bit pc-relative reloc with the right 3 bits assumed
     to be 0. Same as the previous reloc but on the right side of the
     container.

 - : BFD_RELOC_D30V_32
     This is a 32-bit absolute reloc.

 - : BFD_RELOC_D30V_32_PCREL
     This is a 32-bit pc-relative reloc.

 - : BFD_RELOC_M32R_24
     Mitsubishi M32R relocs.  This is a 24 bit absolute address.

 - : BFD_RELOC_M32R_10_PCREL
     This is a 10-bit pc-relative reloc with the right 2 bits assumed
     to be 0.

 - : BFD_RELOC_M32R_18_PCREL
     This is an 18-bit reloc with the right 2 bits assumed to be 0.

 - : BFD_RELOC_M32R_26_PCREL
     This is a 26-bit reloc with the right 2 bits assumed to be 0.

 - : BFD_RELOC_M32R_HI16_ULO
     This is a 16-bit reloc containing the high 16 bits of an address
     used when the lower 16 bits are treated as unsigned.

 - : BFD_RELOC_M32R_HI16_SLO
     This is a 16-bit reloc containing the high 16 bits of an address
     used when the lower 16 bits are treated as signed.

 - : BFD_RELOC_M32R_LO16
     This is a 16-bit reloc containing the lower 16 bits of an address.

 - : BFD_RELOC_M32R_SDA16
     This is a 16-bit reloc containing the small data area offset for
     use in add3, load, and store instructions.

 - : BFD_RELOC_V850_9_PCREL
     This is a 9-bit reloc

 - : BFD_RELOC_V850_22_PCREL
     This is a 22-bit reloc

 - : BFD_RELOC_V850_SDA_16_16_OFFSET
     This is a 16 bit offset from the short data area pointer.

 - : BFD_RELOC_V850_SDA_15_16_OFFSET
     This is a 16 bit offset (of which only 15 bits are used) from the
     short data area pointer.

 - : BFD_RELOC_V850_ZDA_16_16_OFFSET
     This is a 16 bit offset from the zero data area pointer.

 - : BFD_RELOC_V850_ZDA_15_16_OFFSET
     This is a 16 bit offset (of which only 15 bits are used) from the
     zero data area pointer.

 - : BFD_RELOC_V850_TDA_6_8_OFFSET
     This is an 8 bit offset (of which only 6 bits are used) from the
     tiny data area pointer.

 - : BFD_RELOC_V850_TDA_7_8_OFFSET
     This is an 8bit offset (of which only 7 bits are used) from the
     tiny data area pointer.

 - : BFD_RELOC_V850_TDA_7_7_OFFSET
     This is a 7 bit offset from the tiny data area pointer.

 - : BFD_RELOC_V850_TDA_16_16_OFFSET
     This is a 16 bit offset from the tiny data area pointer.

 - : BFD_RELOC_V850_TDA_4_5_OFFSET
     This is a 5 bit offset (of which only 4 bits are used) from the
     tiny data area pointer.

 - : BFD_RELOC_V850_TDA_4_4_OFFSET
     This is a 4 bit offset from the tiny data area pointer.

 - : BFD_RELOC_V850_SDA_16_16_SPLIT_OFFSET
     This is a 16 bit offset from the short data area pointer, with the
     bits placed non-contigously in the instruction.

 - : BFD_RELOC_V850_ZDA_16_16_SPLIT_OFFSET
     This is a 16 bit offset from the zero data area pointer, with the
     bits placed non-contigously in the instruction.

 - : BFD_RELOC_V850_CALLT_6_7_OFFSET
     This is a 6 bit offset from the call table base pointer.

 - : BFD_RELOC_V850_CALLT_16_16_OFFSET
     This is a 16 bit offset from the call table base pointer.

 - : BFD_RELOC_MN10300_32_PCREL
     This is a 32bit pcrel reloc for the mn10300, offset by two bytes
     in the instruction.

 - : BFD_RELOC_MN10300_16_PCREL
     This is a 16bit pcrel reloc for the mn10300, offset by two bytes
     in the instruction.

 - : BFD_RELOC_TIC30_LDP
     This is a 8bit DP reloc for the tms320c30, where the most
     significant 8 bits of a 24 bit word are placed into the least
     significant 8 bits of the opcode.

 - : BFD_RELOC_TIC54X_PARTLS7
     This is a 7bit reloc for the tms320c54x, where the least
     significant 7 bits of a 16 bit word are placed into the least
     significant 7 bits of the opcode.

 - : BFD_RELOC_TIC54X_PARTMS9
     This is a 9bit DP reloc for the tms320c54x, where the most
     significant 9 bits of a 16 bit word are placed into the least
     significant 9 bits of the opcode.

 - : BFD_RELOC_TIC54X_23
     This is an extended address 23-bit reloc for the tms320c54x.

 - : BFD_RELOC_TIC54X_16_OF_23
     This is a 16-bit reloc for the tms320c54x, where the least
     significant 16 bits of a 23-bit extended address are placed into
     the opcode.

 - : BFD_RELOC_TIC54X_MS7_OF_23
     This is a reloc for the tms320c54x, where the most significant 7
     bits of a 23-bit extended address are placed into the opcode.

 - : BFD_RELOC_FR30_48
     This is a 48 bit reloc for the FR30 that stores 32 bits.

 - : BFD_RELOC_FR30_20
     This is a 32 bit reloc for the FR30 that stores 20 bits split up
     into two sections.

 - : BFD_RELOC_FR30_6_IN_4
     This is a 16 bit reloc for the FR30 that stores a 6 bit word
     offset in 4 bits.

 - : BFD_RELOC_FR30_8_IN_8
     This is a 16 bit reloc for the FR30 that stores an 8 bit byte
     offset into 8 bits.

 - : BFD_RELOC_FR30_9_IN_8
     This is a 16 bit reloc for the FR30 that stores a 9 bit short
     offset into 8 bits.

 - : BFD_RELOC_FR30_10_IN_8
     This is a 16 bit reloc for the FR30 that stores a 10 bit word
     offset into 8 bits.

 - : BFD_RELOC_FR30_9_PCREL
     This is a 16 bit reloc for the FR30 that stores a 9 bit pc relative
     short offset into 8 bits.

 - : BFD_RELOC_FR30_12_PCREL
     This is a 16 bit reloc for the FR30 that stores a 12 bit pc
     relative short offset into 11 bits.

 - : BFD_RELOC_MCORE_PCREL_IMM8BY4
 - : BFD_RELOC_MCORE_PCREL_IMM11BY2
 - : BFD_RELOC_MCORE_PCREL_IMM4BY2
 - : BFD_RELOC_MCORE_PCREL_32
 - : BFD_RELOC_MCORE_PCREL_JSR_IMM11BY2
 - : BFD_RELOC_MCORE_RVA
     Motorola Mcore relocations.

 - : BFD_RELOC_AVR_7_PCREL
     This is a 16 bit reloc for the AVR that stores 8 bit pc relative
     short offset into 7 bits.

 - : BFD_RELOC_AVR_13_PCREL
     This is a 16 bit reloc for the AVR that stores 13 bit pc relative
     short offset into 12 bits.

 - : BFD_RELOC_AVR_16_PM
     This is a 16 bit reloc for the AVR that stores 17 bit value
     (usually program memory address) into 16 bits.

 - : BFD_RELOC_AVR_LO8_LDI
     This is a 16 bit reloc for the AVR that stores 8 bit value (usually
     data memory address) into 8 bit immediate value of LDI insn.

 - : BFD_RELOC_AVR_HI8_LDI
     This is a 16 bit reloc for the AVR that stores 8 bit value (high 8
     bit of data memory address) into 8 bit immediate value of LDI insn.

 - : BFD_RELOC_AVR_HH8_LDI
     This is a 16 bit reloc for the AVR that stores 8 bit value (most
     high 8 bit of program memory address) into 8 bit immediate value
     of LDI insn.

 - : BFD_RELOC_AVR_LO8_LDI_NEG
     This is a 16 bit reloc for the AVR that stores negated 8 bit value
     (usually data memory address) into 8 bit immediate value of SUBI
     insn.

 - : BFD_RELOC_AVR_HI8_LDI_NEG
     This is a 16 bit reloc for the AVR that stores negated 8 bit value
     (high 8 bit of data memory address) into 8 bit immediate value of
     SUBI insn.

 - : BFD_RELOC_AVR_HH8_LDI_NEG
     This is a 16 bit reloc for the AVR that stores negated 8 bit value
     (most high 8 bit of program memory address) into 8 bit immediate
     value of LDI or SUBI insn.

 - : BFD_RELOC_AVR_LO8_LDI_PM
     This is a 16 bit reloc for the AVR that stores 8 bit value (usually
     command address) into 8 bit immediate value of LDI insn.

 - : BFD_RELOC_AVR_HI8_LDI_PM
     This is a 16 bit reloc for the AVR that stores 8 bit value (high 8
     bit of command address) into 8 bit immediate value of LDI insn.

 - : BFD_RELOC_AVR_HH8_LDI_PM
     This is a 16 bit reloc for the AVR that stores 8 bit value (most
     high 8 bit of command address) into 8 bit immediate value of LDI
     insn.

 - : BFD_RELOC_AVR_LO8_LDI_PM_NEG
     This is a 16 bit reloc for the AVR that stores negated 8 bit value
     (usually command address) into 8 bit immediate value of SUBI insn.

 - : BFD_RELOC_AVR_HI8_LDI_PM_NEG
     This is a 16 bit reloc for the AVR that stores negated 8 bit value
     (high 8 bit of 16 bit command address) into 8 bit immediate value
     of SUBI insn.

 - : BFD_RELOC_AVR_HH8_LDI_PM_NEG
     This is a 16 bit reloc for the AVR that stores negated 8 bit value
     (high 6 bit of 22 bit command address) into 8 bit immediate value
     of SUBI insn.

 - : BFD_RELOC_AVR_CALL
     This is a 32 bit reloc for the AVR that stores 23 bit value into
     22 bits.

 - : BFD_RELOC_VTABLE_INHERIT
 - : BFD_RELOC_VTABLE_ENTRY
     These two relocations are used by the linker to determine which of
     the entries in a C++ virtual function table are actually used.
     When the -gc-sections option is given, the linker will zero out
     the entries that are not used, so that the code for those
     functions need not be included in the output.

     VTABLE_INHERIT is a zero-space relocation used to describe to the
     linker the inheritence tree of a C++ virtual function table.  The
     relocation's symbol should be the parent class' vtable, and the
     relocation should be located at the child vtable.

     VTABLE_ENTRY is a zero-space relocation that describes the use of a
     virtual function table entry.  The reloc's symbol should refer to
     the table of the class mentioned in the code.  Off of that base,
     an offset describes the entry that is being used.  For Rela hosts,
     this offset is stored in the reloc's addend.  For Rel hosts, we
     are forced to put this offset in the reloc's section offset.

 - : BFD_RELOC_IA64_IMM14
 - : BFD_RELOC_IA64_IMM22
 - : BFD_RELOC_IA64_IMM64
 - : BFD_RELOC_IA64_DIR32MSB
 - : BFD_RELOC_IA64_DIR32LSB
 - : BFD_RELOC_IA64_DIR64MSB
 - : BFD_RELOC_IA64_DIR64LSB
 - : BFD_RELOC_IA64_GPREL22
 - : BFD_RELOC_IA64_GPREL64I
 - : BFD_RELOC_IA64_GPREL32MSB
 - : BFD_RELOC_IA64_GPREL32LSB
 - : BFD_RELOC_IA64_GPREL64MSB
 - : BFD_RELOC_IA64_GPREL64LSB
 - : BFD_RELOC_IA64_LTOFF22
 - : BFD_RELOC_IA64_LTOFF64I
 - : BFD_RELOC_IA64_PLTOFF22
 - : BFD_RELOC_IA64_PLTOFF64I
 - : BFD_RELOC_IA64_PLTOFF64MSB
 - : BFD_RELOC_IA64_PLTOFF64LSB
 - : BFD_RELOC_IA64_FPTR64I
 - : BFD_RELOC_IA64_FPTR32MSB
 - : BFD_RELOC_IA64_FPTR32LSB
 - : BFD_RELOC_IA64_FPTR64MSB
 - : BFD_RELOC_IA64_FPTR64LSB
 - : BFD_RELOC_IA64_PCREL21B
 - : BFD_RELOC_IA64_PCREL21BI
 - : BFD_RELOC_IA64_PCREL21M
 - : BFD_RELOC_IA64_PCREL21F
 - : BFD_RELOC_IA64_PCREL22
 - : BFD_RELOC_IA64_PCREL60B
 - : BFD_RELOC_IA64_PCREL64I
 - : BFD_RELOC_IA64_PCREL32MSB
 - : BFD_RELOC_IA64_PCREL32LSB
 - : BFD_RELOC_IA64_PCREL64MSB
 - : BFD_RELOC_IA64_PCREL64LSB
 - : BFD_RELOC_IA64_LTOFF_FPTR22
 - : BFD_RELOC_IA64_LTOFF_FPTR64I
 - : BFD_RELOC_IA64_LTOFF_FPTR64MSB
 - : BFD_RELOC_IA64_LTOFF_FPTR64LSB
 - : BFD_RELOC_IA64_SEGREL32MSB
 - : BFD_RELOC_IA64_SEGREL32LSB
 - : BFD_RELOC_IA64_SEGREL64MSB
 - : BFD_RELOC_IA64_SEGREL64LSB
 - : BFD_RELOC_IA64_SECREL32MSB
 - : BFD_RELOC_IA64_SECREL32LSB
 - : BFD_RELOC_IA64_SECREL64MSB
 - : BFD_RELOC_IA64_SECREL64LSB
 - : BFD_RELOC_IA64_REL32MSB
 - : BFD_RELOC_IA64_REL32LSB
 - : BFD_RELOC_IA64_REL64MSB
 - : BFD_RELOC_IA64_REL64LSB
 - : BFD_RELOC_IA64_LTV32MSB
 - : BFD_RELOC_IA64_LTV32LSB
 - : BFD_RELOC_IA64_LTV64MSB
 - : BFD_RELOC_IA64_LTV64LSB
 - : BFD_RELOC_IA64_IPLTMSB
 - : BFD_RELOC_IA64_IPLTLSB
 - : BFD_RELOC_IA64_COPY
 - : BFD_RELOC_IA64_TPREL22
 - : BFD_RELOC_IA64_TPREL64MSB
 - : BFD_RELOC_IA64_TPREL64LSB
 - : BFD_RELOC_IA64_LTOFF_TP22
 - : BFD_RELOC_IA64_LTOFF22X
 - : BFD_RELOC_IA64_LDXMOV
     Intel IA64 Relocations.

 - : BFD_RELOC_M68HC11_HI8
     Motorola 68HC11 reloc.  This is the 8 bits high part of an
     absolute address.

 - : BFD_RELOC_M68HC11_LO8
     Motorola 68HC11 reloc.  This is the 8 bits low part of an absolute
     address.

 - : BFD_RELOC_M68HC11_3B
     Motorola 68HC11 reloc.  This is the 3 bits of a value.

 - : BFD_RELOC_CRIS_BDISP8
 - : BFD_RELOC_CRIS_UNSIGNED_5
 - : BFD_RELOC_CRIS_SIGNED_6
 - : BFD_RELOC_CRIS_UNSIGNED_6
 - : BFD_RELOC_CRIS_UNSIGNED_4
     These relocs are only used within the CRIS assembler.  They are not
     (at present) written to any object files.

 - : BFD_RELOC_860_COPY
 - : BFD_RELOC_860_GLOB_DAT
 - : BFD_RELOC_860_JUMP_SLOT
 - : BFD_RELOC_860_RELATIVE
 - : BFD_RELOC_860_PC26
 - : BFD_RELOC_860_PLT26
 - : BFD_RELOC_860_PC16
 - : BFD_RELOC_860_LOW0
 - : BFD_RELOC_860_SPLIT0
 - : BFD_RELOC_860_LOW1
 - : BFD_RELOC_860_SPLIT1
 - : BFD_RELOC_860_LOW2
 - : BFD_RELOC_860_SPLIT2
 - : BFD_RELOC_860_LOW3
 - : BFD_RELOC_860_LOGOT0
 - : BFD_RELOC_860_SPGOT0
 - : BFD_RELOC_860_LOGOT1
 - : BFD_RELOC_860_SPGOT1
 - : BFD_RELOC_860_LOGOTOFF0
 - : BFD_RELOC_860_SPGOTOFF0
 - : BFD_RELOC_860_LOGOTOFF1
 - : BFD_RELOC_860_SPGOTOFF1
 - : BFD_RELOC_860_LOGOTOFF2
 - : BFD_RELOC_860_LOGOTOFF3
 - : BFD_RELOC_860_LOPC
 - : BFD_RELOC_860_HIGHADJ
 - : BFD_RELOC_860_HAGOT
 - : BFD_RELOC_860_HAGOTOFF
 - : BFD_RELOC_860_HAPC
 - : BFD_RELOC_860_HIGH
 - : BFD_RELOC_860_HIGOT
 - : BFD_RELOC_860_HIGOTOFF
     Intel i860 Relocations.


     typedef enum bfd_reloc_code_real bfd_reloc_code_real_type;

`bfd_reloc_type_lookup'
.......................

   *Synopsis*
     reloc_howto_type *
     bfd_reloc_type_lookup (bfd *abfd, bfd_reloc_code_real_type code);
   *Description*
Return a pointer to a howto structure which, when invoked, will perform
the relocation CODE on data from the architecture noted.

`bfd_default_reloc_type_lookup'
...............................

   *Synopsis*
     reloc_howto_type *bfd_default_reloc_type_lookup
        (bfd *abfd, bfd_reloc_code_real_type  code);
   *Description*
Provides a default relocation lookup routine for any architecture.

`bfd_get_reloc_code_name'
.........................

   *Synopsis*
     const char *bfd_get_reloc_code_name (bfd_reloc_code_real_type code);
   *Description*
Provides a printable name for the supplied relocation code.  Useful
mainly for printing error messages.

`bfd_generic_relax_section'
...........................

   *Synopsis*
     boolean bfd_generic_relax_section
        (bfd *abfd,
         asection *section,
         struct bfd_link_info *,
         boolean *);
   *Description*
Provides default handling for relaxing for back ends which don't do
relaxing - i.e., does nothing.

`bfd_generic_gc_sections'
.........................

   *Synopsis*
     boolean bfd_generic_gc_sections
        (bfd *, struct bfd_link_info *);
   *Description*
Provides default handling for relaxing for back ends which don't do
section gc - i.e., does nothing.

`bfd_generic_get_relocated_section_contents'
............................................

   *Synopsis*
     bfd_byte *
     bfd_generic_get_relocated_section_contents (bfd *abfd,
         struct bfd_link_info *link_info,
         struct bfd_link_order *link_order,
         bfd_byte *data,
         boolean relocateable,
         asymbol **symbols);
   *Description*
Provides default handling of relocation effort for back ends which
can't be bothered to do it efficiently.


File: bfd.info,  Node: Core Files,  Next: Targets,  Prev: Relocations,  Up: BFD front end

Core files
==========

   *Description*
These are functions pertaining to core files.

`bfd_core_file_failing_command'
...............................

   *Synopsis*
     CONST char *bfd_core_file_failing_command(bfd *abfd);
   *Description*
Return a read-only string explaining which program was running when it
failed and produced the core file ABFD.

`bfd_core_file_failing_signal'
..............................

   *Synopsis*
     int bfd_core_file_failing_signal(bfd *abfd);
   *Description*
Returns the signal number which caused the core dump which generated
the file the BFD ABFD is attached to.

`core_file_matches_executable_p'
................................

   *Synopsis*
     boolean core_file_matches_executable_p
        (bfd *core_bfd, bfd *exec_bfd);
   *Description*
Return `true' if the core file attached to CORE_BFD was generated by a
run of the executable file attached to EXEC_BFD, `false' otherwise.


File: bfd.info,  Node: Targets,  Next: Architectures,  Prev: Core Files,  Up: BFD front end

Targets
=======

   *Description*
Each port of BFD to a different machine requries the creation of a
target back end. All the back end provides to the root part of BFD is a
structure containing pointers to functions which perform certain low
level operations on files. BFD translates the applications's requests
through a pointer into calls to the back end routines.

   When a file is opened with `bfd_openr', its format and target are
unknown. BFD uses various mechanisms to determine how to interpret the
file. The operations performed are:

   * Create a BFD by calling the internal routine `_bfd_new_bfd', then
     call `bfd_find_target' with the target string supplied to
     `bfd_openr' and the new BFD pointer.

   * If a null target string was provided to `bfd_find_target', look up
     the environment variable `GNUTARGET' and use that as the target
     string.

   * If the target string is still `NULL', or the target string is
     `default', then use the first item in the target vector as the
     target type, and set `target_defaulted' in the BFD to cause
     `bfd_check_format' to loop through all the targets.  *Note
     bfd_target::.  *Note Formats::.

   * Otherwise, inspect the elements in the target vector one by one,
     until a match on target name is found. When found, use it.

   * Otherwise return the error `bfd_error_invalid_target' to
     `bfd_openr'.

   * `bfd_openr' attempts to open the file using `bfd_open_file', and
     returns the BFD.
   Once the BFD has been opened and the target selected, the file
format may be determined. This is done by calling `bfd_check_format' on
the BFD with a suggested format.  If `target_defaulted' has been set,
each possible target type is tried to see if it recognizes the
specified format.  `bfd_check_format' returns `true' when the caller
guesses right.

* Menu:

* bfd_target::

