#! /bin/sh

dry_run=

declare -a fix_files
declare -a lfns
declare -a sfns

pipe=\|
minus=\-

srcdir=".."

function sfnfix()
{
  declare -i i
  i=0
  num_files="${#lfns[@]}"
  unset sed_args
  declare -a sed_args
  
  echo "Entering directory $PWD..."
  while [ $i -lt $num_files ]; do
    sed_args[${#sed_args[@]}]="${minus}e"
    sed_args[${#sed_args[@]}]="s${pipe}${lfns[i]}${pipe}${sfns[i]}${pipe}"
    let i+=1
  done
  for fix in "${fix_files[@]}"; do
    if test -z "$fix"; then
      continue;
    fi
    if ! test -f "$fix"; then
      echo "$fix doesn't exist."
      continue
    fi
    echo "Fixing $fix..."
    if test -z $dry_run; then
      sed "${sed_args[@]}" < $fix > fix.tmp
      rm $fix
      mv fix.tmp $fix
    fi
  done
  i=0
  while [ $i -lt $num_files ]; do
    if test -f "${lfns[i]}"; then
      echo "Renaming ${lfns[i]} -> ${sfns[i]}"
      if test -z $dry_run; then
        mv "${lfns[i]}" "${sfns[i]}"
      fi
    fi
    let i+=1
  done
  fix_files=
  echo
}

lfns=("ChangeLog-9295" "ChangeLog-9697" "ChangeLog-9899")
sfns=("ChangeLog.9295" "ChangeLog.9697" "ChangeLog.9899")

(cd $srcdir/gas; sfnfix)


lfns=("as.info-1" "as.info-2" "as.info-3" "as.info-4" "as.info-5" \
         "as.info-6" "as.info-7" "as.info-8" "as.info-9")
sfns=("as.i1" "as.i2" "as.i3" "as.i4" "as.i5" \
         "as.i6" "as.i7" "as.i8" "as.i9")
fix_files=
(cd $srcdir/gas/doc; sfnfix; )


lfns=("ChangeLog-9193" "ChangeLog-9495" "ChangeLog-9697" "ChangeLog-9899" \
      "coff-tic30.c" "coff-tic80.c" "cpu-ia64-opc.c" "cpu-m68hc11.c" \
      "efi-app-ia32.c" "efi-app-ia64.c" "elf32-i370.c" "elf32-m68hc11.c" \
      "elf32-m68hc12.c" "elf32-sh-lin.c" )
sfns=("ChangeLog.9193" "ChangeLog.9495" "ChangeLog.9697" "ChangeLog.9899" \
      "coff-ti30.c" "coff-ti80.c" "ia64-opc.c" "m68hc11.c" \
      "efi-ia32.c" "efi-ia64.c" "elf-i370.c" "elf-m68hc11.c" \
      "elf-hc12.c" "elf-sh-lin.c")

fix_files=("Makefile.am" "Makefile.in")

(cd $srcdir/bfd; sfnfix; )


lfns=("bfd.info-1" "bfd.info-2" "bfd.info-3" "bfd.info-4" "bfd.info-5" \
      "bfd.info-6" "bfd.info-7")
sfns=("bfd.i1" "bfd.i2" "bfd.i3" "bfd.i4" "bfd.i5" \
      "bfd.i6" "bfd.i7")
fix_files=

(cd $srcdir/bfd/doc; sfnfix; )


lfns=("binutils.info-1" "binutils.info-2" "binutils.info-3" \
      "ChangeLog-9197" "ChangeLog-9899")
sfns=("binutils.i1" "binutils.i2" "binutils.i3" \
      "ChangeLog.9197" "ChangeLog.9899")
fix_files=

(cd $srcdir/binutils; sfnfix)


lfns=("gprof.info-1" "gprof.info-2" "gprof.info-3")
sfns=("gprof.i1" "grof.i2" "gprof.i3")
fix_files=

(cd $srcdir/gprof; sfnfix)


lfns=("ld.info-1" "ld.info-2" "ld.info-3" "ld.info-4" "ld.info-5"  "ld.info-6" \
      "ChangeLog-9197" "ChangeLog-9899")
sfns=("ld.i1" "ld.i2" "ld.i3" "ld.i4" "ld.i5" "ld.i6" \
      "ChangeLog.9197" "ChangeLog.9899")
fix_files=

(cd $srcdir/ld; sfnfix; )


lfns=("emulparams/avrmega103.sh" "emulparams/elf32bmipn32.sh" \
      "emulparams/elf32lppcsim.sh" "emulparams/elf32ppclinux.sh" \
      "emulparams/elf32ppcsim.sh" "emulparams/elf_i386_be.sh" \
      "emulparams/elf_i386_chaos.sh" "emulparams/m68hc11elfb.sh" \
      "emulparams/m68hc12elfb.sh" "scripttempl/elfm68hc12.sc")

sfns=("emulparams/avrmga103.sh" "emulparams/elfbmipn32.sh" \
      "emulparams/elflppcsim.sh" "emulparams/elfppclinux.sh" \
      "emulparams/elfppcsim.sh" "emulparams/i386_be.sh" \
      "emulparams/i386_chaos.sh" "emulparams/m68hc11b.sh" \
      "emulparams/m68hc12b.sh" "scripttempl/m68hc12.sc")

fix_files=("Makefile.am" "Makefile.in")

(cd $srcdir/ld; sfnfix; )

lfns=("ChangeLog-9297" "ChangeLog-9899" \
      "ia64-opc-a.c" "ia64-opc-b.c" "ia64-opc-d.c" "ia64-opc-f.c" \
      "ia64-opc-i.c" "ia64-opc-m.c" "ia64-opc-x.c" "m68hc11-opc.c" )
sfns=("ChangeLog.9297" "ChangeLog.9899" \
      "ia64-opa.c" "ia64-opb.c" "ia64-opd.c" "ia64-opf.c" \
      "ia64-opi.c" "ia64-opm.c" "ia64-opx.c" "hc11-opc.c" )

fix_files=("Makefile.am" "Makefile.in")

(cd $srcdir/opcodes; sfnfix; )


lfns=("configure.info-1" "configure.info-2" "configure.info-3")
sfns=("configure.i1" "configure.i2" "configure.i3")
fix_files=

(cd $srcdir/etc; sfnfix; )

lfns=("intlh.inst.in" "po2tbl.sed.in")
sfns=("intlh-inst.in" "po2tbl-sed.in")
fix_files=("Makefile.in" "configure.in" "configure")

(cd $srcdir/intl; sfnfix; )
