This is configure.info, produced by makeinfo version 4.0f from
./configure.texi.

INFO-DIR-SECTION GNU admin
START-INFO-DIR-ENTRY
* configure: (configure).	The GNU configure and build system
END-INFO-DIR-ENTRY

   This file documents the GNU configure and build system.

   Copyright (C) 1998 Cygnus Solutions.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided that
the entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be stated in a
translation approved by the Foundation.


File: configure.info,  Node: Multilibs in Target Libraries,  Prev: Multilibs in gcc,  Up: Multilibs

Multilibs in Target Libraries
=============================

   The target libraries in the Cygnus tree are automatically built with
multilibs.  That means that each library is built multiple times.

   This default is set in the top level `configure.in' file, by adding
`--enable-multilib' to the list of arguments passed to configure when
it is run for the target libraries (*note Host and Target Libraries::).

   Each target library uses the shell script `config-ml.in', written by
Doug Evans, to prepare to build target libraries.  This shell script is
invoked after the `Makefile' has been created by the `configure'
script.  If multilibs are not enabled, it does nothing, otherwise it
modifies the `Makefile' to support multilibs.

   The `config-ml.in' script makes one copy of the `Makefile' for each
multilib in the appropriate subdirectory.  When configuring in the
source directory (which is not recommended), it will build a symlink
tree of the sources in each subdirectory.

   The `config-ml.in' script sets several variables in the various
`Makefile's.  The `Makefile.in' must have definitions for these
variables already; `config-ml.in' simply changes the existing values.
The `Makefile' should use default values for these variables which will
do the right thing in the subdirectories.

`MULTISRCTOP'
     `config-ml.in' will set this to a sequence of `../' strings, where
     the number of strings is the number of multilib levels in the
     source tree.  The default value should be the empty string.

`MULTIBUILDTOP'
     `config-ml.in' will set this to a sequence of `../' strings, where
     the number of strings is number of multilib levels in the object
     directory.  The default value should be the empty string.  This
     will differ from `MULTISRCTOP' when configuring in the source tree
     (which is not recommended).

`MULTIDIRS'
     In the top level `Makefile' only, `config-ml.in' will set this to
     the list of multilib subdirectories.  The default value should be
     the empty string.

`MULTISUBDIR'
     `config-ml.in' will set this to the installed subdirectory name to
     use for this subdirectory, with a leading `/'.  The default value
     shold be the empty string.

`MULTIDO'
`MULTICLEAN'
     In the top level `Makefile' only, `config-ml.in' will set these
     variables to commands to use when doing a recursive make.  These
     variables should both default to the string `true', so that by
     default nothing happens.

   All references to the parent of the source directory should use the
variable `MULTISRCTOP'.  Instead of writing `$(srcdir)/..', you must
write `$(srcdir)/$(MULTISRCTOP)..'.

   Similarly, references to the parent of the object directory should
use the variable `MULTIBUILDTOP'.

   In the installation target, the libraries should be installed in the
subdirectory `MULTISUBDIR'.  Instead of installing
`$(libdir)/libfoo.a', install `$(libdir)$(MULTISUBDIR)/libfoo.a'.

   The `config-ml.in' script also modifies the top level `Makefile' to
add `multi-do' and `multi-clean' targets which are used when building
multilibs.

   The default target of the `Makefile' should include the following
command:
     @$(MULTIDO) $(FLAGS_TO_PASS) DO=all multi-do

This assumes that `$(FLAGS_TO_PASS)' is defined as a set of variables
to pass to a recursive invocation of `make'.  This will build all the
multilibs.  Note that the default value of `MULTIDO' is `true', so by
default this command will do nothing.  It will only do something in the
top level `Makefile' if multilibs were enabled.

   The `install' target of the `Makefile' should include the following
command:
     @$(MULTIDO) $(FLAGS_TO_PASS) DO=install multi-do

   In general, any operation, other than clean, which should be
performed on all the multilibs should use a `$(MULTIDO)' line, setting
the variable `DO' to the target of each recursive call to `make'.

   The `clean' targets (`clean', `mostlyclean', etc.) should use
`$(MULTICLEAN)'.  For example, the `clean' target should do this:
     @$(MULTICLEAN) DO=clean multi-clean


File: configure.info,  Node: FAQ,  Next: Index,  Prev: Multilibs,  Up: Top

Frequently Asked Questions
**************************

Which do I run first, `autoconf' or `automake'?
     Except when you first add autoconf or automake support to a
     package, you shouldn't run either by hand.  Instead, configure
     with the `--enable-maintainer-mode' option, and let `make' take
     care of it.

`autoconf' says something about undefined macros.
     This means that you have macros in your `configure.in' which are
     not defined by `autoconf'.  You may be using an old version of
     `autoconf'; try building and installing a newer one.  Make sure the
     newly installled `autoconf' is first on your `PATH'.  Also, see
     the next question.

My `configure' script has stuff like `CY_GNU_GETTEXT' in it.
     This means that you have macros in your `configure.in' which should
     be defined in your `aclocal.m4' file, but aren't.  This usually
     means that `aclocal' was not able to appropriate definitions of the
     macros.  Make sure that you have installed all the packages you
     need.  In particular, make sure that you have installed libtool
     (this is where `AM_PROG_LIBTOOL' is defined) and gettext (this is
     where `CY_GNU_GETTEXT' is defined, at least in the Cygnus version
     of gettext).

My `Makefile' has `@' characters in it.
     This may mean that you tried to use an autoconf substitution in
     your `Makefile.in' without adding the appropriate `AC_SUBST' call
     to your `configure' script.  Or it may just mean that you need to
     rebuild `Makefile' in your build directory.  To rebuild `Makefile'
     from `Makefile.in', run the shell script `config.status' with no
     arguments.  If you need to force `configure' to run again, first
     run `config.status --recheck'.  These runs are normally done
     automatically by `Makefile' targets, but if your `Makefile' has
     gotten messed up you'll need to help them along.

Why do I have to run both `config.status --recheck' and `config.status'?
     Normally, you don't; they will be run automatically by `Makefile'
     targets.  If you do need to run them, use `config.status --recheck'
     to run the `configure' script again with the same arguments as the
     first time you ran it.  Use `config.status' (with no arguments) to
     regenerate all files (`Makefile', `config.h', etc.) based on the
     results of the configure script.  The two cases are separate
     because it isn't always necessary to regenerate all the files
     after running `config.status --recheck'.  The `Makefile' targets
     generated by automake will use the environment variables
     `CONFIG_FILES' and `CONFIG_HEADERS' to only regenerate files as
     they are needed.

What is the Cygnus tree?
     The Cygnus tree is used for various packages including gdb, the GNU
     binutils, and egcs.  It is also, of course, used for Cygnus
     releases.  It is the build system which was developed at Cygnus,
     using the Cygnus configure script.  It permits building many
     different packages with a single configure and make.  The
     configure scripts in the tree are being converted to autoconf, but
     the general build structure remains intact.

Why do I have to keep rebuilding and reinstalling the tools?
     I know, it's a pain.  Unfortunately, there are bugs in the tools
     themselves which need to be fixed, and each time that happens
     everybody who uses the tools need to reinstall new versions of
     them.  I don't know if there is going to be a clever fix until the
     tools stabilize.

Why not just have a Cygnus tree `make' target to update the tools?
     The tools unfortunately need to be installed before they can be
     used.  That means that they must be built using an appropriate
     prefix, and it seems unwise to assume that every configuration
     uses an appropriate prefix.  It might be possible to make them
     work in place, or it might be possible to install them in some
     subdirectory; so far these approaches have not been implemented.


File: configure.info,  Node: Index,  Prev: FAQ,  Up: Top

Index
*****

* Menu:

* --build option:                        Build and Host Options.
* --host option:                         Build and Host Options.
* --target option:                       Specifying the Target.
* _GNU_SOURCE:                           Write configure.in.
* AC_CANONICAL_HOST:                     Using the Host Type.
* AC_CANONICAL_SYSTEM:                   Using the Target Type.
* AC_CONFIG_HEADER:                      Write configure.in.
* AC_EXEEXT:                             Write configure.in.
* AC_INIT:                               Write configure.in.
* AC_OUTPUT:                             Write configure.in.
* AC_PREREQ:                             Write configure.in.
* AC_PROG_CC:                            Write configure.in.
* AC_PROG_CXX:                           Write configure.in.
* acconfig.h:                            Written Developer Files.
* acconfig.h, writing:                   Write acconfig.h.
* acinclude.m4:                          Written Developer Files.
* aclocal.m4:                            Generated Developer Files.
* AM_CONFIG_HEADER:                      Write configure.in.
* AM_DISABLE_SHARED:                     Write configure.in.
* AM_EXEEXT:                             Write configure.in.
* AM_INIT_AUTOMAKE:                      Write configure.in.
* AM_MAINTAINER_MODE:                    Write configure.in.
* AM_PROG_LIBTOOL:                       Write configure.in.
* AM_PROG_LIBTOOL in configure:          FAQ.
* build option:                          Build and Host Options.
* building with a cross compiler:        Canadian Cross.
* canadian cross:                        Canadian Cross.
* canadian cross in configure:           CCross in Configure.
* canadian cross in cygnus tree:         CCross in Cygnus Tree.
* canadian cross in makefile:            CCross in Make.
* canadian cross, configuring:           Build and Host Options.
* canonical system names:                Configuration Names.
* config.cache:                          Build Files Description.
* config.h:                              Build Files Description.
* config.h.in:                           Generated Developer Files.
* config.in:                             Generated Developer Files.
* config.status:                         Build Files Description.
* config.status --recheck:               FAQ.
* configuration names:                   Configuration Names.
* configuration triplets:                Configuration Names.
* configure:                             Generated Developer Files.
* configure build system:                Build and Host Options.
* configure host:                        Build and Host Options.
* configure target:                      Specifying the Target.
* configure.in:                          Written Developer Files.
* configure.in, writing:                 Write configure.in.
* configuring a canadian cross:          Build and Host Options.
* cross compiler:                        Cross Compilation Concepts.
* cross compiler, building with:         Canadian Cross.
* cross tools:                           Cross Compilation Tools.
* CY_GNU_GETTEXT in configure:           FAQ.
* cygnus configure:                      Cygnus Configure.
* goals:                                 Goals.
* history:                               History.
* host names:                            Configuration Names.
* host option:                           Build and Host Options.
* host system:                           Host and Target.
* host triplets:                         Configuration Names.
* HOST_CC:                               CCross in Make.
* libg++ configure:                      Cygnus Configure in C++ Libraries.
* libio configure:                       Cygnus Configure in C++ Libraries.
* libstdc++ configure:                   Cygnus Configure in C++ Libraries.
* Makefile:                              Build Files Description.
* Makefile, garbage characters:          FAQ.
* Makefile.am:                           Written Developer Files.
* Makefile.am, writing:                  Write Makefile.am.
* Makefile.in:                           Generated Developer Files.
* multilibs:                             Multilibs.
* stamp-h:                               Build Files Description.
* stamp-h.in:                            Generated Developer Files.
* system names:                          Configuration Names.
* system types:                          Configuration Names.
* target option:                         Specifying the Target.
* target system:                         Host and Target.
* triplets:                              Configuration Names.
* undefined macros:                      FAQ.


