#!/bin/sh
#
# This shell script is a wrapper to the main configure script when
# configuring GDB for DJGPP.  99% of it can also be used when
# configuring other GNU programs for DJGPP.
#
#=====================================================================
# Copyright 1997, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
#
# Originally written by Robert Hoehne, revised by Eli Zaretskii.
#  This file is part of GDB.
#  Adapted for binutils by Andris Pavenis
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.  */
#=====================================================================
#
# Call this script like the main configure script with one exception.  If you
# want to pass parameters to configure, you have to pass as the first
# argument the srcdir, even when it is `.' !!!!!
#
# First, undo any CDPATH settings; they will get in our way when we
# chdir to directories.
unset CDPATH

# Where are the sources? If you are used to having the sources
# in a separate directory and the objects in another, then set
# here the full path to the source directory and run this script
# in the directory where you want to build gdb!!
# You might give the source directory on commandline, but use
# then only forward slashes (/) in the directories. It should be
# an absolute path.

srcdir=..


case `uname` in 

MS-DOS)
    
    # Now set the config shell. It is really needed, that the shell
    # points to a shell with full path and also it must conatain the
    # .exe suffix. I assume here, that bash is installed. If not,
    # install it. Additionally, the pathname must not contain a
    # drive letter, so use the /dev/x/foo format supported by versions
    # of Bash 2.03 and later, and by all DJGPP programs compiled with
    # v2.03 (or later) library.
    export CONFIG_SHELL=/dev/env/DJDIR/bin/sh.exe
    
    # force to have the ltmain.sh script to be in DOS text format,
    # otherwise the resulting ltconfig script will have mixed
    # (UNIX/DOS) format and is unusable with Bash ports before v2.03.
    utod $srcdir/ltmain.sh
    
    # Give the configure script some hints:
    export LD=ld
    export NM=nm
    export CC=gcc
    export CFLAGS="-O2 -g"
    export RANLIB=ranlib
    export DEFAULT_YACC="bison -y"
    export YACC="bison -y"
    export DEFAULT_LEX=flex
    export TEST_FINDS_EXE=Y
    # Force the test for 'ln -s' to report no.
    export LN_S="cp -p"
    export ac_cv_prog_LN_S="cp -p"
    # Define explicitly the .exe extension because on W95 with LFN=y
    # the check might fail
    export am_cv_exeext=.exe
    # ltconfig wants to compute the maximum command-line length, but
    # Bash 2.04 doesn't like that (it doesn't have any limit ;-), and
    # reboots the system.  We know our limit in advance, so we don't
    # need all that crap.  Assuming that the environment size is less
    # than 4KB, we can afford 12KB of command-line arguments.
    export lt_cv_sys_max_cmd_len=12288
    
    # The configure script needs to see the `install-sh' script, otherwise
    # it decides the source installation is broken.  But "make install" will
    # fail on 8+3 filesystems if it finds a file `install-', since there
    # are numerous "install-foo" targets in Makefile's.  So we rename the
    # offending file after the configure step is done.
    if test ! -f ${srcdir}/install-sh ; then
      if test -f ${srcdir}/install-.sh ; then
        mv ${srcdir}/install-.sh ${srcdir}/install-sh
      fi
    fi
    
    CONFOPT="--target=djgpp --host=djgpp --build=djgpp"
    
    ;;
    
*) 
    CONFOPT="--target=djgpp --host=djgpp --build=`$srcdir/config.guess`"
    ;;
    

esac

# Now run the configure script while disabling some things like the NLS
# support, which is nearly impossible to be supported in the current way,
# since it relies on file names which will never work on DOS.
echo "Running the configure script..."
$srcdir/configure $CONFOPT --srcdir="$srcdir" --prefix='${DJDIR}' \
  --disable-shared --disable-nls --verbose --enable-build-warnings=\
-Wimplicit,-Wcomment,-Wformat,-Wparentheses,-Wpointer-arith $*

if test -f ${srcdir}/install- ; then
  mv ${srcdir}/install- ${srcdir}/install-.sh
fi
