#! /bin/sh
#
# psize.sh -- determine this system's pipe size, and write a define to
#             pipesize.h so ulimit.c can use it.

TMPDIR=${TMPDIR=/tmp}
TMPNAME=pipsize.$$
TMPFILE=$TMPDIR/$TMPNAME

trap 'rm -f $TMPFILE' 0 1 2 3 6 15

echo "/*"
echo " * pipesize.h"
echo " *"
echo " * This file is automatically generated by psize.sh"
echo " * Do not edit!"
echo " */"
echo ""

#
# Try to avoid tempfile races.  We can't really check for the file's
# existance before we run psize.aux, because `test -e' is not portable,
# `test -h' (test for symlinks) is not portable, and `test -f' only
# checks for regular files
#
rm -f $TMPFILE

./psize.aux 2>$TMPFILE | sleep 3

if [ -s $TMPFILE ]; then
	echo "#define PIPESIZE `cat $TMPFILE`"
else
	echo "#define PIPESIZE 512"
fi

exit 0
