#! /bin/sh
#-----------------------------------------------------------------------------
#  This script patches original sources of gcc-2.95.2 together with
#  sources of libg++ for building under DJGPP.
#-----------------------------------------------------------------------------
#  NOTES: 
#  
#  1) LFN support is required both for this script and for building egcs
#     and libraries (but not for using resulting binaries)
#  2) This all is intended for DJGPP-2.03 (no released yet) but it is expected
#     to work also with DJGPP-2.02. Don't use it with DJGPP-2.01	
#-----------------------------------------------------------------------------
#  1) Unpack gcc-2.95.2 and libg++-2.8.1.3 source archives
#     move libg++ and librx directories into egcs tree.
#     This script may work also with next minor releases but there
#     may also be problems. If You're using it with different version of
#     gcc then ALWAYS check output of script whether there are no error 
#     messages.
#  2) Correct location of egcs source tree in this script
#	  source=...
#     (absolute path please, should be on the same drive)
#  3) Change to build.djg and run
#         build.bat
#     You should have DJGPP port of autoconf (not older than June 24, 1999)
#-----------------------------------------------------------------------------
#  Happy hacking
#
#  Andris Pavenis <pavenis@lanet.lv> 
#-----------------------------------------------------------------------------

source=${gccsrc-${DJDIR}/gnu/gcc-2.952}

update() 
{ 
	if ! cmp -s $1.new $1 ; then
             test -f $1~1 || ( \
		  mv -f $1 $1~1; 
		  echo "File $1 updated"; )
             mv -f $1.new $1;
	     dtou $1;	
	fi
        test -f $1.new && rm -f $1.new;
}

currdir=`pwd`

###############################################################################
#	Apply patches to egcs directories
###############################################################################
for name in build.djg install.djg install.djg/manifest build.cross; do
	test -d ${source}/${name} || mkdir ${source}/${name};
done

diff_list=`(cd diffs; find . -not -type d | sed -e 's,[.]/,,g')`
for file in ${diff_list}; do
	case ${file} in *.diff) 
		orig_name=`echo ${file} | sed -e 's,[.]diff,,g'`
		if [ -f ${source}/${orig_name} ]; then
			patch --verbose -b ${source}/${orig_name} < diffs/$file;
#			patch --verbose ${source}/${orig_name} < diffs/$file;
		else
			echo "File $orig_name is not found";
		fi
		;;
	*~) 	;;
	*)
		cp -v diffs/${file} ${source}/${file}
		;;
	esac
done
###############################################################################

sed -e 's,SYSCALLS[.]c[.]X,SYSCALLS.cX,g' ${source}/gcc/Makefile.in >${source}/gcc/Makefile.in.new
update ${source}/gcc/Makefile.in

###############################################################################

LIBIO_RENAME=iostreamP.h

LIBSTDCXX_RENAME="stl_algobase.h stl_hash_map.h stl_hash_set.h stl_hashtable.h \
		  stl_multiset.h"

LIBGPP_RENAME="Complex.h Regex.h String.h"

################################################################################				
#  Remove directories not supported for DJGPP
################################################################################				
for dir in `find ${source} -type d -name testsuite`; do
	case ${dir} in ${source}/libiberty/testsuite) ;;
		       *) echo "Removing directory $dir"
			  rm -fr $dir ;;
        esac
done
#
test -d ${source}/libio/dbz && ( echo "Removing directory ${source}/libio/dbz"; \
	rm -fr ${source}/libio/dbz; );
#
test -d ${source}/libg++/etc/lf && ( echo "Removing directory ${source}/libg++/etc/lf"; \
	rm -fr ${source}/libg++/etc/lf; );
#
#	This breaks --enable-nls. Therefore let's leave these directories in.
#	Presence of these directories can also help for building DJGPP targetted
#	cross-compiler
#for dir in `find ${source}/gcc/config -type d -not -name i386 -not -name config`; do
#	echo "Removing directory ${dir}";
#	rm -rf ${dir};
#done;
#
for file in `find ${source} -name .brik -or -name .cvsignore`; do
	rm -vf $file
done
#
mv ${source}/texinfo ${source}/texinfo.bak
mkdir ${source}/texinfo
for x in gpl.texinfo lgpl.texinfo; do 
	mv -v ${source}/texinfo.bak/${x} ${source}/texinfo/${x}
done
rm -rf ${source}/texinfo.bak
#
################################################################################				
#
#  Rename include files in libio. We must do this with iostreamP.h only. 
#  Let's rename it to _iostreamP.h. Fix also corresponding sources and
#  depend file
#
################################################################################				
for incname in $LIBIO_RENAME; do
	newname=_$incname;
	incpath=${source}/libio/$incname
	if test -f $incpath; then
		for file in `grep -l $incname ${source}/libio/*.c ${source}/libio/*.cc ${source}/libio/*.h`; do
			sed -e 's,\"iostreamP.h\",\"_iostreamP.h\",g' $file >$file.new;
			update $file
		done;
	fi;
done;
#
sed -e 's,iostreamP.h,_iostreamP.h,g' ${source}/libio/depend >${source}/libio/depend.new
update ${source}/libio/depend;
#
for incname in $LIBIO_RENAME; do
	test -f ${source}/libio/$incname && mv -f ${source}/libio/$incname ${source}/libio/$newname;
done

################################################################################

for file in ${source}/libio/config.shared ${source}/libio/tests/Makefile.in; do
    sed -e 's,-lstdc[+][+],-lstdcxx,g' \
	-e 's,-lg[+][+],-lgpp,g' $file >$file.new
    update $file
done    

################################################################################				
#
#  Rename include files in libstdc++. Fix also corresponding sources and
#  depend file
#
################################################################################				
for incname in $LIBSTDCXX_RENAME; do
	newname=`echo $incname | sed -e 's,_,,g'`
	if test -f ${source}/libstdc++/stl/$incname; then
		flist=`grep -l '<'$incname'>' ${source}/libstdc++/stl/* 2>/dev/null`;
		for file in $flist; do
			sed -e 's,<'$incname'>,<'$newname'>,g' $file >$file.new;
			update $file;
		done;
	fi;
done;
#
for incname in $LIBSTDCXX_RENAME; do	 
	if test -f ${source}/libstdc++/stl/$incname; then
		newname=`echo $incname | sed -e 's,_,,g'`
		mv -f ${source}/libstdc++/stl/$incname ${source}/libstdc++/stl/$newname;
		echo "Rename ${source}/libstdc++/stl/$incname ==> ${source}/libstdc++/stl/$newname"
	fi;
done;	   
#
################################################################################

for file in ${source}/libstdc++/Makefile.in ${source}/libstdc++/tests/Makefile.in; do
	sed -e 's,libstdc[+][+][.]a,libstdcxx.a,g' \
	    -e 's,-lstdc[+][+],-lstdcxx,g' $file >$file.new;
	update $file;
done		

################################################################################				
#
#  Rename include files in libg++. Fix also corresponding sources and
#  depend file
#
################################################################################				
#
flisth=`find ${source}/libg++ -name '*.h'`;
flistcc=`find ${source}/libg++ -name '*.cc'`;
flistin=`find ${source}/libg++ -name Makefile.in`;

for incname in $LIBGPP_RENAME; do
	if test -f ${source}/libg++/src/$incname; then
		newname=_$incname;
		edlist=`grep -l '<'$incname'>' $flisth $flistcc`;
		for file in $edlist; do
			sed -e 's,<'$incname'>,<'$newname'>,g' $file >$file.new
			update $file
		done;
	fi;
done;	
#
for incname in $LIBGPP_RENAME; do
	if test -f ${source}/libg++/src/$incname; then
  	       newname=_$incname;
	       mv -f ${source}/libg++/src/$incname ${source}/libg++/src/$newname;
	       echo "Rename ${source}/libg++/src/$incname ==> ${source}/libg++/src/$newname";
	fi;	     
done;	
#
for file in ${source}/libg++/tests/test_h.cc; do
	sed -e 's,sys[/]signal[.]h,signal.h,g' $file >$file.new;
	update $file;
done
#
for file in `find ${source}/libg++ -name depend`; do
	sed -e 's,[/]String.h,/_String.h,g' \
	    -e 's,[/]Regex.h,/_Regex.h,g' \
	    -e 's,[/]Complex.h,/_Complex.h,g' $file >$file.new;
	update $file;
done;	
#
for file in $flistin; do
	sed -e 's,libstdc[+][+][.]a,libstdcxx.a,g' \
	    -e 's,-lstdc[+][+],-lstdcxx,g' \
	    -e 's,libg[+][+][.]a,libgpp.a,g' \
	    -e 's,-lg[+][+],-lgpp,g' $file >$file.new
        update $file
done;

#-------------------------------------------------------------------------------
# Rename  libg++/g++FAQ.texi  and do corresponding changes to libg++
#-------------------------------------------------------------------------------
mv ${source}/libg++/g++FAQ.texi ${source}/libg++/gxxFAQ.texi
mv ${source}/libg++/libg++.texi ${source}/libg++/libgpp.texi
for file in ${source}/libg++/Makefile.in ${source}/libg++/configure.in; do
	sed -e 's,g[+][+]FAQ[.],gxxFAQ.,g' \
            -e 's,libg[+][+][.]texi,libgpp.texi,g' \
	    -e 's,INFO_FILES=libg[+][+],INFO_FILES=libgpp,g' \
	    $file >$file.new
	update $file
done
sed -e 's,[(]libg[+][+][)],(libgpp),g' ${source}/libg++/libgpp.texi >${source}/libg++/libgpp.texi.new
update ${source}/libg++/libgpp.texi
sed -e 's,g[+][+]FAQ[.]info,gxxFAQ.info,g' ${source}/libg++/gxxFAQ.texi >${source}/libg++/gxxFAQ.texi.new
update ${source}/libg++/gxxFAQ.texi

#-------------------------------------------------------------------------------

( cd ${source}/libio/stdio && mv -v clearerr_u.c _clearerr_u.c )
( cd ${source}/libio && mv -v iofflush_u.c _iofflush_u.c )

test -d ${source}/libstdc++ && mv -v ${source}/libstdc++ ${source}/libstdcxx
test -d ${source}/libg++ && mv -v ${source}/libg++ ${source}/libgpp

for file in `find $source -name configure.in`; do
	cat $file | sed -e 's,Make[.]pack[.]r,Make_pack.r,g' >$file.new
	update $file
done

for file in ${source}/configure.in ${source}/Makefile.in; do
	cat $file | \
	sed -e 's,target[-]libstdc[+][+],target-libstdcxx,g' \
	    -e 's,target[-]libg[+][+],target-libgpp,g' >$file.new
	update $file
done

	
for file in `find ${source}/libgpp -name Makefile.in`; do
	cat $file | \
	sed -e 's,[/]libstdc[+][+],/libstdcxx,g' >$file.new
	update $file
done

for file in `find ${source}/libgpp -name depend` \
	    `find ${source} -name Makefile.in` \
	    ${source}/libio/config.shared; do
	cat $file | \
	sed -e 's,[/]libstdc[+][+],/libstdcxx,g' >$file.new
	update $file
done

if [ -f ${source}/libgpp/etc/PlotFile3D/PlotFile3D.h ]; then
	( cd ${source}/libgpp/etc/PlotFile3D && mv -v PlotFile3D.h _PlotFile3D.h )

	for file in ${source}/libgpp/etc/PlotFile3D/*.cc \
		    ${source}/libgpp/etc/PlotFile3D/depend;	do 
		cat $file | \
		sed -e 's,PlotFile3D[.]h,_PlotFile3D.h,g' >$file.new
		update $file
	done

	cat ${source}/libgpp/etc/PlotFile3D/configure.in | \
		sed -e 's,PlotFile3D[.]h,_PlotFile3D.h,g' \
		    -e 's,libg[+][+],libgpp,g' \
		>${source}/libgpp/etc/PlotFile3D/configure.in.new
	update ${source}/libgpp/etc/PlotFile3D/configure.in
fi


for file in ${source}/libstdcxx/Makefile.in; do
	sed -e 's,bigstmp,bstmp,g' $file >$file.new
	update $file
done

for file in ${source}/libio/tests/Makefile.in; do
	sed -e 's,putback[-]b,pback-b,g' \
            -e 's,tFile-buf0[.]out,tFile-b0.out,g' \
	    -e 's,tFile-buf3[.]out,tFile-b3.out,g' $file >$file.new
	update $file
done

for file in ${source}/libgpp/utils/gendepend ${source}/libgpp/utils/Makefile.in \
            ${source}/libgpp/utils/configure.in ${source}/libgpp/test-install/Makefile.in; do
	sed -e 's,g++dep,gxxdep,g' $file >$file.new
	update $file
done

mv -v ${source}/libgpp/utils/g++dep.sh  ${source}/libgpp/utils/gxxdep.sh
mv -v ${source}/libgpp/etc/hints ${source}/libgpp/etc/HINTS

for file in `find ${source} -name .gdbinit`; do
	mv -v $file `echo $file | sed -e 's,[.]gdbinit,gdb.ini,g'`;
done

#-------------------------------------------------------------------------------
#   Running autoconf where needed. Fails in librx but I didn't want to
#   fight it now (AP)
#-------------------------------------------------------------------------------
currdir=`pwd`
for file in `find ${source} -name configure.in`; do
	directory=`echo $file | sed -e 's,/configure.in,,g' -e 's,[.]/,,g'`;
	(
		cd $directory;
		if grep -q AC_INIT configure.in; then
			echo "Running autoconf in `pwd`"
			autoconf;
		fi;
	)
done;

echo "Running autoheader in ${source}/gcc"
( cd ${source}/gcc && autoheader && echo timestamp >cstamp-h.in )

echo "Running autoheader in ${source}/libf2c/libU77"
( cd ${source}/libf2c/libU77 && autoheader && echo timestamp >stamp-h.in )
	  
dtou `find ${source} -not -type d -and -not -name '*.bat'`
