#!/bin/sh 
#
#  This script is for building native compiler for target
#  i586-pc-msdosdjgpp using cross-compiling. I have tested it
#  under Linux only.
#
here=`pwd` 
action=$1 
export srcdir=`(cd ..; pwd)`

build=`$srcdir/gcc/config.guess` 

case $build in i[34567]86-*-msdosdjgpp)
    echo ''
    echo 'This script is intended for cross-building native compiler for'
    echo 'targets i[34567]86-pc-msdosdjgpp. You should not run it'
    echo 'under DOS. I have tested it under Linux (i586-pc-linux-gnu) only'
    echo ''
    exit 1;
    ;;
esac;    

target=i586-pc-msdosdjgpp
host=i586-pc-msdosdjgpp 
src=$srcdir
rel=/tmp/test 
relexec=$rel/H-${host} 

if ! test -d $srcdir/install.cross; then
    echo DJGPP targetted cross-compiler is not built yet
    echo Please change to directory $srcdir/build.cross and run script build-cross.sh
    exit 1
fi

cross_prefix=$srcdir/build.cross/gcc

# These are for building programs that run on $build. 
CC_FOR_BUILD=gcc 
CXX_FOR_BUILD=gcc 

# These are for building programs and libraries that run on $host. 
CC="$cross_prefix/xgcc -B$cross_prefix/"
AR=`$CC -print-prog-name=ar` 
AS=`$CC -print-prog-name=as`
RANLIB=`$CC -print-prog-name=ranlib`

# These are for building libraries that run on $target. 
CC_FOR_TARGET=$CC
GCC_FOR_TARGET="$CC_FOR_TARGET" 
CC_FOR_TARGET="$CC_FOR_TARGET" 
CXX_FOR_TARGET="$CC_FOR_TARGET" 
# use the correct names for as, ld, and nm. 
AS_FOR_TARGET=$target-as
LD_FOR_TARGET=$target-ld
NM_FOR_TARGET=$target-nm
AR_FOR_TARGET=$target-ar
RANLIB_FOR_TARGET=$target-ranlib
# $DLLTOOL_FOR_TARGET is only needed for win32 hosted systems, but 
# it doesn't hurt to always pass it. 
DLLTOOL_FOR_TARGET=$target-dlltool 
# For go32 cannot use -g because it can overflow coff debug info tables. 
CFLAGS=${CFLAGS--O2} 
CXXFLAGS="-g1 -O2 -mno-bnu210" 


LANGUAGES="c c++ f77 objc proto gcov.exe \
	   `test -d $srcdir/gcc/ch && echo CHILL` \
	   `test -d $srcdir/gcc/java && echo java` \
	   `test -d $srcdir/gcc/p && echo pascal`"

if [ -d $srcdir/gcc/p ] ; then
    export GPC_FOR_TARGET="$cross_prefix/xgpc -B$cross_prefix/"
fi

echo GPC_FOR_TARGET=$GPC_FOR_TARGET

# Ready.  Configure and build. 
if [ ! -f configure.done ] ; then 
    CC="$CC" AR="$AR" AS="$AS" RANLIB="$RANLIB" $src/configure --build=${build} \
       --host=${host} --target=${target} --prefix=\\\$\$DJDIR \
       --with-gxx-include-dir=\\\${prefix}/lang/cxx --with-gnu-ld --with-gnu-as -v &&\ 
    touch configure.done 
fi 

make -w all \
        LANGUAGES="$LANGUAGES" \
        CFLAGS="$CFLAGS" \
        CXXFLAGS="$CXXFLAGS" \
        CC_FOR_BUILD="$CC_FOR_BUILD" \
        CXX_FOR_BUILD="$CXX_FOR_BUILD" \
        CC="$CC" \
        AR="$AR" \
        RANLIB="$RANLIB" \
        GCC_FOR_TARGET="$CC_FOR_TARGET" \
        CC_FOR_TARGET="$CC_FOR_TARGET" \
        CXX_FOR_TARGET="$CC_FOR_TARGET" \
        AS_FOR_TARGET="$AS_FOR_TARGET" \
        LD_FOR_TARGET="$LD_FOR_TARGET" \
        AR_FOR_TARGET="$AR_FOR_TARGET" \
        NM_FOR_TARGET="$NM_FOR_TARGET" \
        RANLIB_FOR_TARGET="$RANLIB_FOR_TARGET" \
        DLLTOOL_FOR_TARGET="$DLLTOOL_FOR_TARGET" || exit 1;	

echo make done
# All done, install it in ../install.djg
make -w install prefix=$srcdir/install.djg \
        LANGUAGES="$LANGUAGES" \
	CFLAGS="$CFLAGS" \
        CXXFLAGS="$CXXFLAGS" \
        CC_FOR_BUILD="$CC_FOR_BUILD" \
        CXX_FOR_BUILD="$CXX_FOR_BUILD" \
        CC="$CC" \
        AR="$AR" \
        RANLIB="$RANLIB" \
        GCC_FOR_TARGET="$CC_FOR_TARGET" \
        CC_FOR_TARGET="$CC_FOR_TARGET" \
        CXX_FOR_TARGET="$CC_FOR_TARGET" \
        AS_FOR_TARGET=$AS_FOR_TARGET \
        LD_FOR_TARGET=$LD_FOR_TARGET \
        AR_FOR_TARGET=$AR_FOR_TARGET \
        NM_FOR_TARGET=$NM_FOR_TARGET \
        RANLIB_FOR_TARGET=$RANLIB_FOR_TARGET \
        DLLTOOL_FOR_TARGET="$DLLTOOL_FOR_TARGET" || exit 1

make -w info install-info prefix=$srcdir/install.djg

( cd $srcdir/install.djg; sh ./mkdist.sh; )

exit $?
