#! /bin/sh
#
# I used this script to generate GCC-3.3.4 documentation package for DJGPP.
# This script is tested (with small modifications) only under Linux.
#
srcdir=`(cd ${1-../gcc-3.34}; pwd)`
builddir=`(cd ../build.gcc; pwd)`
#
MAKEINFO=makeinfo
DVIPS=dvips
DVIPDF=dvipdfm
#
TOP=`pwd`
version=`grep version_string $srcdir/gcc/version.c |\
         sed -e 's/.*\"\(.*\)\".*/\1/'`
ver1=`echo $version | sed -e 's/\.//2'`
ver2=`echo $version | sed -e 's/\.//g'`
docdir=gnudocs/gcc-$ver1
MKHTML="$MAKEINFO --no-split --number-sections --html"

mkdir -p $docdir

cd $builddir || exit 1
make dvi
for x in `find . -name '*.dvi'` ; do cp -v $x $TOP/$docdir/`basename $x`; done

cd $srcdir/libiberty || exit 1
$MKHTML libiberty.texi
cp -v libiberty.html $TOP/$docdir/

cd $srcdir/gcc/doc || exit 1
# Something didn't work with generating gccinstall.html,
# so I skipped it
for x in cpp cppinternals gcc gccint ../f/g77 \
    ../ada/gnat-style ../ada/gnat_rm ../ada/gnat_ug_unx \
    ../ada/gnat_ug_vms ../ada/gnat_ug_vxw \
    ../ada/gnat_ug_wnt ../ada/gnat_ug; do
  ( cd `dirname $x` && $MKHTML -I ../doc/include `basename $x.texi` )
  cp -v $x.html $TOP/$docdir/
done

cd $TOP/$docdir
for x in *.dvi ; do 
  $DVIPS $x
  $DVIPDF $x
done

cd $TOP
if ! [ -d manifest ] ; then mkdir manifest; fi
echo "gcc$ver2.zip GCC-$version documentation" >manifest/gcc${ver2}d.ver
echo "g77$ver2.zip GCC-$version documentation (Fortran)" >manifest/g77${ver2}d.ver
echo "ada$ver2.zip GCC-$version documentation (Ada)" >manifest/ada${ver2}d.ver
rm -vf manifest/gcc${ver2}d.mft 
rm -vf manifest/g77${ver2}d.mft 
rm -vf manifest/ada${ver2}d.mft
touch manifest/gcc${ver2}d.mft 
touch manifest/g77${ver2}d.mft 
touch manifest/ada${ver2}d.mft

for name in `( find manifest -type f -a -name "*d.*"; \
	       find gnudocs -type f ) | sort` ; do
      case $name in
          manifest/ada*d.*|*/gnat*.*) echo $name >>manifest/ada${ver2}d.mft ;;
          manifest/g77*d.*|*/g77*.*) echo $name >>manifest/g77${ver2}d.mft ;;
          *) echo $name >>manifest/gcc${ver2}d.mft ;; 	  
      esac
done      
rm -f ada${ver2}d.zip
rm -f g77${ver2}d.zip
rm -f gcc${ver2}d.zip
echo "Creating ada${ver2}d.zip"
cat manifest/ada${ver2}d.mft | zip -9@ ada${ver2}d.zip
echo "Creating g77${ver2}d.zip"
cat manifest/g77${ver2}d.mft | zip -9@ g77${ver2}d.zip
echo "Creating gcc${ver2}d.zip"
cat manifest/gcc${ver2}d.mft | zip -9@ gcc${ver2}d.zip
