# Specs file to building RPM of Linux to DJGPP cross-compiler
# Tested on Fedora Core 4. One may need to modify this file
# for other RPM based Linux distribution

%define gcc_version 4.4.2

%define gmp_version 4.3.1
%define mpfr_version 2.4.1
%define target i586-pc-msdosdjgpp

%define languages c,c++,f95,objc,obj-c++,ada
#define languages c,c++,f95,objc,obj-c++,ada

%define do_native_bootstrap 1

Name: djcross-gcc
Summary:  GCC cross-compiler for target i586-pc-msdosdjgpp
Version: %{gcc_version}
Release: 1ap

License: GPL
Group: Development/Tools
URL: http://www.iki.fi/andris.pavenis/djgpp/gcc/
Source0: djcross-gcc-%{gcc_version}.tar.bz2
Source1: gcc-%{gcc_version}.tar.bz2
Source2: gmp-%{gmp_version}.tar.bz2
Source3: mpfr-%{mpfr_version}.tar.bz2
Source4: autoconf-2.59.tar.gz
Source5: automake-1.9.6.tar.bz2

Buildroot: %{_tmppath}/%{name}-%{version}-root
BuildArch: i686 x86_64
Requires: djcrx djcross-binutils
BuildPrereq: gcc gcc-gnat gmp gmp-devel djcrx djcross-binutils

%define shortver %(echo %{gcc_version} | sed -e 's:\\.::2g')
%define shortver2 %(echo %{gcc_version} | sed -e 's:\\.::g')

%package c++
Summary: GCC cross-compiler for i586-pc-msdosdjgpp (C++)
Requires: djcross-gcc = %{version} 
Group: Development/Tools

%package gfortran
Summary: GCC cross-compiler for i586-pc-msdosdjgpp (GNU Fortran)
Requires: djcross-gcc = %{version} 
Group: Development/Tools

%package objc
Summary: GCC cross-compiler for i586-pc-msdosdjgpp (Objective C and Objective C++)
Requires: djcross-gcc = %{version} 
Group: Development/Tools

%package gnat
Summary: GCC cross-compiler for i586-pc-msdosdjgpp (GNU Ada)
Requires: djcross-gcc = %{version} 
Group: Development/Tools

%package info
Summary: GCC cross-compiler for i586-pc-msdosdjgpp (Info files)
Group: Development/Tools

%package tools
Summary: Tools for Linux to DJGPP cross-compiler
Group: Development/Tools

%package djdocs
Summary: DJGPP documentation archives for GCC
Group: Development/Tools

%description 
Support of the following programing languages is included:
    C
    C++
    Fortran
    Objective C
    Objective C++
    Ada

%description c++
C++ Cross-compiler for target i586-pc-msdosdjgpp. Includes both
C++ compiler and C++ standard library.

%description gfortran
GNU Fortran compiler for target i586-pc-msdosdjgpp

%description objc
GNU Objective C and Objective C++ compilers for target i586-pc-msdosdjgpp

%description gnat
GNU Ada compiler for target i586-pc-msdosdjgpp

%description info
Info files for Linux to DJGPP cross-compiler. These files are
in a separate package to avGNU Objective C and Objective C++ compilers for target i586-pc-msdosdjgpp

%description tools
Tools for Linux to DJGPP cross-compiler.

At this time there is only fixinc.
You don't need to install it unless You know why You need it...

%description djdocs
DJGPP documentation archives for GCC

This RPM is built only to generate and pack PDF, PS and HTML
documentation archives for DJGPP. It is not intended to
be used in Linux system

#############################################################################
%if %do_native_bootstrap
%define native_cc_spec CC=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin/gcc
%define native_cxx_spec CXX=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin/g++
%else
%define native_cc_spec CC=gcc
%define native_cxx_spec CXX=g++
%endif

%prep 

echo Build cross-compiler for DJGPP: languages are %{languages}

rm -rf $RPM_BUILD_DIR/%{name}-%{version}
%setup -q
ln -s $RPM_SOURCE_DIR/gcc-%{gcc_version}.tar.bz2 $RPM_BUILD_DIR/%{name}-%{version}/
cd $RPM_BUILD_DIR/%{name}-%{version} || exit 1
sed -e 's:^\(AUTOCONF_OLD=\).*$:\1/usr/bin/autoconf-2.13:' \
    -e 's:^\(AUTOHEADER_OLD=\).*$:\1/usr/bin/autoheader-2.13:' \
    -e 's:^\(exec .*\)$:#\1:' unpack-gcc.sh >unpack-gcc.sh.new
mv -f unpack-gcc.sh.new unpack-gcc.sh

tar xzf $RPM_SOURCE_DIR/autoconf-2.59.tar.gz || exit 1
cd $RPM_BUILD_DIR/%{name}-%{version}/autoconf-2.59
./configure --prefix=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst
make all install

cd $RPM_BUILD_DIR/%{name}-%{version} || exit 1
tar xjf $RPM_SOURCE_DIR/automake-1.9.6.tar.bz2 || exit 1
cd $RPM_BUILD_DIR/%{name}-%{version}/automake-1.9.6
./configure --prefix=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst
make all install

cd $RPM_BUILD_DIR/%{name}-%{version} || exit 1
tar xjf $RPM_SOURCE_DIR/gmp-%{gmp_version}.tar.bz2 || exit 1
tar xjf $RPM_SOURCE_DIR/mpfr-%{mpfr_version}.tar.bz2 || exit 1

cd $RPM_BUILD_DIR/%{name}-%{version}
PATH="$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin:$PATH" \
    sh unpack-gcc.sh gcc-%{gcc_version}.tar.bz2 || exit 1

cp -fv gnu/gcc-%{shortver}/COPYING* gnu/gcc-%{shortver}/NEWS gnu/gcc-%{shortver}/README \
   gnu/gcc-%{shortver}/readme.DJGPP ./

%build 
# Build requires this directory to be present or to be creatable to work
#mkdir -p /usr/lib/gcc/i586-pc-msdosdjgpp/%{version} || exit 1
#

cd $RPM_BUILD_DIR/%{name}-%{version}/autoconf-2.59
./configure --prefix=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst
make all install

cd $RPM_BUILD_DIR/%{name}-%{version}/gmp-%{gmp_version}
./configure --build=${RPM_ARCH}-${RPM_OS} \
            --prefix=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
            --enable-static --disable-shared || exit 1
make all check || exit 1
make install || exit 1

cd $RPM_BUILD_DIR/%{name}-%{version}/mpfr-%{mpfr_version}
./configure --build=${RPM_ARCH}-${RPM_OS} \
            --prefix=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
            --with-gmp-build=$RPM_BUILD_DIR/%{name}-%{version}/gmp-%{gmp_version} \
            --enable-static --disable-shared || exit 1
make all check || exit 1
make install || exit 1

cd $RPM_BUILD_DIR/%{name}-%{version}

%if %do_native_bootstrap

# Bootstrap native compiler for building cross-compiler
# Native C compiler is being built always. Ada compiler
# is only built when building Ada cross-compiler is required.
# (This step is intended to ensure that the cross-compiler
# is built with the same GCC version). 
mkdir tmpbuild
cd tmpbuild

../gnu/gcc-%{shortver}/configure \
    --prefix=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
    --with-gmp=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
    --with-mpfr=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
    --enable-languages=c$(echo %{languages} | grep -q ada && echo ",ada") \
    --enable-__cxa_atexit

make bootstrap
make install

cd ..

%endif

#

mkdir djcross
cd djcross
#$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin/gcc -v >$RPM_BUILD_DIR/%{name}-%{version}/gccver.stmp 2>&1



%native_cc_spec \
%native_cxx_spec \
PATH=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin:$PATH \
../gnu/gcc-%{shortver}/configure --build=%{_build} \
                                 --host=%{_host} \
			         --target=%{target} \
			         --program-prefix=%{target}- \
			         --prefix=%{_prefix} \
			         --exec-prefix=%{_exec_prefix} \
			         --bindir=%{_bindir} \
			         --sbindir=%{_sbindir} \
			         --sysconfdir=%{_sysconfdir} \
			         --datadir=%{_datadir} \
			         --includedir=%{_includedir} \
			         --libdir=%{_libdir} \
			         --libexecdir=%{_libexecdir} \
			         --localstatedir=%{_localstatedir} \
			         --sharedstatedir=%{_sharedstatedir} \
			         --mandir=%{_mandir} \
			         --infodir=%{_infodir} \
			         --disable-nls \
			         --disable-libssp \
                                 --with-gmp=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
                                 --with-mpfr=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
			         --enable-version-specific-runtime-libs \
			         --enable-languages=%{languages} || exit 1 

make PATH=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin:$PATH || exit 1

cd ..

# Build DJGPP documentation packages for GCC
( cd gnu/install.gcc && perl mkdocs.pl )
cp -fv gnu/gcc-%{shortver}/COPYING* gnu/gcc-%{shortver}/NEWS gnu/gcc-%{shortver}/README \
   gnu/gcc-%{shortver}/readme.DJGPP ./ 

%install 
rm -fr %{buildroot}

export STRIP=/bin/true
cd $RPM_BUILD_DIR/%{name}-%{version}/djcross
#%makeinstall
PATH=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin:$PATH make install DESTDIR=%{buildroot}
( cd %{buildroot}%{_bindir} && for file in *; do case $file in *gccbug) ;; *) strip $file ;; esac; done )
( cd %{buildroot}%{_bindir} && if [ -f gprmake ] ; then mv -fv gprmake i586-pc-msdosdjgpp-gprmake; fi )
( cd %{buildroot}%{_bindir} && if [ -f vxaddr2line ] ; then mv -fv vxaddr2line i586-pc-msdosdjgpp-vxaddr2line; fi )
rm -f %{buildroot}/%{_libdir}/libiberty.a
rm -fr %{buildroot}%{_mandir}/man7/*
rm -fr %{buildroot}%{_infodir}/dir

( cd %{buildroot}%{_libexecdir}/gcc/%{target}/%{version} &&\
    strip cc1* collect2 f951 install-tools/fixincl )

( cd %{buildroot}%{_libexecdir}/gcc/%{target}/%{version} &&\
    if [ -f gnat1 ] ; then strip gnat1; fi; )

%clean 
rm -fr %{buildroot}

%files 
%defattr(-,root,root) 
%{_bindir}/%{target}-cpp
%{_bindir}/%{target}-gcc*
%{_bindir}/%{target}-gcov
# FIXME: do we need the next?
/usr/%{target}/lib/libiberty.a
# FIXME: why one haves empty directory here?
%{_libdir}/gcc/%{target}/%{version}/finclude
%{_libdir}/gcc/%{target}/%{version}/include-fixed/*
%{_libdir}/gcc/%{target}/%{version}/libgcc.a
%{_libdir}/gcc/%{target}/%{version}/libgcov.a
%{_libdir}/gcc/%{target}/%{version}/include/*intrin*.h
%{_libdir}/gcc/%{target}/%{version}/include/cpuid.h
%{_libdir}/gcc/%{target}/%{version}/include/cross-stdarg.h
%{_libdir}/gcc/%{target}/%{version}/include/float.h
%{_libdir}/gcc/%{target}/%{version}/include/iso646.h
%{_libdir}/gcc/%{target}/%{version}/include/mm3dnow.h
%{_libdir}/gcc/%{target}/%{version}/include/mm_malloc.h
%{_libdir}/gcc/%{target}/%{version}/include/stdarg.h
%{_libdir}/gcc/%{target}/%{version}/include/stdbool.h
%{_libdir}/gcc/%{target}/%{version}/include/stddef.h
%{_libdir}/gcc/%{target}/%{version}/include/stdfix.h
%{_libdir}/gcc/%{target}/%{version}/include/tgmath.h
%{_libdir}/gcc/%{target}/%{version}/include/unwind.h
%{_libdir}/gcc/%{target}/%{version}/include/varargs.h
%{_libexecdir}/gcc/%{target}/%{version}/cc1
%{_libexecdir}/gcc/%{target}/%{version}/collect2
%{_mandir}/man1/%{target}-cpp.1.gz
%{_mandir}/man1/%{target}-gcc.1.gz
%{_mandir}/man1/%{target}-gcov.1.gz
%doc COPYING* NEWS README readme.DJGPP

%files c++
%defattr(-,root,root) 
%{_bindir}/%{target}-c++
%{_bindir}/%{target}-g++
%{_libdir}/gcc/%{target}/%{version}/include/c++/*
%{_libdir}/gcc/%{target}/%{version}/libstdc++.a
%{_libdir}/gcc/%{target}/%{version}/libstdc++.la
%{_libdir}/gcc/%{target}/%{version}/libsupc++.a
%{_libdir}/gcc/%{target}/%{version}/libsupc++.la
%{_libexecdir}/gcc/%{target}/%{version}/cc1plus
%{_mandir}/man1/%{target}-g++.1.gz

%files gfortran
%defattr(-,root,root) 
%{_bindir}/%{target}-gfortran
%{_libdir}/gcc/%{target}/%{version}/libgfortranbegin.a
%{_libdir}/gcc/%{target}/%{version}/libgfortranbegin.la
%{_libdir}/gcc/%{target}/%{version}/libgfortran.a
%{_libdir}/gcc/%{target}/%{version}/libgfortran.la
%{_libexecdir}/gcc/%{target}/%{version}/f951
%{_mandir}/man1/%{target}-gfortran.1.gz

%files objc
%defattr(-,root,root) 
%{_libdir}/gcc/%{target}/%{version}/libobjc.a
%{_libdir}/gcc/%{target}/%{version}/libobjc.la
%{_libdir}/gcc/%{target}/%{version}/include/objc/*
%{_libexecdir}/gcc/%{target}/%{version}/cc1obj
%{_libexecdir}/gcc/%{target}/%{version}/cc1objplus

%files gnat
%defattr(-,root,root)
%{_bindir}/%{target}-gnat*
%{_libdir}/gcc/%{target}/%{version}/adainclude/*
%{_libdir}/gcc/%{target}/%{version}/adalib/*
%{_libexecdir}/gcc/%{target}/%{version}/gnat1

%files info
%defattr(-,root,root) 
%{_infodir}/*

%files tools
%defattr(-,root,root) 
%{_libdir}/gcc/%{target}/%{version}/install-tools
%{_libexecdir}/gcc/%{target}/%{version}/install-tools

%files djdocs
%defattr(-,root,root) 
%doc gnu/install.gcc/gcc*d.zip
%doc gnu/install.gcc/gfor*d.zip

%changelog

* Fri Oct 16 2009 Andris Pavenis <andris.pavenis@iki.fi> 4.4.2-1ap
- Update to GCC-4.4.2

* Fri Jul 24 2009 Andris Pavenis <andris.pavenis@iki.fi> 4.4.1-1ap
- Update to GCC-4.4.1

* Fri Jun 19 2009 Andris Pavenis <andris.pavenis@iki.fi> 4.4.0-5ap
- Do not override LINK_COMMAND_SPEC, modify gcc.c to add POST_LINK_SPEC
  for adding extra linking steps instead. Modify config/i386/djgpp.h
  accordingly
- Use %{build} instead of %{host} for detecting DJGPP in libfortran
  subdirectory (rename libgfortranbegin.a for native DJGPP compiler
  only).

* Tue Jun 16 2009 Andris Pavenis <andris.pavenis@iki.fi> 4.4.0-4ap
- Fix Ada support.

* Fri May 22 2009 Andris Pavenis <andris.pavenis@iki.fi> 4.4.0-2ap
- Split in several RPM packages
- Update to use gmp-4.3.1 and mpfr-2.4.1

* Fri May  1 2009 Andris Pavenis <andris.pavenis@iki.fi> 4.4.0-1ap
- Update for gcc-4.4.0.

* Tue Dec 30 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Leave Ada out as it does not build without sockets support

* Sat Dec 27 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Modified for GCC-4.4 development snapshots (used 20081205 snapshot)
- Included also autoconf-2.59 and automake-1.9.6 to avoid using
  newer versions.

* Sat Aug 30 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Use gcc-4.3.2 (RPM version 4.3.2-7ap)

- I wanted to include also sources of GMP and MPFR to avoid dependency
  on their shared libraries. Unfortunatelly it did not work. So I left
  related stuff commented out from spec file.

* Sat Jun  7 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Use gcc-4.3.1 (RPM version 4.3.1-6ap)

* Wed Apr 30 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Some small additional patches (does not affect functionality)

* Sat Apr  5 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Some small additional patches

* Sat Mar 15 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Use gcc-4.3.0 (RPM version 4.3.0-3ap)

* Sun Feb 24 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Use gcc-4.3-20080221
- use 'make install DESTDIR=...' instead of '%makeinstall'.

* Sat Feb  4 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Use gcc-4.3-20080201
- Disable building libssp
- Fix libstdc++-v3 configuration for DJGPP (add os/djgpp/error_constants.h)

* Sat Nov 24 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Updates for using gcc-4.3.0 development snapshots

* Mon Oct 15 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Small updates (4.2.2-12ap) to scripts and readme.DJGPP
  in gcc422s2.zip

* Tue Oct  9 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Update to GCC-4.2.2 (4.2.2-11ap)

* Tue Sep  5 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Add BuildArch for x86_64.

* Fri Jul 25 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Update to GCC-4.2.1 (4.2.1-9).

* Fri Jul 23 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Small updates not really influencing functionality
  (4.2.0-8).

* Fri Jun 07 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Small updates not really influencing functionality
  (4.2.0-7).

* Mon May 28 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Include patch for fixing warnings about requested
  alignemnt exceeding one supported in object file
  from DJ Delorie <dj@delorie.com> 

* Wed May 23 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Update to GCC-4.2.0 (4.2.0-5)

* Sun Mar 25 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Test for cross-compiler installation directory at very
  begin, as it is nuisance to see build failing after an
  hour for this reason
- Merge changes from Gordon Schumacher with my updates to
  later GCC versions.

* Tue Mar 13 2007 Gordon Schumacher <whiplash@pobox.com>
- Updated to use RPM's prefix macros

* Thu Mar  8 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Update to GCC-4.1.2 (4.1.2-1)
 
* Tue May 30 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Fixed libstdc++ name for cross-compiler (4.1.1-2)

* Sun May 28 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Updated to GCC-4.1.1 (4.1.1-1)

* Fri Apr  7 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Patched libssp directory to fix problem with generated
  gcc410s.zip. Cross-compiler itself does not change.

* Sat Mar  5 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Bootstrap at first native compiler to be used for building 
  cross-compiler as one need to build cross-compiler with the
  same version of GCC (use of GCC-4.0.2 causes failure in 
  building Ada tools). Updates to DJGPP related patchset.

* Wed Mar  1 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Updated for GCC-4.1.0

* Sun Feb 19 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Added modification of readme.DJGPP according the version of GCC and DJGPP, as
  otherwise it is rather easy to forget to edit it manually when needed

* Mon Nov 15 2005 Andris Pavenis <pavenis@latnet.lv>
- Initial version of rpm spec file for DJGPP cross-compiler
