# This shell script is wrapper to the main configure script when
# configuring gdb for DJGPP. It can be used to 99% also as a wrapper
# when configuring other GNU programs for DJGPP.
# Call it like the main configure script with an exception. If you
# want to pass parameters to configure, you have to pass as the first
# argument the srcdir, even when it is . !!!!!
#
# WARNING: even when in some parts of the configure step the working
# "ln -s" is checked, it falls then back to use the hard link "ln" which
# will NOT work in 99% on DJGPP. To fix this, please copy (at least for
# the configuring and make steps) ln.exe to cp.exe in your $DJDIR/bin
# directory (make a backup of cp.exe first).

# just in case
export PATH_SEPARATOR=:

# The following is needed, to avoid the //c/foo or /dev/c/foo syntax,
# when the configure script or the makefile calls pwd
current_drive=`pwd | sed -e 's,^//\([A-z]\)/.*,\1,' -e 's,^/dev/\([A-z]\)/.*,\1,'`
export SYSROOT=$current_drive:/

# Where are the sources? If you use (like I) to have the sources
# in a separate directory and the objects in an other, then set
# here the full path to the source directory and run this script
# in the directory where you want to build gdb!!
# WARNING: Only unix-like absolute paths are known to work, like
#
# /djgpp/gnu/gdb-4.18
#
# do not use any drive in it like
#
# c:/djgpp/gnu/gdb-4.18
#
# since this will confuse all that unix like scrips, which
# assume that an absolute path starts with a slash.
# You might give the source directory on commandline, but use
# then only slashes (/) in the directories. It might be relative or
# absolute with the limitation mentioned above.

if [ x$1 = x ]; then
  srcdir=`pwd`
else
  srcdir=`cd $1 && pwd`
  shift
fi

# Now set the config shell. It is really needed, that the shell
# points to a shell with full path and also it must conatain the
# .exe suffix. I assume here, that there is installed bash. If
# not, install it. Additionally the pathname must not contain a
# drive letter, so I create on the current drive the directory
# /bin and place there sh.exe.
# (BTW: This limitation comes now with the great !-((
# libtool utility)
if ! test -d /bin; then
  mkdir /bin
fi
if ! test -f /bin/sh.exe; then
  cp -p $DJDIR/bin/bash.exe /bin/sh.exe
fi
export CONFIG_SHELL=/bin/sh.exe

# force to have the ltmain.sh script to be in DOS text format,
# otherwise the resulting ltconfig script will have mixed
# (UNIX/DOS) format and is unusable with Bash ports before v2.03.

utod $srcdir/ltmain.sh

# give now the configure script some hints
export LD=ld
export CC=gcc
export RANLIB=ranlib
# force to use cp instead of ln
export ac_cv_prog_LN_S=cp
# configure always finds mawk with Bash 1.14.7, even when it
# does not exist, due to a bug in handling parenthesized commands
export AWK=gawk
# define explicit the .exe ext because on W95 with LFN=y the check fails
export am_cv_exeext=.exe
# configure finds this with a syntax like //C/DJGPP... which we can`t use
export ac_cv_path_install="ginstall -c"
export DEFAULT_YACC="bison -y"
export YACC="bison -y"
export DEFAULT_LEX=flex
# disable the finding of wctype.h since this header is broken in
# DJGPP 2.02
export ac_cv_header_wctype_h=no

# since many scripts have ln hardcoded and the ln.exe from the current
# DJGPP system does really not, what the normal ln does, so I need to force
# to use cp instead. Just in case the user forgot the hint at the beginning
# of the script.
cp $DJDIR/bin/cp.exe ln.exe
export PATH=`pwd`:$PATH

# now run the configure script whith disabling some things like the nls
# support which is nearly impossible to be supported in the current way,
# since it uses to strongly formated filenames.
$srcdir/configure --srcdir=$srcdir --disable-shared --disable-nls --verbose $*

# Most of the makefiles have the .libs directory hardcoded to be used by
# libtool. But since libtool recognizes now also the _libs directory on
# non-LFN platforms, I have to change the makefiles in this situation.

touch .dummy 2>/dev/null
if ! test -f .dummy; then
  for i in `find -name makefile -print`; do
    sed 's,\.libs/lib,_libs/lib,g' $i > $i.fix
    mv -f $i.fix $i
  done
else
  rm -f .dummy
fi

# The readline lib has the build_dir hardcoded in the generated Makefile.
# This is wrong when making a configured distribution, so I change it to be
# the current directory.
mv -f readline/Makefile readline/Makefile.old
sed -e 's,\(^BUILD_DIR = \).*$,\1 .,g' readline/Makefile.old > readline/Makefile
export ac_cv_header_wctype_h="\${ac_cv_header_wctype_h='yes'}"
