/* BFD back-end for Intel 386 COFF files (DJGPP variant).
   Copyright 1990, 1991, 1992, 1993, 1994, 1999, 2000, 2001, 2005, 2007
   Free Software Foundation, Inc.
   Written by DJ Delorie.

   This file is part of BFD, the Binary File Descriptor library.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#define TARGET_SYM		go32coff_vec
#define TARGET_NAME		"coff-go32"
#define TARGET_UNDERSCORE	'_'
#define COFF_GO32
#define COFF_LONG_SECTION_NAMES
#define COFF_SUPPORT_GNU_LINKONCE
#define COFF_LONG_FILENAMES

#define COFF_SECTION_ALIGNMENT_ENTRIES \
{ COFF_SECTION_NAME_EXACT_MATCH (".data"), \
  COFF_ALIGNMENT_FIELD_EMPTY, COFF_ALIGNMENT_FIELD_EMPTY, 4 }, \
{ COFF_SECTION_NAME_EXACT_MATCH (".text"), \
  COFF_ALIGNMENT_FIELD_EMPTY, COFF_ALIGNMENT_FIELD_EMPTY, 4 }, \
{ COFF_SECTION_NAME_PARTIAL_MATCH (".gnu.linkonce.d"), \
  COFF_ALIGNMENT_FIELD_EMPTY, COFF_ALIGNMENT_FIELD_EMPTY, 4 }, \
{ COFF_SECTION_NAME_PARTIAL_MATCH (".gnu.linkonce.t"), \
  COFF_ALIGNMENT_FIELD_EMPTY, COFF_ALIGNMENT_FIELD_EMPTY, 4 }, \
{ COFF_SECTION_NAME_PARTIAL_MATCH (".gnu.linkonce.r"), \
  COFF_ALIGNMENT_FIELD_EMPTY, COFF_ALIGNMENT_FIELD_EMPTY, 4 }, \
{ COFF_SECTION_NAME_PARTIAL_MATCH (".debug"), \
  COFF_ALIGNMENT_FIELD_EMPTY, COFF_ALIGNMENT_FIELD_EMPTY, 0 }, \
{ COFF_SECTION_NAME_PARTIAL_MATCH (".gnu.linkonce.wi"), \
  COFF_ALIGNMENT_FIELD_EMPTY, COFF_ALIGNMENT_FIELD_EMPTY, 0 }

/* Section contains extended relocations. */
#define IMAGE_SCN_LNK_NRELOC_OVFL  0x01000000

#define PUT_SCNHDR_NLNNO_EXTENDED(abdf, scnhdr_int, scnhdr_ext)                    \
  do {                                                                             \
    if (coff_data (abfd)->link_info                                                \
        && strcmp (scnhdr_int->s_name, ".text") == 0)                              \
      {                                                                            \
        /* By inference from looking at MS output, the 32 bit field                \
           which is the combination of the number_of_relocs and                    \
           number_of_linenos is used for the line number count in                  \
           executables.  A 16-bit field won't do for cc1.  The MS                  \
           document says that the number of relocs is zero for                     \
           executables, but the 17-th bit has been observed to be there.           \
           Overflow is not an issue: a 4G-line program will overflow a             \
           bunch of other fields long before this!  */                             \
        H_PUT_16 (abfd, (scnhdr_int->s_nlnno & 0xffff), scnhdr_ext->s_nlnno);      \
        H_PUT_16 (abfd, (scnhdr_int->s_nlnno >> 16), scnhdr_ext->s_nreloc);        \
      }                                                                            \
    else                                                                           \
      {                                                                            \
        if (scnhdr_int->s_nlnno <= 0xffff)                                         \
          H_PUT_16 (abfd, scnhdr_int->s_nlnno, scnhdr_ext->s_nlnno);               \
        else                                                                       \
          {                                                                        \
            (*_bfd_error_handler) (_("%s: line number overflow: 0x%lx > 0xffff"),  \
                                   bfd_get_filename (abfd),                        \
                                   scnhdr_int->s_nlnno);                           \
            bfd_set_error (bfd_error_file_truncated);                              \
            H_PUT_16 (abfd, 0xffff, scnhdr_ext->s_nlnno);                          \
            ret = 0;                                                               \
          }                                                                        \
      }                                                                            \
  } while (0)

#define PUT_SCNHDR_NRELOC_EXTENDED(abdf, scnhdr_int, scnhdr_ext)                   \
  do {                                                                             \
    if (!coff_data (abfd)->link_info                                               \
        || strcmp (scnhdr_int->s_name, ".text") != 0)                              \
      {                                                                            \
        /* Although we could encode 0xffff relocs here, we do not, to be           \
           consistent with other parts of bfd. Also it lets us warn, as            \
           we should never see 0xffff here w/o having the overflow flag            \
           set.  */                                                                \
        if (scnhdr_int->s_nreloc < 0xffff)                                         \
          H_PUT_16 (abfd, scnhdr_int->s_nreloc, scnhdr_ext->s_nreloc);             \
        else                                                                       \
          {                                                                        \
            /* DJGPP can deal with large #s of relocs, but not here.  */           \
            H_PUT_16 (abfd, 0xffff, scnhdr_ext->s_nreloc);                         \
            scnhdr_int->s_flags |= IMAGE_SCN_LNK_NRELOC_OVFL;                      \
            H_PUT_32 (abfd, scnhdr_int->s_flags, scnhdr_ext->s_flags);             \
          }                                                                        \
      }                                                                            \
  } while (0)

#define GET_SCNHDR_NLNNO_EXTENDED(abfd, scnhdr_ext)                                \
  ({                                                                               \
      /* MS handles overflow of line numbers by carrying into the reloc            \
         field (it appears).  Since it's supposed to be zero for PE                \
         *IMAGE* format, that's safe.  This is still a bit iffy.  */               \
                                                                                   \
      unsigned short _s_nlnno;                                                     \
      coff_data_type *_coff = coff_data (abfd);                                    \
                                                                                   \
      if (_coff->go32stub)                                                         \
        _s_nlnno = (H_GET_16 (abfd, scnhdr_ext->s_nlnno)                           \
                      + (H_GET_16 (abfd, scnhdr_ext->s_nreloc) << 16));            \
      else                                                                         \
        _s_nlnno = H_GET_16 (abfd, scnhdr_ext->s_nlnno);                           \
      _s_nlnno;                                                                    \
  })

#define GET_SCNHDR_NRELOC_EXTENDED(abfd, scnhdr_ext)                               \
  ({                                                                               \
      /* MS handles overflow of line numbers by carrying into the reloc            \
         field (it appears).  Since it's supposed to be zero for PE                \
         *IMAGE* format, that's safe.  This is still a bit iffy.  */               \
                                                                                   \
      unsigned short _s_nreloc;                                                    \
      coff_data_type *_coff = coff_data (abfd);                                    \
                                                                                   \
      _s_nreloc = _coff->go32stub ? 0 : H_GET_16 (abfd, scnhdr_ext->s_nreloc);     \
      _s_nreloc;                                                                   \
  })

#include "bfd.h"

bfd_boolean _bfd_go32_mkobject (bfd *abfd);

#define coff_mkobject  _bfd_go32_mkobject

#include "coff-i386.c"
