#! /bin/sh

export CFLAGS=-O2
export CXXFLAGS=-O2
export builddir=`pwd | sed -e 's,[a-z][:],,g'`
export srcdir=`cd ..; pwd | sed -e 's,[a-z][:],,g'`
export CONFIG_SHELL='/dev/env/DJDIR/bin/bash.exe'
inst_prefix=`( cd ..; pwd; ) | sed -e 's,[a-z][:][/],/,g'`/install.djg
dft_target=i586-pc-msdosdjgpp
#
export LANGUAGES="c proto gcov.exe \
                  `test -d $srcdir/gcc/ch && echo CHILL` \
                  `test -d $srcdir/gcc/java && echo java` \
                  `test -d $srcdir/gcc/p && echo pascal`"
#
case $1 in \
        config) 
                echo "BASH_VERSION: ${BASH_VERSION}" >con
                case ${BASH_VERSION} in 
                        1.*.*)  # Warn about using bash-1.4.17
                                echo 'It is recommended to use DJGPP port of bash-2.0.4 instead'
                                export PATH_SEPARATOR=:
                                # The following is needed, to get not the // syntax, when
                                # the configure script or the makefile calls pwd
                                current_drive=`pwd | sed 's,//\(.\).*,\1,'`
                                export SYSROOT=$current_drive:/
                                ;;
                        2.*.*)  ;;
                        *) exit 1 ;;
                esac

                # give now the configure script some hints
                topdir=`(cd $srcdir/..; pwd;)`
                AS=`test -f $DJDIR/bin/as.exe && echo $DJDIR/bin/as.exe`
                export AS=${AS-as}
                export PATH_SEPARATOR=:
                export CC=gcc
                export CXX=gpp
                export LD=ld
                export DEFAULT_LEX=flex
                export LEX=flex
                export RANLIB=ranlib
                export ac_cv_path_install="ginstall -c"
                #
                # Finally run configure
                #
                $srcdir/configure --srcdir=$srcdir --disable-shared --verbose \
                  --with-gxx-include-dir=\\\${prefix}/lang/cxx \
                  --with-gnu-ld --target=${target-${dft_target}} \
                  --host=${target-${dft_target}}  \
                  --build=${target-${dft_target}}  \
                  --prefix=\\\$\$DJDIR
                exit $?
                ;;

        gcc1)
                make all-gcc LANGUAGES="c" CFLAGS=-g && \
                ( cd gcc; make stage1; )
                exit $?
                ;;

        gcc2)
                make CFLAGS=-O2 \
                     CC="${builddir}/gcc/stage1/xgcc -B${builddir}/gcc/stage1/" \
                     LANGUAGES="$LANGUAGES" \
                     all-gcc && \
                ( cd gcc; make stage2; )
                exit $?
                ;;

        gcc3)
                make CFLAGS=-O2 \
                     CC="${builddir}/gcc/stage2/xgcc -B${builddir}/gcc/stage2/" \
                     LANGUAGES="$LANGUAGES" \
                     all-gcc && \
                rm -rf stage1
                exit $?
                ;;

        compare)
                ( cd gcc; make compare)
                echo $?
                ;;

        libs1)
                make        CFLAGS=-O2 \
                            CXXFLAGS=-O2 \
                            configure-target-libiberty \
                            configure-target-libio \
                            configure-target-libstdcxx \
                            configure-target-libgpp \
                            all-target-libio \
                            all-target-libiberty \
                            all-target-libstdcxx \
                            all-target-libgpp
                exit $?
                ;;

        libs2)
                make        CFLAGS=-O2 \
                            CXXFLAGS=-O2 \
                            configure-target-libf2c \
                            all-target-libf2c
                exit $?
                ;;

        libs3)
                make        CFLAGS=-O2 \
                            CXXFLAGS=-O2 \
                            all-target-libobjc \
                            `test -d ../libchill && echo all-target-libchill`
                exit $?
                ;;

        install)
                make        CFLAGS=-O2 \
                            CXXFLAGS=-O2 \
                            LANGUAGES="$LANGUAGES" \
                            install prefix=${inst_prefix}
                rc=$?
                make info
                make install-info prefix=${inst_prefix}
                exit ${rc}
                ;;

        mkdist)
                cd ${inst_prefix} && ./mkdist.sh
                exit $? 
                ;;

        *)      ;;

esac;
