#! /bin/sh
#
#  This script generates binary distribution archives of DJGPP port
#  of gcc-2.95.3 
#
#
#  We should not invoke gcc here as it's impossible in case of cross-compiling
#  There should be only one directory there so it should be Ok
version=`ls lib/gcc-lib/djgpp`
#
full_version=${version}
case ${version} in 2*|3*) full_version=gcc-${version} ;;
                   *)     full_version=${version} ;; 
                   esac;

test -z ${version} && version=gcc-2.952
version_dir=lib/gcc-lib/djgpp/${version}

target=i386-pc-msdosdjgpp
for x in i[34567]86-pc-msdosdjgpp; do \
        test -f $x/include/_G_config.h && \
        export target=$x; 
done
        
source=`(cd ..; pwd)`
docdir=gnu/${full_version}

dos_ln ()
{
    rm -f $2
    touch $2
    bn=`echo $1 | sed -e 's/[.]exe//g'`
    stubify $2 >&/dev/null
    stubedit $2 runfile=$bn argv0=$bn
}

if [ x`uname` = xMS-DOS ]
then
    LN="ln -s"
else
    LN=dos_ln
fi    

#STRIP=strip
STRIP=true

#############################################################################
#  With LFN enabled info files are installed with names that are not valid
#  for MS-DOS. Let's fix that
#############################################################################
for file in info/*.info*; do
        echo Processing $file
        case ${file} in
                *.info) nm=`echo $file | sed -e 's/[.]info//g' -e 's|info/||g'`
                        cat $file | \
                        sed -e "s|${nm}[.]info-|${nm}.i|g" > info/tmpfile;
                        mv -f info/tmpfile $file
                        ;;
                *)      mv ${file} `echo $file | sed -e 's,[.]info-,.i,g'`
                        ;;
        esac
done
#############################################################################
#############################################################################

( cd bin && rm -f djgpp-gcc.exe c++.exe )

for file in bin/*.exe; do echo "Stripping ${file}"; ${STRIP} ${file}; done

( cd bin && ( mv g++.exe gpp.exe; $LN gpp.exe g++.exe; $LN gpp.exe c++.exe; ) )

( cd bin && mv c++filt.exe cxxfilt.exe )

cat bin/genclass | sed -e 's,[-]JDIR[/],-$DJDIR/,g' >bin/tmp-genclass
mv -f bin/tmp-genclass bin/genclass

mv -v ${target}/include/_G_config.h lang/cxx/_G_config.h 
mv -v lang/cxx/GetOpt.h lang/cxx/_GetOpt.h

cat >lang/cxx/header.gcc << 'EOF'
String.h _String.h
Complex.h _Complex.h
Regex.h _Regex.h
iostreamP.h _iostreamP.h
stl_algobase.h stlalgobase.h
stl_hash_map.h stlhashmap.h
stl_hash_set.h stlhashset.h
stl_hashtable.h stlhashtable.h
stl_multiset.h stlmultiset.h
GetOpt.h _GetOpt.h
EOF

mv lang/cxx/std/valarray_meta.h lang/cxx/std/_valarray_meta.h 
cat >lang/cxx/std/header.gcc << 'EOF'
valarray_meta.h _valarray_meta.h
EOF

echo ".so man1/cccp.1" >man/man1/cpp.1
mv man/man1/g++.1 man/man1/gpp.1


test -d gnu || mkdir gnu
test -d ${docdir} || mkdir ${docdir}
for x in gcc gcc/cp gcc/objc gcc/f gcc/java gcc/ch gcc/p\
         libio libstdcxx libgpp libf2c libchill; do
        mkdir ${docdir}/${x}
done

for file in readme.DJGPP problems.txt gcc/bugs gcc/problems \
            gcc/copying gcc/news gcc/readme gcc/README-bugs gcc/cp/news \
            libio/news libio/readme libstdcxx/news libgpp/news \
            libgpp/readme gcc/objc/readme gcc/f/install gcc/f/news gcc/p/readme.djgpp\
            libf2c/readme libf2c/permission.netlib libf2c/readme.netlib \
            gcc/ch/readme; do
                cp -v ${source}/${file} ${docdir}/${file}
done

makeinfo --no-split ${source}/libgpp/gxxFAQ.texi -o info/gxxFAQ.info
makeinfo --no-split ${source}/gcc/cp/gxxint.texi -o info/gxxint.info
cp ${source}/README.libg++ ${docdir}/libgpp/readme.libgpp
cat ${source}/libgpp/g++FAQ.txt >${docdir}/gcc/cp/gxxFAQ.txt

for name in cc1 cc1chill cc1obj cc1plus f771 jc1 gpc1; do
        file=lib/gcc-lib/djgpp/${version}/${name}.exe
        echo $file
        if [ -f $file ] ; then
            ${STRIP} $file
            stubedit $file minstack=1536k
        fi
done


(   
    #---------------------------------------------------------------------
    #  If we are building DJGPP port of gcc-2.95.3 using cross-compiler
    #  specs are dumped by it as native compiler for DJGPP cannot be run
    #  in that environment. So we should fix specs. Perhaps it would be
    #  more correct to run freshly built compiler under DOS and dump specs
    #  then, but we cannot do that automatically when cross-building
    #  native compiler for DJGPP
    #---------------------------------------------------------------------
    cd lib/gcc-lib/djgpp/$version;
    cat specs | sed -e '/[*]cross_compile[:]/,/^$/s/1/0/g' >specs.new
    mv -f specs.new specs
)

#
mv -v lib/gcc-lib/djgpp/${version}/djgpp.ver lib/djgpp.ver
#---------------------------------------------------------------------
#  The number of parts of files in gpcXXXXb.zip can change between versions.
#  Therefore let's update manifest files according the actual contents
#---------------------------------------------------------------------
if [ -f bin/gpc.exe ] ; then
        fl0=`cat manifest/gpc2953b.mf1`
        fl1=
        for x in $fl0; do
                case $x in info/*) ;; 
                           ${version_dir}/units/* | doc/gpc/demos/* | doc/gpc/docdemos/*) ;;
                           *) fl1="$fl1 $x" ;;
                esac;
        done
        
        for x in doc/gpc/demos doc/gpc/docdemos ${version_dir}/units; do
                for f in `ls -1 $x`; do 
                        fl1="$fl1 $x/$f"
                done
        done
        
        for x in info/gpc*.i*; do
                fl1="$fl1 $x"
        done

        ( for x in $fl1; do echo $x; done ) | sort >manifest/gpc2953b.mft
fi
#---------------------------------------------------------------------
#  The number of parts of info files can change between versions.
#  Therefore let's update manifest files according the actual size
#---------------------------------------------------------------------  
for mf0 in `(cd manifest; echo *.mf0;)`; do
        mft=`echo $mf0 | sed -e 's,[.]mf0,.mft,g'`
        echo "Updating manifest/$mft"
        fl0=`cat manifest/$mf0`
        inf_index=
        fl1=
        for x in $fl0; do
                case $x in *.info | *.inf) inf_index="$inf_index $x" ;; 
                           *.i*) ;;
                           *) fl1="$fl1 $x" ;;
                esac;
        done
        for inf in $inf_index; do
                n1=`echo $inf | sed -e 's,[.]info,.i,g' -e 's,[.]inf,.i,g'`
                for x in ${n1}*; do
                        test -f $x && fl1="$fl1 $x"
                done
        done    
        ( for x in $fl1; do echo $x; done ) | sort >manifest/$mft
done
#---------------------------------------------------------------------
#  If version is not 2.95.3 then it's necessary to update manifest files
#  according the actual version
#---------------------------------------------------------------------  
case $version in 2.953) ;; *)
        for file in manifest/*.mft; do
                cat $file | \
                sed -e "s,[/]2[.]953[/],/${version}/,g" \
                    -e "s,[/]gcc-2.953[/],/${full_version}/,g" \
                >$file.new;
                mv -f $file.new $file
        done
        ;;
esac;
#---------------------------------------------------------------------  
#  Now create binary ZIP archives. We should have INFO-ZIP compiled
#  with DJGPP v2 on DOS path to succeed 
#---------------------------------------------------------------------  
for mft in `(cd manifest; echo *.mft)`; do
        rm -f err-${mft}
        flist=`cat manifest/${mft}`
        zip=`echo $mft | sed -e 's,[.]mft,.zip,g'`
        echo "Checking manifest/${mft}"
        for x in ${flist}; do
                test -f ${x} || ( echo '     ' ${x} is missing; touch err-${mft}; )
        done
        test -f err-${mft} || \
          ( 
             echo "Creating $zip..."; 
             cat manifest/$mft | zip -9@ $zip;
          )
        rm -f err-${mft}
done 
