This is ../p/doc/info/gpc.info, produced by makeinfo version 4.1 from
gpc.texi.

INFO-DIR-SECTION GNU programming tools
START-INFO-DIR-ENTRY
* GPC: (gpc).                   The GNU Pascal Compiler.
END-INFO-DIR-ENTRY
INFO-DIR-SECTION Individual utilities
START-INFO-DIR-ENTRY
* GPC: (gpc)Invoking GPC.       The GNU Pascal Compiler.
END-INFO-DIR-ENTRY

   This file documents the GNU Pascal Compiler.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Copyright (C) 1988-2003 Free Software Foundation, Inc.

   Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.1
published by the Free Software Foundation; with the Invariant Sections
being "Copying - The GNU General Public License", "Library Copying -
The GNU Lesser General Public License", "Documentation Copying - The
GNU Free Documentation License", "Demo Copying - GPL with exception",
"GNU - The GNU Project", "Manifesto - The GNU Manifesto" and "Funding -
How to help assure funding for Free Software", with the Front-Cover
Texts being "The GNU Pascal Manual", and with no Back-Cover Texts. A
copy of the license is included in the section entitled "Documentation
Copying - The GNU Free Documentation License".


File: gpc.info,  Node: GPC Command Line Options,  Next: GPC Options,  Up: Invoking GPC

GPC options besides those of GCC.
=================================

   The following table lists the command line options GPC understands
in addition to those understood by GCC.

`--classic-pascal-level-0'
     Reject conformant arrays and anything besides ISO 7185 Pascal.

`--standard-pascal-level-0'
     Synonym for `--classic-pascal-level-0'.

`--classic-pascal'
     Reject anything besides ISO 7185 Pascal.

`--standard-pascal'
     Synonym for `--classic-pascal'.

`--extended-pascal'
     Reject anything besides ISO 10206 Extended Pascal.

`--object-pascal'
     Reject anything besides (the implemented parts of) ANSI draft
     Object Pascal.

`--ucsd-pascal'
     Try to emulate UCSD Pascal.

`--borland-pascal'
     Try to emulate Borland Pascal, version 7.0.

`--delphi'
     Try to emulate Borland Pascal, version 7.0, with some Delphi
     extensions.

`--pascal-sc'
     Be strict about the implemented Pascal-SC extensions.

`--vax-pascal'
     Support (a few features of) VAX Pascal.

`--sun-pascal'
     Support (a few features of) Sun Pascal.

`--mac-pascal'
     Support (some features of) traditional Macintosh Pascal compilers.

`--gnu-pascal'
     Undo the effect of previous dialect options, allow all features
     again.

`--debug-tree'
     (For GPC developers.) Show the internal representation of a given
     tree node (name or address).

`--debug-gpi'
     (For GPC developers.) Show what is written to and read from GPI
     files (huge output!).

`--debug-automake'
     (For GPC developers.) Give additional information about the
     actions of automake.

`--debug-source'
     Output the source while it is processed.

`--no-debug-info'
     Inhibit `-g' options (temporary work-around, this option may
     disappear in the future).

`--progress-messages'
     Output source file names and line numbers while compiling.

`--no-progress-messages'
     Do not output source file names and line numbers while compiling
     (default).

`--progress-bar'
     Output number of processed lines while compiling.

`--progress-bar'
     Do not output number of processed lines while compiling (default).

`--autolink'
     Automatically link object files provided by units/modules or `{$L
     ...}' (default).

`--no-autolink'
     Do not automatically link object files provided by
     units/modules/`{$L ...}'.

`--automake'
     Automatically compile changed units/modules/`{$L ...}' files and
     link the object files provided.

`--no-automake'
     Same as `--no-autolink'.

`--autobuild'
     Automatically compile all units/modules/`{$L ...}' files and link
     the object files provided.

`--no-autobuild'
     Same as `--no-autolink'.

`--automake-gpc'
     Set the Pascal compiler invoked by automake.

`--automake-gcc'
     Set the C compiler invoked by automake.

`--automake-g++'
     Set the C++ compiler invoked by automake.

`--amtmpfile'
     (Internal switch used for automake).

`--maximum-field-alignment'
     Set the maximum field alignment in bits if `pack-struct' is in
     effect.

`--ignore-packed'
     Ignore `packed' in the source code (default in `--borland-pascal').

`--no-ignore-packed'
     Do not ignore `packed' in the source code (default).

`--ignore-garbage-after-dot'
     Ignore anything after the terminating `.' (default in
     `--borland-pascal').

`--no-ignore-garbage-after-dot'
     Complain about anything after the terminating `.' (default).

`--extended-syntax'
     Enable certain `dangerous' features such as ignoring function
     results, pointer arithmetic or using `CString's as strings (same
     as `{$X+}').

`--no-extended-syntax'
     Disable the dangerous features enabled by `--extended-syntax'
     (default; same as `{$X-}').

`--short-circuit'
     Guarantee short-circuit Boolean evaluation (default; same as
     `{$B-}').

`--no-short-circuit'
     Do not guarantee short-circuit Boolean evaluation (same as
     `{$B+}').

`--mixed-comments'
     Allow comments like `{ ... *)' as required in ISO Pascal (default
     in ISO 7185/10206 Pascal mode).

`--no-mixed-comments'
     Ignore `{' and `}' within `(* ... *)' comments and vice versa
     (default).

`--nested-comments'
     Allow nested comments like `{ { } }' and `(* (* *) *)'.

`--no-nested-comments'
     Do not allow nested comments (default).

`--delphi-comments'
     Allow Delphi style `//' comments (default).

`--no-delphi-comments'
     Do not allow Delphi style `//' comments.

`--macros'
     Expand macros (default).

`--no-macros'
     Do not expand macros (default with `--ucsd-pascal',
     `--borland-pascal' or `--delphi').

`--ignore-function-results'
     Do not complain when a function is called like a procedure.

`--no-ignore-function-results'
     Complain when a function is called like a procedure (default).

`--truncate-strings'
     Truncate strings being assigned to other strings of too short
     capacity..

`--no-truncate-strings'
     Treat string assignments to other strings of too short capacity as
     errors..

`--exact-compare-strings'
     Do not blank-pad strings for comparisons.

`--no-exact-compare-strings'
     Blank-pad strings for comparisons.

`--double-quoted-strings'
     Allow strings enclosed in "\"..

`--no-double-quoted-strings'
     Do not allow strings enclosed in "\"..

`--longjmp-all-nonlocal-labels'
     Use `longjmp' for all nonlocal labels.

`--no-longjmp-all-nonlocal-labels'
     Use `longjmp' only for nonlocal labels in the main program
     (default).

`--io-checking'
     Do automatic run-time checks after I/O operations (same as
     `{$I+}').

`--no-io-checking'
     Do not check I/O operations automatically (same as `{$I-}').

`--read-base-specifier'
     In read statements, allow input base specifier `n#' (default).

`--no-read-base-specifier'
     In read statements, do not allow input base specifier `n#'
     (default in ISO 7185 Pascal).

`--read-hex'
     In read statements, allow hexadecimal input with `$' (default).

`--no-read-hex'
     In read statements, do not allow hexadecimal input with `$'
     (default in ISO 7185 Pascal).

`--read-white-space'
     In read statements, require whitespace after numbers.

`--no-read-white-space'
     In read statements, do not require whitespace after numbers
     (default).

`--write-clip-strings'
     In write statements, truncate strings exceeding their field width
     (`Write (SomeLongString : 3)').

`--no-write-clip-strings'
     Do not truncate strings exceeding their field width.

`--write-real-blank'
     Output a blank in front of positive reals in exponential form
     (default).

`--no-write-real-blank'
     Do not output a blank in front of positive reals in exponential
     form.

`--write-capital-exponent'
     Write real exponents with a capital `E'.

`--no-write-capital-exponent'
     Write real exponents with a lowercase `e'.

`--transparent-file-names'
     Derive external file names from variable names.

`--no-transparent-file-names'
     Do not derive external file names from variable names (default).

`--field-widths'
     Comma-separated list of default field widths for Integer, Real,
     Boolean, LongInt, LongReal.

`--no-field-widths'
     Reset the default field widths.

`--pedantic'
     Reject everything not allowed in some dialect, e.g. redefinition
     of its keywords.

`--no-pedantic'
     Don't give pedantic warnings.

`--stack-checking'
     Enable stack checking (same as `{$S+}').

`--no-stack-checking'
     Disable stack checking (same as `{$S-}').

`--typed-address'
     Make the result of the address operator typed (same as `{$T+}',
     default).

`--no-typed-address'
     Make the result of the address operator an untyped pointer (same
     as `{$T-}').

`--enable-keyword'
     Enable a keyword, independently of dialect defaults.

`--disable-keyword'
     Disable a keyword, independently of dialect defaults.

`--assert'
     Enable assertion checking (default).

`--no-assert'
     Disable assertion checking.

`--setlimit'
     Define the range for `set of Integer' etc..

`--gpc-main'
     External name for the program's entry point (default: `main').

`--interface-only'
     Compile only the interface part of a unit/module and exit (creates
     `.gpi' file, no `.o' file.

`--implementation-only'
     Do not produce a GPI file; only compile the implementation part.

`--executable-file-name'
     Name for the output file, if specified; otherwise derive from main
     source file name.

`--unit-path'
     Directories where to look for unit/module sources.

`--no-unit-path'
     Forget about directories where to look for unit/module sources.

`--object-path'
     Directories where to look for additional object (and source) files.

`--no-object-path'
     Forget about directories where to look for additional object (and
     source) files.

`--executable-path'
     Path where to create the executable file.

`--no-executable-path'
     Create the executable file in the directory where the main source
     is (default).

`--unit-destination-path'
     Path where to create object and GPI files of Pascal units.

`--no-unit-destination-path'
     Create object and GPI files of Pascal units in the current
     directory (default).

`--object-destination-path'
     Path where to create additional object files (e.g. of C files, not
     Pascal units).

`--no-object-destination-path'
     Create additional object files (e.g. of C files, not Pascal units)
     in the current directory (default).

`--no-default-paths'
     Do not add a default path to the unit and object path.

`--gpi-destination-path'
     (Internal switch used for automake).

`--uses'
     Add an implicit `uses' clause.

`--init-modules'
     Initialize the named modules in addition to those imported
     regularly; kind of a kludge.

`--cidefine'
     Define a case-insensitive macro.

`--csdefine'
     Define a case-sensitive macro.

`--big-endian'
     Tell GPC that the system is big-endian (for those targets where it
     can vary).

`--little-endian'
     Tell GPC that the system is little-endian (for those targets where
     it can vary).

`--print-needed-options'
     Print the needed options.

`-Wwarnings'
     Enable warnings (same as `{$W+}').

`-Wno-warnings'
     Disable all warnings (same as `{$W-}').

`-Widentifier-case'
     Warn about an identifier written with varying case.

`-Wno-identifier-case'
     Do not warn about an identifier written with varying case
     (default).

`-Widentifier-case-local'
     Warn about an identifier written with varying case within one
     program/module/unit.

`-Wno-identifier-case-local'
     Same as `-Wno-identifier-case'.

`-Winterface-file-name'
     Warn when a unit/module interface differs from the file name.

`-Wno-interface-file-name'
     Do not warn when a unit/module interface differs from the file
     name (default).

`-Wimplicit-abstract'
     Warn when an object type not declared `abstract' contains an
     abstract method (default).

`-Wno-implicit-abstract'
     Do not warn when an object type not `declared' abstract contains
     an abstract method.

`-Winherited-abstract'
     Warn when an abstract object type inherits from a non-abstract one
     (default).

`-Wno-inherited-abstract'
     Do not warn when an abstract object type inherits from a
     non-abstract one.

`-Wimplicit-io'
     Warn when `Input' or `Output' are used implicitly.

`-Wno-implicit-io'
     Do not warn when `Input' or `Output' are used implicitly (default).

`-Wfloat-equal'
     Warn about `=' and `<>' comparisons of real numbers.

`-Wno-float-equal'
     Do not warn about `=' and `<>' comparisons of real numbers.

`-Wtyped-const'
     Warn about misuse of typed constants as initialized variables
     (default).

`-Wno-typed-const'
     Do not warn about misuse of typed constants as initialized
     variables.

`-Wnear-far'
     Warn about use of useless `near' or `far' directives (default).

`-Wno-near-far'
     Do not warn about use of useless `near' or `far' directives.

`-Wunderscore'
     Warn about double/leading/trailing underscores in identifiers.

`-Wno-underscore'
     Do not warn about double/leading/trailing underscores in
     identifiers.

`-Wsemicolon'
     Warn about a semicolon after @samp{then}, @samp{else} or @samp{do}
     (default).

`-Wno-semicolon'
     Do not warn about a semicolon after @samp{then}, @samp{else} or
     @samp{do}.

`-Wlocal-external'
     Warn about local `external' declarations.

`-Wno-local-external'
     Do not warn about local `external' declarations.

`-Wmixed-comments'
     Warn about mixed comments like `{ ... *)'.

`-Wno-mixed-comments'
     Do not warn about mixed comments.

`-Wnested-comments'
     Warn about nested comments like `{ { } }'.

`-Wno-nested-comments'
     Do not warn about nested comments.


File: gpc.info,  Node: GPC Options,  Prev: GPC Command Line Options,  Up: Invoking GPC

The most commonly used options to GPC
=====================================

   As the most simple example, calling

     gpc foo.pas

   tells GPC to compile the source file `foo.pas' and to produce an
executable of the default name which is `foo.exe' on EMX, `a.exe' on
Cygwin, both `a.out' and `a.exe' on DJGPP, and `a.out' on most other
platforms.

   Users familiar with BP, please note that you have to give the file
name extension `.pas': GPC is a common interface for a Pascal compiler,
a C, ObjC and C++ compiler, an assembler, a linker, and perhaps an Ada
and a FORTRAN compiler. From the extension of your source file GPC
figures out which compiler to run. GPC recognizes Pascal sources by the
extension `.pas', `.p', `.pp' or `.dpr'. GPC also accepts source files
in other languages (e.g., `.c' for C) and calls the appropriate
compilers for them. Files with the extension `.o' or without any special
recognized extension are considered to be object files or libraries to
be linked.

   Another example:

     gpc -O2 -Wall --executable-file-name --automake --unit-path=units foo.pas

   This will compile the source file `foo.pas' to an executable named
`foo' (`--executable-file-name') with fairly good optimization (`-O2'),
warning about possible problems (`-Wall'). If the program uses units or
imports modules, they will be searched for in a directory called `units'
(`--unit-path') and automatically compiled and linked (`--automake').

   The following table lists the most commonly used options to GPC.

`--automake'
     Check whether modules/units used must be recompiled and do the
     recompilation when necessary.

`--unit-path=DIR[:DIR...]'
     Search the given directories for units and object files.

`--object-path=DIR[:DIR...]'
     Search the given directories for object files.

`--unit-destination-path=DIR'
     Place compiled units (GPI and object files) into the directory
     DIR. The default is the current directory.

`--object-destination-path=DIR'
     Place compiled object files (e.g., from C files, but not from
     Pascal units) into the directory DIR. The default is the directory
     given with `--unit-destination-path'.

`--executable-path=DIR'
     Place the executable compiled into the directory DIR. The default
     is the main source file's directory.

`-o FILE'
     Place output in file FILE. This applies regardless to whatever
     sort of output is being produced, whether it be an executable file,
     an object file, an assembler file, etc.

     Since only one output file can be specified, it does not make sense
     to use `-o' when compiling more than one input file, unless you
     are producing an executable file as output.

`--executable-file-name[=NAME]'
     Derive the executable file name from the source file name, or use
     NAME as the executable file name. The difference to the `-o'
     option is that `--executable-file-name' considers the
     `--executable-path', while `-o' does not and accepts a file name
     with directory. Furthermore, `--executable-file-name' only applies
     to executables, not to other output formats selected.

`-LDIR'
     Search the directory DIR for libraries. Can be given multiple
     times.

`-IDIR'
     Search the directory DIR for include files. Can be given multiple
     times.

`-lLIBRARY'
     Search the library named LIBRARY when linking. This option must be
     placed on the command line _after_ all source or object files or
     other libraries that reference the library.

`-O[N]'
     Select the optimization level. Without optimization (or `-O0'
     which is the default), the compiler's goal is to reduce the
     compilation time and to make debugging produce the expected
     results.  Statements are independent: if you stop the program with
     a breakpoint between statements, you can then assign a new value to
     any variable or change the program counter to any other statement
     in the same routine and get exactly the results you would expect
     from the source code.

     With optimization, the compiler tries to reduce code size and
     execution time. The higher the value of N, the more optimizations
     will be done, but the longer the compilation will take.

     If you use multiple `-O' options, with or without N, the last such
     option is the one that is effective.

`-g'
     Produce debugging information suitable for `gdb'. Unlike some
     other compilers, GNU Pascal allows you to use `-g' with `-O'. The
     shortcuts taken by optimized code may occasionally produce
     surprising results: some variables you declared may not exist at
     all; flow of control may briefly move where you did not expect it;
     some statements may not be executed because they compute constant
     results or their values were already at hand; some statements may
     execute in different places because they were moved out of loops.
     Nevertheless it proves possible to debug optimized output. This
     makes it reasonable to use the optimizer for programs still in the
     testing phase.

`-s'
     Remove all symbol table and relocation information from the
     executable. Note: this has no influence on the performance of the
     compiled executable.

`-Wall'
     Give warnings for a number of constructs which are not inherently
     erroneous but which are risky or suggest there may have been an
     error. There are additional warning options not implied by
     `-Wall', see the GCC warning options (*note Options to Request or
     Suppress Warnings: (gcc)Warning Options.), while `-Wall' only
     warns about such constructs that should be easy to avoid in
     programs. Therefore, we suggest using `-Wall' on most sources.

     Note that some warnings (e.g., those about using uninitialized
     variables) are never given unless you compile with optimization
     (see above), because otherwise the compiler doesn't analyze the
     usage patterns of variables.

`-Werror'
     Turn all warnings into errors.

`-S'
     Stop after the stage of compilation proper; do not assemble. The
     output is in the form of an assembler code file for each source
     file. By default, the assembler file name for a source file is made
     by replacing the extension with `.s'.

`-c'
     Compile and assemble the source files, but do not link. The output
     is in the form of an object file for each source file. By default,
     the object file name for a source file is made by replacing the
     extension with `.o'.

`-static'
     On systems that support dynamic linking, this prevents linking with
     the shared libraries, i.e. forces static linking. On other systems,
     this option has no effect.

`-DMACRO[=DEF]'
     Define the macro and conditional symbol MACRO as DEF (or as `1' if
     DEF is omitted).

`-b MACHINE'
     The argument MACHINE specifies the target machine for compilation.
     This is useful when you have installed GNU Pascal as a
     cross-compiler.

`-v'
     Print (on standard error) the commands executed to run the stages
     of compilation. Also print the version number of the compiler
     driver program and of the preprocessor and the compiler proper.

`--classic-pascal-level-0'
`--classic-pascal'
`--extended-pascal'
`--object-pascal'
`--ucsd-pascal'
`--borland-pascal'
`--pascal-sc'
     GNU Pascal supports the features of several different Pascal
     standards and dialects. By default, they are all enabled. These
     switches tell GPC to restrict itself to the features of the
     specified standard. It does not enable any additional features.
     Warnings about certain dangerous constructs which would be valid in
     the specified dialect (e.g., assignment to a typed constant with
     `--borland-pascal') are suppressed.

     By default, GNU Pascal allows the redefinition of some keywords.
     Each of these switches causes GNU Pascal to forbid the redefinition
     of keywords of the specified standard.

     Valid ISO 7185 Pascal programs should compile properly with or
     without `--classic-pascal'. However, without this option, certain
     GNU extensions and Pascal features from other dialects are
     supported as well. With this option, they are rejected.

     These options are not intended to be useful; they exist only to
     satisfy pedants who would otherwise claim that GNU Pascal fails to
     support the ISO Standard or is not really compatible to Borland
     Pascal, or whatever. We recommend, rather, that users take
     advantage of the extensions of GNU Pascal and disregard the
     limitations of other compilers.

`-pedantic-errors'
     Produce errors rather than warnings for portability violations.
     Unlike in C, this does _not_ imply the `-pedantic' option, so you
     can, for instance, use `-pedantic-errors' without `-pedantic', but
     with `--extended-pascal'.

`--gpc-main=NAME'
     Name the entry point of the main program `NAME' instead of `main'
     on the linker level. This is useful, e.g., when working with some
     C libraries which define their own `main' function and require the
     program's main entry point to be named differently. (This option
     should preferably be used as a compiler directive in the unit or
     module which links to that strange C library, rather than be given
     on the command-line.)


File: gpc.info,  Node: Programming,  Next: Borland Pascal,  Prev: Invoking GPC,  Up: Top

The Programmer's Guide to GPC
*****************************

   *This chapter is still under development.*

   This chapter tells you how the source of a valid GNU Pascal program
should look like.  You can use it as tutorial about the GNU Pascal
language, but since the main goal is to document all special GPC
features, implementation-dependent stuff, etc., expect a steep learning
curve.

   This chapter does _not_ cover how to compile your programs and to
produce an executable - this is discussed above in *Note Invoking GPC::.

* Menu:

* Source Structures::    Programs, Units and Modules.
* Data Types::           Standard and non-standard data types.
* Operators::            Built-in and user-definable operators.
* Parameters::           Procedure And Function Parameters
* Pointer Arithmetics::  How pointer arithmetics works in Pascal.
* String Slice Access::  Accessing parts of strings (and other arrays)
* Type Casts::           Explicit and emulated type casting in GPC.
* OOP::                  How object-oriented programming is implemented.
* Compiler Directives::  Compiler Directives And The Preprocessor
* Library Routines::     Routines Built-in or in the Run Time System
* Other Languages::      How to share libraries with other languages.
* Notes for Debugging::  Problems and caveats when debugging GPC programs.
* Run Time System::      Pascal declarations for GPC's Run Time System library.
* GPC Units::            Units included with GPC
* I18N::                 How to use Internationalization in your programs


File: gpc.info,  Node: Source Structures,  Next: Data Types,  Up: Programming

Source Structures
=================

   A source file accepted by GNU Pascal may contain up to one program,
zero or more ISO-style modules, and/or zero or more UCSD-style units.
Units and modules can be mixed in one project.

* Menu:

* The Program::             The Source Structure of Programs
* Label Declaration::
* Constant Declaration::
* Type Declaration::
* Variable Declaration::
* Subroutine Declaration::  Procedures, Functions and Operators
* Statements::              Loops and Conditional Statements
* Modules and Units::       Import Part and Module/Unit Concept

   One trivial example for a valid GPC source file follows. Note that
the code below may either be in one source file, or else the unit and
the program may be in separate source files.

     unit DemoUnit;
     
     interface
     
     procedure Hello;
     
     implementation
     
     procedure Hello;
     begin
       WriteLn ('Hello, world!')
     end;
     
     end.

     program UnitDemo;
     
     uses
       DemoUnit;
     
     begin
       Hello
     end.


File: gpc.info,  Node: The Program,  Next: Label Declaration,  Up: Source Structures

The Source Structure of Programs
--------------------------------

   A generic GNU Pascal program looks like the following:

     program NAME (Input, Output);
     
     IMPORT_PART
     
     DECLARATION_PART
     
     begin
       STATEMENT_PART
     end.

   The `program' headline may be omitted in GPC, but a warning will be
given except in `--borland-pascal' mode.

   While the program parameters (usually `Input', `Output') are
obligatory in ISO Pascal if you want to use `ReadLn' and `WriteLn',
they are optional in GNU Pascal. GPC will warn about such missing
parameters in `--extended-pascal' mode. However if you give parameters
to the program headline, they work like ISO requires.

   The IMPORT_PART consists either of an ISO-style `import'
specification or a UCSD/Borland-style `uses' clause. While `import' is
intended to be used with interfaces exported by ISO 10206 Extended
Pascal modules, and `uses' is intended to be used with units, this is
not enforced. (See also *Note uses::, *Note import::.)

   The DECLARATION_PART consists of label, constant, type, variable or
subroutine declarations in free order. However, every identifier must
be declared before it is used. The only exception are type identifiers
pointing to another type identifier which may be declared below.

   The STATEMENT_PART consists of a sequence of statements.

   As an extension, GPC supports a "declaring statement" which can be
used in the statement part to declare variables (see *Note var::).


File: gpc.info,  Node: Label Declaration,  Next: Constant Declaration,  Prev: The Program,  Up: Source Structures

Label Declaration
-----------------

   A label declaration has the following look:

     label
       LABEL_NAME, ..., LABEL;

   A label declaration part starts with the reserved word `label',
which contains a list of labels.

See also
--------

   *Note label::, *Note goto::


File: gpc.info,  Node: Constant Declaration,  Next: Type Declaration,  Prev: Label Declaration,  Up: Source Structures

Constant Declaration
--------------------

   A constant declaration has the following look:

     const
       CONSTANT_IDENTIFIER = CONSTANT_EXPRESSION;
       ...
       CONSTANT_IDENTIFIER = CONSTANT_EXPRESSION;

   A constant declaration part starts with the reserved word `const'.
It declares a CONSTANT_IDENTIFIER which is defined by
CONSTANT_EXPRESSION. This expression has to be evaluatable during
compilation time, i.e. it can include numbers, parentheses, predefined
operators, sets and type casts (the last, however, is a Borland
extension).  In ISO 7185 Pascal, CONSTANT_EXPRESSION must be a constant
or a set. All Pascal Dialects but ISO-Pascal allow the use of these
intrinsic functions in CONSTANT_EXPRESSION:

   *Note Abs::, *Note Round::, *Note Trunc::, *Note Chr::, *Note Ord::,
*Note Length::, *Note Pred::, *Note Succ::, *Note SizeOf::, *Note Odd::.

   In Borland Pascal, in the constant declaration part variables can be
declared as well, which are given an initial value. These variables are
called "typed constants". It is good style to avoid this use,
especially since Extended Pascal and GNU Pascal allow to initialize a
variable in variable declaration part or give a type a preset value on
declaration.

     const
       FiveFoo      = 5;
       StringFoo    = 'string constant';
       AlphabetSize = Ord ('Z') - Ord ('A') + 1;
     
     type
       PInteger     = ^Integer;     { Define a pointer to an Integer }
     
     const
       { Constant which holds a pointer to an Integer at address 1234 }
       AddressFoo   = PInteger (1234);

   * BP does not know initialized variables, only typed constants. Even
     worse, it allows them to be misused as variables, without even
     warning. GPC supports this (unwillingly ;-), and warns unless in
     `--borland-pascal' mode.

     An example of a typed constant:

          const
            i: Integer = 0;

     If you want to use it as a constant only, that's perfectly fine.
     However, if you modify `i', we suggest to translate the
     declaration to an initialized variable. The EP syntax is:

          var
            i: Integer value 0;

     GPC supports this as well as the following mixture of dialects:

          var
            i: Integer = 0;

     Furthermore, you can also assign initialization values to types:

          program InitTypeDemo;
          
          type
            MyInteger = Integer value 42;
          
          var
            i: MyInteger;
          
          begin
            WriteLn (i)
          end.

     Here, all variables of type MyInteger are automatically initialized
     to 42 when created.

   * Arrays initializers look like this in BP:

          program BPArrayInitDemo;
          
          const
            MyStringsCount = 5;
          
          type
            Ident = String [20];
          
          const
            MyStrings: array [1 .. MyStringsCount] of Ident =
              ('export', 'implementation', 'import',
               'interface', 'module');
          
          begin
          end.

     And the following way in EP:

          program EPArrayInitDemo;
          
          const
            MyStringsCount = 5;
          
          type
            Ident = String (20);
          
          var
            MyStrings: array [1 .. MyStringsCount] of Ident value
              [1: 'export'; 2: 'implementation'; 3: 'import';
               4: 'interface'; 5: 'module'];
          
          begin
          end.

     There seem to be pros and cons to each style. GPC supports both as
     well as just about any thinkable mixture of them.

     Some folks don't like having to specify an index since it requires
     renumbering if you want to add a new item to the middle. However,
     if you index by an enumerated type, you might be able to avoid
     major renumbering by hand.


See also
--------

   *Note Subroutine Parameter List Declaration::


File: gpc.info,  Node: Type Declaration,  Next: Variable Declaration,  Prev: Constant Declaration,  Up: Source Structures

Type Declaration
----------------

   A type declaration looks like this:

     type
       TYPE_IDENTIFIER = TYPE_DEFINITION;
       ...
       TYPE_IDENTIFIER = TYPE_DEFINITION;
   or, with preset content:
     type
       TYPE_IDENTIFIER = TYPE_DEFINITION value CONSTANT_EXPRESSION;
       ...
       TYPE_IDENTIFIER = TYPE_DEFINITION value CONSTANT_EXPRESSION;

   A type declaration part begins with the reserved word `type'.  It
declares a TYPE_IDENTIFIER which is defined by TYPE_DEFINITION.  A type
definition either can be an array, a record, a schema, a set, an
object, a subrange, an enumerated type, a pointer to another
type_identifier or simply another type_identifier which is to alias.
If a schema type is to be declared, TYPE_IDENTIFIER is followed by a
discriminant enclosed in parentheses:

     TYPE_IDENTIFIER (DISCRIMINANT) = SCHEMA_TYPE_DEFINITION;

   If `value' is specified, followed by a constant satisfying the type
definition, every variable of this type is initialized with
CONSTANT_EXPRESSION, unless it is initialized by `value' itself.  The
reserved word `value' can be replaced by `=', however `value' is not
allowed in ISO-Pascal and Borland Pascal, and the replacement by `=' is
not allowed in Extended Pascal.

Type declaration example
------------------------

     type
       { This side is the }     { That side is the }
       { type declaration }     { type definition  }
     
       Arrayfoo            = array [0 .. 9] of Integer;  { array definition }
       Recordfoo           = record                      { record definition }
                               Bar: Integer;
                             end;
     
            { schema def with discriminants ``x, y: Integer'' }
       SchemaFoo (x, y: Integer) = array [x .. y] of Integer;
       CharSetFoo          = set of Char;              { Def of a set }
       ObjectFoo           = object                    { Def of an object }
                               procedure DoAction;
                               constructor Init;
                               destructor Done;
                             end;
       SubrangeFoo         = -123..456;                { subrange def }
     
       EnumeratedFoo       = (Pope,John,the,Second);   { enum type def }
            { Def of a pointer to another type identifier }
       PInteger            = ^arrayfoo;
            { Def of an alias name for another type identifier }
       IdentityFoo         = Integer;
            { Def of an integer which was initialized by 123 }
       InitializedFoo      = Integer value 123;

See also
--------

   *Note Type Definition::, *Note Data Types::, *Note Variable
Declaration::


File: gpc.info,  Node: Variable Declaration,  Next: Subroutine Declaration,  Prev: Type Declaration,  Up: Source Structures

Variable Declaration
--------------------

   A variable declaration looks like this:

     var
       VAR_IDENTIFIER: TYPE_IDENTIFIER;
       ...
       VAR_IDENTIFIER: TYPE_IDENTIFIER;
   or
     var
       VAR_IDENTIFIER: TYPE_DEFINITION;
       ...
       VAR_IDENTIFIER: TYPE_DEFINITION;
   and with initializing value:
     var
       VAR_IDENTIFIER: TYPE_IDENTIFIER value CONSTANT_EXPRESSION;
       ...
       VAR_IDENTIFIER: TYPE_IDENTIFIER value CONSTANT_EXPRESSION;
   or
     var
       VAR_IDENTIFIER: TYPE_DEFINITION value CONSTANT_EXPRESSION;
       ...
       VAR_IDENTIFIER: TYPE_DEFINITION value CONSTANT_EXPRESSION;

   A variable declaration part begins with the reserved word `var'.  It
declares a VAR_IDENTIFIER whose type either can be specified by a type
identifier, or by a type definion which either can be an array, a
record, a set, a subrange, an enumerated type or a pointer to an type
identifier.  If `value' is specified followed by a constant expression
satisfying the specified type, the variable declared is initialized with
CONSTANT_EXPRESSION.  The reserved word `value' can be replaced by `=',
however `value' is not allowed in ISO-Pascal and Borland Pascal, and the
replacement by `=' is not allowed in Extended Pascal.

See also
--------

   *Note Type Definition::, *Note Type Declaration::, *Note Data
Types::, *Note The Declaring Statement::, *Note Subroutine Parameter
List Declaration::


File: gpc.info,  Node: Subroutine Declaration,  Next: Statements,  Prev: Variable Declaration,  Up: Source Structures

Subroutine Declaration
----------------------

* Menu:

* The Procedure::
* The Function::
* The Operator::
* Subroutine Parameter List Declaration::


File: gpc.info,  Node: The Procedure,  Next: The Function,  Up: Subroutine Declaration

The Procedure
.............

     procedure PROCEDURE_IDENTIFIER;
     DECLARATION_PART
     begin
       STATEMENT_PART
     end;
   or with a parameter list:
     procedure PROCEDURE_IDENTIFIER (PARAMETER_LIST);
     DECLARATION_PART
     begin
       STATEMENT_PART
     end;

   A procedure is quite like a sub-program: The DECLARATION_PART
consists of label, constant, type, variable or subroutine declarations
in free order. The STATEMENT_PART consists of a sequence of statements.
If PARAMETER_LIST is specified, parameters can be passed to the
procedure and can be used in STATEMENT_PART. A recursive procedure call
is allowed.

See also
--------

   *Note The Function::, *Note Subroutine Parameter List Declaration::


File: gpc.info,  Node: The Function,  Next: The Operator,  Prev: The Procedure,  Up: Subroutine Declaration

The Function
............

     function FUNCTION_IDENTIFIER: FUNCTION_RESULT_TYPE;
     DECLARATION_PART
     begin
       STATEMENT_PART
     end;
   or with a parameter list:
     function FUNCTION_IDENTIFIER (PARAMETER_LIST): RESULT_TYPE;
     DECLARATION_PART
     begin
       STATEMENT_PART
     end;

   A function is a subroutine which has a return value of type
FUNCTION_RESULT_TYPE. It is structured like the program: the
DECLARATION_PART consists of label, constant, type, variable or
subroutine declarations in free order. The STATEMENT_PART consists of a
sequence of statements. If PARAMETER_LIST is specified, parameters can
be passed to the function and can be used in STATEMENT_PART. The result
is set via an assignment:
     FUNCTION_IDENTIFIER := EXPRESSION
   Recursive function calls are allowed. Concerning the result type,
ISO 7185 Pascal and Borland Pascal only allow the intrinsic types,
subranges, enumerated types and pointer types to be returned. In
Extended Pascal, FUNCTION_RESULT_TYPE can be every assignable type.  Of
course, there are no type restrictions in GNU Pascal as well.  If
extended syntax is switched on, functions can be called like procedures
via procedure call statement.

See also
--------

   *Note The Procedure::, *Note Subroutine Parameter List Declaration::,
*Note Data Types::


File: gpc.info,  Node: The Operator,  Next: Subroutine Parameter List Declaration,  Prev: The Function,  Up: Subroutine Declaration

The Operator
............

   GNU Pascal allows to define operators which can be used the infix
style in expressions. For a more detailed description, see *Note
Operators::


File: gpc.info,  Node: Subroutine Parameter List Declaration,  Prev: The Operator,  Up: Subroutine Declaration

Subroutine Parameter List Declaration
.....................................

     PARAMETER; ...; PARAMETER

   Each parameter can start with a prefix (see below) describing how
the parameters are passed, followed by a comma seperated list of one or
more PARAMETER_IDENTIFIERS and an optional PARAMETER_TYPE.

     procedure DoIt (var x, y, z: OneType; a, b: AnotherType; var q);

   To understand parameter passing, first some definitions.

actual parameter
     the parameter passed in to the routine.

formal parameter
     the parameter as used inside the procedure.

by value
     the value of the actual parameter is copied on to the stack.

by reference
     the address of the actual parameter is copied on to the stack.

L-value
     (left hand of a `:=' statement) something that can be assigned
     to (not a constant, or const or protected variable or other
     immutable item).

R-value
     (right hand of a `:=' statement) anything you can get the   value
     of (could be a constant, an expression, a variable (whether
     const or protected or not) or just about anything.

addressable
     something you can get the address of (not a field of a packed
     structure or a variable with `attribute (register)' (GPC
     extension)).

aliasing
     accessing memory via two different names (e.g. a global variable
     passed by reference to a procedure can be accessed either as the
     global variable or the formal paramater). Generally this is very
     bad practice.

   Technical note: Parameters are not always passed on the stack, they
may also be passed in registers, especially on RISC machines.

   The prefix defines how a variable is passed on the stack and how you
can access the FORMAL_PARAMETER inside the procedure.  The prefix can
be one of:

nothing
          procedure DoIt (x: SOMETYPE);

     Technical: The actual parameter is passed by value or reference,
     but if passed by reference, it is then copied to a local copy on
     the stack. Aliasing has no effect on x.

     What it means: you can modify `x' inside the routine, but your
     changes will not affect the actual parameter (and vice versa). The
     actual parameter can be a constant or other immutable object, or a
     protected or const variable.

protected
          procedure DoIt (protected x: SOMETYPE);

     Technical: The actual parameter is passed by value or reference,
     but if passed by reference, it is then copied to a local copy on
     the stack. Aliasing has no effect on x. `protected' is a Extended
     Pascal extension.

     What it means: if you modify the actual parameter, this will not
     affect `x' inside the routine. The actual parameter can be a
     constant or other immutable object, or a protected or const
     variable. You are forbidden from modifying x inside the routine.

var
          procedure DoIt (var x: SOMETYPE);

     Technical: The actual parameter is passed by reference.  Aliasing
     will definitely change `x'.

     What it means: modifications to `x' inside the routine will change
     the actual parameter passed in. The actual parameter must be an
     addressable L-value (ie, it must be something you can take the
     address of and assign to).

     A parameter of this kind is called variable parameter and
     internally corresponds to an L-value pointer (to the specified
     type identifier if any). This declaration is necessary if the
     parameter is to be modified within the routine and to hold its
     value still after return.

const
          procedure DoIt (const x: SOMETYPE);

     Technical: The actual parameter is passed by value or reference.
     The compiler will make a copy of the actual parameter to have
     something it can address if the actual parameter is not
     addressable.  You are forbidden from modifying `x' inside the
     routine, and therefore you cannot modify the actual parameter.
     Aliasing may or may not change `x'. `const' is a Borland Pascal
     extension.

     What it means: You can pass any R-value. You cannot modify `x'
     inside the routine. If you change the actual parameter while inside
     the routine, `x' will have an undefined value.

protected var
          procedure DoIt (protected var x: SOMETYPE);

     Technical: The actual parameter is passed by reference. The
     compiler will never make a copy of the actual parameter. You are
     forbidden from modifying `x' inside the routine, and therefore you
     cannot modify the actual parameter. Aliasing will definitely change
     `x'.

     What it means: You can pass anything addressable. You cannot modify
     `x' inside the routine. If you change the actual parameter while
     inside the routine, `x' will change as well.

     In GPC, the `protected var' mode guarantees that the parameter is
     always passed by reference, making it the correct choice for
     calling C routines with `const' pointer parameters.

   If you omit the formal parameter type specification, then any type
may be passed to that parameter. Generally this is a bad idea, but
occasionally it can be useful, especially for low level code.

   As an Extended Pascal extension, you can also declare procedural
parameters directly:
     procedure PARAMETER_IDENTIFIER
   or:
     function PARAMETER_IDENTIFIER: PARAMETER_IDENTIFIER_RESULT_TYPE

   Example for parameter lists:
     program ParameterDemo;
     
     procedure Foo (var Bar; var Baz: Integer; const Fred: Integer);
     
       procedure Glork1 (function Foo: Integer; procedure Bar (Baz: Integer));
       begin
         Bar (Foo)
       end;
     
     begin
       Baz := Integer (Bar) + Fred
     end;
     
     var
       a, b, c: Integer;
     
     begin
       Foo (a, b, c)
     end.

See also
--------

   *Note Data Types::, *Note var::, *Note const::, *Note protected::


File: gpc.info,  Node: Statements,  Next: Modules and Units,  Prev: Subroutine Declaration,  Up: Source Structures

Statements
----------

* Menu:

* Assignment::
* begin end Compound Statement::
* if Statement::
* case Statement::
* for Statement::
* while Statement::
* repeat Statement::
* asm Inline::
* with Statement::
* goto Statement::
* Procedure Call::
* The Declaring Statement::
* Loop Control Statements::


File: gpc.info,  Node: Assignment,  Next: begin end Compound Statement,  Up: Statements

Assignment
..........

   The way an assignment looks like:
     L-VALUE := EXPRESSION;

   This statement assigns any valid expression to L-VALUE. Make sure
that the result of EXPRESSION is compatible with L-VALUE, otherwise an
compilation error is reported. The `:=' is called assignment operator.
As long as L-VALUE and EXPRESSION are type compatible, they are
assignment compatible for _any definable type_ as well.


File: gpc.info,  Node: begin end Compound Statement,  Next: if Statement,  Prev: Assignment,  Up: Statements

begin end Compound Statement
............................

   It looks like that:
     begin
       STATEMENT;
       STATEMENT;
       ...
       STATEMENT
     end

   This statement joins several STATEMENTS together into one compound
statement which is treated as a single statement by the compiler. The
finishing semicolon before `end' can be left out.


File: gpc.info,  Node: if Statement,  Next: case Statement,  Prev: begin end Compound Statement,  Up: Statements

if Statement
............

   This statement has the following look:
     if BOOLEAN_EXPRESSION then
       STATEMENT
   or with an alternative statement:
     if BOOLEAN_EXPRESSION then
       STATEMENT1
     else
       STATEMENT2

   The `if' ... `then' statement consists of a boolean expression and a
STATEMENT, which is conditionally executed if the evaluation of
BOOLEAN_EXPRESSION yields true.

   If `if' ... `then' ... `else' is concerned, STATEMENT1 is executed
depending on BOOLEAN_EXPRESSION being true, otherwise STATEMENT2 is
executed alternatively. Note: the statement before else _must not_
finish with a semicolon.


File: gpc.info,  Node: case Statement,  Next: for Statement,  Prev: if Statement,  Up: Statements

case Statement
..............

     case EXPRESSION of
       SELECTOR: STATEMENT;
       ...
       SELECTOR: STATEMENT;
     end
   or, with alternative statement sequence:
     case ORDINAL_EXPRESSION of
       SELECTOR: STATEMENT;
       ...
       SELECTOR: STATEMENT;
     otherwise                   { ``else'' instead of ``otherwise'' allowed }
       STATEMENT;
       ...
       STATEMENT;
     end
   or, as part of the invariant `record' type definition:
     type
       foo = record
         FIELD_DECLARATIONS
       case bar: VARIANT_TYPE of
         SELECTOR: (FIELD_DECLARATIONS);
         SELECTOR: (FIELD_DECLARATIONS);
         ...
       end;
   or, without a variant selector field,
     type
       foo = record
         FIELD_DECLARATIONS
       case VARIANT_TYPE of
         SELECTOR: (FIELD_DECLARATIONS);
         SELECTOR: (FIELD_DECLARATIONS);
         ...
       end;

   The `case' statement compares the value of ORDINAL_EXPRESSION to
each SELECTOR, which can be a constant, a subrange, or a list of them
separated by commas, being compatible with the result of
ORDINAL_EXPRESSION.  Note: duplicate selectors or range crossing is not
allowed unless {$borland-pascal} is specified. In case of equality the
corresponding statement is executed. If `otherwise' is specified and no
appropriate selector matched the expression, the series of statements
following `otherwise' is executed. As a synonym for `otherwise', `else'
can be used. The semicolon before `otherwise' is optional.

   @@ ????  The expression _must_ match one of the selectors in order
to continue, unless an alternative statement series is specified.

   For `case' in a variant record type definition, see *Note Record
Types::.

See also
--------

   *Note if Statement::

