/* Copyright (C) 2016 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 2015 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 2014 DJ Delorie, see COPYING.DJ for details */
/*
 * This file will be removed as soon as DJGPP implements multi-byte character support.
 */

#include "dj_wctype.h"


int
iswctype(wint_t wc, wctype_t charclass)
{
  switch(charclass)
  {
  case WC_ALNUM:
    return iswalnum(wc);
  case WC_ALPHA:
    return iswalpha(wc);
  case WC_BLANK:
    return iswblank(wc);
  case WC_CNTRL:
    return iswcntrl(wc);
  case WC_DIGIT:
    return iswdigit(wc);
  case WC_GRAPH:
    return iswgraph(wc);
  case WC_LOWER:
    return iswlower(wc);
  case WC_PRINT:
    return iswprint(wc);
  case WC_PUNCT:
    return iswpunct(wc);
  case WC_SPACE:
    return iswspace(wc);
  case WC_UPPER:
    return iswupper(wc);
  case WC_XDIGIT:
    return iswxdigit(wc);
  default:
    break;
  }

  return 0;
}

