#
# This file is auto-generated. ***ANY*** changes here will be lost
#

package Errno;
use vars qw(@EXPORT_OK %EXPORT_TAGS @ISA $VERSION %errno $AUTOLOAD);
use Exporter ();
use Config;
use strict;

$Config{'myarchname'} eq "pc-dos" or
	die "Errno architecture (pc-dos) does not match executable architecture ($Config{'myarchname'})";

$VERSION = "1.09";
@ISA = qw(Exporter);

@EXPORT_OK = qw(ENMFILE EFAULT ENOSYS EACCES EAGAIN ENOEXEC
	ENAMETOOLONG ENOSPC ECHILD ENOENT EDEADLK EEXIST EBADF ERANGE EMFILE
	ENFILE ENOLCK EXDEV EMLINK EISDIR ENOMEM ENODEV EINTR ENXIO ENOTTY
	ENOTEMPTY EDOM ESPIPE EBUSY E2BIG EPIPE ENOTDIR ESRCH EPERM EFBIG EIO
	EINVAL EROFS);

%EXPORT_TAGS = (
    POSIX => [qw(
	E2BIG EACCES EAGAIN EBADF EBUSY ECHILD EDEADLK EDOM EEXIST EFAULT
	EFBIG EINTR EINVAL EIO EISDIR EMFILE EMLINK ENAMETOOLONG ENFILE ENODEV
	ENOENT ENOEXEC ENOLCK ENOMEM ENOSPC ENOSYS ENOTDIR ENOTEMPTY ENOTTY
	ENXIO EPERM EPIPE ERANGE EROFS ESPIPE ESRCH EXDEV
    )]
);

sub EDOM () { 1 }
sub ERANGE () { 2 }
sub E2BIG () { 3 }
sub EACCES () { 4 }
sub EAGAIN () { 5 }
sub EBADF () { 6 }
sub EBUSY () { 7 }
sub ECHILD () { 8 }
sub EDEADLK () { 9 }
sub EEXIST () { 10 }
sub EFAULT () { 11 }
sub EFBIG () { 12 }
sub EINTR () { 13 }
sub EINVAL () { 14 }
sub EIO () { 15 }
sub EISDIR () { 16 }
sub EMFILE () { 17 }
sub EMLINK () { 18 }
sub ENAMETOOLONG () { 19 }
sub ENFILE () { 20 }
sub ENODEV () { 21 }
sub ENOENT () { 22 }
sub ENOEXEC () { 23 }
sub ENOLCK () { 24 }
sub ENOMEM () { 25 }
sub ENOSPC () { 26 }
sub ENOSYS () { 27 }
sub ENOTDIR () { 28 }
sub ENOTEMPTY () { 29 }
sub ENOTTY () { 30 }
sub ENXIO () { 31 }
sub EPERM () { 32 }
sub EPIPE () { 33 }
sub EROFS () { 34 }
sub ESPIPE () { 35 }
sub ESRCH () { 36 }
sub EXDEV () { 37 }
sub ENMFILE () { 38 }

sub TIEHASH { bless [] }

sub FETCH {
    my ($self, $errname) = @_;
    my $proto = prototype("Errno::$errname");
    if (defined($proto) && $proto eq "") {
	no strict 'refs';
        return $! == &$errname;
    }
    require Carp;
    Carp::confess("No errno $errname");
} 

sub STORE {
    require Carp;
    Carp::confess("ERRNO hash is read only!");
}

*CLEAR = \&STORE;
*DELETE = \&STORE;

sub NEXTKEY {
    my($k,$v);
    while(($k,$v) = each %Errno::) {
	my $proto = prototype("Errno::$k");
	last if (defined($proto) && $proto eq "");
	
    }
    $k
}

sub FIRSTKEY {
    my $s = scalar keys %Errno::;
    goto &NEXTKEY;
}

sub EXISTS {
    my ($self, $errname) = @_;
    my $proto = prototype($errname);
    defined($proto) && $proto eq "";
}

tie %!, __PACKAGE__;

1;
__END__

=head1 NAME

Errno - System errno constants

=head1 SYNOPSIS

    use Errno qw(EINTR EIO :POSIX);

=head1 DESCRIPTION

C<Errno> defines and conditionally exports all the error constants
defined in your system C<errno.h> include file. It has a single export
tag, C<:POSIX>, which will export all POSIX defined error numbers.

C<Errno> also makes C<%!> magic such that each element of C<%!> has a non-zero
value only if C<$!> is set to that value, eg

    use Errno;
    
    unless (open(FH, "/fangorn/spouse")) {
        if ($!{ENOENT}) {
            warn "Get a wife!\n";
        } else {
            warn "This path is barred: $!";
        } 
    } 

=head1 AUTHOR

Graham Barr <gbarr@pobox.com>

=head1 COPYRIGHT

Copyright (c) 1997-8 Graham Barr. All rights reserved.
This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

