Dies ist recode.info, hergestellt von Makeinfo Version 4.0 aus
recode.texi.

INFO-DIR-SECTION Internationalization and character sets
START-INFO-DIR-ENTRY
* recode: (recode).     Conversion between character sets and surfaces.
END-INFO-DIR-ENTRY

   This file documents the `recode' command, which has the purpose of
converting files between various character sets and surfaces.

   Copyright (C) 1990, 93, 94, 96, 97, 98, 99 Free Software Foundation,
Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided that
the entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be stated in a
translation approved by the Foundation.


File: recode.info,  Node: UTF-8,  Next: UTF-16,  Prev: UTF-7,  Up: Universal

Universal Transformation Format, 8 bits
=======================================

   Even if `UTF-8' does not originally come from IETF, there is now
RFC 2279 to describe it.  In letters sent on 1995-01-21 and 1995-04-20,
Markus Kuhn writes:

     `UTF-8' is an `ASCII' compatible multi-byte encoding of the
     ISO 10646 universal character set (`UCS').  `UCS' is a 31-bit
     superset of all other character set standards.  The first 256
     characters of `UCS' are identical to those of ISO 8859-1 (Latin-1).
     The `UCS-2' encoding of UCS is a sequence of bigendian 16-bit
     words, the `UCS-4' encoding is a sequence of bigendian 32-bit
     words.  The `UCS-2' subset of ISO 10646 is also known as
     "Unicode".  As both `UCS-2' and `UCS-4' require heavy
     modifications to traditional `ASCII' oriented system designs (e.g.
     Unix), the `UTF-8' encoding has been designed for these
     applications.

     In `UTF-8', only `ASCII' characters are encoded using bytes below
     128.  All other non-ASCII characters are encoded as multi-byte
     sequences consisting only of bytes in the range 128-253.  This
     avoids critical bytes like `NUL' and `/' in `UTF-8' strings, which
     makes the `UTF-8' encoding suitable for being handled by the
     standard C string library and being used in Unix file names.
     Other properties include the preserved lexical sorting order and
     that `UTF-8' allows easy self-synchronisation of software
     receiving `UTF-8' strings.

   `UTF-8' is the most common external surface of `UCS', each character
uses from one to six bytes, and is able to encode all 2^31 characters
of the `UCS'.  It is implemented as a charset, with the following
properties:

   * Strict 7-bit `ASCII' is completely invariant under `UTF-8', and
     those are the only one-byte characters.  `UCS' values and `ASCII'
     values coincide.  No multi-byte characters ever contain bytes less
     than 128.  `NUL' _is_ `NUL'.  A multi-byte character always starts
     with a byte of 192 or more, and is always followed by a number of
     bytes between 128 to 191.  That means that you may read at random
     on disk or memory, and easily discover the start of the current,
     next or previous character.  You can count, skip or extract
     characters with this only knowledge.

   * If you read the first byte of a multi-byte character in binary, it
     contains many `1' bits in successions starting with the most
     significant one (from the left), at least two.  The length of this
     `1' sequence equals the byte size of the character.  All
     succeeding bytes start by `10'.  This is a lot of redundancy,
     making it fairly easy to guess that a file is valid `UTF-8', or to
     safely state that it is not.

   * In a multi-byte character, if you remove all leading `1' bits of
     the first byte of a multi-byte character, and the initial `10'
     bits of all remaining bytes (so keeping 6 bits per byte for
     those), the remaining bits concatenated are the UCS value.

These properties also have a few nice consequences:

   * Conversion to/from values is algorithmically simple, and
     reasonably speedy.

   * A sequence of N bytes can hold characters needing up to 2 + 5N
     bits in their `UCS' representation.  Here, N is a number between 1
     and 6.  So, `UTF-8' is most economical when mapping ASCII (1 byte),
     followed by `UCS-2' (1 to 3 bytes) and `UCS-4' (1 to 6 bytes).

   * The lexicographic sorting order of `UCS' strings is preserved.

   * Bytes with value 254 or 255 never appear, and because of that,
     these are sometimes used when escape mechanisms are needed.

   In some case, when little processing is done on a lot of strings,
one may choose for efficiency reasons to handle `UTF-8' strings
directly even if variable length, as it is easy to get start of
characters.  Character insertion or replacement might require moving
the remainder of the string in either direction.  In most cases, it is
faster and easier to convert from `UTF-8' to `UCS-2' or `UCS-4' prior
to processing.

   This charset is available in `recode' under the name `UTF-8'.
Accepted aliases are `UTF-2', `UTF-FSS', `FSS_UTF', `TF-8' and `u8'.


File: recode.info,  Node: UTF-16,  Next: count-characters,  Prev: UTF-8,  Up: Universal

Universal Transformation Format, 16 bits
========================================

   Another external surface of `UCS' is also variable length, each
character using either two or four bytes.  It is usable for the subset
defined by the first million characters (17 * 2^16) of `UCS'.

   Martin J. Du"rst writes (to `comp.std.internat', on 1995-03-28):

     `UTF-16' is another method that reserves two times 1024 codepoints
     in Unicode and uses them to index around one million additional
     characters.  `UTF-16' is a little bit like former multibyte codes,
     but quite not so, as both the first and the second 16-bit code
     clearly show what they are.  The idea is that one million
     codepoints should be enough for all the rare Chinese ideograms and
     historical scripts that do not fit into the Base Multilingual
     Plane of ISO 10646 (with just about 63,000 positions available,
     now that 2,000 are gone).

   This charset is available in `recode' under the name `UTF-16'.
Accepted aliases are `Unicode', `TF-16' and `u6'.


File: recode.info,  Node: count-characters,  Next: dump-with-names,  Prev: UTF-16,  Up: Universal

Frequency count of characters
=============================

   A device may be used to obtain a list of characters in a file, and
how many times each character appears.  Each count is followed by the
`UCS-2' value of the character and, when known, the RFC 1345 mnemonic
for that character.

   This charset is available in `recode' under the name
`count-characters'.

   This `count' feature has been implemented as a charset.  This may
change in some later version, as it would sometimes be convenient to
count original bytes, instead of their `UCS-2' equivalent.


File: recode.info,  Node: dump-with-names,  Prev: count-characters,  Up: Universal

Fully interpreted UCS dump
==========================

   Another device may be used to get fully interpreted dumps of an
`UCS-2' stream of characters, with one `UCS-2' character displayed on a
full output line.  Each line receives the RFC 1345 mnemonic for the
character if it exists, the `UCS-2' value of the character, and a
descriptive comment for that character.  As each input character
produces its own output line, beware that the output file from this
conversion may be much, much bigger than the input file.

   This charset is available in `recode' under the name
`dump-with-names'.

   This `dump-with-names' feature has been implemented as a charset
rather than a surface.  This is surely debatable.  The current
implementation allows for dumping charsets other than `UCS-2'.  For
example, the command `recode l2..full < INPUT' implies a necessary
conversion from `Latin-2' to `UCS-2', as `dump-with-names' is only
connected out from `UCS-2'.  In such cases, `recode' does not display
the original `Latin-2' codes in the dump, only the corresponding
`UCS-2' values.  To give a simpler example, the command

     echo 'Hello, world!' | recode us..dump

produces the following output:

     UCS2   Mne   Description
     
     0048   H     latin capital letter h
     0065   e     latin small letter e
     006C   l     latin small letter l
     006C   l     latin small letter l
     006F   o     latin small letter o
     002C   ,     comma
     0020   SP    space
     0077   w     latin small letter w
     006F   o     latin small letter o
     0072   r     latin small letter r
     006C   l     latin small letter l
     0064   d     latin small letter d
     0021   !     exclamation mark
     000A   LF    line feed (lf)

   The descriptive comment is given in English and `ASCII', yet if the
English description is not available but a French one is, then the
French description is given instead, using `Latin-1'.  However, if the
`LANGUAGE' or `LANG' environment variable begins with the letters `fr',
then listing preference goes to French when both descriptions are
available.

   Here is another example.  To get the long description of the code
237 in Latin-5 table, one may use the following command.

     echo -n 237 | recode l5/d..dump

If your `echo' does not grok `-n', use `echo 237\c' instead.  Here is
how to see what Unicode `U+03C6' means, while getting rid of the title
lines.

     echo -n 0x03C6 | recode u2/x2..dump | tail +3


File: recode.info,  Node: Tabular,  Next: ASCII misc,  Prev: Universal,  Up: Top

Tabular sources (RFC 1345)
**************************

   An important part of the tabular charset knowledge in `recode' comes
from RFC 1345 or, alternatively, from the `chset' tools, both
maintained by Keld Simonsen.  The RFC 1345 document:

     "Character Mnemonics & Character Sets", K. Simonsen, Request for
     Comments no. 1345, Network Working Group, June 1992.

defines many character mnemonics and character sets.  The `recode'
library implements most of RFC 1345, however:

   * It does not recognise those charsets which overload character
     positions: `dk-us' and `us-dk'.  However, see *Note Mixed::.

   * It does not recognise those charsets which combine two characters
     for representing a third: `ANSI_X3.110-1983', `ISO_6937-2-add',
     `T.101-G2', `T.61-8bit', `iso-ir-90' and `videotex-suppl'.

   * It does not recognise 16-bits charsets: `GB_2312-80',
     `JIS_C6226-1978', `JIS_C6226-1983', `JIS_X0212-1990' and
     `KS_C_5601-1987'.

   * It interprets the charset `isoir91' as `NATS-DANO' (alias
     `iso-ir-9-1'), _not_ as `JIS_C6229-1984-a' (alias `iso-ir-91').
     It also interprets the charset `isoir92' as `NATS-DANO-ADD' (alias
     `iso-ir-9-2'), _not_ as `JIS_C6229-1984-b' (alias `iso-ir-92').
     It might be better just avoiding these two alias names.

   Keld Simonsen <keld@dkuug.dk> did most of RFC 1345 himself, with
some funding from Danish Standards and Nordic standards (INSTA) project.
He also did the character set design work, with substantial input from
Olle Jaernefors.  Keld typed in almost all of the tables, some have been
contributed.  A number of people have checked the tables in various
ways.  The RFC lists a number of people who helped.

   Keld and the `recode' maintainer have an arrangement by which any new
discovered information submitted by `recode' users, about tabular
charsets, is forwarded to Keld, eventually merged into Keld's work, and
only then, reimported into `recode'.  Neither the `recode' program nor
its library try to compete, nor even establish themselves as an
alternate or diverging reference: RFC 1345 and its new drafts stay the
genuine source for most tabular information conveyed by `recode'.  Keld
has been more than collaborative so far, so there is no reason that we
act otherwise.  In a word, `recode' should be perceived as the
application of external references, but not as a reference in itself.

   Internally, RFC 1345 associates which each character an unambiguous
mnemonic of a few characters, taken from ISO 646, which is a minimal
ASCII subset of 83 characters.  The charset made up by these mnemonics
is available in `recode' under the name `RFC1345'.  It has `mnemonic'
and `1345' for aliases.  As implemened, this charset exactly
corresponds to `mnemonic+ascii+38', using RFC 1345 nomenclature.
Roughly said, ISO 646 characters represent themselves, except for the
ampersand (`&') which appears doubled.  A prefix of a single ampersand
introduces a mnemonic.  For mnemonics using two characters, the prefix
is immediately by the mnemonic.  For longer mnemonics, the prefix is
followed by an underline (`_'), the mmemonic, and another underline.
Conversions to this charset are usually reversible.

   Currently, `recode' does not offer any of the many other possible
variations of this family of representations.  They will likely be
implemented in some future version, however.

`ANSI_X3.4-1968'
     `367', `ANSI_X3.4-1986', `ASCII', `CP367', `IBM367', `ISO646-US',
     `ISO_646.irv:1991', `US-ASCII', `iso-ir-6' and `us' are aliases
     for this charset.  Source: ISO 2375 registry.

`ASMO_449'
     `ISO_9036', `arabic7' and `iso-ir-89' are aliases for this charset.
     Source: ISO 2375 registry.

`BS_4730'
     `ISO646-GB', `gb', `iso-ir-4' and `uk' are aliases for this
     charset.  Source: ISO 2375 registry.

`BS_viewdata'
     `iso-ir-47' is an alias for this charset.  Source: ISO 2375
     registry.

`CP1250'
     `1250', `ms-ee' and `windows-1250' are aliases for this charset.
     Source: UNICODE 1.0.

`CP1251'
     `1251', `ms-cyrl' and `windows-1251' are aliases for this charset.
     Source: UNICODE 1.0.

`CP1252'
     `1252', `ms-ansi' and `windows-1252' are aliases for this charset.
     Source: UNICODE 1.0.

`CP1253'
     `1253', `ms-greek' and `windows-1253' are aliases for this charset.
     Source: UNICODE 1.0.

`CP1254'
     `1254', `ms-turk' and `windows-1254' are aliases for this charset.
     Source: UNICODE 1.0.

`CP1255'
     `1255', `ms-hebr' and `windows-1255' are aliases for this charset.
     Source: UNICODE 1.0.

`CP1256'
     `1256', `ms-arab' and `windows-1256' are aliases for this charset.
     Source: UNICODE 1.0.

`CP1257'
     `1257', `WinBaltRim' and `windows-1257' are aliases for this
     charset.  Source: CEN/TC304 N283.

`CSA_Z243.4-1985-1'
     `ISO646-CA', `ca', `csa7-1' and `iso-ir-121' are aliases for this
     charset.  Source: ISO 2375 registry.

`CSA_Z243.4-1985-2'
     `ISO646-CA2', `csa7-2' and `iso-ir-122' are aliases for this
     charset.  Source: ISO 2375 registry.

`CSA_Z243.4-1985-gr'
     `iso-ir-123' is an alias for this charset.  Source: ISO 2375
     registry.

`CSN_369103'
     `KOI-8_L2', `iso-ir-139' and `koi8l2' are aliases for this charset.
     Source: ISO 2375 registry.

`CWI'
     `CWI-2' and `cp-hu' are aliases for this charset.  Source:
     Computerworld Sza'mita'stechnika vol 3 issue 13 1988-06-29.

`DEC-MCS'
     `dec' is an alias for this charset.  VAX/VMS User's Manual, Order
     Number: AI-Y517A-TE, April 1986.

`DIN_66003'
     `ISO646-DE', `de' and `iso-ir-21' are aliases for this charset.
     Source: ISO 2375 registry.

`DS_2089'
     `DS2089', `ISO646-DK' and `dk' are aliases for this charset.
     Source: Danish Standard, DS 2089, February 1974.

`EBCDIC-AT-DE'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-AT-DE-A'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-CA-FR'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-DK-NO'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-DK-NO-A'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-ES'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-ES-A'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-ES-S'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-FI-SE'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-FI-SE-A'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-FR'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-IS-FRISS'
     `friss' is an alias for this charset.  Source: Skyrsuvelar
     Rikisins og Reykjavikurborgar, feb 1982.

`EBCDIC-IT'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-PT'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-UK'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`EBCDIC-US'
     Source: IBM 3270 Char Set Ref Ch 10, GA27-2837-9, April 1987.

`ECMA-cyrillic'
     `ECMA-113', `ECMA-113:1986' and `iso-ir-111' are aliases for this
     charset.  Source: ISO 2375 registry.

`ES'
     `ISO646-ES' and `iso-ir-17' are aliases for this charset.  Source:
     ISO 2375 registry.

`ES2'
     `ISO646-ES2' and `iso-ir-85' are aliases for this charset.
     Source: ISO 2375 registry.

`GB_1988-80'
     `ISO646-CN', `cn' and `iso-ir-57' are aliases for this charset.
     Source: ISO 2375 registry.

`GOST_19768-87'
     `ST_SEV_358-88' and `iso-ir-153' are aliases for this charset.
     Source: ISO 2375 registry.

`IBM037'
     `037', `CP037', `ebcdic-cp-ca', `ebcdic-cp-nl', `ebcdic-cp-us' and
     `ebcdic-cp-wt' are aliases for this charset.  Source: IBM NLS RM
     Vol2 SE09-8002-01, March 1990.

`IBM038'
     `038', `CP038' and `EBCDIC-INT' are aliases for this charset.
     Source: IBM 3174 Character Set Ref, GA27-3831-02, March 1990.

`IBM1004'
     `1004', `CP1004' and `os2latin1' are aliases for this charset.
     Source: CEN/TC304 N283, 1994-02-04.

`IBM1026'
     `1026' and `CP1026' are aliases for this charset.  Source: IBM NLS
     RM Vol2 SE09-8002-01, March 1990.

`IBM1047'
     `1047' and `CP1047' are aliases for this charset.  Source: IBM
     Character Data Representation Architecture.  Registry SC09-1391-00
     p 150.

`IBM256'
     `256', `CP256' and `EBCDIC-INT1' are aliases for this charset.
     Source: IBM Registry C-H 3-3220-050.

`IBM273'
     `273' and `CP273' are aliases for this charset.  Source: IBM NLS
     RM Vol2 SE09-8002-01, March 1990.

`IBM274'
     `274', `CP274' and `EBCDIC-BE' are aliases for this charset.
     Source: IBM 3174 Character Set Ref, GA27-3831-02, March 1990.

`IBM275'
     `275', `CP275' and `EBCDIC-BR' are aliases for this charset.
     Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM277'
     `EBCDIC-CP-DK' and `EBCDIC-CP-NO' are aliases for this charset.
     Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM278'
     `278', `CP278', `ebcdic-cp-fi' and `ebcdic-cp-se' are aliases for
     this charset.  Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM280'
     `280', `CP280' and `ebcdic-cp-it' are aliases for this charset.
     Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM281'
     `281', `CP281' and `EBCDIC-JP-E' are aliases for this charset.
     Source: IBM 3174 Character Set Ref, GA27-3831-02, March 1990.

`IBM284'
     `284', `CP284' and `ebcdic-cp-es' are aliases for this charset.
     Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM285'
     `285', `CP285' and `ebcdic-cp-gb' are aliases for this charset.
     Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM290'
     `290', `CP290' and `EBCDIC-JP-kana' are aliases for this charset.
     Source: IBM 3174 Character Set Ref, GA27-3831-02, March 1990.

`IBM297'
     `297', `CP297' and `ebcdic-cp-fr' are aliases for this charset.
     Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM420'
     `420', `CP420' and `ebcdic-cp-ar1' are aliases for this charset.
     Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.  IBM NLS RM p
     11-11.

`IBM423'
     `423', `CP423' and `ebcdic-cp-gr' are aliases for this charset.
     Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM424'
     `424', `CP424' and `ebcdic-cp-he' are aliases for this charset.
     Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM437'
     `437' and `CP437' are aliases for this charset.  Source: IBM NLS
     RM Vol2 SE09-8002-01, March 1990.

`IBM500'
     `500', `500V1', `CP500', `ebcdic-cp-be' and `ebcdic-cp-ch' are
     aliases for this charset.  Source: IBM NLS RM Vol2 SE09-8002-01,
     March 1990.

`IBM850'
     `850' and `CP850' are aliases for this charset.  Source: IBM NLS
     RM Vol2 SE09-8002-01, March 1990.  Source: UNICODE 1.0.

`IBM851'
     `851' and `CP851' are aliases for this charset.  Source: IBM NLS
     RM Vol2 SE09-8002-01, March 1990.

`IBM852'
     `852', `CP852', `pcl2' and `pclatin2' are aliases for this charset.
     Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM855'
     `855' and `CP855' are aliases for this charset.  Source: IBM NLS
     RM Vol2 SE09-8002-01, March 1990.

`IBM857'
     `857' and `CP857' are aliases for this charset.  Source: IBM NLS
     RM Vol2 SE09-8002-01, March 1990.

`IBM860'
     `860' and `CP860' are aliases for this charset.  Source: IBM NLS
     RM Vol2 SE09-8002-01, March 1990.

`IBM861'
     `861', `CP861' and `cp-is' are aliases for this charset.  Source:
     IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM862'
     `862' and `CP862' are aliases for this charset.  Source: IBM NLS
     RM Vol2 SE09-8002-01, March 1990.

`IBM863'
     `863' and `CP863' are aliases for this charset.  Source: IBM
     Keyboard layouts and code pages, PN 07G4586 June 1991.

`IBM864'
     `864' and `CP864' are aliases for this charset.  Source: IBM
     Keyboard layouts and code pages, PN 07G4586 June 1991.

`IBM865'
     `865' and `CP865' are aliases for this charset.  Source: IBM DOS
     3.3 Ref (Abridged), 94X9575 (Feb 1987).

`IBM868'
     `868', `CP868' and `cp-ar' are aliases for this charset.  Source:
     IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM869'
     `869', `CP869' and `cp-gr' are aliases for this charset.  Source:
     IBM Keyboard layouts and code pages, PN 07G4586 June 1991.

`IBM870'
     `870', `CP870', `ebcdic-cp-roece' and `ebcdic-cp-yu' are aliases
     for this charset.  Source: IBM NLS RM Vol2 SE09-8002-01, March
     1990.

`IBM871'
     `871', `CP871' and `ebcdic-cp-is' are aliases for this charset.
     Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM875'
     `875', `CP875' and `EBCDIC-Greek' are aliases for this charset.
     Source: UNICODE 1.0.

`IBM880'
     `880', `CP880' and `EBCDIC-Cyrillic' are aliases for this charset.
     Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IBM891'
     `891' and `CP891' are aliases for this charset.  Source: IBM NLS
     RM Vol2 SE09-8002-01, March 1990.

`IBM903'
     `903' and `CP903' are aliases for this charset.  Source: IBM NLS
     RM Vol2 SE09-8002-01, March 1990.

`IBM904'
     `904' and `CP904' are aliases for this charset.  Source: IBM NLS
     RM Vol2 SE09-8002-01, March 1990.

`IBM905'
     `905', `CP905' and `ebcdic-cp-tr' are aliases for this charset.
     Source: IBM 3174 Character Set Ref, GA27-3831-02, March 1990.

`IBM918'
     `918', `CP918' and `ebcdic-cp-ar2' are aliases for this charset.
     Source: IBM NLS RM Vol2 SE09-8002-01, March 1990.

`IEC_P27-1'
     `iso-ir-143' is an alias for this charset.  Source: ISO 2375
     registry.

`INIS'
     `iso-ir-49' is an alias for this charset.  Source: ISO 2375
     registry.

`INIS-8'
     `iso-ir-50' is an alias for this charset.  Source: ISO 2375
     registry.

`INIS-cyrillic'
     `iso-ir-51' is an alias for this charset.  Source: ISO 2375
     registry.

`INVARIANT'
     `iso-ir-170' is an alias for this charset.

`ISO-8859-1'
     `819', `CP819', `IBM819', `ISO_8859-1', `ISO_8859-1:1987',
     `iso-ir-100', `l1' and `latin1' are aliases for this charset.
     Source: ISO 2375 registry.

`ISO-8859-10'
     `ISO_8859-10', `ISO_8859-10:1993', `iso-ir-157', `l6' and `latin6'
     are aliases for this charset.  Source: ISO 2375 registry.

`ISO-8859-13'
     `ISO_8859-13', `ISO_8859-13:1998', `iso-baltic', `iso-ir-179a',
     `l7' and `latin7' are aliases for this charset.  Source: ISO 2375
     registry.

`ISO-8859-14'
     `ISO_8859-14', `ISO_8859-14:1998', `iso-celtic', `iso-ir-199',
     `l8' and `latin8' are aliases for this charset.  Source: ISO 2375
     registry.

`ISO-8859-15'
     `ISO_8859-15', `ISO_8859-15:1998', `iso-ir-203', `l9' and `latin9'
     are aliases for this charset.  Source: ISO 2375 registry.

`ISO-8859-2'
     `912', `CP912', `IBM912', `ISO_8859-2', `ISO_8859-2:1987',
     `iso-ir-101', `l2' and `latin2' are aliases for this charset.
     Source: ISO 2375 registry.

`ISO-8859-3'
     `ISO_8859-3', `ISO_8859-3:1988', `iso-ir-109', `l3' and `latin3'
     are aliases for this charset.  Source: ISO 2375 registry.

`ISO-8859-4'
     `ISO_8859-4', `ISO_8859-4:1988', `iso-ir-110', `l4' and `latin4'
     are aliases for this charset.  Source: ISO 2375 registry.

`ISO-8859-5'
     `ISO_8859-5', `ISO_8859-5:1988', `cyrillic' and `iso-ir-144' are
     aliases for this charset.  Source: ISO 2375 registry.

`ISO-8859-6'
     `ASMO-708', `ECMA-114', `ISO_8859-6', `ISO_8859-6:1987', `arabic'
     and `iso-ir-127' are aliases for this charset.  Source: ISO 2375
     registry.

`ISO-8859-7'
     `ECMA-118', `ELOT_928', `ISO_8859-7', `ISO_8859-7:1987', `greek',
     `greek8' and `iso-ir-126' are aliases for this charset.  Source:
     ISO 2375 registry.

`ISO-8859-8'
     `ISO_8859-8', `ISO_8859-8:1988', `hebrew' and `iso-ir-138' are
     aliases for this charset.  Source: ISO 2375 registry.

`ISO-8859-9'
     `ISO_8859-9', `ISO_8859-9:1989', `iso-ir-148', `l5' and `latin5'
     are aliases for this charset.  Source: ISO 2375 registry.

`ISO_10367-box'
     `iso-ir-155' is an alias for this charset.  Source: ISO 2375
     registry.

`ISO_2033-1983'
     `e13b' and `iso-ir-98' are aliases for this charset.  Source: ISO
     2375 registry.

`ISO_5427'
     `iso-ir-37' is an alias for this charset.  Source: ISO 2375
     registry.

`ISO_5427-ext'
     `ISO_5427:1981' and `iso-ir-54' are aliases for this charset.
     Source: ISO 2375 registry.

`ISO_5428'
     `ISO_5428:1980' and `iso-ir-55' are aliases for this charset.
     Source: ISO 2375 registry.

`ISO_646.basic'
     `ISO_646.basic:1983' and `ref' are aliases for this charset.
     Source: ISO 2375 registry.

`ISO_646.irv'
     `ISO_646.irv:1983', `irv' and `iso-ir-2' are aliases for this
     charset.  Source: ISO 2375 registry.

`ISO_6937-2-25'
     `iso-ir-152' is an alias for this charset.  Source: ISO 2375
     registry.

`ISO_8859-supp'
     `iso-ir-154' and `latin1-2-5' are aliases for this charset.
     Source: ISO 2375 registry.

`IT'
     `ISO646-IT' and `iso-ir-15' are aliases for this charset.  Source:
     ISO 2375 registry.

`JIS_C6220-1969-jp'
     `JIS_C6220-1969', `iso-ir-13', `katakana' and `x0201-7' are
     aliases for this charset.  Source: ISO 2375 registry.

`JIS_C6220-1969-ro'
     `ISO646-JP', `iso-ir-14' and `jp' are aliases for this charset.
     Source: ISO 2375 registry.

`JIS_C6229-1984-a'
     `jp-ocr-a' is an alias for this charset.  Source: ISO 2375
     registry.

`JIS_C6229-1984-b'
     `ISO646-JP-OCR-B' and `jp-ocr-b' are aliases for this charset.
     Source: ISO 2375 registry.

`JIS_C6229-1984-b-add'
     `iso-ir-93' and `jp-ocr-b-add' are aliases for this charset.
     Source: ISO 2375 registry.

`JIS_C6229-1984-hand'
     `iso-ir-94' and `jp-ocr-hand' are aliases for this charset.
     Source: ISO 2375 registry.

`JIS_C6229-1984-hand-add'
     `iso-ir-95' and `jp-ocr-hand-add' are aliases for this charset.
     Source: ISO 2375 registry.

`JIS_C6229-1984-kana'
     `iso-ir-96' is an alias for this charset.  Source: ISO 2375
     registry.

`JIS_X0201'
     `X0201' is an alias for this charset.

`JUS_I.B1.002'
     `ISO646-YU', `iso-ir-141', `js' and `yu' are aliases for this
     charset.  Source: ISO 2375 registry.

`JUS_I.B1.003-mac'
     `iso-ir-147' and `macedonian' are aliases for this charset.
     Source: ISO 2375 registry.

`JUS_I.B1.003-serb'
     `iso-ir-146' and `serbian' are aliases for this charset.  Source:
     ISO 2375 registry.

`KOI-7'
     Source: Andrey A. Chernov <ache@nagual.pp.ru>.

`KOI-8'
     `GOST_19768-74' is an alias for this charset.  Source: Andrey A.
     Chernov <ache@nagual.pp.ru>.

`KOI8-R'
     Source: RFC1489 via Gabor Kiss <kissg@sztaki.hu>.  And Andrey A.
     Chernov <ache@nagual.pp.ru>.

`KOI8-RU'
     Source: http://cad.ntu-kpi.kiev.ua/multiling/koi8-ru/.

`KOI8-U'
     Source: RFC 2319.  Mibenum: 2088.  Source:
     http://www.net.ua/KOI8-U/.

`KSC5636'
     `ISO646-KR' is an alias for this charset.

`Latin-greek-1'
     `iso-ir-27' is an alias for this charset.  Source: ISO 2375
     registry.

`MSZ_7795.3'
     `ISO646-HU', `hu' and `iso-ir-86' are aliases for this charset.
     Source: ISO 2375 registry.

`NATS-DANO'
     `iso-ir-9-1' is an alias for this charset.  Source: ISO 2375
     registry.

`NATS-DANO-ADD'
     `iso-ir-9-2' is an alias for this charset.  Source: ISO 2375
     registry.

`NATS-SEFI'
     `iso-ir-8-1' is an alias for this charset.  Source: ISO 2375
     registry.

`NATS-SEFI-ADD'
     `iso-ir-8-2' is an alias for this charset.  Source: ISO 2375
     registry.

`NC_NC00-10'
     `ISO646-CU', `NC_NC00-10:81', `cuba' and `iso-ir-151' are aliases
     for this charset.  Source: ISO 2375 registry.

`NF_Z_62-010'
     `ISO646-FR', `fr' and `iso-ir-69' are aliases for this charset.
     Source: ISO 2375 registry.

`NF_Z_62-010_(1973)'
     `ISO646-FR1' and `iso-ir-25' are aliases for this charset.
     Source: ISO 2375 registry.

`NS_4551-1'
     `ISO646-NO', `iso-ir-60' and `no' are aliases for this charset.
     Source: ISO 2375 registry.

`NS_4551-2'
     `ISO646-NO2', `iso-ir-61' and `no2' are aliases for this charset.
     Source: ISO 2375 registry.

`NeXTSTEP'
     `next' is an alias for this charset.  Source: Peter Svanberg -
     psv@nada.kth.se.

`PT'
     `ISO646-PT' and `iso-ir-16' are aliases for this charset.  Source:
     ISO 2375 registry.

`PT2'
     `ISO646-PT2' and `iso-ir-84' are aliases for this charset.
     Source: ISO 2375 registry.

`SEN_850200_B'
     `FI', `ISO646-FI', `ISO646-SE', `SS636127', `iso-ir-10' and `se'
     are aliases for this charset.  Source: ISO 2375 registry.

`SEN_850200_C'
     `ISO646-SE2', `iso-ir-11' and `se2' are aliases for this charset.
     Source: ISO 2375 registry.

`T.61-7bit'
     `iso-ir-102' is an alias for this charset.  Source: ISO 2375
     registry.

`baltic'
     `iso-ir-179' is an alias for this charset.  Source: ISO 2375
     registry.  &g1esc x2d56 &g2esc x2e56 &g3esc x2f56.

`greek-ccitt'
     `iso-ir-150' is an alias for this charset.  Source: ISO 2375
     registry.

`greek7'
     `iso-ir-88' is an alias for this charset.  Source: ISO 2375
     registry.

`greek7-old'
     `iso-ir-18' is an alias for this charset.  Source: ISO 2375
     registry.

`hp-roman8'
     `r8' and `roman8' are aliases for this charset.  Source: LaserJet
     IIP Printer User's Manual,.  HP part no 33471-90901,
     Hewlet-Packard, June 1989.

`latin-greek'
     `iso-ir-19' is an alias for this charset.  Source: ISO 2375
     registry.

`mac-is'

`macintosh'
     `mac' is an alias for this charset.  Source: The Unicode Standard
     ver 1.0, ISBN 0-201-56788-1, Oct 1991.

`macintosh_ce'
     `macce' is an alias for this charset.  Source: Macintosh CE fonts.

`sami'
     `iso-ir-158', `lap' and `latin-lap' are aliases for this charset.
     Source: ISO 2375 registry.


File: recode.info,  Node: ASCII misc,  Next: IBM and MS,  Prev: Tabular,  Up: Top

ASCII and some derivatives
**************************

* Menu:

* ASCII::               Usual ASCII
* ISO 8859::            ASCII extended by Latin Alphabets
* ASCII-BS::            ASCII 7-bits, BS to overstrike
* flat::                ASCII without diacritics nor underline


File: recode.info,  Node: ASCII,  Next: ISO 8859,  Prev: ASCII misc,  Up: ASCII misc

Usual ASCII
===========

   This charset is available in `recode' under the name `ASCII'.  In
fact, it's true name is `ANSI_X3.4-1968' as per RFC 1345, accepted
aliases being `ANSI_X3.4-1986', `ASCII', `IBM367', `ISO646-US',
`ISO_646.irv:1991', `US-ASCII', `cp367', `iso-ir-6' and `us'.  The
shortest way of specifying it in `recode' is `us'.

   This documentation used to include ASCII tables.  They have been
removed since the `recode' program can now recreate these easily:

     recode -lf us                   for commented ASCII
     recode -ld us                   for concise decimal table
     recode -lo us                   for concise octal table
     recode -lh us                   for concise hexadecimal table


File: recode.info,  Node: ISO 8859,  Next: ASCII-BS,  Prev: ASCII,  Up: ASCII misc

ASCII extended by Latin Alphabets
=================================

   There are many Latin charsets.  The following has been written by Tim
Lasko <lasko@video.dec.com>, a long while ago:

     ISO Latin-1, or more completely ISO Latin Alphabet No 1, is now an
     international standard as of February 1987 (IS 8859, Part 1).  For
     those American USEnet'rs that care, the 8-bit ASCII standard, which
     is essentially the same code, is going through the final
     administrative processes prior to publication.  ISO Latin-1 (IS
     8859/1) is actually one of an entire family of eight-bit one-byte
     character sets, all having ASCII on the left hand side, and with
     varying repertoires on the right hand side:

        * Latin Alphabet No 1 (caters to Western Europe - now approved).

        * Latin Alphabet No 2 (caters to Eastern Europe - now approved).

        * Latin Alphabet No 3 (caters to SE Europe + others - in draft
          ballot).

        * Latin Alphabet No 4 (caters to Northern Europe - in draft
          ballot).

        * Latin-Cyrillic alphabet (right half all Cyrillic - processing
          currently suspended pending USSR input).

        * Latin-Arabic alphabet (right half all Arabic - now approved).

        * Latin-Greek alphabet (right half Greek + symbols - in draft
          ballot).

        * Latin-Hebrew alphabet (right half Hebrew + symbols -
          proposed).

   The ISO Latin Alphabet 1 is available as a charset in `recode' under
the name `Latin-1'.  In fact, it's true name is `ISO_8859-1:1987' as
per RFC 1345, accepted aliases being `CP819', `IBM819', `ISO-8859-1',
`ISO_8859-1', `iso-ir-100', `l1' and `Latin-1'.  The shortest way of
specifying it in `recode' is `l1'.

   It is an eight-bit code which coincides with ASCII for the lower
half.  This documentation used to include Latin-1 tables.  They have
been removed since the `recode' program can now recreate these easily:

     recode -lf l1                   for commented ISO Latin-1
     recode -ld l1                   for concise decimal table
     recode -lo l1                   for concise octal table
     recode -lh l1                   for concise hexadecimal table


File: recode.info,  Node: ASCII-BS,  Next: flat,  Prev: ISO 8859,  Up: ASCII misc

ASCII 7-bits, `BS' to overstrike
================================

   This charset is available in `recode' under the name `ASCII-BS',
with `BS' as an acceptable alias.

   The file is straight ASCII, seven bits only.  According to the
definition of ASCII, diacritics are applied by a sequence of three
characters: the letter, one `BS', the diacritic mark.  We deviate
slightly from this by exchanging the diacritic mark and the letter so,
on a screen device, the diacritic will disappear and let the letter
alone.  At recognition time, both methods are acceptable.

   The French quotes are coded by the sequences: `< BS "' or `" BS <'
for the opening quote and `> BS "' or `" BS >' for the closing quote.
This artificial convention was inherited in straight `ASCII-BS' from
habits around `Bang-Bang' entry, and is not well known.  But we decided
to stick to it so that `ASCII-BS' charset will not lose French quotes.

   The `ASCII-BS' charset is independent of `ASCII', and different.
The following examples demonstrate this, knowing at advance that `!2'
is the `Bang-Bang' way of representing an `e' with an acute accent.
Compare:

     % echo \!2 | recode -v bang..l1/d
     Request: Bang-Bang..ISO-8859-1/Decimal-1
     233,  10

with:

     % echo \!2 | recode -v bang..bs/d
     Request: Bang-Bang..ISO-8859-1..ASCII-BS/Decimal-1
      39,   8, 101,  10

   In the first case, the `e' with an acute accent is merely
transmitted by the `Latin-1..ASCII' mapping, not having a special
recoding rule for it.  In the `Latin-1..ASCII-BS' case, the acute
accent is applied over the `e' with a backspace: diacriticised
characters have special rules.  For the `ASCII-BS' charset,
reversibility is still possible, but there might be difficult cases.


File: recode.info,  Node: flat,  Prev: ASCII-BS,  Up: ASCII misc

ASCII without diacritics nor underline
======================================

   This charset is available in `recode' under the name `flat'.

   This code is ASCII expunged of all diacritics and underlines, as
long as they are applied using three character sequences, with `BS' in
the middle.  Also, despite slightly unrelated, each control character is
represented by a sequence of two or three graphic characters.  The
newline character, however, keeps its functionality and is not
represented.

   Note that charset `flat' is a terminal charset.  We can convert _to_
`flat', but not _from_ it.


File: recode.info,  Node: IBM and MS,  Next: CDC,  Prev: ASCII misc,  Up: Top

Some IBM or Microsoft charsets
******************************

   The `recode' program provides various IBM or Microsoft code pages
(*note Tabular::).  An easy way to find them all at once out of the
`recode' program itself is through the command:

     recode -l | egrep -i '(CP|IBM)[0-9]'

But also, see few special charsets presented in the incoming sections.

* Menu:

* EBCDIC::              EBCDIC codes
* IBM-PC::              IBM's PC code
* Icon-QNX::            Unisys' Icon code


File: recode.info,  Node: EBCDIC,  Next: IBM-PC,  Prev: IBM and MS,  Up: IBM and MS

EBCDIC code
===========

   This charset is the IBM's External Binary Coded Decimal for
Interchange Coding.  This is an eight bits code.  The following three
variants were implemented in `recode' independently of RFC 1345:

`EBCDIC'
     In `recode', the `us..ebcdic' conversion is identical to `dd
     conv=ebcdic' conversion, and `recode' `ebcdic..us' conversion is
     identical to `dd conv=ascii' conversion.  This charset also
     represents the way Control Data Corporation relates EBCDIC to
     8-bits ASCII.

`EBCDIC-CCC'
     In `recode', the `us..ebcdic-ccc' or `ebcdic-ccc..us' conversions
     represent the way Concurrent Computer Corporation (formerly Perkin
     Elmer) relates EBCDIC to 8-bits ASCII.

`EBCDIC-IBM'
     In `recode', the `us..ebcdic-ibm' conversion is _almost_ identical
     to the GNU `dd conv=ibm' conversion.  Given the exact `dd
     conv=ibm' conversion table, `recode' once said:

          Codes  91 and 213 both recode to 173
          Codes  93 and 229 both recode to 189
          No character recodes to  74
          No character recodes to 106

     So I arbitrarily chose to recode 213 by 74 and 229 by 106.  This
     makes the `EBCDIC-IBM' recoding reversible, but this is not
     necessarily the best correction.  In any case, I think that GNU
     `dd' should be amended.  `dd' and `recode' should ideally agree on
     the same correction.  So, this table might change once again.

   RFC 1345 brings into `recode' 15 other EBCDIC charsets, and 21 other
charsets having EBCDIC in at least one of their alias names.  You can
get a list of all these by executing:

     recode -l | grep -i ebcdic

   Note that `recode' may convert a pure stream of EBCDIC characters,
but it does not know how to handle binary data between records which is
sometimes used to delimit them and build physical blocks.  If end of
lines are not marked, fixed record size may produce something readable,
but `VB' or `VBS' blocking is likely to yield some garbage in the
converted results.


File: recode.info,  Node: IBM-PC,  Next: Icon-QNX,  Prev: EBCDIC,  Up: IBM and MS

IBM's PC code
=============

   This charset is available in `recode' under the name `IBM-PC', with
`dos', `MSDOS' and `pc' as acceptable aliases.  The shortest way of
specifying it in `recode' is `pc'.

   The charset is aimed towards a PC microcomputer from IBM or any
compatible.  This is an eight-bit code.  This charset is fairly old in
`recode', its tables were produced a long while ago by mere inspection
of a printed chart of the IBM-PC codes and glyph.

   It has `CR-LF' as its implied surface.  This means that, if the
original end of lines have to be preserved while going out of `IBM-PC',
they should currently be added back through the usage of a surface on
the other charset, or better, just never removed.  Here are examples
for both cases:

     recode pc..l2/cl < INPUT > OUTPUT
     recode pc/..l2 < INPUT > OUTPUT

   RFC 1345 brings into `recode' 44 `IBM' charsets or code pages, and
also 8 other code pages.  You can get a list of these all these by
executing:(1)

     recode -l | egrep -i '(CP|IBM)[0-9]'

All charset or aliases beginning with letters `CP' or `IBM' also have
`CR-LF' as their implied surface.  The same is true for a purely
numeric alias in the same family.  For example, all of `819', `CP819'
and `IBM819' imply `CR-LF' as a surface.  Note that `ISO-8859-1' does
_not_ imply a surface, despite it shares the same tabular data as `819'.

   There are a few discrepancies between this `IBM-PC' charset and the
very similar RFC 1345 charset `ibm437', which have not been analysed
yet, so the charsets are being kept separate for now.  This might
change in the future, and the `IBM-PC' charset might disappear.
Wizards would be interested in comparing the output of these two
commands:

     recode -vh IBM-PC..Latin-1
     recode -vh IBM437..Latin-1

The first command uses the charset prior to RFC 1345 introduction.
Both methods give different recodings.  These differences are annoying,
the fuzziness will have to be explained and settle down one day.

   ---------- Footnotes ----------

   (1) On DOS/Windows, stock shells do not know that apostrophes quote
special characters like `|', so one need to use double quotes instead
of apostrophes.


File: recode.info,  Node: Icon-QNX,  Prev: IBM-PC,  Up: IBM and MS

Unisys' Icon code
=================

   This charset is available in `recode' under the name `Icon-QNX',
with `QNX' as an acceptable alias.

   The file is using Unisys' Icon way to represent diacritics with code
25 escape sequences, under the system QNX.  This is a seven-bit code,
even if eight-bit codes can flow through as part of IBM-PC charset.


File: recode.info,  Node: CDC,  Next: Micros,  Prev: IBM and MS,  Up: Top

Charsets for CDC machines
*************************

   What is now `recode' evolved out, through many transformations
really, from a set of programs which were originally written in
"COMPASS", Control Data Corporation's assembler, with bits in FORTRAN,
and later rewritten in CDC 6000 Pascal.  The CDC heritage shows by the
fact some old CDC charsets are still supported.

   The `recode' author used to be familiar with CDC Scope-NOS/BE and
Kronos-NOS, and many CDC formats.  Reading CDC tapes directly on other
machines is often a challenge, and `recode' does not always solve it.
It helps having tapes created in coded mode instead of binary mode, and
using `S' (Stranger) tapes instead of `I' (Internal) tapes.  ANSI
labels and multi-file tapes might be the source of trouble.  There are
ways to handle a few Cyber Record Manager formats, but some of them
might be quite difficult to decode properly after the transfer is done.

   The `recode' program is usable only for a small subset of NOS text
formats, and surely not with binary textual formats, like `UPDATE' or
`MODIFY' sources, for example.  `recode' is not especially suited for
reading 8/12 or 56/60 packing, yet this could easily arranged if there
was a demand for it.  It does not have the ability to translate Display
Code directly, as the ASCII conversion implied by tape drivers or FTP
does the initial approximation.  `recode' can decode 6/12 caret
notation over Display Code already mapped to ASCII.

* Menu:

* Display Code::        Control Data's Display Code
* CDC-NOS::             ASCII 6/12 from NOS
* Bang-Bang::           ASCII ``bang bang''


File: recode.info,  Node: Display Code,  Next: CDC-NOS,  Prev: CDC,  Up: CDC

Control Data's Display Code
===========================

   This code is not available in `recode', but repeated here for
reference.  This is a 6-bit code used on CDC mainframes.

     Octal display code to graphic       Octal display code to octal ASCII
     
     00  :    20  P    40  5   60  #     00 072  20 120  40 065  60 043
     01  A    21  Q    41  6   61  [     01 101  21 121  41 066  61 133
     02  B    22  R    42  7   62  ]     02 102  22 122  42 067  62 135
     03  C    23  S    43  8   63  %     03 103  23 123  43 070  63 045
     04  D    24  T    44  9   64  "     04 104  24 124  44 071  64 042
     05  E    25  U    45  +   65  _     05 105  25 125  45 053  65 137
     06  F    26  V    46  -   66  !     06 106  26 126  46 055  66 041
     07  G    27  W    47  *   67  &     07 107  27 127  47 052  67 046
     10  H    30  X    50  /   70  '     10 110  30 130  50 057  70 047
     11  I    31  Y    51  (   71  ?     11 111  31 131  51 050  71 077
     12  J    32  Z    52  )   72  <     12 112  32 132  52 051  72 074
     13  K    33  0    53  $   73  >     13 113  33 060  53 044  73 076
     14  L    34  1    54  =   74  @     14 114  34 061  54 075  74 100
     15  M    35  2    55      75  \     15 115  35 062  55 040  75 134
     16  N    36  3    56  ,   76  ^     16 116  36 063  56 054  76 136
     17  O    37  4    57  .   77  ;     17 117  37 064  57 056  77 073

   In older times, `:' used octal 63, and octal 0 was not a character.
The table above shows the ASCII glyph interpretation of codes 60 to 77,
yet these 16 codes were once defined differently.

   There is no explicit end of line in Display Code, and the Cyber
Record Manager introduced many new ways to represent them, the
traditional end of lines being reachable by setting `RT' to `Z'.  If
6-bit bytes in a file are sequentially counted from 1, a traditional
end of line does exist if bytes 10*N+9 and 10N+10 are both zero for a
given N, in which case these two bytes are not to be interpreted as
`::'.  Also, up to 9 immediately preceeding zero bytes, going backward,
are to be considered as part of the end of line and not interpreted as
`:'(1).

   ---------- Footnotes ----------

   (1) This convention replaced an older one saying that up to 4
immediately preceeding _pairs_ of zero bytes, going backward, are to be
considered as part of the end of line and not interpreted as `::'.


File: recode.info,  Node: CDC-NOS,  Next: Bang-Bang,  Prev: Display Code,  Up: CDC

ASCII 6/12 from NOS
===================

   This charset is available in `recode' under the name `CDC-NOS', with
`NOS' as an acceptable alias.

   This is one of the charsets in use on CDC Cyber NOS systems to
represent ASCII, sometimes named "NOS 6/12" code for coding ASCII.
This code is also known as "caret ASCII".  It is based on a six bits
character set in which small letters and control characters are coded
using a `^' escape and, sometimes, a `@' escape.

   The routines given here presume that the six bits code is already
expressed in ASCII by the communication channel, with embedded ASCII
`^' and `@' escapes.

   Here is a table showing which characters are being used to encode
each ASCII character.

     000  ^5  020  ^#  040     060  0  100 @A  120  P  140  @G  160  ^P
     001  ^6  021  ^[  041  !  061  1  101  A  121  Q  141  ^A  161  ^Q
     002  ^7  022  ^]  042  "  062  2  102  B  122  R  142  ^B  162  ^R
     003  ^8  023  ^%  043  #  063  3  103  C  123  S  143  ^C  163  ^S
     004  ^9  024  ^"  044  $  064  4  104  D  124  T  144  ^D  164  ^T
     005  ^+  025  ^_  045  %  065  5  105  E  125  U  145  ^E  165  ^U
     006  ^-  026  ^!  046  &  066  6  106  F  126  V  146  ^F  166  ^V
     007  ^*  027  ^&  047  '  067  7  107  G  127  W  147  ^G  167  ^W
     010  ^/  030  ^'  050  (  070  8  110  H  130  X  150  ^H  170  ^X
     011  ^(  031  ^?  051  )  071  9  111  I  131  Y  151  ^I  171  ^Y
     012  ^)  032  ^<  052  *  072 @D  112  J  132  Z  152  ^J  172  ^Z
     013  ^$  033  ^>  053  +  073  ;  113  K  133  [  153  ^K  173  ^0
     014  ^=  034  ^@  054  ,  074  <  114  L  134  \  154  ^L  174  ^1
     015  ^   035  ^\  055  -  075  =  115  M  135  ]  155  ^M  175  ^2
     016  ^,  036  ^^  056  .  076  >  116  N  136 @B  156  ^N  176  ^3
     017  ^.  037  ^;  057  /  077  ?  117  O  137  _  157  ^O  177  ^4

