/******************************************************************/
/*                  libjpeg for Allegro                           */
/*                  by Eric Vannier                               */
/*                                                                */
/*   sample.c : example program                                   */
/*    Version : 1.03                                              */
/*    Date    : 02/03/98                                          */
/*                                                                */
/*   If you need some information read the readme.1st             */
/*                                                                */
/******************************************************************/


#include <stdio.h>
#include <conio.h>

#include <allegro.h>
#include <jpeg.h>

/* prints a little which explains the commandline */
void print_usage(void);

int main(int argc, char **argv)
{
int i, j, options;
int depth=16;
int videox=640, videoy=480;
BITMAP *bmp;
PALETTE pal;
jpeg_decode_param jpeg;

/* commandline parsing */
j=argc;
for (i=1;i<argc;i++)
    {
    if (argv[i][0]=='-')
       {
       if (argv[i][1]=='d')
          {
          depth=atoi(&argv[i][2]);
          j--;
          }
       if (argv[i][1]=='v')
          {
          videox=atoi(&argv[i][2]);
          j--;
          }
       if (argv[i][1]=='h')
          {
          print_usage();
          exit(0);
          }
       }
    }
if (j!=1)
   {
   print_usage();
   exit(0);
   }

/* checks the value of the color_depth */
switch (depth)
       {
       case 8:
       case 15:
       case 16:
       case 24:
       case 32:
            allegro_init();
            set_color_depth(depth);
            break;
       default:
               printf("Color depth %d is not valid\n", depth);
               printf("Must be one of the following : 8 15 16 24 32\n");
               exit(1);
       }

/* checks the value of the video mode */
switch (videox)
       {
       case 320:
            videoy=200;
            break;
       case 640:
            videoy=480;
            break;
       case 800:
            videoy=600;
            break;
       case 1024:
            videoy=768;
            break;
       case 1280:
            videoy=1024;
            break;
       default:
            printf("Videox value %d is not valid\n", videox);
            printf("Video mode must be in the following : 320 640 800 1024 1280\n");
            exit(2);
       }
/* sets the video mode */
if (set_gfx_mode(GFX_AUTODETECT, videox, videoy, 0, 0)<0)
   {
   printf("Mode %dx%dx%d cannot be initialized\n",videox,videoy,depth);
   exit(3);
   }

/* loads the image in a conventionnal way           */
/* we read it from a dat file, but you can specify  */
/* a classic jpeg file as an argument               */
/* Use the grabber from Allegro if you want to see  */
/* how it is done                                   */
bmp=load_jpeg("sample.dat#FRACTAL",pal);

/* checks if an error occured while reading         */
/* the file                                         */
if (bmp==NULL)
   {
   set_gfx_mode(GFX_TEXT,80,25,0,0);
   printf("Cannot open sample.dat : file missing or data corrupted\n");
   exit(2);
   }
/* uses the palette returned by the function        */
/* if we are using some palette mode (8 bits)       */
if (depth==8)
   {
   set_palette(pal);
   }
/* blits the image on the screen                    */
blit(bmp,screen,0,0,0,0,bmp->w,bmp->h);

/* frees some memory                                */
destroy_bitmap(bmp);


getch();


/* loads the same image but using different options */
jpeg.color_type=CT_GRAYSCALE; /* greyscale output   */
jpeg.scale_factor=2;          /* smaller size       */
jpeg.decoding_speed=DS_FAST;  /* fastest method     */
                              /* less accurate      */
/* the two arguments nbr_colors and first_color are */
/* not used, since we are doing some grayscale      */
/* using the standard palette                       */

bmp=load_jpeg_ex("sample.dat#FRACTAL",pal,&jpeg);
if (bmp==NULL)
   {
   set_gfx_mode(GFX_TEXT,80,25,0,0);
   printf("Cannot open sample.dat : file missing or data corrupted\n");
   exit(2);
   }

if (depth==8)
   {
   set_palette(pal);
   }

/* displays the image : tiles it on the screen      */
for (i=0;i<videox;i+=bmp->w)
    {
    for (j=0;j<videoy;j+=bmp->h)
        {
        blit(bmp,screen,0,0,i,j,bmp->w,bmp->h);
        }
    }

destroy_bitmap(bmp);


getch();

exit(0);
}


void print_usage(void)
{
printf("Usage :\n");
printf("sample [-vn] [-dm] [-h]\n");
printf("-vn : selects the video mode\n");
printf("\tWhere n must be :\n");
printf("\t320  : 320x200   mode\n");
printf("\t640  : 640x480   mode (default)\n");
printf("\t800  : 800x600   mode\n");
printf("\t1024 : 1024x768  mode\n");
printf("\t1280 : 1280x1024 mode\n");
printf("-dm : selects the color depth\n");
printf("\tWhere m must be 8, 15, 16 (default), 24 or 32\n");
printf("-h : prints this message\n");
}
