/* Jan 30th 2001
 * Example program of M3D requires WIP .34 or later
 *
 * Tom St Denis
 */
#include <stdio.h>
#include <stdlib.h>
#define USE_CONSOLE
#include "m3d.h"

#define WIDTH   400
#define HEIGHT  300

volatile long tick=0;

void ticker(void) { ++tick; }
END_OF_FUNCTION(ticker);

int main(void)
{
    obj *o;
    MATRIX_f camera;
    light dalight, dalight2, dalight3;
    BITMAP *backbuffer;
    PALETTE pal;
    static int depths[] = { 32, 24, 16, 15, 8 };
    int curdepth;
    float x, y;
    int i, ii;

    srand(time(NULL));
    allegro_init();
    install_keyboard();
    install_timer();
    install_mouse();
    LOCK_VARIABLE(tick);
    LOCK_FUNCTION(ticker);
    install_int(&ticker, MSEC_TO_TIMER(1));

    for (curdepth = 0; curdepth < 5; curdepth++) {
        set_color_depth(depths[curdepth]);
        if (set_gfx_mode(GFX_AUTODETECT, WIDTH, HEIGHT, 0, 0) == 0)
            break; }
    if (curdepth == 5) {
        printf("No suitable %d by %d modes available dude.\n", WIDTH, HEIGHT);
        return -1; }

    /* You must set the blender if you use 8/15/16 bit color depths or
     * the zbuffered rasterizers.  This call will set it to a default of
     * no additional blending */
    set_trans_blender(0,0,0,128);

    /* setup back buffer */
    backbuffer = create_bitmap(WIDTH, HEIGHT);

    /* setup viewport */
    set_projection_viewport(0, 0, WIDTH, HEIGHT);

    /* move the clip distance to 250 units */
    clipdist = 250.0;

    /* setup light (at 0,0,0) pointing inwards */
    memset(&dalight, 0, sizeof(light));
    dalight.intensity = 1;
    dalight.fadedist = 3;
    dalight.flags |= LIGHT_FADE;
    dalight.falloff = 2; 

    /* load object */
    o = m3d_LoadVTX("plane.vtx");
    m3d_ChangeShading(o, POLYTYPE_ATEX_LIT); // | POLYTYPE_ZBUF);
    m3d_ApplyTexture(o, load_bitmap("shade.pcx", NULL));
    m3d_StretchObj(o, 3, 3, 1);
    m3d_FlipNormals(o);
    o->Zp += 2;
    o->Xa = 90;

    /* setup 8bpp palette */
    if (depths[curdepth] == 8) {
        m3d_MakePalInit();
        m3d_MakePalObj(o, 32);
        m3d_MakePal();
    }

    /* draw loop */
    while (!keypressed() && (sframes < 15000)) {
        /* rotate camera */
        get_camera_matrix_f(&camera,
                            0,-2,0, //cos(++x/30),0,sin(++y/30),      /* location 0,0,0 */
                            0,.25,.25,      /* facing 0,0,0 */
                            0,-1,0,     /* up */
                            45,         /* fov */
                            1.0);       /* aspect */

        poll_mouse();
        if (mouse_b & 1) {
            o->Ya += 3 * ((float)mouse_x - (WIDTH / 2)) / (WIDTH / 2);
            o->Xa -= 3 * ((float)mouse_y - (HEIGHT / 2)) / (HEIGHT / 2);
        }
        dalight.Xp = 3 * (((float)mouse_x - (WIDTH / 2)) / (WIDTH / 2));
        dalight.Yp = 3 * (((float)mouse_y - (HEIGHT / 2)) / (HEIGHT / 2));

        /* start */
        clear(backbuffer);
        m3d_Begin(backbuffer, &camera);

        /* Render Light */
        m3d_RenderLight(&dalight);

        /* render the object */
        m3d_RenderObj(o);

        /* draw all objects (1 == zbuffered, 0 = sort) */
        m3d_Draw(0);

        /* blit em to the screen */
        vsync();
        show_mouse(NULL);
        blit(backbuffer, screen, 0, 0, 0, 0, WIDTH, HEIGHT);
        textprintf(screen, font, 8, 8, makecol(255,255,255), "X == %f, Y == %f", dalight.Xp, dalight.Yp);
        show_mouse(screen);
    }
    save_bitmap("m3d.pcx", backbuffer, m3dpal);
    clear_keybuf();
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    printf("Mode: %d by %d @ %d bpp\n", WIDTH, HEIGHT, depths[curdepth]);
    printf("Avg faces per frame: %f\n", sfaces/sframes);
    printf("Avg fps: %f\n", sframes/(float)tick);

    /* clean up */
    destroy_bitmap(backbuffer);
    m3d_DeleteObj(o);

    return 0;
}

END_OF_MAIN();
