/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include "bccgrx00.h"

/* The following io routines were taken from Csaba Biegl's
   GRX v2.0  source. Many thanks Csaba ! */
#define __INLINE_LOW_PORT_TEST__(P)  (                  \
    (__builtin_constant_p((P))) &&                      \
    ((unsigned)(P) < 0x100U)                            \
)
#define inportb(P) ({                                   \
    register unsigned char _value;                      \
    if(__INLINE_LOW_PORT_TEST__(P)) __asm__ volatile(   \
	"inb %1,%0"                                     \
	: "=a"  (_value)                                \
	: "n"   ((unsigned short)(P))                   \
    );                                                  \
    else __asm__ volatile(                              \
	"inb %1,%0"                                     \
	: "=a"  (_value)                                \
	: "d"   ((unsigned short)(P))                   \
    );                                                  \
    _value;                                             \
})

#define outportb(p,v) ({                                \
    __asm__ volatile(                                   \
	"outb %0,%1"                                    \
	: /* no outputs */                              \
	: "a" ((unsigned char)(v)),                     \
	  "d" ((unsigned short)(p))                     \
    );                                                  \
})

static volatile int dummy;

#define WAIT() do {               \
  dummy += inportb(0x80);         \
} while(0)

void __getrgbpalette(int color, int *red, int *green, int *blue) {
#ifdef GO32
  _DO_INIT_CHECK;
  WAIT();
  outportb(0x3c8, color&0xff);
  WAIT();
  *red = inportb(0x3c9)<<2;
  WAIT();
  *green = inportb(0x3c9)<<2;
  WAIT();
  *blue = inportb(0x3c9)<<2;
#else
  *red = *green = *blue = 0;
#endif
}
