/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Mar  7 10:31:08 EST 2006 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_twiddle -fma -reorder-insns -schedule-for-pipeline -simd -compact -variables 4 -pipeline-latency 8 -n 2 -name t1sv_2 -include ts.h */

/*
 * This function contains 6 FP additions, 4 FP multiplications,
 * (or, 4 additions, 2 multiplications, 2 fused multiply/add),
 * 11 stack variables, and 8 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_twiddle.ml,v 1.24 2006-02-12 23:34:12 athena Exp $
 */

#include "ts.h"

static const R *t1sv_2(R *ri, R *ii, const R *W, stride ios, INT m, INT dist)
{
     INT i;
     for (i = m; i > 0; i = i - (2 * VL), ri = ri + ((2 * VL) * dist), ii = ii + ((2 * VL) * dist), W = W + ((2 * VL) * 2), MAKE_VOLATILE_STRIDE(ios)) {
	  V T1, Ta, T3, T6, T2, T5;
	  T1 = LD(&(ri[0]), dist, &(ri[0]));
	  Ta = LD(&(ii[0]), dist, &(ii[0]));
	  T3 = LD(&(ri[WS(ios, 1)]), dist, &(ri[WS(ios, 1)]));
	  T6 = LD(&(ii[WS(ios, 1)]), dist, &(ii[WS(ios, 1)]));
	  T2 = LDW(&(W[0]));
	  T5 = LDW(&(W[TWVL * 1]));
	  {
	       V T8, T4, T9, T7;
	       T8 = VMUL(T2, T6);
	       T4 = VMUL(T2, T3);
	       T9 = VFNMS(T5, T3, T8);
	       T7 = VFMA(T5, T6, T4);
	       ST(&(ii[0]), VADD(T9, Ta), dist, &(ii[0]));
	       ST(&(ii[WS(ios, 1)]), VSUB(Ta, T9), dist, &(ii[WS(ios, 1)]));
	       ST(&(ri[0]), VADD(T1, T7), dist, &(ri[0]));
	       ST(&(ri[WS(ios, 1)]), VSUB(T1, T7), dist, &(ri[WS(ios, 1)]));
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     {TW_NEXT, (2 * VL), 0}
};

static const ct_desc desc = { 2, "t1sv_2", twinstr, &GENUS, {4, 2, 2, 0}, 0, 0, 0 };

void X(codelet_t1sv_2) (planner *p) {
     X(kdft_dit_register) (p, t1sv_2, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_twiddle -simd -compact -variables 4 -pipeline-latency 8 -n 2 -name t1sv_2 -include ts.h */

/*
 * This function contains 6 FP additions, 4 FP multiplications,
 * (or, 4 additions, 2 multiplications, 2 fused multiply/add),
 * 9 stack variables, and 8 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_twiddle.ml,v 1.24 2006-02-12 23:34:12 athena Exp $
 */

#include "ts.h"

static const R *t1sv_2(R *ri, R *ii, const R *W, stride ios, INT m, INT dist)
{
     INT i;
     for (i = m; i > 0; i = i - (2 * VL), ri = ri + ((2 * VL) * dist), ii = ii + ((2 * VL) * dist), W = W + ((2 * VL) * 2), MAKE_VOLATILE_STRIDE(ios)) {
	  V T1, T8, T6, T7;
	  T1 = LD(&(ri[0]), dist, &(ri[0]));
	  T8 = LD(&(ii[0]), dist, &(ii[0]));
	  {
	       V T3, T5, T2, T4;
	       T3 = LD(&(ri[WS(ios, 1)]), dist, &(ri[WS(ios, 1)]));
	       T5 = LD(&(ii[WS(ios, 1)]), dist, &(ii[WS(ios, 1)]));
	       T2 = LDW(&(W[0]));
	       T4 = LDW(&(W[TWVL * 1]));
	       T6 = VFMA(T2, T3, VMUL(T4, T5));
	       T7 = VFNMS(T4, T3, VMUL(T2, T5));
	  }
	  ST(&(ri[WS(ios, 1)]), VSUB(T1, T6), dist, &(ri[WS(ios, 1)]));
	  ST(&(ii[WS(ios, 1)]), VSUB(T8, T7), dist, &(ii[WS(ios, 1)]));
	  ST(&(ri[0]), VADD(T1, T6), dist, &(ri[0]));
	  ST(&(ii[0]), VADD(T7, T8), dist, &(ii[0]));
     }
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     {TW_NEXT, (2 * VL), 0}
};

static const ct_desc desc = { 2, "t1sv_2", twinstr, &GENUS, {4, 2, 2, 0}, 0, 0, 0 };

void X(codelet_t1sv_2) (planner *p) {
     X(kdft_dit_register) (p, t1sv_2, &desc);
}
#endif				/* HAVE_FMA */
