/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Fri Jan 27 19:25:09 EST 2006 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_twiddle -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -n 6 -name t1_6 -include t.h */

/*
 * This function contains 46 FP additions, 32 FP multiplications,
 * (or, 24 additions, 10 multiplications, 22 fused multiply/add),
 * 47 stack variables, and 24 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_twiddle.ml,v 1.23 2006-01-05 03:04:27 stevenj Exp $
 */

#include "t.h"

static const R *t1_6(R *ri, R *ii, const R *W, stride ios, INT m, INT dist)
{
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     INT i;
     for (i = m; i > 0; i = i - 1, ri = ri + dist, ii = ii + dist, W = W + 10, MAKE_VOLATILE_STRIDE(ios)) {
	  E TY, TU, T10, TZ;
	  {
	       E T1, TX, TW, T7, Tn, Tq, TJ, TR, TB, Tl, To, TK, Tt, Tw, Ts;
	       E Tp, Tv;
	       T1 = ri[0];
	       TX = ii[0];
	       {
		    E T3, T6, T2, T5;
		    T3 = ri[WS(ios, 3)];
		    T6 = ii[WS(ios, 3)];
		    T2 = W[4];
		    T5 = W[5];
		    {
			 E Ta, Td, Tg, TF, Tb, Tj, Tf, Tc, Ti, TV, T4, T9;
			 Ta = ri[WS(ios, 2)];
			 Td = ii[WS(ios, 2)];
			 TV = T2 * T6;
			 T4 = T2 * T3;
			 T9 = W[2];
			 Tg = ri[WS(ios, 5)];
			 TW = FNMS(T5, T3, TV);
			 T7 = FMA(T5, T6, T4);
			 TF = T9 * Td;
			 Tb = T9 * Ta;
			 Tj = ii[WS(ios, 5)];
			 Tf = W[8];
			 Tc = W[3];
			 Ti = W[9];
			 {
			      E TG, Te, TI, Tk, TH, Th, Tm;
			      Tn = ri[WS(ios, 4)];
			      TH = Tf * Tj;
			      Th = Tf * Tg;
			      TG = FNMS(Tc, Ta, TF);
			      Te = FMA(Tc, Td, Tb);
			      TI = FNMS(Ti, Tg, TH);
			      Tk = FMA(Ti, Tj, Th);
			      Tq = ii[WS(ios, 4)];
			      Tm = W[6];
			      TJ = TG - TI;
			      TR = TG + TI;
			      TB = Te + Tk;
			      Tl = Te - Tk;
			      To = Tm * Tn;
			      TK = Tm * Tq;
			 }
			 Tt = ri[WS(ios, 1)];
			 Tw = ii[WS(ios, 1)];
			 Ts = W[0];
			 Tp = W[7];
			 Tv = W[1];
		    }
	       }
	       {
		    E TA, T8, TL, Tr, TN, Tx, T11, TM, Tu;
		    TA = T1 + T7;
		    T8 = T1 - T7;
		    TM = Ts * Tw;
		    Tu = Ts * Tt;
		    TL = FNMS(Tp, Tn, TK);
		    Tr = FMA(Tp, Tq, To);
		    TN = FNMS(Tv, Tt, TM);
		    Tx = FMA(Tv, Tw, Tu);
		    T11 = TX - TW;
		    TY = TW + TX;
		    {
			 E TP, TT, TD, TE, TQ, Tz, T14, T13;
			 {
			      E TO, TS, TC, Ty, T12;
			      TO = TL - TN;
			      TS = TL + TN;
			      TC = Tr + Tx;
			      Ty = Tr - Tx;
			      T12 = TJ + TO;
			      TP = TJ - TO;
			      TT = TR - TS;
			      TU = TR + TS;
			      Tz = Tl + Ty;
			      T14 = Ty - Tl;
			      ii[WS(ios, 3)] = T12 + T11;
			      T13 = FNMS(KP500000000, T12, T11);
			      T10 = TC - TB;
			      TD = TB + TC;
			 }
			 ri[WS(ios, 3)] = T8 + Tz;
			 TE = FNMS(KP500000000, Tz, T8);
			 ii[WS(ios, 5)] = FNMS(KP866025403, T14, T13);
			 ii[WS(ios, 1)] = FMA(KP866025403, T14, T13);
			 TQ = FNMS(KP500000000, TD, TA);
			 ri[WS(ios, 5)] = FNMS(KP866025403, TP, TE);
			 ri[WS(ios, 1)] = FMA(KP866025403, TP, TE);
			 ri[0] = TA + TD;
			 ri[WS(ios, 4)] = FMA(KP866025403, TT, TQ);
			 ri[WS(ios, 2)] = FNMS(KP866025403, TT, TQ);
		    }
	       }
	  }
	  ii[0] = TU + TY;
	  TZ = FNMS(KP500000000, TU, TY);
	  ii[WS(ios, 2)] = FNMS(KP866025403, T10, TZ);
	  ii[WS(ios, 4)] = FMA(KP866025403, T10, TZ);
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 6},
     {TW_NEXT, 1, 0}
};

static const ct_desc desc = { 6, "t1_6", twinstr, &GENUS, {24, 10, 22, 0}, 0, 0, 0 };

void X(codelet_t1_6) (planner *p) {
     X(kdft_dit_register) (p, t1_6, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_twiddle -compact -variables 4 -pipeline-latency 4 -n 6 -name t1_6 -include t.h */

/*
 * This function contains 46 FP additions, 28 FP multiplications,
 * (or, 32 additions, 14 multiplications, 14 fused multiply/add),
 * 23 stack variables, and 24 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_twiddle.ml,v 1.23 2006-01-05 03:04:27 stevenj Exp $
 */

#include "t.h"

static const R *t1_6(R *ri, R *ii, const R *W, stride ios, INT m, INT dist)
{
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     INT i;
     for (i = m; i > 0; i = i - 1, ri = ri + dist, ii = ii + dist, W = W + 10, MAKE_VOLATILE_STRIDE(ios)) {
	  E T7, TS, Tv, TO, Tt, TJ, Tx, TF, Ti, TI, Tw, TC;
	  {
	       E T1, TN, T6, TM;
	       T1 = ri[0];
	       TN = ii[0];
	       {
		    E T3, T5, T2, T4;
		    T3 = ri[WS(ios, 3)];
		    T5 = ii[WS(ios, 3)];
		    T2 = W[4];
		    T4 = W[5];
		    T6 = FMA(T2, T3, T4 * T5);
		    TM = FNMS(T4, T3, T2 * T5);
	       }
	       T7 = T1 - T6;
	       TS = TN - TM;
	       Tv = T1 + T6;
	       TO = TM + TN;
	  }
	  {
	       E Tn, TD, Ts, TE;
	       {
		    E Tk, Tm, Tj, Tl;
		    Tk = ri[WS(ios, 4)];
		    Tm = ii[WS(ios, 4)];
		    Tj = W[6];
		    Tl = W[7];
		    Tn = FMA(Tj, Tk, Tl * Tm);
		    TD = FNMS(Tl, Tk, Tj * Tm);
	       }
	       {
		    E Tp, Tr, To, Tq;
		    Tp = ri[WS(ios, 1)];
		    Tr = ii[WS(ios, 1)];
		    To = W[0];
		    Tq = W[1];
		    Ts = FMA(To, Tp, Tq * Tr);
		    TE = FNMS(Tq, Tp, To * Tr);
	       }
	       Tt = Tn - Ts;
	       TJ = TD + TE;
	       Tx = Tn + Ts;
	       TF = TD - TE;
	  }
	  {
	       E Tc, TA, Th, TB;
	       {
		    E T9, Tb, T8, Ta;
		    T9 = ri[WS(ios, 2)];
		    Tb = ii[WS(ios, 2)];
		    T8 = W[2];
		    Ta = W[3];
		    Tc = FMA(T8, T9, Ta * Tb);
		    TA = FNMS(Ta, T9, T8 * Tb);
	       }
	       {
		    E Te, Tg, Td, Tf;
		    Te = ri[WS(ios, 5)];
		    Tg = ii[WS(ios, 5)];
		    Td = W[8];
		    Tf = W[9];
		    Th = FMA(Td, Te, Tf * Tg);
		    TB = FNMS(Tf, Te, Td * Tg);
	       }
	       Ti = Tc - Th;
	       TI = TA + TB;
	       Tw = Tc + Th;
	       TC = TA - TB;
	  }
	  {
	       E TG, Tu, Tz, TR, TT, TU;
	       TG = KP866025403 * (TC - TF);
	       Tu = Ti + Tt;
	       Tz = FNMS(KP500000000, Tu, T7);
	       ri[WS(ios, 3)] = T7 + Tu;
	       ri[WS(ios, 1)] = Tz + TG;
	       ri[WS(ios, 5)] = Tz - TG;
	       TR = KP866025403 * (Tt - Ti);
	       TT = TC + TF;
	       TU = FNMS(KP500000000, TT, TS);
	       ii[WS(ios, 1)] = TR + TU;
	       ii[WS(ios, 3)] = TT + TS;
	       ii[WS(ios, 5)] = TU - TR;
	  }
	  {
	       E TK, Ty, TH, TQ, TL, TP;
	       TK = KP866025403 * (TI - TJ);
	       Ty = Tw + Tx;
	       TH = FNMS(KP500000000, Ty, Tv);
	       ri[0] = Tv + Ty;
	       ri[WS(ios, 4)] = TH + TK;
	       ri[WS(ios, 2)] = TH - TK;
	       TQ = KP866025403 * (Tx - Tw);
	       TL = TI + TJ;
	       TP = FNMS(KP500000000, TL, TO);
	       ii[0] = TL + TO;
	       ii[WS(ios, 4)] = TQ + TP;
	       ii[WS(ios, 2)] = TP - TQ;
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 6},
     {TW_NEXT, 1, 0}
};

static const ct_desc desc = { 6, "t1_6", twinstr, &GENUS, {32, 14, 14, 0}, 0, 0, 0 };

void X(codelet_t1_6) (planner *p) {
     X(kdft_dit_register) (p, t1_6, &desc);
}
#endif				/* HAVE_FMA */
