/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Fri Jan 27 20:39:25 EST 2006 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2r -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -n 14 -name hc2r_14 -include hc2r.h */

/*
 * This function contains 62 FP additions, 44 FP multiplications,
 * (or, 18 additions, 0 multiplications, 44 fused multiply/add),
 * 58 stack variables, and 28 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2r.ml,v 1.18 2006-01-05 03:04:27 stevenj Exp $
 */

#include "hc2r.h"

static void hc2r_14(const R *ri, const R *ii, R *O, stride ris, stride iis, stride os, INT v, INT ivs, INT ovs)
{
     DK(KP1_949855824, +1.949855824363647214036263365987862434465571601);
     DK(KP1_801937735, +1.801937735804838252472204639014890102331838324);
     DK(KP692021471, +0.692021471630095869627814897002069140197260599);
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     DK(KP356895867, +0.356895867892209443894399510021300583399127187);
     DK(KP801937735, +0.801937735804838252472204639014890102331838324);
     DK(KP554958132, +0.554958132087371191422194871006410481067288862);
     INT i;
     for (i = v; i > 0; i = i - 1, ri = ri + ivs, ii = ii + ivs, O = O + ovs, MAKE_VOLATILE_STRIDE(ris), MAKE_VOLATILE_STRIDE(iis), MAKE_VOLATILE_STRIDE(os)) {
	  E Te, TO, TT, TG, TJ, TD, TR, TE;
	  {
	       E T3, TK, To, TM, Tu, TL, Tr, TS, TA, TN, TX, TF, Tv, T7, Tf;
	       E T6, Th, Tc, T8, T1, T2;
	       T1 = ri[0];
	       T2 = ri[WS(ris, 7)];
	       {
		    E Ts, Tt, Tp, Tq, Tm, Tn;
		    Tm = ii[WS(iis, 4)];
		    Tn = ii[WS(iis, 3)];
		    Ts = ii[WS(iis, 6)];
		    Te = T1 + T2;
		    T3 = T1 - T2;
		    TK = Tm + Tn;
		    To = Tm - Tn;
		    Tt = ii[WS(iis, 1)];
		    Tp = ii[WS(iis, 2)];
		    Tq = ii[WS(iis, 5)];
		    {
			 E T4, T5, Ta, Tb;
			 T4 = ri[WS(ris, 2)];
			 TM = Ts + Tt;
			 Tu = Ts - Tt;
			 TL = Tp + Tq;
			 Tr = Tp - Tq;
			 TS = FMA(KP554958132, TK, TM);
			 TA = FMA(KP554958132, To, Tu);
			 TN = FMA(KP554958132, TM, TL);
			 TX = FNMS(KP554958132, TL, TK);
			 TF = FNMS(KP554958132, Tr, To);
			 Tv = FMA(KP554958132, Tu, Tr);
			 T5 = ri[WS(ris, 5)];
			 Ta = ri[WS(ris, 6)];
			 Tb = ri[WS(ris, 1)];
			 T7 = ri[WS(ris, 4)];
			 Tf = T4 + T5;
			 T6 = T4 - T5;
			 Th = Ta + Tb;
			 Tc = Ta - Tb;
			 T8 = ri[WS(ris, 3)];
		    }
	       }
	       {
		    E Tw, Tx, TP, Tg, T9, TY, TC, TI, TQ;
		    Tw = FMA(KP801937735, Tv, To);
		    Tx = FNMS(KP356895867, Tf, Th);
		    TP = FNMS(KP356895867, T6, Tc);
		    Tg = T7 + T8;
		    T9 = T7 - T8;
		    TY = FNMS(KP801937735, TX, TM);
		    {
			 E TB, TH, TV, Ty, Tl, Ti, TW, Tz;
			 TB = FNMS(KP801937735, TA, Tr);
			 Ti = Tf + Tg + Th;
			 TC = FNMS(KP356895867, Th, Tg);
			 {
			      E Tj, Td, TU, Tk;
			      Tj = FNMS(KP356895867, Tg, Tf);
			      Td = T6 + T9 + Tc;
			      TH = FNMS(KP356895867, T9, T6);
			      TU = FNMS(KP356895867, Tc, T9);
			      O[0] = FMA(KP2_000000000, Ti, Te);
			      Tk = FNMS(KP692021471, Tj, Th);
			      O[WS(os, 7)] = FMA(KP2_000000000, Td, T3);
			      TV = FNMS(KP692021471, TU, T6);
			      Ty = FNMS(KP692021471, Tx, Tg);
			      Tl = FNMS(KP1_801937735, Tk, Te);
			 }
			 TO = FMA(KP801937735, TN, TK);
			 TW = FNMS(KP1_801937735, TV, T3);
			 Tz = FNMS(KP1_801937735, Ty, Te);
			 O[WS(os, 6)] = FMA(KP1_949855824, Tw, Tl);
			 O[WS(os, 8)] = FNMS(KP1_949855824, Tw, Tl);
			 O[WS(os, 11)] = FMA(KP1_949855824, TY, TW);
			 O[WS(os, 3)] = FNMS(KP1_949855824, TY, TW);
			 O[WS(os, 12)] = FMA(KP1_949855824, TB, Tz);
			 O[WS(os, 2)] = FNMS(KP1_949855824, TB, Tz);
			 TI = FNMS(KP692021471, TH, Tc);
		    }
		    TT = FNMS(KP801937735, TS, TL);
		    TQ = FNMS(KP692021471, TP, T9);
		    TG = FNMS(KP801937735, TF, Tu);
		    TJ = FNMS(KP1_801937735, TI, T3);
		    TD = FNMS(KP692021471, TC, Tf);
		    TR = FNMS(KP1_801937735, TQ, T3);
	       }
	  }
	  O[WS(os, 13)] = FMA(KP1_949855824, TO, TJ);
	  O[WS(os, 1)] = FNMS(KP1_949855824, TO, TJ);
	  TE = FNMS(KP1_801937735, TD, Te);
	  O[WS(os, 5)] = FMA(KP1_949855824, TT, TR);
	  O[WS(os, 9)] = FNMS(KP1_949855824, TT, TR);
	  O[WS(os, 4)] = FMA(KP1_949855824, TG, TE);
	  O[WS(os, 10)] = FNMS(KP1_949855824, TG, TE);
     }
}

static const khc2r_desc desc = { 14, "hc2r_14", {18, 0, 44, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_hc2r_14) (planner *p) {
     X(khc2r_register) (p, hc2r_14, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2r -compact -variables 4 -pipeline-latency 4 -sign 1 -n 14 -name hc2r_14 -include hc2r.h */

/*
 * This function contains 62 FP additions, 38 FP multiplications,
 * (or, 36 additions, 12 multiplications, 26 fused multiply/add),
 * 28 stack variables, and 28 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2r.ml,v 1.18 2006-01-05 03:04:27 stevenj Exp $
 */

#include "hc2r.h"

static void hc2r_14(const R *ri, const R *ii, R *O, stride ris, stride iis, stride os, INT v, INT ivs, INT ovs)
{
     DK(KP1_801937735, +1.801937735804838252472204639014890102331838324);
     DK(KP445041867, +0.445041867912628808577805128993589518932711138);
     DK(KP1_246979603, +1.246979603717467061050009768008479621264549462);
     DK(KP867767478, +0.867767478235116240951536665696717509219981456);
     DK(KP1_949855824, +1.949855824363647214036263365987862434465571601);
     DK(KP1_563662964, +1.563662964936059617416889053348115500464669037);
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     INT i;
     for (i = v; i > 0; i = i - 1, ri = ri + ivs, ii = ii + ivs, O = O + ovs, MAKE_VOLATILE_STRIDE(ris), MAKE_VOLATILE_STRIDE(iis), MAKE_VOLATILE_STRIDE(os)) {
	  E T3, Td, T6, Te, Tq, Tz, Tn, Ty, Tc, Tg, Tk, Tx, T9, Tf, T1;
	  E T2;
	  T1 = ri[0];
	  T2 = ri[WS(ris, 7)];
	  T3 = T1 - T2;
	  Td = T1 + T2;
	  {
	       E T4, T5, To, Tp;
	       T4 = ri[WS(ris, 2)];
	       T5 = ri[WS(ris, 5)];
	       T6 = T4 - T5;
	       Te = T4 + T5;
	       To = ii[WS(iis, 2)];
	       Tp = ii[WS(iis, 5)];
	       Tq = To - Tp;
	       Tz = To + Tp;
	  }
	  {
	       E Tl, Tm, Ta, Tb;
	       Tl = ii[WS(iis, 6)];
	       Tm = ii[WS(iis, 1)];
	       Tn = Tl - Tm;
	       Ty = Tl + Tm;
	       Ta = ri[WS(ris, 6)];
	       Tb = ri[WS(ris, 1)];
	       Tc = Ta - Tb;
	       Tg = Ta + Tb;
	  }
	  {
	       E Ti, Tj, T7, T8;
	       Ti = ii[WS(iis, 4)];
	       Tj = ii[WS(iis, 3)];
	       Tk = Ti - Tj;
	       Tx = Ti + Tj;
	       T7 = ri[WS(ris, 4)];
	       T8 = ri[WS(ris, 3)];
	       T9 = T7 - T8;
	       Tf = T7 + T8;
	  }
	  O[WS(os, 7)] = FMA(KP2_000000000, T6 + T9 + Tc, T3);
	  O[0] = FMA(KP2_000000000, Te + Tf + Tg, Td);
	  {
	       E Tr, Th, TE, TD;
	       Tr = FNMS(KP1_949855824, Tn, KP1_563662964 * Tk) - (KP867767478 * Tq);
	       Th = FMA(KP1_246979603, Tf, Td) + FNMA(KP445041867, Tg, KP1_801937735 * Te);
	       O[WS(os, 4)] = Th - Tr;
	       O[WS(os, 10)] = Th + Tr;
	       TE = FMA(KP867767478, Tx, KP1_563662964 * Ty) - (KP1_949855824 * Tz);
	       TD = FMA(KP1_246979603, Tc, T3) + FNMA(KP1_801937735, T9, KP445041867 * T6);
	       O[WS(os, 5)] = TD - TE;
	       O[WS(os, 9)] = TD + TE;
	  }
	  {
	       E Tt, Ts, TA, Tw;
	       Tt = FMA(KP867767478, Tk, KP1_563662964 * Tn) - (KP1_949855824 * Tq);
	       Ts = FMA(KP1_246979603, Tg, Td) + FNMA(KP1_801937735, Tf, KP445041867 * Te);
	       O[WS(os, 12)] = Ts - Tt;
	       O[WS(os, 2)] = Ts + Tt;
	       TA = FNMS(KP1_949855824, Ty, KP1_563662964 * Tx) - (KP867767478 * Tz);
	       Tw = FMA(KP1_246979603, T9, T3) + FNMA(KP445041867, Tc, KP1_801937735 * T6);
	       O[WS(os, 11)] = Tw - TA;
	       O[WS(os, 3)] = Tw + TA;
	  }
	  {
	       E TC, TB, Tv, Tu;
	       TC = FMA(KP1_563662964, Tz, KP1_949855824 * Tx) + (KP867767478 * Ty);
	       TB = FMA(KP1_246979603, T6, T3) + FNMA(KP1_801937735, Tc, KP445041867 * T9);
	       O[WS(os, 1)] = TB - TC;
	       O[WS(os, 13)] = TB + TC;
	       Tv = FMA(KP1_563662964, Tq, KP1_949855824 * Tk) + (KP867767478 * Tn);
	       Tu = FMA(KP1_246979603, Te, Td) + FNMA(KP1_801937735, Tg, KP445041867 * Tf);
	       O[WS(os, 8)] = Tu - Tv;
	       O[WS(os, 6)] = Tu + Tv;
	  }
     }
}

static const khc2r_desc desc = { 14, "hc2r_14", {36, 12, 26, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_hc2r_14) (planner *p) {
     X(khc2r_register) (p, hc2r_14, &desc);
}

#endif				/* HAVE_FMA */
