/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Fri Jan 27 20:16:13 EST 2006 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_r2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -n 8 -name r2hc_8 -include r2hc.h */

/*
 * This function contains 20 FP additions, 4 FP multiplications,
 * (or, 16 additions, 0 multiplications, 4 fused multiply/add),
 * 18 stack variables, and 16 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_r2hc.ml,v 1.17 2006-01-05 03:04:27 stevenj Exp $
 */

#include "r2hc.h"

static void r2hc_8(const R *I, R *ro, R *io, stride is, stride ros, stride ios, INT v, INT ivs, INT ovs)
{
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = v; i > 0; i = i - 1, I = I + ivs, ro = ro + ovs, io = io + ovs, MAKE_VOLATILE_STRIDE(is), MAKE_VOLATILE_STRIDE(ros), MAKE_VOLATILE_STRIDE(ios)) {
	  E T4, T7, T3, Tj, Td, T5, T8, T9;
	  {
	       E T1, T2, Tb, Tc;
	       T1 = I[0];
	       T2 = I[WS(is, 4)];
	       Tb = I[WS(is, 7)];
	       Tc = I[WS(is, 3)];
	       T4 = I[WS(is, 2)];
	       T7 = T1 - T2;
	       T3 = T1 + T2;
	       Tj = Tb + Tc;
	       Td = Tb - Tc;
	       T5 = I[WS(is, 6)];
	       T8 = I[WS(is, 1)];
	       T9 = I[WS(is, 5)];
	  }
	  {
	       E T6, Tf, Ta, Ti;
	       T6 = T4 + T5;
	       Tf = T4 - T5;
	       Ta = T8 - T9;
	       Ti = T8 + T9;
	       {
		    E Th, Tk, Te, Tg;
		    Th = T3 + T6;
		    ro[WS(ros, 2)] = T3 - T6;
		    Tk = Ti + Tj;
		    io[WS(ios, 2)] = Tj - Ti;
		    Te = Ta + Td;
		    Tg = Td - Ta;
		    ro[0] = Th + Tk;
		    ro[WS(ros, 4)] = Th - Tk;
		    io[WS(ios, 3)] = FMA(KP707106781, Tg, Tf);
		    io[WS(ios, 1)] = FMS(KP707106781, Tg, Tf);
		    ro[WS(ros, 1)] = FMA(KP707106781, Te, T7);
		    ro[WS(ros, 3)] = FNMS(KP707106781, Te, T7);
	       }
	  }
     }
}

static const kr2hc_desc desc = { 8, "r2hc_8", {16, 0, 4, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_r2hc_8) (planner *p) {
     X(kr2hc_register) (p, r2hc_8, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_r2hc -compact -variables 4 -pipeline-latency 4 -n 8 -name r2hc_8 -include r2hc.h */

/*
 * This function contains 20 FP additions, 2 FP multiplications,
 * (or, 20 additions, 2 multiplications, 0 fused multiply/add),
 * 14 stack variables, and 16 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_r2hc.ml,v 1.17 2006-01-05 03:04:27 stevenj Exp $
 */

#include "r2hc.h"

static void r2hc_8(const R *I, R *ro, R *io, stride is, stride ros, stride ios, INT v, INT ivs, INT ovs)
{
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = v; i > 0; i = i - 1, I = I + ivs, ro = ro + ovs, io = io + ovs, MAKE_VOLATILE_STRIDE(is), MAKE_VOLATILE_STRIDE(ros), MAKE_VOLATILE_STRIDE(ios)) {
	  E T3, T7, Td, Tj, T6, Tg, Ta, Ti;
	  {
	       E T1, T2, Tb, Tc;
	       T1 = I[0];
	       T2 = I[WS(is, 4)];
	       T3 = T1 + T2;
	       T7 = T1 - T2;
	       Tb = I[WS(is, 7)];
	       Tc = I[WS(is, 3)];
	       Td = Tb - Tc;
	       Tj = Tb + Tc;
	  }
	  {
	       E T4, T5, T8, T9;
	       T4 = I[WS(is, 2)];
	       T5 = I[WS(is, 6)];
	       T6 = T4 + T5;
	       Tg = T4 - T5;
	       T8 = I[WS(is, 1)];
	       T9 = I[WS(is, 5)];
	       Ta = T8 - T9;
	       Ti = T8 + T9;
	  }
	  ro[WS(ros, 2)] = T3 - T6;
	  io[WS(ios, 2)] = Tj - Ti;
	  {
	       E Te, Tf, Th, Tk;
	       Te = KP707106781 * (Ta + Td);
	       ro[WS(ros, 3)] = T7 - Te;
	       ro[WS(ros, 1)] = T7 + Te;
	       Tf = KP707106781 * (Td - Ta);
	       io[WS(ios, 1)] = Tf - Tg;
	       io[WS(ios, 3)] = Tg + Tf;
	       Th = T3 + T6;
	       Tk = Ti + Tj;
	       ro[WS(ros, 4)] = Th - Tk;
	       ro[0] = Th + Tk;
	  }
     }
}

static const kr2hc_desc desc = { 8, "r2hc_8", {20, 2, 0, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_r2hc_8) (planner *p) {
     X(kr2hc_register) (p, r2hc_8, &desc);
}

#endif				/* HAVE_FMA */
