/****************************************************************************/
/* TCOMBOBOX                                                                */
/*--------------------------------------------------------------------------*/
/* Objet TComboBox                                                          */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 22/02/96                                                    */
/****************************************************************************/

#include <string.h>

#include "Settings.h"

#include "Const.h"

#include "Callback.h"
#include "Mouse.h"
#include "Screen.h"
#include "SpChars.h"

#include "TScrBar.h"
#include "TWindow.h"

#include "TSmpList.h"

#include "TCombBox.h"

/*ͻ*/
/*                           CLASSE COMBOLIST                             */
/*ͼ*/


class TComboList:public TSimpleList
{
  /*---------------*/
  /* Classes amies */
  /*---------------*/

  friend TComboBox;

  /*---------------*/
  /* Champs privs */
  /*---------------*/

  private:

    // ComboBox associe

    PComboBox f_combo_box;

    // La souris a t amene dans la liste

    boolean   f_mouse_went_into_list;

    // Si TRUE,  chaque changement de l'lment slectionn, on
    // recopie l'lment slectionn dans la zone de saisie

    boolean   f_update_edzone_when_selection_change;

  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur/Destructeur
		    TComboList(PComboBox combo_box,
			       int rel_x,int rel_y,
			       int width,int height,
			       unsigned background,
			       boolean sorted,
			       boolean always_one_item_selected,
			       boolean enabled);
		    ~TComboList();


  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:

    // Affichage

    virtual void    m_display();

    // Callbacks

    virtual void    m_selected_item_changed_callback();
    virtual void    m_mouse_went_to_list_callback();
};

typedef TComboList *PComboList;

TComboList::TComboList(PComboBox combo_box,
		       int rel_x,int rel_y,
		       int width,int height,
		       unsigned background,
		       boolean sorted,
		       boolean always_one_item_selected,
		       boolean enabled)
	 :TSimpleList(NULL,
		      OBJ_COMBO_LIST,
		      rel_x,rel_y,
		      width,height,
		      background,
		      "",
		      1,1,
		      width-4,height-2,
		      sorted,
		      LI_NOATTR,
		      always_one_item_selected,
		      FALSE,       // Item hot key disabled
		      TRUE,        // scroll bar
		      width-2,
		      0,
		      height,
		      enabled)
{
  // ComboBox associe

  f_combo_box=combo_box;

  // La souris a t amene dans la liste

  f_mouse_went_into_list=FALSE;

  // Si TRUE,  chaque changement de l'lment slectionn, on
  // recopie l'lment slectionn dans la zone de saisie

  f_update_edzone_when_selection_change=TRUE;

  // Couleur de la bordure de la fentre
  f_window->m_set_border_attr((f_background<<4)+(unsigned)BLACK);
}


TComboList::~TComboList()
{
}

/****************************************************************************/
/* m_selected_item_changed_callback                                         */
/*--------------------------------------------------------------------------*/
/* Fonction appele quand l'lment slectionn de la liste est modifi.    */
/****************************************************************************/

void TComboList::m_selected_item_changed_callback()
{
  if (f_update_edzone_when_selection_change)
    f_combo_box->m_set_string_from_selected_item();

  TSimpleList::m_selected_item_changed_callback();
}

/****************************************************************************/
/* m_mouse_went_to_list_callback                                            */
/*--------------------------------------------------------------------------*/
/* Appele dans les vnements souris quand la souris entre dans la partie  */
/* 'liste' de l'objet                                                       */
/****************************************************************************/

void TComboList::m_mouse_went_to_list_callback()
{
  // La souris a t amene dans la liste

  f_mouse_went_into_list=TRUE;
}

/****************************************************************************/
/* m_display                                                                */
/*--------------------------------------------------------------------------*/
/* Affichage de l'objet                                                     */
/****************************************************************************/

void TComboList::m_display()
{
  int x2,y1,
      y2;

  register int i;

  if (!f_open)
    return;

  x2=m_get_x_in_window()+f_width-3;
  y1=m_get_y_in_window();
  y2=y1+f_height-1;

  // Colonne d'espace  droite (hors liste)

  f_window->m_gotoxy(x2,y1);
  f_window->m_putch(SPECIAL_CHAR(SCH_COMBOBOX_UP_RIGHT));

  for (i=y1+1;i<y2;i++)
    {
      f_window->m_gotoxy(x2,i);
      f_window->m_putch(' ');
    };
  f_window->m_gotoxy(x2,y2);
  f_window->m_putch(SPECIAL_CHAR(SCH_COMBOBOX_BOTTOM_RIGHT));

  // Affichage du reste

  TSimpleList::m_display();
}

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x,rel_y      : Coordonnes de la zone d'dition p/r au groupe        */
/* xoffset_caption,                                                         */
/* yoffset_caption  : Coordonnes du titre p/r au contenu de la zone d'dit.*/
/* caption          : Titre de la zone d'dition (hot-key prcd de ~)     */
/* display_length   : Longueur visible du contenu de la zone d'dition      */
/* max_length       : Longueur maximale du contenu de la zone d'dition     */
/* string           : Contenu initial de la zone d'dition                  */
/* list_height      : Hauteur de la liste                                   */
/* items            : Elments de la liste                                  */
/* sorted           : Indique si les lments ajouts  la liste sont tris */
/*                    ou non                                                */
/* enabled          : ENABLED si la zone est activable (DISABLED sinon)     */
/****************************************************************************/


TComboBox::TComboBox(PObject parent,
		     int rel_x,int rel_y,
		     int xoffset_caption,int yoffset_caption,
		     const char *caption,
		     int display_length,
		     int max_length,
		     const char *string,
		     int list_height,
		     TListItem items[],
		     boolean string_must_be_in_list,
		     boolean sorted,
		     boolean enabled)
	  :TEditZone(parent,
		     rel_x,rel_y,
		     xoffset_caption,yoffset_caption,
		     caption,
		     display_length,
		     max_length,
		     "",
		     enabled)
{
  // Largeur (flche)

  f_width+=2;

  // Le contenu de la zone d'dition doit tre dans la liste

  f_string_must_be_in_list=string_must_be_in_list;

  // Dselectionne l'lment slectionn de la liste si le
  // contenu de la zone de saisie est modifi

  f_unselect_on_string_change=TRUE;

  // Elment slectionne de la liste lorsqu'on l'ouvre

  f_selected_item_when_opening=0;

  if (f_string_must_be_in_list)
    f_modification_enabled=FALSE;

  // Callbacks

  InitCallback(f_string_validated_action,f_string_validated_argument);

  // Liste

  f_list=new TComboList(this,
			0,0,
			f_display_length+4,list_height,
			parent->m_get_background(),
			sorted,
			f_string_must_be_in_list,
			enabled);

  if (items!=NULL)
    f_list->m_add_items(items);


  (f_list->m_get_window())->m_set_pos(m_get_x(),m_get_y()+1);
  f_list->m_set_focus();


  // Zone de saisie

  m_set_string(string);
}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TComboBox::~TComboBox()
{
  delete f_list;

  // Destruction des variables dynamiques

  DestroyCallback(f_string_validated_action,f_string_validated_argument);
}

/****************************************************************************/
/* m_enable                                                                 */
/*--------------------------------------------------------------------------*/
/* Rend l'objet activable                                                   */
/****************************************************************************/

void TComboBox::m_enable()
{
  if (!f_enabled)
    {
      TEditZone::m_enable();
      f_list->m_enable();
    }
}

/****************************************************************************/
/* m_disable                                                                */
/*--------------------------------------------------------------------------*/
/* Rend l'objet inactivable                                                 */
/****************************************************************************/

void TComboBox::m_disable()
{
  if (f_enabled)
    {
      m_close_list();
      TEditZone::m_disable();
      f_list->m_disable();
    }
}

/****************************************************************************/
/* m_set_string                                                             */
/*--------------------------------------------------------------------------*/
/* Modifie le contenu de la zone d'dition                                  */
/* Recopie d'un lment de la liste dans la zone d'dition                  */
/* string : chane sans les . finaux apparaissant dans la zone d'dition;   */
/*          si la chane n'est pas valide, c'est la valeur par dfaut qui   */
/*          est affecte  la zone de saisie                                */
/****************************************************************************/

void TComboBox::m_set_string(const char *string)
{
  int index;

  // Si la chane doit faire partie de la liste,
  // on vrifie qu'elle est bien dans la liste

  index=f_list->m_get_item_index(string);
  if (index!=0)
    f_list->m_set_selected_item_index(index);
  else
    {
      if (!f_string_must_be_in_list)
	TEditZone::m_set_string(string);
    }
}

/*********************************************************************/
/* m_set_string_validated_callback : Dfinition du callback associ  */
/* -------------------------------    la modification du contenu de */
/*                                   la zone d'dition               */
/*********************************************************************/

void TComboBox::m_set_string_validated_callback(void (*string_validated_action)(PObject, const char *),
						const char *string_validated_argument)
{
  SetCallback(f_string_validated_action,f_string_validated_argument,
	      string_validated_action,string_validated_argument);
}

/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/

/**************************/
/* m_display : Affichage  */
/* ---------   de l'objet */
/**************************/

void TComboBox::m_display()
{
  m_display_arrow();
  TEditZone::m_display();
}

/*********************************************/
/* m_set_open : Ouvre/Ferme l'objet          */
/* ----------   (ne modifie pas l'affichage) */
/*********************************************/

void TComboBox::m_set_open(boolean open)
{
  if (!open)
    m_close_list();

  TEditZone::m_set_open(open);
}


/*********************************************************************/
/* m_left_button_pressed_event : L'utilisateur a cliqu dans l'objet */
/* ---------------------------   avec le bouton gauche               */
/*                               (l'objet tant activable).          */
/*                               Retourne TRUE si l'objet est        */
/*                               intress par cet vnement.        */
/*********************************************************************/

boolean TComboBox::m_left_button_pressed_event(int x,int y)
{
  int x_arrow;
  int x_edzone,y_edzone;
  int x1_combo_list,y1_combo_list,x2_combo_list,y2_combo_list;
  int old_selected_item_index;

  x_edzone=m_get_x();
  y_edzone=m_get_y();

  x_arrow=x_edzone+f_display_length+2;

  // Zone de saisie

  if ((y==y_edzone) && (x>=x_edzone) && (x<x_arrow))
    return(TEditZone::m_left_button_pressed_event(x,y));

  // Hors de la combo-liste avec liste ouverte

  if (((PComboList)f_list)->f_open)
    {
      x1_combo_list=f_list->m_get_x();
      x2_combo_list=x1_combo_list+((PComboList)f_list)->f_width-1;
      y1_combo_list=f_list->m_get_y();
      y2_combo_list=y1_combo_list+((PComboList)f_list)->f_height-1;

      if (   (x < x1_combo_list)
	  || (x > x2_combo_list)
	  || (y < y1_combo_list)
	  || (y > y2_combo_list))
	{
	  m_close_list();
	  JPRefresh();
	  WaitMouseLeftButtonRelease();
	  return(TRUE);
	}
    }

  // Flche (donc liste ferme)

  if ((y==y_edzone) && (x>=x_arrow) && (x<=(x_arrow+1)))
    {
      if (!f_focused)
	{
	  if (!m_set_focus())
	    return(FALSE);
	}

      m_open_list();
      JPRefresh();
    }

  if (((PComboList)f_list)->f_open)
    {
      // Dans combo-liste ou aprs appui sur la flche (sans relcher)

      ((PComboList)f_list)->f_mouse_went_into_list=FALSE;
      old_selected_item_index=((PComboList)f_list)->f_selected_item_index;
      ((PComboList)f_list)->f_always_one_item_selected=FALSE;
      ((PComboList)f_list)->f_update_edzone_when_selection_change=FALSE;

      ((PComboList)f_list)->m_left_button_pressed_event(x,y);
      ((PComboList)f_list)->f_update_edzone_when_selection_change=TRUE;
      ((PComboList)f_list)->f_always_one_item_selected=f_string_must_be_in_list;

      // La souris n'est pas alle dans la liste
      // (ex : scroll_bar), on ne ferme pas

      if (!((PComboList)f_list)->f_mouse_went_into_list)
	return(TRUE);

      if (((PComboList)f_list)->f_selected_item_index==0)
	{
	  ((PComboList)f_list)->f_update_edzone_when_selection_change=FALSE;
	  if (!f_list->m_set_selected_item_index(old_selected_item_index))
	    f_list->m_select_first_possible_item();
	  ((PComboList)f_list)->f_update_edzone_when_selection_change=TRUE;
	}

      if ((((PComboList)f_list)->f_selected_item_index!=0) || (f_string_must_be_in_list))
	m_set_string_from_selected_item();

      m_close_list();
   }

  return(TRUE);
}

/**************************************************************************/
/* m_left_button_double_click_event : L'utilisateur a double-cliqu dans  */
/* --------------------------------   l'objet avec le bouton gauche       */
/*                                    (l'objet tant activable et         */
/*                                    ayant dj subi l'vnement         */
/*                                    m_left_button_pressed_event)        */
/*                                    Retourne TRUE si l'objet est        */
/*                                    intress par cet vnement.        */
/**************************************************************************/

boolean TComboBox::m_left_button_double_click_event(int x,int y)
{
  int x_arrow;

  x_arrow=m_get_x()+f_display_length+2;

  // En arrivant ici, on est soit dans la liste, soit dans la flche,
  // soit dans la zone de saisie (flche et zone accole)

  // Zone de saisie

  if ((y==m_get_y()) && (x<x_arrow))
    return(TEditZone::m_left_button_double_click_event(x,y));

  // Flche ou liste

  return(FALSE);
}

/************************************************************************/
/* m_key_pressed_event : L'utilisateur a appuy sur une touche          */
/* -------------------   qui est propose  l'objet (qui est activable).*/
/*                       Retourne TRUE si l'objet est                   */
/*                       intress par cette touche.                    */
/************************************************************************/

boolean TComboBox::m_key_pressed_event(TKey key)
{
  if (f_focused)
    {
      switch (key.character)
	{
	  case ALT_UP       : m_close_list();
			      return(TRUE);
	  case ALT_DOWN     : m_open_list();
			      return(TRUE);
	  case RETURN       :
	  case ESC          : if (((PComboList)f_list)->f_open)
				{
				  if (key.character==RETURN)
				    {
				      if (((PComboList)f_list)->f_selected_item_index!=0)
					m_set_string_from_selected_item();
				    }
				  else
				    f_list->m_set_selected_item_index(f_selected_item_when_opening);

				  m_close_list();
				  return(TRUE);
				}
			      break;
	}
    }

  // On donne le focus  la liste mme si elle n'est pas ouverte
  // Sinon, la touche ne serait pas prise en compte par la liste

  if (!((PComboList)f_list)->f_focused)
    f_list->m_set_focus();

  if (((PComboList)f_list)->f_focused)
    {
      if (((PComboList)f_list)->m_key_pressed_event(key))
	return(TRUE);
    }

  // Enfin, on passe la touche  la zone de saisie

  return(TEditZone::m_key_pressed_event(key));
}

/***********************************************************************/
/* m_string_modified_callback : Appele en cas de modification de la   */
/* --------------------------   chane. Appel le callback associ s'il */
/*                              y en a un de dfini.                   */
/***********************************************************************/

void TComboBox::m_string_modified_callback()
{
  if (f_unselect_on_string_change)
    f_list->m_set_selected_item_index(0);

  TEditZone::m_string_modified_callback();
  if (!f_list->m_is_open())
    m_string_validated_callback();
}

/****************************************************************************/
/* m_string_validated_callback                                              */
/*--------------------------------------------------------------------------*/
/* Appel quand le contenu de la zone est valid.                           */
/****************************************************************************/

void TComboBox::m_string_validated_callback()
{
  CallCallback(this,f_string_validated_action,f_string_validated_argument);
}

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/


/****************************************************************************/
/* m_display_arrow                                                          */
/*--------------------------------------------------------------------------*/
/* Affiche la flche  ct de la zone de saisie                            */
/****************************************************************************/

void TComboBox::m_display_arrow()
{
  if (!f_open)
    return;

  if (f_enabled)
    f_window->m_textattr((WHITE<<4)+(unsigned)BLACK);
  else
    f_window->m_textattr((LIGHTGRAY<<4)+(unsigned)BLACK);

  f_window->m_gotoxy(m_get_x_in_window()+f_display_length+2,
		     m_get_y_in_window());


  f_window->m_display_arrow( (((PComboList)f_list)->f_open)?
			    ARROW_UP:
			    ARROW_DOWN);
}

/****************************************************************************/
/* m_close_list                                                             */
/*--------------------------------------------------------------------------*/
/* Ferme la liste                                                           */
/****************************************************************************/

void TComboBox::m_close_list()
{
  if (!((PComboList)f_list)->f_open)
    return;

  ((PComboList)f_list)->f_window->m_close();

  // Affichage de la flche

  m_display_arrow();

  m_string_validated_callback();
}

/****************************************************************************/
/* m_open_list                                                              */
/*--------------------------------------------------------------------------*/
/* Ouvre la liste                                                           */
/****************************************************************************/

void TComboBox::m_open_list()
{
  int         tmp;
  int         y_edzone;
  int         x_list,y_list;
  int         list_width,list_height;

  if (((PComboList)f_list)->f_open)
    return;

  f_selected_item_when_opening=((PComboList)f_list)->f_selected_item_index;

  // Slection d'un lment de la liste

  //  m_select_item_if_none_is_selected();

  // On rend l'lment slectionn visible

  if (((PComboList)f_list)->f_selected_item_index!=0)
    f_list->m_set_middle_visible_item_index(((PComboList)f_list)->f_selected_item_index);

  // On positionne la fentre de la liste

  y_edzone=m_get_y();
  list_height=((PComboList)f_list)->f_window->m_get_height();
  list_width =((PComboList)f_list)->f_window->m_get_width();

  if ((GetScreenHeight()-y_edzone)>=list_height)
    y_list=y_edzone+1;
  else
    y_list=y_edzone-list_height;

  x_list=m_get_x();

  if (x_list<1)
    x_list=1;

  tmp=GetScreenWidth();
  if (x_list+list_width>tmp+1)
    x_list=tmp+1-list_width;

  ((PComboList)f_list)->f_window->m_set_pos(x_list,y_list);

  // et on l'affiche

  ((PComboList)f_list)->f_window->m_open_as_object_element(this);

  // Affichage de la flche

  m_display_arrow();
}

/****************************************************************************/
/* m_select_item_is_none_is_selected                                        */
/*--------------------------------------------------------------------------*/
/* Slectionne le premier lment possible de la liste si aucun n'est       */
/* slectionn, et le positionne au milieu de la liste                      */
/****************************************************************************/

void TComboBox::m_select_item_if_none_is_selected()
{
  if (((PComboList)f_list)->f_selected_item_index==0)
    {
      f_list->m_select_first_possible_item();
      JPRefresh();
    }
}

/****************************************************************************/
/* m_set_string_from_selected_item                                          */
/*--------------------------------------------------------------------------*/
/* Recopie le texte de l'lment slectionn de la liste (s'il y en a un)   */
/* dans la zone de saisie.						    */
/****************************************************************************/

void TComboBox::m_set_string_from_selected_item()
{
  char old_char=0;
  boolean too_long;
  char *string;

  if (((PComboList)f_list)->f_selected_item_index==0)
    string="";
  else
    string=f_list->m_get_item(((PComboList)f_list)->f_selected_item_index);

  f_modification_enabled=TRUE;
  too_long=(boolean)(strlen(string)>(unsigned)f_max_length);

  if (too_long)
    {
      old_char=string[f_max_length];
      string[f_max_length]=0;
    }

  f_unselect_on_string_change=FALSE;
  TEditZone::m_set_string(string);
  f_unselect_on_string_change=TRUE;

  if (too_long)
    string[f_max_length]=old_char;

  if (f_string_must_be_in_list)
    f_modification_enabled=FALSE;
}

