/****************************************************************************/
/* TLABEL                                                                   */
/*--------------------------------------------------------------------------*/
/* Objet TLabel (Etiquette)                                                 */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 19/01/95                                                    */
/****************************************************************************/

#include <conio.h>

#include "Strings.h"

#include "TWindow.h"

#include "TLabel.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x, rel_y     : Coordonnes de l'tiquette p/r au groupe              */
/* text             : Texte de l'tiquette                                  */
/****************************************************************************/

TLabel::TLabel(PObject parent,
	       int rel_x,int rel_y,
	       const char *text)
       :TObject(parent,
		OBJ_LABEL,
		rel_x,rel_y,
		GetTextWidth(text),
		GetTextHeight(text),
		(parent==NULL)?((unsigned)WHITE):parent->m_get_background(),
		"",
		DISABLED,
		FALSE,  // NOT_FOCUS_DEPENDING_ASPECT
		FALSE,  // CANNOT_BE_ENABLED
		TRUE)   // SIMPLE
{
  f_text=NULL;
  m_set_text(text);
}

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x, rel_y     : Coordonnes de l'tiquette p/r au groupe              */
/* width, height    : Dimensions de l'tiquette                             */
/* text             : Texte de l'tiquette                                  */
/****************************************************************************/

TLabel::TLabel(PObject parent,
	       int rel_x,int rel_y,
	       int width,int height,
	       const char *text)
       :TObject(parent,
		OBJ_LABEL,
		rel_x,rel_y,
		width,height,
		(parent==NULL)?((unsigned)WHITE):parent->m_get_background(),
		"",
		DISABLED,
		FALSE,  // NOT_FOCUS_DEPENDING_ASPECT
		FALSE,  // CANNOT_BE_ENABLED
		TRUE)   // SIMPLE
{
  f_text=NULL;
  m_set_text(text);
}


/***************/
/* Destructeur */
/* ----------- */
/***************/

TLabel::~TLabel()
{
  // Destruction des variables dynamiques

  if (f_text!=NULL)
    {
      delete [] f_text;
      f_text=NULL;
    }
}

/****************************************************************************/
/* m_set_text                                                               */
/*--------------------------------------------------------------------------*/
/* Modifie le texte du label                                                */
/****************************************************************************/

void TLabel::m_set_text(const char *text)
{
  int x=m_get_x_in_window();
  int y=m_get_y_in_window();

  if (f_text!=NULL)
    {
      delete []f_text;
      if (f_open)
        {
          f_window->m_set_clip_window(x,y,f_width,f_height);
          f_window->m_cls(f_background);
          f_window->m_reset_clip_window();
        }
    }

  f_text=new char [strlen(text)+1];
  strcpy(f_text,text);
  m_display();
}

/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/**************************/
/* m_display : Affichage  */
/* ---------   de l'objet */
/**************************/

void TLabel::m_display()
{
  int x,y;

  if (!f_open)
    return;

  x=m_get_x_in_window();
  y=m_get_y_in_window();

  f_window->m_set_normal_attr(f_background);
  f_window->m_set_clip_window(x,y,f_width,f_height);
  f_window->m_gotoxy(x,y);
  f_window->m_put_text(f_text);
  f_window->m_reset_clip_window();
}
