/****************************************************************************/
/* TPUSHBUT                                                                 */
/*--------------------------------------------------------------------------*/
/* Objet TPushButton (bouton  presser)                                     */
/****************************************************************************/

#ifndef _TPUSHBUT_H_
#define _TPUSHBUT_H_

#include "Types.h"

#include "Keyboard.h"

#include "TObject.h"

// Types des boutons (types cumulables par l'oprateur |)

#define  PB_NORMAL            0
#define  PB_DEFAULT           1  // 000000000001
#define  PB_CANCEL            2  // 000000000010

// Dure d'enfoncement d'un bouton lors de son appui par appel  m_press
// (en ms)

#define PRESSURE_TIME_LENGTH 75

class TPushButton:public TObject
{
  /*-------------*/
  /* Objets amis */
  /*-------------*/

  friend TWindow;  // Pour que la fentre puisse accder directement
		   // aux boutons spciaux

  /*------------------*/
  /* Protected fields */
  /*------------------*/

  protected:

    // Shadows

    TShadowChoice f_shadows;


  /*----------------*/
  /* Private fields */
  /*----------------*/

  private:

    // Bouton enfonc ou non

    boolean f_pressed;

    // Bouton enfonc par action sur le clavier

    boolean f_pressed_by_key;

    //    Bouton actionnable par RETURN
    // et bouton actionnable par ESCAPE

    boolean f_ok_button;
    boolean f_cancel_button;

    // Callback : Fonction appele si on presse et relche le bouton
    //            et son argument

    void (*f_pressed_action)(PObject, const char *);
    const char *f_pressed_argument;
    JPTUI::base_callback_t* pressed_callback;
    string pressed_callback_argument;


  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		    TPushButton(PObject parent,
				int rel_x,int rel_y,
				int width,
				const char *caption,
				int  type=PB_NORMAL,
				TShadowChoice shadows=SHC_BOTH,
				boolean enabled=TRUE);

    virtual	    ~TPushButton();

    // Appui sur le bouton

            void    m_press();


    // Dfinition des callbacks

	    void    m_set_pressed_callback(void (*pressed_action)(PObject, const char *),
					   const char *pressed_argument);

            void    set_pressed_callback(JPTUI::base_callback_t* a_callback,
		  	                 const char* a_callback_argument);
  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:

    // Prise/Perte du focus

    virtual void    m_lose_focus();
    virtual void    m_take_focus();


  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Affichage

    virtual void    m_display_focus_depending_part();
    virtual void    m_display_caption();

    // Le bouton devient/n'est plus
    // le ok_button ou le cancel_button

	    void    m_take_ok();
	    void    m_lose_ok();
	    void    m_take_cancel() { f_cancel_button=TRUE; };
	    void    m_lose_cancel() { f_cancel_button=FALSE; };

  protected: // Fix: to be able to redefine
    // Evnements

    virtual boolean m_left_button_pressed_event(int x,int y);
    virtual boolean m_key_pressed_event(TKey key);

};

#endif