/****************************************************************************/
/* TRDIOGRP                                                                 */
/*--------------------------------------------------------------------------*/
/* Objet TRadioGroup (groupe de boutons radio)                              */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/95                                                    */
/****************************************************************************/

#include <stdlib.h>


#include "Const.h"
#include "Debug.h"

#include "Mouse.h"

#include "TRdioBut.h"

#include "TRdioGrp.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x,rel_y      : Coordonnes du groupe p/r  son groupe                */
/* width,height     : Dimensions du groupe                                  */
/* caption          : Lgende du groupe (hot-key prcd de ~)              */
/* enabled          : ENABLED si le groupe est activable (DISABLED sinon)   */
/****************************************************************************/

TRadioGroup::TRadioGroup(PObject parent,
                         int rel_x,int rel_y,
                         int width,int height,
			 char *caption,
			 boolean enabled)
            :TFrame(parent,
                    rel_x,rel_y,
                    width,height,
		    caption,
		    enabled)

{
  // Bouton coch

  f_checked_radio_button=NULL;
}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TRadioGroup::~TRadioGroup()
{
}


/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/**************************************************************/
/* m_change_checked_radio_button_to : La coche passe au radio */
/* --------------------------------   bouton indiqu          */
/**************************************************************/

void TRadioGroup::m_change_checked_radio_button_to(int radio_button_number)
{
  PObject object;

  if (f_checked_radio_button!=NULL)
    {
      if (f_checked_radio_button->m_get_number()==radio_button_number)
	return;
      f_checked_radio_button->m_lose_check();
    }

  object=m_object_number_to_element(radio_button_number);

  DEBUG_TEST((object->m_get_type())==OBJ_CHECK_BOX);

  f_checked_radio_button=(PRadioButton)(object);
  f_checked_radio_button->m_take_check();
}

