/****************************************************************************/
/* TTABGRP                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TTabGroup (Groupe d'onglets)                                       */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 29/05/95                                                    */
/****************************************************************************/

#include <conio.h>
#include <stdlib.h>

#include "Const.h"
#include "JPDebug.h"

#include "JPAppli.h"

#include "Callback.h"
#include "Mouse.h"
#include "Screen.h"
#include "SpChars.h"

#include "TWindow.h"

#include "TTab.h"
#include "TTabGrp.h"


/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************************************************************************/
/* Constructeur                                                             */
/*--------------------------------------------------------------------------*/
/* parent           : Objet auquel appartient l'objet                       */
/* type             : Type du groupe                                        */
/* rel_x,rel_y      : Coordonnes du groupe p/r  son groupe                */
/* width,height     : Dimensions du groupe                                  */
/* enabled          : ENABLED si le groupe est activable (DISABLED sinon)   */
/****************************************************************************/

TTabGroup::TTabGroup(PObject parent,
		     int rel_x,int rel_y,
		     int width,int height,
		     unsigned background,
                     boolean enabled)
          :TGroup(parent,
	          OBJ_TAB_GROUP,
	          rel_x,rel_y,
	          width,height,
	          background,
	          "",
                  enabled,
		  TRUE,  // FOCUS_DEPENDING_ASPECT
		  TRUE,  // CAN_BE_ENABLED,
		  TRUE)  // NEED_FOCUSED_ELEMENT
{
  // Nombre d'onglets en largeur

  f_nb_tabs_width=2;

  // Onglet visible

  f_visible_tab=NULL;
}

/****************************************************************************/
/* Destructeur                                                              */
/*--------------------------------------------------------------------------*/
/****************************************************************************/

TTabGroup::~TTabGroup()
{
}

/****************************************************************************/
/* m_set_focus                                                              */
/*--------------------------------------------------------------------------*/
/* Pour un objet simple ou compos, donne le focus  l'objet.               */
/* Pour un groupe, donne le focus au premier lment du groupe qui l'accepte*/
/* (ici, essaie d'abord de le donner  l'onglet visible)                    */
/* Retourne TRUE en cas de prise effective du focus.                        */
/****************************************************************************/

boolean TTabGroup::m_set_focus()
{
  PObjectNode node;
  boolean found;

  if (!f_enabled)
    return(FALSE);

  if (f_visible_tab!=NULL)
    {
      if (f_visible_tab->object->m_set_focus())
	return(TRUE);
    }

  node=f_element_list;
  found=FALSE;

  while ((node!=NULL) && (node!=f_visible_tab) && (!found))
    {
      if (node->object->m_set_focus())
	found=TRUE;
      else
	node=node->next;
    }

  return(found);
}

/****************************************************************************/
/* m_set_focus_to_last_element                                               */
/*--------------------------------------------------------------------------*/
/* Pour un objet simple ou compos, donne le focus  l'objet.               */
/* Pour un groupe, donne le focus au dernier lment du groupe qui l'accepte*/
/* Retourne TRUE en cas de prise effective du focus.                        */
/****************************************************************************/

boolean TTabGroup::m_set_focus_to_last_element()
{
  PObjectNode node;
  boolean found;

  if (!f_enabled)
    return(FALSE);

  if (f_visible_tab!=NULL)
    {
      if (f_visible_tab->object->m_set_focus_to_last_element())
        return(TRUE);
    }

  node=f_last_element;
  found=FALSE;

  while ((node!=NULL) && (node!=f_visible_tab) && (!found))
    {
      if (node->object->m_set_focus_to_last_element())
	found=TRUE;
      else
	node=node->last;
    }

  return(found);
}

/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/


/****************************************************************************/
/* m_add_element :                                                           */
/*--------------------------------------------------------------------------*/
/* Ajout un onglet au groupe et retourne le numro qui lui est attribu     */
/****************************************************************************/

int TTabGroup::m_add_element(PObject object)
{
  int object_number;

  JPDEBUG_TEST(DEBUG_ERROR_7,(object->m_get_type())==OBJ_TAB);

  object_number=TGroup::m_add_element(object);

  if (f_visible_tab==NULL)
    f_visible_tab=f_last_element;

  if (f_nb_elements>f_nb_tabs_width)
    f_nb_tabs_width=f_nb_elements;

  return(object_number);
}

/****************************************/
/* m_del_element : Supprime un lment  */
/* -------------   de l'objet           */
/****************************************/

void TTabGroup::m_del_element(int object_number)
{
  PObjectNode node;

  node=m_object_number_to_element_node(object_number);

  if (f_visible_tab==node)
    f_visible_tab=NULL;

  TGroup::m_del_element(object_number);

  if (f_visible_tab==NULL)
    f_visible_tab=f_last_element;

};

/****************************************************************************/
/* m_set_open                                                               */
/*--------------------------------------------------------------------------*/
/* Ouvre ou ferme le groupe d'onglets (et l'onglet visible)                 */
/****************************************************************************/

void TTabGroup::m_set_open(boolean open)
{
  if (open==f_open)
    return;

  if (f_visible_tab!=NULL)
    m_set_element_open(f_visible_tab->object,open);

  f_open=open;

  // A la fermeture, on se replace sur le premier onglet

  if (!open)
    {
      if (f_nb_elements!=0)
	f_visible_tab=f_element_list;

      m_closed_callback();
    }
  else
    {
      m_opened_callback();
    }
}

/****************************************************************************/
/* m_display                                                                */
/*--------------------------------------------------------------------------*/
/* Affichage du groupe d'onglets (et de l'onglet visible)                   */
/****************************************************************************/

void TTabGroup::m_display()
{
  int x1,y1,x2,y2;
  char char_left,char_right;

  register int i;

  unsigned parent_background=f_parent->m_get_background();

  if (!f_open)
    return;

  x1=m_get_x_in_window();
  y1=m_get_y_in_window();
  x2=x1+f_width-1;
  y2=y1+f_height-1;

  f_window->m_textattr((f_background<<4)+(unsigned)WHITE);
  f_window->m_gotoxy(x1,y1+1);
  f_window->m_putch(SPECIAL_CHAR(SCH_TABGROUP_UP_LEFT));
  f_window->m_putnch(f_width-2,SPECIAL_CHAR(SCH_TABGROUP_UP));
  f_window->m_putch(SPECIAL_CHAR(SCH_TABGROUP_UP_RIGHT));

  char_left=SPECIAL_CHAR(SCH_TABGROUP_LEFT);
  char_right=SPECIAL_CHAR(SCH_TABGROUP_RIGHT);

  for (i=y1+2;i<y2;i++)
    {
      f_window->m_gotoxy(x1,i);
      f_window->m_putch(char_left);
      f_window->m_gotoxy(x2,i);
      f_window->m_putch(char_right);
    };

  f_window->m_gotoxy(x1,y2);
  f_window->m_putch(SPECIAL_CHAR(SCH_TABGROUP_BOTTOM_LEFT));
  f_window->m_putnch(f_width-2,SPECIAL_CHAR(SCH_TABGROUP_BOTTOM));
  f_window->m_putch(SPECIAL_CHAR(SCH_TABGROUP_BOTTOM_RIGHT));

  // Fond

  f_window->m_set_clip_window(x1+1,y1+2,f_width-2,f_height-3);
  f_window->m_cls(f_background);
  f_window->m_reset_clip_window();

  // Ombres

  f_window->m_textattr((parent_background<<4)+(unsigned)BLACK);
  f_window->m_gotoxy(x2+1,y1+1);
  f_window->m_putch('');

  x2++;
  for (i=y1+2;i<=y2;i++)
    {
      f_window->m_gotoxy(x2,i);
      f_window->m_putch('');
    };
  x2--;

  f_window->m_gotoxy(x1+1,y2+1);
  f_window->m_putnch(f_width,'');

  // Affichage des onglets

  for (i=1;i<=f_nb_elements;i++)
    m_display_tab_caption(i);


  m_display_focus_depending_part();

  if ((f_elements_display_enabled) && (f_visible_tab!=NULL))
    m_display_element(f_visible_tab->object);
}


/*********************************************************************/
/* m_left_button_pressed_event : L'utilisateur a cliqu dans l'objet */
/* ---------------------------   avec le bouton gauche               */
/*                               (l'objet tant activable).          */
/*                               Retourne TRUE si l'objet est        */
/*                               intress par cet vnement.        */
/*********************************************************************/

boolean TTabGroup::m_left_button_pressed_event(int x,int y)
{
  int button_state;
  register int i;
  int  last_tab_clicked;
  int  rel_x1,rel_x2;

  boolean found;

  int  x1=m_get_x();
  int  y1=m_get_y();

  if (!f_focused)
    {
      if (!m_set_focus())
	return(FALSE);
    }

  // A-t-on cliqu sur un onglet

  if (y==y1)
    {
      button_state=LEFT_BUTTON_PRESSED;
      last_tab_clicked=0;

      while (button_state==LEFT_BUTTON_PRESSED)
	{
	  if (y==y1)
	    {
	      i=f_nb_elements;
	      found=FALSE;
	      while ((i>=1) && (!found))
		{
		  m_get_tab_caption_pos(i,rel_x1,rel_x2);
		  if ((x>=(x1+rel_x1)) && (x<=(x1+rel_x2)))
		    found=TRUE;
		  else
		    i--;
		}

	      if (found)
		{
		  if (i!=last_tab_clicked)
		    {
		      m_object_number_to_element(i)->m_set_focus();
		      JPRefresh();
		      last_tab_clicked=i;
		    }
		}
	    }
	  GetMouseState(x,y,button_state);
	}
      return(TRUE);
    }

  // sinon, on propose l'vnement  l'onglet visible

  if (f_visible_tab!=NULL)
    return(m_left_button_pressed_event_on(f_visible_tab->object,x,y));

  return(FALSE);
}


/**************************************************************************/
/* m_left_button_double_click_event : L'utilisateur a double-cliqu dans  */
/* --------------------------------   l'objet avec le bouton gauche       */
/*                                    (l'objet tant activable et         */
/*                                    ayant dj subi l'vnement         */
/*                                    m_left_button_pressed_event)        */
/*                                    Retourne TRUE si l'objet est        */
/*                                    intress par cet vnement.        */
/**************************************************************************/

boolean TTabGroup::m_left_button_double_click_event(int x,int y)
{
  int  y1=m_get_y();

  if (!f_focused)
    {
      if (!m_set_focus())
	return(FALSE);
    }

  // A-t-on cliqu sur un onglet

  if (y==y1)
    return(FALSE);

  // sinon, on propose l'vnement  l'onglet visible

  if (f_visible_tab!=NULL)
    return(m_left_button_dbl_click_event_on(f_visible_tab->object,x,y));

  return(FALSE);
}

/************************************************************************/
/* m_key_pressed_event : L'utilisateur a appuy sur une touche          */
/* -------------------   qui est propose  l'objet (qui est activable) */
/*                       Retourne TRUE si l'objet est                   */
/*                       intress par cette touche.                    */
/************************************************************************/

boolean TTabGroup::m_key_pressed_event(TKey key)
{
  PObjectNode node;

  // On regarde si l'objet qui a dj le focus est intress par la touche
  // Cet objet est forcment activable

  if (f_focused_element!=NULL)
    if (m_key_pressed_event_on(f_focused_element->object,key))
      return(TRUE);

  // On regarde si c'est la hot-key d'un onglet

  node=f_element_list;

  while (node!=NULL)
    {
      if (key.hot_character==node->object->m_get_hot_key())
	{
	  if (node->object->m_set_focus())
	    return(TRUE);
	}
      node=node->next;
    }

  // On regarde si c'est une touche de dplacement entre les onglets
  //  condition que le groupe ait le focus

  if (f_focused)
    {
      switch (key.character)
	{
	  case LEFT : return(m_set_focus_to_previous_element());
	  case RIGHT: return(m_set_focus_to_next_element());
	}
    }

  // sinon, on propose l'vnement  l'onglet visible

  if (f_visible_tab!=NULL)
    {
      if (f_visible_tab!=f_focused_element)
	return(m_key_pressed_event_on(f_visible_tab->object,key));
    }

  return(FALSE);
}

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/


/****************************************************************************/
/* m_display_focus_depending_part                                           */
/*--------------------------------------------------------------------------*/
/* Affiche la partie de l'objet dont l'aspect dpend du focus.              */
/****************************************************************************/

void TTabGroup::m_display_focus_depending_part()
{
  if ((f_open) && (f_visible_tab!=NULL))
    m_display_tab_caption(f_visible_tab->object->m_get_number());
}

/****************************************************************************/
/* m_display_tab_caption                                                    */
/*--------------------------------------------------------------------------*/
/* Affiche le titre d'un onglet                                             */
/****************************************************************************/

void TTabGroup::m_display_tab_caption(int tab_nb)
{
  int x1,x2;
  int x,y;
  int width;
  char char1,char2;

  int visible_tab_nb;

  PTab        tab=(PTab)((m_object_number_to_element_node(tab_nb))->object);

  boolean     tab_caption_focused=FALSE;

  if (!f_open)
    return;

  JPDEBUG_TEST(DEBUG_ERROR_8,f_visible_tab!=NULL);

  m_get_tab_caption_pos(tab_nb,x1,x2);
  x=m_get_x_in_window();
  y=m_get_y_in_window();
  x1+=x;
  x2+=x;
  width=x2-x1+1;

  f_window->m_gotoxy(x1,y);
  visible_tab_nb=f_visible_tab->object->m_get_number();

  if (tab_nb==visible_tab_nb)
    {
      f_window->m_textattr((WHITE<<4)+(unsigned)BLUE);

      if (f_focused_element!=NULL)
	{
	  if (tab==f_focused_element->object)
	    {
	      if (tab->m_get_focused_element()==NULL)
		tab_caption_focused=TRUE;
	    }
	}

      if ((tab_caption_focused) && (f_window->m_is_active()))
	{
	  char1='[';
	  char2=']';
	}
      else
	{
	  char1=' ';
	  char2=' ';
	}

      f_window->m_putch(char1);
      f_window->m_put_caption(tab->m_get_caption(),TRUE,width-2,CENTERED_LEFT);
      f_window->m_putch(char2);
    }
  else
    {
      f_window->m_textattr((LIGHTGRAY<<4)+(unsigned)BLACK);
      if ((tab_nb!=1) && (tab_nb!=(visible_tab_nb+1)))
	f_window->m_putch(SPECIAL_CHAR(SCH_TAB_CAPTION_LEFT));

      else
	f_window->m_putch(' ');

      f_window->m_put_caption(tab->m_get_caption(),TRUE,width-2,CENTERED_LEFT);
      f_window->m_putch(' ');
    }

  if (tab_nb==f_nb_elements)
    {
      f_window->m_textattr( ((f_parent->m_get_background())<<4)+BLACK);
      f_window->m_gotoxy(x1+width,y);
      f_window->m_putch('');
    }
}

/****************************************************************************/
/* m_get_tab_caption_pos                                                    */
/*--------------------------------------------------------------------------*/
/* Retourne les coordonnes du titre de l'onglet                            */
/****************************************************************************/

void TTabGroup::m_get_tab_caption_pos(int tab_nb,int &rel_x1,int &rel_x2)
{
  rel_x1=((f_width-1)*(tab_nb-1))/f_nb_tabs_width;
  rel_x2=(((f_width-1)*(tab_nb))/f_nb_tabs_width)-1;
}

/****************************************************************************/
/* m_set_visible_tab                                                        */
/*--------------------------------------------------------------------------*/
/* Permet de choisir l'onglet visible (si possible)                         */
/****************************************************************************/

void TTabGroup::m_set_visible_tab(int tab_number)
{
  PObjectNode new_visible_tab;

  if (f_visible_tab!=NULL)
    {
      if ((f_visible_tab->object->m_get_number())==tab_number)
	return;
    }

  // Si le groupe d'onglets  le focus,
  // on regarde si l'onglet visible peut lacher le focus.
  // Si oui, on essaie de donner le focus au nouvel onglet
  // S'il le prend, il devient galement l'onglet visible

  if (f_focused)
    {
      if (!f_visible_tab->object->m_can_lose_focus())
	return;
    }

  new_visible_tab=m_object_number_to_element_node(tab_number);

  if (f_open)
    {
      m_set_element_open(f_visible_tab->object,FALSE);
      m_set_element_open(new_visible_tab->object,TRUE);
    }

  f_visible_tab=new_visible_tab;
  m_display();
  if (f_focused)
    new_visible_tab->object->m_set_focus();

  CallCallback(new_visible_tab->object,
	       PTab(new_visible_tab->object)->f_visible_action,
	       PTab(new_visible_tab->object)->f_visible_argument);
}
