/* -*- coding: cp852 -*- */
/** Windows Send Test
 * by Tomasz Zbroek
 * PUBLIC DOMAIN
 */

#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <winsock.h>
#include <errno.h>

void Test(const char *i_pAddr, const char *i_pPort)
{
  int nRes;
  int nSocket;
  struct sockaddr_in saServer;
  char szHost[254];
  const char szMessage[] = "Hello from Windows";

  nSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
  if(nSocket < 0)
    {
      printf("socket() error, res=%d, err=%d\n", nSocket, errno);
      return;
    }

  gethostname(szHost, 254);
  
  printf("TCP Service   : %s\n", i_pPort);
  printf("Host name     : %s\n", szHost);

  saServer.sin_family = AF_INET;          
  saServer.sin_port = htons(atoi(i_pPort));
  saServer.sin_addr.s_addr = inet_addr(i_pAddr);
  memset(saServer.sin_zero, '\0', sizeof saServer.sin_zero);

  nRes = connect(nSocket, (struct sockaddr *)&saServer, sizeof(saServer));
  if(nRes < 0)
    {
      printf("connect() error, res=%d, err=%d\n", nRes, errno);
      closesocket(nSocket);
      return;
    }

  nRes = send(nSocket, szMessage, strlen(szMessage), 0);
  if(nRes < 0)
    {
      printf("send() error, res=%d, err=%d\n", nRes, errno);
      closesocket(nSocket);
      return;
    }

  closesocket(nSocket);
}

int main(int argc, char *argv[])
{
  int nRes;

  const char aPort[] = "23";
  const char aAddr[] = "192.168.0.91";

  const char *pPort = NULL;
  const char *pAddr = NULL;

  if(argc > 1)
    pPort = argv[1];
  if(argc > 2)
    pAddr = argv[2];
  
  printf("Send Test\n");
  if(argc > 1) 
    if(strcmp(argv[1], "-h")==0)
      {
        printf("send.exe <PORT> <ADDRESS>\n\n");
        return 0;
      }

  if(pPort == NULL)
    pPort = aPort;
  if(pAddr == NULL)
    pAddr = aAddr;

  WSADATA wsaData;
  WORD wVersionRequested;
  wVersionRequested = MAKEWORD( 2, 2 );
 
  if(WSAStartup(wVersionRequested, &wsaData))
    {
      printf("Socket startup error\n");
      return 0;
    }

  Test(pAddr, pPort);

  WSACleanup();

  return 0;
}

