/* vpl3 - dispatched header to the VGA Planets I/O library, V3, by RLSystems
//  project  VPL
//  Comments For detailed information on version history, etc., please refer
//           to <vgap.h>, included in the package
*/
#ifndef VPL3
#ifdef VPL3_VPL_H
#error <vgap.h> already included!
#endif // VPL3_VPL_H
#endif // VPL3
#ifndef VPL3_VPL3_H
#define VPL3_VPL3_H
#ifdef __cplusplus
extern "C" {
#endif
/******************************************************************Defines*/
// type definitions
#ifndef word
  #define word unsigned short
#endif // word
#ifndef byte
  #define byte unsigned char
#endif // byte
#ifndef bool
  #define bool byte
#endif // bool
#ifndef false
  #define false 0
#endif // false
#ifndef true
  #define true !false
#endif // true
// VGAP definitions
#ifndef numPlanets
  #define numPlanets         500   // PLANETS has a fixed number of planets
#endif // numPlanets
#ifndef numMines
  #define numMines           500   // probable maximum number of mine fields
#endif // numMines
#ifndef planetNameLength
  #define planetNameLength   20    // As in file PLANET.NM
#endif // planetNameLength
#ifndef numRaces
  #define numRaces           11    // There are 11 races
#endif // numRaces
#ifndef numHulls
  #define numHulls           105   // Maximum number of hulls that can be read
#endif // numHulls
#ifndef numBeams
  #define numBeams           10    // Beam specs
#endif // numBeams
#ifndef numTorps
  #define numTorps           10    // Torp specs
#endif // numTorps
#ifndef numEngines
  #define numEngines         9     // Engine specs
#endif // numEngines
#ifndef numIonStorms
  #define numIonStorms       50    // maximum number of ion disturbances
#endif // numionStorms
#ifndef numUFOs
  #define numUFOs            1000
  // maximum number of UFOs
#endif // numUFOs
#ifndef maxMessageSize
  #define maxMessageSize     615   // 15 lines of 40 chars + CR
#endif // maxMessageSize
// VPL3 modes
#define NO_BUFFERING   0x00000001 // disables buffering game info by the lib
#define USE_SHIPS      0x00000002 // Add-on uses ships
#define USE_PLANETS    0x00000004 // Add-on uses planets
#define USE_STARBASES  0x00000008 // Add-on uses starbases
#define PLAYER_DATA    0x00000010 // Add-on uses player-side data (not available yet)
#define USE_RACES      0x00000020 // Add-on uses race information
#define USE_CONFIG     0x00000040 // Add-on uses configuration information
#define USE_MINEFIELDS 0x00000080 // Add-on uses mine fields
#define USE_IONSTORMS  0x00000100 // Add-on uses ion storms
#define USE_UFOS       0x00000200 // Add-on uses UFOs
#define DO_VALIDATE    0x00000400 // library will validate and repair data before writing it to databases
#define USE_MESSAGES   0x00000800 // Add-on uses messages (player-side utils only: host-side always has access to messages)
#define USE_ALL        (USE_SHIPS | USE_PLANETS | USE_STARBASES | USE_RACES | USE_CONFIG | USE_MINEFIELDS | USE_IONSTORMS | USE_UFOS | USE_MESSAGES)
/*******************************************************************Macros*/
long long root(long long X); // a macro helper
#define randomFCode(S) do {                                                \
  S[0] = (random() % 62);                                                  \
  S[1] = (random() % 62);                                                  \
  S[2] = (random() % 62);                                                  \
  S[0] = (((S[0] >= 0) && (S[0] <= 9))   ? (S[0] += '0') :                 \
         (((S[0] >= 10) && (S[0] <= 36)) ? (S[0] += ('A' - 10)) :          \
                                           (S[0] += ('a' - 37))));         \
  S[1] = (((S[1] >= 0) && (S[1] <= 9))   ? (S[1] += '0') :                 \
         (((S[1] >= 10) && (S[1] <= 36)) ? (S[1] += ('A' - 10)) :          \
                                           (S[1] += ('a' - 37))));         \
  S[2] = (((S[2] >= 0) && (S[2] <= 9))   ? (S[2] += '0') :                 \
         (((S[2] >= 10) && (S[2] <= 36)) ? (S[2] += ('A' - 10)) :          \
                                           (S[2] += ('a' - 37))));         \
} while (false)

#define moveShip(S) do {                                                      \
  if (((S)->speed != 0) && ((S)->xDisplacement != 0) && ((S)->yDisplacement != 0)) {\
    (S)->fuelUsed = (S)->engineFuelUsage[(S)->speed - 1];                           \
    (S)->distance = root(((S)->xDisplacement * (S)->xDisplacement) +                \
                      ((S)->yDisplacement * (S)->yDisplacement));                 \
    (S)->fuelUsed *= ((S)->mass / 10) ? ((S)->mass / 10) : (1);                     \
    (S)->fuelUsed *= (S)->distance;                                               \
    (S)->fuelUsed /= 10000;                                                     \
    if ((S)->fuelUsed > (S)->fuel) {                                              \
      (S)->distance *= (S)->fuel;                                                 \
      (S)->distance /= (S)->fuelUsed;                                             \
      (S)->fuelUsed = (S)->fuel;                                                  \
    }                                                                         \
    if ((S)->distance > ((S)->speed * (S)->speed)) {                                \
      if (((S)->hullClass > 44) && ((S)->hullClass < 46)) {                       \
        if ((S)->distance > (2 * (S)->speed * (S)->speed)) {                        \
          (S)->distance = (2 * (S)->speed * (S)->speed);                            \
        }                                                                     \
      } else {                                                                \
        (S)->distance = ((S)->speed * (S)->speed);                                  \
      }                                                                       \
    }                                                                         \
    (S)->newX = (S)->xDisplacement;                                               \
    (S)->newX *= (S)->distance;                                                   \
    (S)->newX /= root(((S)->xDisplacement * (S)->xDisplacement) +                   \
                   ((S)->yDisplacement * (S)->yDisplacement));                    \
    (S)->newX += (S)->xCoord;                                                     \
    (S)->newY = (S)->yDisplacement;                                               \
    (S)->newY *= (S)->distance;                                                   \
    (S)->newY /= root(((S)->xDisplacement * (S)->xDisplacement) +                   \
                   ((S)->yDisplacement * (S)->yDisplacement));                    \
    (S)->newY += (S)->yCoord;                                                     \
  } else {                                                                    \
    (S)->newX = (S)->xCoord;                                                      \
    (S)->newY = (S)->yCoord;                                                      \
  }                                                                           \
} while (false)
/*********************************************************Type definitions*/
typedef struct _shipRecordType { // record that holds all the ships info
  // identification of the ship
  short ID;                           /* R/O */ // the ship's unique ID#
  char  name[21];                               // the ship's name (NULL terminated - 20 chars)
  char  owner;                                  // the ship's owner (0 thru 11 - 0 = no ship)
  char  fCode[4];                               // the ship's friendly code (NULL terminated - 3 chars)
  // ship's status
  short crew;                                   // Ship's crew
  short crewExperience;                         // Experience level of the crew
  short damage;                                 // amount of damage ship sustained
  short mission;                                // current mission
  short primeEnemy;                             // ID of ship's prime enemy
  short shipInTow;                              // ID of the ship being towed
  short mass;                         /* R/O */ // mass of the ship with cargo, etc.
  short intercept;                              // ship being intercepted
  // movement of the ship
  short fuel;
  short speed;                                  // The ship's warp speed
  short xCoord, yCoord;                         // The ship's current coordinats
  short xDisplacement, yDisplacement;           // The ship's "displacement"
  short heading;                      /* R/O */ // Heading of the ship, see comment 1
  short newX, newY;                   /* R/O */ // The ship's coordinats after movement
  short numberOfEngines;              /* R/O */ // number of engines the ship has
  long  fuelUsed;                     /* R/O */ // The amount of fuel ship uses to fly from (xCoord,yCoord) to (newX,newY)
  long  engineFuelUsage[9];           /* R/O */ // Usage of fuel by the engine at different speeds
  long  distance;                     /* R/O */ // Distance travelled next turn
  // ship's technology
  char  hullTech;                               // tech level of the ship's hull
  char  engineTech;                             // tech level of the ship's engines
  char  beamTech;                               // tech level of the ship's beam weapons
  char  torpTech;                               // tech level of the ship's torpedo tubes
  // ship's hull specs
  char  hullClass;                              // class of the hull (1 thru 105)
  char  hullType[31];                 /* R/O */ // name of the hull type (NULL terminated - 30 chars)
  short picture;                      /* R/O */ // number of the hull's picture in RESOURCE.PLN
  short fueltankSize;                 /* R/O */ // Size of the hull's fuel tank
  short normalCrewSize;               /* R/O */ // normal ship'ss crew size
  short cargoBaySize;                 /* R/O */ // amount of cargo the ship can carry
  short maxBeams;                     /* R/O */ // maximal number of beam weapons on board
  short maxTubes;                     /* R/O */ // maximal number of torpedo tubes
  // ship's armament
  short numberOfBeamWeapons;                    // number of beam weapons on board
  short numberOfFighterBays;          /* R/O */ // number of fighter bays in the
  short numberOfTorpedoTubes;                   // number of torpedo tubes on board
  short numberOfTorpedoesOrFighters;            // number of torpedoes or fighters on board (if fighterbays are present - number of fighters. else number of torpedoes)
  // ship status
  bool  isCloaked;                              // true if cloaked - false if not (cloak failed etc)
  short shieldStatus;                           // percentage of current shields
  // beam specs
  char  beamType[21];                 /* R/O */ // Name of the beam type
  short beamKillPower;                /* R/O */ // kill power per beam weapon
  short beamExplosivePower;           /* R/O */ // explosive/destructive power per beam weapon
  // torp specs
  char  torpType[21];                 /* R/O */ // name of the torpedo type
  short torpCostMCs;                  /* R/O */ // cost in MCs per torpedo
  short torpCostTritanium;            /* R/O */ // cost in tritanium per torpedo
  short torpCostDuranium;             /* R/O */ // cost in duranium per torpedo
  short torpCostMolybdenum;           /* R/O */ // cost in molybdenum per torpedo
  short torpKillPower;                /* R/O */ // kill power per torpedo
  short torpExplosivePower;           /* R/O */ // explosive/destructive power per torpedo
  // ship's cargo
  short tritanium;                              // amount of tritanium in the cargo hold
  short duranium;                               // amount of duranium in the cargo hold
  short molybdenum;                             // amount of molybdenum in the cargo hold
  short colonists;                              // amount of colonist clans in the cargo hold
  short supplies;                               // amount of supply units in the cargo hold
  short megaCredits;                            // amount of money in the ship's vault.
  // cargo being unloaded
  short unloadFuel;                             // amount of fuel being unloaded
  short unloadTritanium;                        // amount of tritanium being unloaded
  short unloadDuranium;                         // amount of duranium being unloaded
  short unloadMolybdenum;                       // amount of molybdenum being unloaded
  short unloadColonists;                        // amount of colonist clans being unloaded
  short unloadSupplies;                         // amount of supply units being unloaded
  short unloadPlanet;                           // planet cargo is being unloaded to (0 if vented into space)
  // cargo being transferred ship-to-ship
  short transferFuel;                           // amount of fuel being transferred to another ship
  short transferTritanium;                      // amount of tritanium being transferred to another ship
  short transferDuranium;                       // amount of duranium being transferred to another ship
  short transferMolybdenum;                     // amount of molybdenum being transferred to another ship
  short transferColonists;                      // amount of colonist clans being transferred to another ship
  short transferSupplies;                       // amount of supply units being transferred to another ship
  short transferShip;                           // Ship cargo is being transferred to
} shipRecordType;

typedef struct _planetRecordType {
  // identification of the planet
  short ID;                       /* R/O */ // unique ID of the planet
  char  name[21];                           // name of the planet (NULL terminated - 20 chars)
  char  owner;                              // owner of the planet (0 thru 11 - 0 = unowned)
  char  fCode[4];                           // friendly code of the planet (NULL terminated - 3 chars)
  // coordinats of the planet
  short xCoord;                   /* R/O */ // X-coordinate of the planet
  short yCoord;                   /* R/O */ // Y-coordinate of the planet
  // buildings on the planet surface
  short mines;                              // amount of mines on the planet surface
  short factories;                          // amount of factories on the surface
  short defense;                            // amount of defense posts on the surface
  // colony specs
  short temperature;                        // temperature on the planet
  char  climate[21];                        // climate on the planet (NULL terminated - 20 chars)
  long  colonists;                          // colonists on the planet
  short colonistTaxRate;                    // tax rate for the colonists
  short colonistHappiness;                  // colonist happiness
  char  colonistAttitude[3][31];            // colonist attitude as text (NULL terminated - 30 chars)
  long  natives;                            // natives on the planet
  short nativeRace;                         // native race - number
  char  nativeRaceName[11];                 // name of native race (NULL terminated - 10 chars)
  short nativeTaxRate;                      // tax rate for the natives
  short nativeHappiness;                    // native happiness
  char  nativeAttitude[3][31];              // native attitude as text (NULL terminated - 20 chars)
  short nativeGovernment;                   // native government - number
  char  nativeGovernmentName[11];           // native government as text (NULL terminated - 10 chars)
  // resources on the planet surface
  long  supplies;                           // supply units on the planet
  long  megaCredits;                        // money on the planet
  long  surfaceNeutronium;                  // amount of neutronium (fuel) on the planet surface
  long  surfaceTritanium;                   // amount of tritanium on the planet surface
  long  surfaceDuranium;                    // amount of duranium on the planet surface
  long  surfaceMolybdenum;                  // amount of molybdenum on the planet surface
  long  newSupplies;              /* R/O */ // supply units on the planet next month/turn
  long  newMegaCredits;           /* R/O */ // money on the planet next month/turn
  long  newSurfaceNeutronium;     /* R/O */ // amount of neutronium (fuel) on the planet surface next month/turn
  long  newSurfaceTritanium;      /* R/O */ // amount of tritanium on the planet surface next month/turn
  long  newSurfaceDuranium;       /* R/O */ // amount of duranium on the planet surface next month/turn
  long  newSurfaceMolybdenum;     /* R/O */ // amount of molybdenum on the planet surface next month/turn
  // resources in the planet core
  long  coreNeutronium;                     // amount of neutronium (fuel) in the planet core
  long  coreTritanium;                      // amount of tritanium in the planet core
  long  coreDuranium;                       // amount of duranium in the planet core
  long  coreMolybdenum;                     // amount of molybdenum in the planet core
  short neutroniumDensity;                  // density of neutronium (fuel) in the planet core
  short tritaniumDensity;                   // density of tritanium in the planet core
  short duraniumDensity;                    // density of duranium in the planet core
  short molybdenumDensity;                  // density of molybdenum in the planet core
  // miscelanious specs
  bool buildStarbase;                       // true if there will be a starbase there next turn
} planetRecordType;

typedef enum {neither, fix, recycle} fixType;
typedef struct _starbaseRecordType {
  // identification of the starbase
  short ID;                         /* R/O */ // unique ID of the planet/starbase
  char  name[21];                   /* R/O */ // name of the planet (NULL terminated - 20 chars)
  char  owner;                                // owner of the planet (0 thru 11 - 0 = unowned)
  char  fCode[4];                   /* R/O */ // friendly code of the planet (NULL terminated - 3 chars)
  // coordinats of the planet
  short xCoord;                     /* R/O */ // X-coordinate of the planet
  short yCoord;                     /* R/O */ // Y-coordinate of the planet
  // tech levels
  char  engineTech;                           // engine tech level of the starbase
  char  hullTech;                             // hull tech level of the starbase
  char  beamTech;                             // beam weapon tech level of the starbase
  char  torpedoTech;                          // torpedo tech level of the starbase
  // status of the starbase
  short mission;                              // current mission of the starbase
  short defense;                              // defense units of the starbase
  short damage;                               // damage of the starbase
  // stored ship components
  short hullTypes[20];              /* R/O */ // Types of hulls the starbase can build
  short numberOfHulls[20];                    // Amount of each type in storage
  short numberOfEngines[9];                   // Amount of engine types (-1) in storage
  short numberOfBeams[10];                    // Amount of beam weapon types (-1) in storage
  short numberOfTorpedoTubes[10];             // Amount of torpedo tube types (-1) in storage
  // stored ship armament
  short numberOfTorpedoes[10];                // Amount of torpedo types (-1) in storage
  short numberOfFighters;                     // Amount of fighters in storage
  // Fixing & Recycling
  short   fixID;                              // ID of ship being fixed/recycled
  fixType fixOrRecycle;                       // what it's doing to ship fixID
  // building activities
  short buildHull;                            // Hull type (1 thru 20) being built
  short buildEngineTech;                      // Engine tech being fitted
  short buildBeamTech;                        // Beam tech being fitted
  short buildBeamCount;                       // Amount of beam weapons being fitted
  short buildTorpTech;                        // Torpedo tech being fitted
  short buildTubeCount;                       // Amount of tubes being fitted
  short buildFighterCount;                    // Amount of fighters being built (obsolete)
  // building costs
  short hullTritanium[20];          /* R/O */ // Amount of tritanium needed to build hull type
  short hullDuranium[20];           /* R/O */ // Amount of duranium needed to build hull type
  short hullMolybdenum[20];         /* R/O */ // Amount of molybdenum needed to build hull type
  short hullMegaCredits[20];        /* R/O */ // Amount of megacredits needed to build hull type
  short engineTritanium[9];         /* R/O */ // Amount of tritanium needed to build engine type (-1)
  short engineDuranium[9];          /* R/O */ // Amount of duranium needed to build engine type (-1)
  short engineMolybdenum[9];        /* R/O */ // Amount of molybdenum needed to build engine type (-1)
  short engineMegaCredits[9];       /* R/O */ // Amount of megacredits needed to build engine type (-1)
  short beamWeaponTritanium[10];    /* R/O */ // Amount of tritanium needed to build a beam weapon type (-1)
  short beamWeaponDuranium[10];     /* R/O */ // Amount of duranium needed to build a beam weapon type (-1)
  short beamWeaponMolybdenum[10];   /* R/O */ // Amount of molybdenum needed to build a beam weapon type (-1)
  short beamWeaponMegaCredits[10];  /* R/O */ // Amount of megacredits needed to build a beam weapon type (-1)
  short torpedoTubeTritanium[10];   /* R/O */ // Amount of tritanium needed to build a torpedo tube type (-1)
  short torpedoTubeDuranium[10];    /* R/O */ // Amount of duranium needed to build a torpedo tube type (-1)
  short torpedoTubeMolybdenum[10];  /* R/O */ // Amount of molybdenum needed to build a torpedo tube type (-1)
  short torpedoTubeMegaCredits[10]; /* R/O */ // Amount of megacredits needed to build a torpedo tube type (-1)
} starbaseRecordType;

typedef struct _raceRecordType { // see comment R3
  // race identification
  char  ID;                            // Unique ID (1 thru 11)
  char  raceType;                      // Type of race (1 thru 11 - may differ from ID with SwitchRace host)
  bool  isActive;                      // set if the race is active
  char  completeName[31];              // complete race name (NULL terminated - 30 chars)
  char  pluralName[21];                // plural form of the race's name (NULL terminated - 20 chars)
  char  adjectiveName[13];             // adjective form of the race's name (NULL terminated - 12 chars)
  // points
  short numberOfFreighters;            // total number of freighters (ships without weapons) the race has (one point each)
  short numberOfWarShips;              // total number of warships (ships with weapons) the race has (ten points each)
  short numberOfPlanets;               // total number of planets the race has (ten points each)
  short numberOfStarBases;             // total number of starbases the race has (120 points each)
  short priorityBuildPoints;           // total number of priority build points (aka kill points) the race has
  long  score;               /* R/O */ // total score (numFreighters + (10 * numWarShips) + (10 * numPlanets) + (120 * numStarBases))
  // race alliances
  bool  alliances[12];                 // alliances of the race (alliances[0] == 0 if none)
  // battle ratios
  short groundCombatAttack;  /* R/O */ // ground combat kill ratio
  short groundCombatDefend;  /* R/O */ // ground combat defense ratio
  short freeFighters;        /* R/O */ // amount of free fighters the race gets with a new starbase
  // economy ratios
  short mineRate;            /* R/O */ // mineral mining rate (multiplier)
  short taxRate;             /* R/O */ // native tax rate (multiplier)
  // passwords (player-side only); see comment R3
  char password[11];                   // password of the player - encrypted, 10 characters, NULL terminated
  char encryptionBytes[10];     /* R/O */ // bytes used for enxryption/decryption
  bool newPassword;                    // true if there's a new password - should be set when the password is changed.
  // misc. specs
  short buildableHulls[20];            // hulls the race can build.
} raceRecordType;

typedef struct _configType {
  struct {
    // Hull identification
    char  ID;                   /* R/O */ // unique ID of this hull type
    char  name[31];                       // name of this hull type (NULL terminated - 30 chars)
    short picture;                        // picture number in RESOURCE.PLN
    // resources required to build the hull
    short techLevel;                      // technology level required to build the hull
    short tritanium;                      // amount of tritanium required to build the hull
    short duranium;                       // amount of duranium required to build the hull
    short molybdenum;                     // amount of molybdenum required to build the hull
    short megaCredits;                    // amount of money required to build the hull
    // Setup of the hull
    short fueltankSize;                   // size of the hull's fuel tank
    short numberOfEngines;                // number of engines required for the hull
    short numberOfFighterBays;            // number of fighter bays in the hull
    short numberOfBeamWeapons;            // maximal number of beam weapons that can be fitted in the hull
    short numberOfTorpedoTubes;           // maximal number of torpedo tubes that can be fitted in the hull
    short cargoBaySize;                   // size of the hull's cargo bay
    // auxiliary information about the hull
    short crewSize;                       // normal size of the crew  for this type of ship
    short mass;                           // mass of the hull
  } hullSpecs[105];                       // hull type specifications
  struct {
    // engine identification
    char  ID;                   /* R/O */ // unique ID of this engine type
    char  name[21];                       // name of this engine type (NULL terminated - 20 chars)
    // resources required to build the engine
    short techLevel;                      // technpology level required to build the engine
    short tritanium;                      // amount of tritanium required to build the engine
    short duranium;                       // amount of duranium required to build the engine
    short molybdenum;                     // amount of molybdenum required to build the engine
    short megaCredits;                    // amount of money required to build the engine
    // fuel usage
    long  fuelUsage[9];                   // amount of fuel used at (indexed) warp speed, per unit of mass & distance
  } engineSpecs[9];                       // engine type specifications
  struct {
    // beam weapon identification
    char  ID;                   /* R/O */ // Unique ID of this beam weapon type
    char  name[21];                       // name of this beam weapon type (NULL terminated - 20 chars)
    // resources required to build this beam weapon
    short techlevel;                      // technology level required to build this beam weapon
    short tritanium;                      // amount of tritanium required to build the beam weapon
    short duranium;                       // amount of duranium required to build the beam weapon
    short molybdenum;                     // amount of molybdenum required to build the beam weapon
    short megaCredits;                    // amount of money required to build the beam weapon
    // auxiliary information about the beam weapon
    short mass;                           // mass of the beam weapon
    short killPower;                      // kill power of the beam weapon
    short explosivePower;                 // explosive/destructive power of the beam weapon
  } beamWeaponSpecs[10];                  // beam weapon type specifications
  struct {
    // torpedo type identification
    char  ID;                   /* R/O */ // Unique ID of this torpedo type
    char  name[21];                       // name of this torpedo type (NULL terminated - 20 chars)
    // resources required to build this torpedo/tube type
    short techlevel;                      // technology level required to build this torpedo/tube
    short tritanium;                      // amount of tritanium required to build the torpedo/tube
    short duranium;                       // amount of duranium required to build the torpedo/tube
    short molybdenum;                     // amount of molybdenum required to build the torpedo/tube
    short megaCreditsTorpedo;             // amount of money required to build the torpedo
    short megaCreditsTube;                // amount of money required to build the torpedo tube
    // auxiliary information about the torpedo type
    short mass;                           // mass of the torpedo tube
    short killPower;                      // kill power of the torpedo
    short explosivePower;                 // explosive/destructive power of the torpedo
  } torpedoSpecs[10];                     // torpedo type specifications
  // meteors
  short oddsLargeMeteor;                  // odds (percentage) one large meteor will drop on a random planet (in addition to the large meteors defined below)
  short oddsSallMeteorImpact;             // odds (percentage) a small meteor will drop on each planet
  long  smallMeteorMinimumNeutronium;     // minimum minerals in meteor - neutronium
  long  smallMeteorMinimumTritanium;      // minimum minerals in meteor - tritanium
  long  smallMeteorMinimumDuranium;       // minimum minerals in meteor - duranium
  long  smallMeteorMinimumMolybdenum;     // minimum minerals in meteor - molybdenum
  long  smallMeteorMaximumNeutronium;     // maximum minerals in meteor - neutronium
  long  smallMeteorMaximumTritanium;      // maximum minerals in meteor - tritanium
  long  smallMeteorMaximumDuranium;       // maximum minerals in meteor - duranium
  long  smallMeteorMaximumMolybdenum;     // maximum minerals in meteor - molybdenum
  short numberOfLargeMeteors;             // number of large meteors that will drop on random planets
  long  largeMeteorMinimumNeutronium;     // minimum minerals in meteor - neutronium
  long  largeMeteorMinimumTritanium;      // minimum minerals in meteor - tritanium
  long  largeMeteorMinimumDuranium;       // minimum minerals in meteor - duranium
  long  largeMeteorMinimumMolybdenum;     // minimum minerals in meteor - molybdenum
  long  largeMeteorMaximumNeutronium;     // maximum minerals in meteor - neutronium
  long  largeMeteorMaximumTritanium;      // maximum minerals in meteor - tritanium
  long  largeMeteorMaximumDuranium;       // maximum minerals in meteor - duranium
  long  largeMeteorMaximumMolybdenum;     // maximum minerals in meteor - molybdenum
  bool  sendMeteorMessages;               // true if meteor messages are sent
  // races
  short groundKillRatio[11];              // ground combat kill ratios (race - 1)
  short defenseKillRatio[11];             // ground combat defense factor (race - 1)
  short freeFighters[11];                 // number of free fighters on new starbases (race - 1)
  short mineRates[11];                    // mineral mining rates (race - 1)
  short taxRate[11];                      // tax rate multipliers (percentage; race - 1)
  bool  fedCrewBonus;                     // federation (race type 1) ships get a combat bonus (shields & weapons don't diminish with damage (between & during battle, resp.))
  bool  superRefit;                       // federation (race type 1) super refit
  bool  hissMission;                      // lizard (race type 2) hiss mission (paccify colonists & natives)
  short lizardMaxHiss;                    // the max that a lizard (race type 2) hiss mission can effect planet population (percentage of happiness added)
  bool  birdDecloak;                      // Are Birds decloaked by lokis?
  short spyBoost;                         // bird man (race type 3) super spy bonus
  bool  fascistNoATTNUK;                  // planets can't attack fascists (race type 4) with friendly code ATT or NUK
  short robFailRate;                      // the odds that the privateer (race type 5) rob mission will fail
  bool  robCloakedShips;                  // privateers (race type 5) rob cloaked ships
  bool  boardingParties;                  // privateers (race type 5) and crystals (race type 7) can capture an empty (fuel-less) ship with tow mission
  short cyborgAssimilation;               // cyborg assimulation rate (1-100%)
  bool  crystalsLikeHot;                  // crystals (race type 7) grow best at hot planets (temp 100)
  bool  webMines;                         // crystal (race type 7) web mines
  short darkSenseRange;                   // empire (race type 8) range of dark sense
  bool  robotBuildFighters;               // robots (race type 9) build fighters in space
  bool  rebelNoATTNUK;                    // planets can't attack rebels (race type 10) with friendly code ATT or NUK
  bool  rebelBuildFighters;               // rebels (race type 10) build fighters in space
  bool  groundAttack;                     // rebel (race type 10) ground attack
  bool  coloniesBuildFighters;            // colonies (race type 11) build fighters in space
  short coloniesFighterSweepRate;         // colonies (race type 11) fighter minesweep rate
  bool  coloniesFighterWebSweep;          // colonies (race type 11) fighter sweep web mines
  short buildableHulls[11][20];           // ship hulls the race can build
  // ships
  bool  moveWithoutFuel;                  // ships without fuel can move
  short colonizeRecycleRate;              // percentage of resources recycled from colonizing ships
  short sensorSweepRange;                 // range in LY of the sensor sweep mission
  short cloakBurn;                        // amount of fuel needed & burned to cloak a ship
  short oddsCloakFail;                    // percentage odds cloak ship failure
  short shipScanRange;                    // amount of LY within which a ship is scanned
  bool  imperialAssault;                  // empire (race type 8) super star destroyer can take planets with 10 clans (also works for other races with this ship)
  short alchemy;                          // alchemy ships (merlin & refinery) change minerals & supplies
  bool  engineShieldBonus;                // engine shield bonus shield
  short engineShieldBonusRate;            // engine shield bonus rate (percentage)
  bool  scienceMissions;                  // ship science missions (ram scoop, terraforming)
  short maxDamageCloak;                   // the amount of damage that prevents cloaking
  bool  singleEngineTow;                  // a ship with one engine can tow another
  bool  hyperSpaceJumps;                  // hyper space jumps with friendly code HYP (for PL21, B200 and Falcon)
  bool  chunneling;                       // warp chunnel (firecloud class)
  bool  gloryDevice;                      // fascist glory device (D19, Saber)
  bool  lokiDevice;                       // loki class anti-cloaking
  bool  gambling;                         // lady royal class gambing ships
  bool  cloakAttack;                      // cloaked ships can attack primary enemy
  bool  cloning;                          // ships can be cloned
  short cobolFreeFuelPerLY;               // amount of free fuel a Cobol makes per LY
  bool  ariesRefinery;                    // true if aries refine
  bool  bioScanners;                      // true if they exist
  // mine fields
  bool  minefields;                       // mine fields may be layed
  short maxMinefieldRadius;               // max mine field radius in lightyears
  short mineDecayRate;                    // mine field decay rate
  short webDecayRate;                     // web mine decay rate
  short oddsMineHit;                      // odds of hitting a mine per LY if flight
  short oddsWebMineHit;                   // odds of hitting a web mine per LY if flight
  short mineVisibleRange;                 // range that you can see mines in mine sweep
  bool  minesKillMines;                   // mines destroy enemy mines
  bool  minesDestroyWebs;                 // normal mines destroy web mines
  short mineSweepRange;                   // the range that a mine field can be sweeped
  short webSweepRange;                    // the range that a web field can be sweeped
  short mineSweepRate;                    // rate that beam weapons sweep mines
  short webSweepRate;                     // rate that beam weapons sweep web mines
  short cloakedMineHitOdds;               // the odds that a cloaked ship will hit a mine
  short hullTechNotSlowedByMineHits;      // hulltech not slowed by mine hits
  // planetary economy
  bool  newNativesAppear;                 // add new natives
  short isotopeTransmutationRate;         // new mineral form rate
  short structuralDecay;                  // decay of structures on underpopulated planet
  bool  overpopulationEatsSupplies;       // eat supplies?
  bool  climateLimitsPop;                 // climate limits population
  short colonistDeathRate;                // colonist death rate on bad climates
  long  maxPlanetaryIncome;               // maximum amount of money that the planet can make per turn
  // auxiliary planetary specs
  bool  gravityWells;                     // gravity wells (objects fall to planet if within 5 LY & at warp >1)
  bool  planetCanAttack;                  // planets attack ships with friendly codes ATT and NUK
  // ion storms
  short ionstormActivity;                 // 0%-100% The activity rating of Ion storms
  bool  ionsHideMines;                    // ion storms hide mines
  // auxiliary specs
  bool  deleteOldMessages;                // delete old messages
  bool  noPassword;                       // disable passwords
} configType;

typedef struct _minefieldRecordType {
  // identification of the mine field
  short ID;            /* R/O */ // Unique ID of the mine field
  short owner;                   // owner of the mine field
  // location of the mine field
  short xCoord;                  // X-coordinat of the mine field
  short yCoord;                  // Y coordinat of the mine field
  // size of the mine field
  long  numberOfMines;           // The total number of mines in the field
  short radius;        /* R/O */ // The radius of the mine field
  short maxRadius;     /* R/O */ // the maximal radius of a mine field
  // type of mine field
  bool  webType;                 // is web mine field
} minefieldRecordType;

typedef struct _ionstormRecordType {
  // identification of the ion storm
  short ID;            /* R/O */ // unique ID of the ion storm
  // strength of the ion storm
  short voltage;                 // voltage of the ion storm
  char  strength[21];            // textual - strength of the ion storm (NULL terminated - 20 chars)
  short radius;                  // size of the ion storm
  // location of the ion storm
  short xCoord;                  // X-coordinat of the ion storm
  short yCoord;                  // Y-coordinat of the ion storm
  // movement of the ion storm
  short speed;         /* R/O */ // warp speed of the ion storm
  short heading;                 // heading (in degrees - 0 is due North) of the ion storm
  short xDisplacement;           // movement along the X-axis of the ion storm
  short yDisplacement;           // movement along the Y-axis of the ion storm
  short newX, newY;    /* R/O */ // location next turn
} ionstormRecordType;

typedef struct _UFORecordType {
  // identification of the UFO
  short ID;        /* R/O */  // unique ID of the UFO
  // visible features on WinPlan map
  short marker;               // marker used on the map by WinPlan
  char  name[21];             // name of the UFO as displayed on map by WinPlan (NULL terminated - 20 chars)
  char  info1[21];            // first info line as displayed on map by WinPlan (NULL terminated - 20 chars)
  char  info2[21];            // second info line as displayed on map by WinPlan (NULL terminated - 20 chars)
  short rangeP;               // visibility range - within which name & marker can be seen (I think)
  short rangeS;               // visibility range - within which name, marker & info can be seen (I think)
  // location of the UFO
  short xCoord;               // X-coordinat of the UFO
  short yCoord;               // Y-coordinat of the UFO
  // movement of the UFO
  short speed;                // warp speed of the UFO
  short heading;              // heading (in degrees) of the UFO
  short newX, newY; /* R/O */ // approximate location of the UFO next turn
  // auxiliary data about the UFO
  short edge;                 // size of the UFO (radius in LY)
  short parent;               // code of the parent program (the add-on that created the UFO)
} UFORecordType;

typedef struct _hostRecordType {
  char  timestamp[18];         // time stamp of this turn
  short turn;                  // number of current turn/month
  word  hostID;                // unique ID number of the host - used only at player-side
} hostRecordType;

typedef struct _playerRecordType { // exclusively player-side data; see comment R3
  long  shipChecksum;       // bytewise checksum over SHIP??.DAT
  long  planetChecksum;     // bytewise checksum over PDATA??.DAT
  long  starbaseChecksum;   // bytewise checksum over BDATA??.DAT
  struct {
    short numberOfPlanets;    // total number of planets owned    ( 10p each)
    short numberOfFreighters; // total number of freighters owned (  1p each)
    short numberOfWarships;   // total number of warships owned   ( 10p each)
    short numberOfBases;      // total number of starbases owned  (120p each)
    long  score;              // score in points
  } scores[12];               // scores of all players (0 = sum, 1 thru 11 is race # 1 thru 11)
  char registrationName[25];  // name under which Planets was registered
  char registrationAdd[25];   // Additional registration info
} playerRecordType;

#define oMessageID(messNum,sender) ((messNum > 50) ? (-1) :                \
                                   ((messNum < 1) ? (-1) :                 \
                                   (((sender) * 50) + messNum)))
typedef struct _messageRecordType { // currently only player-side data; see comment R3
  short length;
  short sender;
  short recipient;
  char  body[maxMessageSize];
} messageRecordType;
/******************************************************************Globals*/
extern bool *doSave;
/*******************************************************Dispatcher methods*/
bool initVPL3(int mode, char *gamePath, char *basePath, short *numberOfShips, byte player);
/******************************************************************Readers*/
bool readConfig(configType *cfg);
bool readShip(shipRecordType *p, short record);
bool readPlanet(planetRecordType *p, short record);
bool readStarbase(starbaseRecordType *p, short record);
bool readRace(raceRecordType *r, short record);
bool readMinefield(minefieldRecordType *m, short record);
bool readIonstorm(ionstormRecordType *m, short record);
bool readUFO(UFORecordType *m, short record);
bool readHost(hostRecordType *hostRecord); // see comment R3
bool readPlayer(playerRecordType *playerRecord, short record); // see comment R3
bool readIncomingMessage(messageRecordType *messageRecord, short record); // see comment R3
bool readOutgoingMessage(messageRecordType *messageRecord, short record); // see comment R3
/******************************************************************Writers*/
bool writeConfig(configType *cfg);
bool writeShip(shipRecordType *p, short record);
bool writePlanet(planetRecordType *p, short record);
bool writeStarbase(starbaseRecordType *p, short record);
bool writeRace(raceRecordType *r, short record);
bool writeMinefield(minefieldRecordType *m, short record);
bool writeIonstorm(ionstormRecordType *m, short record);
bool writeUFO(UFORecordType *m, short record);
bool writeIncomingMessage(messageRecordType *messageRecord, short record); // see comment R3
bool writeOutgoingMessage(messageRecordType *messageRecord, short record); // see comment R3
/*****************************************************************Comments**
// R3 As of revision 3 (version 3.3.0) of the library, player-side data can
//    be read by add-ons & utilities at the player side. This prompted a
//    change in the raceRecordType, in which the passwords are stored at the
//    player side (the new fields are not used at the host side) and the
//    addition of three new types: the hostRecordType, which stores
//    host-specific data and general data about the turn (time stamp, turn
//    number and host ID) and is available both at the host and at the
//    player side - the hostID field is not available at the host side.
//    playerRecordType, which contains information specifically for the race
//    at the player-side, and can not be accessed at the host side. For
//    these structures, two new readers were added, but as all the data
//    stored in these new structures is read-only, no new writers
//    were added (well.. actually.. they were added, but can only be used by
//    the library during setup. readHost() is available both at the player
//    and the host sides, readPlayer() is only available at the player side.
//    The password fields of the raceRecordType are left empty at the host
//    side.
//    The third new structure is messageRecordType and is used to store
//    incoming and outgoing messages, currently only at the player side. At
//    the host side messages are stored differently than at the player side,
//    and the messages module is used to access them. Code to read messages
//    being passed along by the host is being designed, but
//    getMessagePointer() is not applicable yet.
// 1. The new HEADING field of the shipRecordType is only used when the X
//    and Y displacement are unknown, but the heading is - i.e. if the ship
//    is one picked up on "radar" on a wide range at the player side. At the
//    host side, this field is never used and left on 0.
***************************************************************************/
#ifdef __cplusplus
}
#endif
#endif // VPL3_VPL3_H
