typedef void (*FUNC) (void);


void xprintf (const char *fmt, ...);


/****************************************************************************/


void exec_something (void);
void __attribute__((weak)) lib2_main (void);


extern int exec_major;
int lib1_major = 3;
static int lib1_minor = 4;
extern int lib2_major;


void
lib1_something (void)
{
    xprintf("  lib1_something\n");
}


static void
execute_code (FUNC f)
{
    f();
}


void
lib1_main (void)
{
    /* call to global function here */
    lib1_something();
    /* indirect call here */
    execute_code(lib1_something);
    /* direct call to exec */
    /* access global variable here */
    /* access local variable here */
    /* access external variable from lib1 */
    xprintf("  lib1: %x.%x <- %x\n", lib1_major, lib1_minor, exec_major);
    /* call to local function here */
    /* indirect call to exec */
    execute_code(exec_something);
    /* access external variable from lib2 */
    xprintf("  lib1: %x.%x -> %x\n", lib1_major, lib1_minor, lib2_major);
    if (lib2_main) {
	/* direct call to lib2 */
	lib2_main();
	/* indirect call to lib2 */
	execute_code(lib2_main);
    }
}
