/*
 * dllink - dynamic linking system
 * Version:  0.1
 *
 * Copyright (C) 2005  Daniel Borca   All Rights Reserved.
 *
 * dllink is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * dllink is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Make; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "stubinfo.h"


/* The functions below assume that FS:0 -> transferbuffer, whose layout is:
 * 0000 - 0080		stubinfo
 * 0080 - 0100		DPMI register structure
 * 0100 - ????		data
 */


#define DPMI_AX %es:28(%edi)
#define DPMI_AH %es:29(%edi)
#define DPMI_BX %es:16(%edi)
#define DPMI_CX %es:24(%edi)
#define DPMI_DX %es:20(%edi)
#define DPMI_SI %es:04(%edi)
#define DPMI_DS %es:36(%edi)
#define DPMI_Fl %es:32(%edi)
#define DPMI_St %es:46(%edi)

		.text


	/* int dos_seek (int f, int offset) */
		.globl	dos_seek
		.type	dos_seek, @function
		.p2align 4
dos_seek:
		pushl	%ebx
		movl	0xc(%esp), %edx
		movl	0x8(%esp), %ebx
		movl	%edx, %ecx
		movl	$0x4200, %eax
		shrl	$16, %ecx
		int	$0x21
		jc	0f
		xorl	%eax, %eax
	0:
		popl	%ebx
		ret
		.size	dos_seek, .-dos_seek


	/* int dos_close (int f) */
		.globl	dos_close
		.type	dos_close, @function
		.p2align 4
dos_close:
		pushl	%ebx
		movb	$0x3e, %ah
		movl	0x8(%esp), %ebx
		int	$0x21
		jc	0f
		xorl	%eax, %eax
	0:
		andl	$0xffff, %eax
		popl	%ebx
		ret
		.size	dos_close, .-dos_close


	/* int dos_read (int handle, void *buffer, unsigned int count) */
		.globl	dos_read
		.type	dos_read, @function
		.p2align 4
dos_read:
		movl	4(%esp), %eax
		movl	8(%esp), %edx
		movl	12(%esp), %ecx
		pushl	%ebx
		pushl	%esi
		pushl	%edi
		pushl	%ebp
		pushl	%es
		pushl	%fs
		popl	%es
		movl	$0x80, %edi
		xorl	%esi, %esi
		movw	%ax, DPMI_BX
		movw	%fs:(STUBINFO_DS_SEGMENT), %si
		movw	%si, DPMI_DS
		movw	$0x100, DPMI_DX
		movw	$0x3202, DPMI_Fl
		movl	$0, DPMI_St
		shl	$4, %esi
		addl	$0x100, %esi
		movl	%edx, %ebp
		xorl	%eax, %eax
		xorl	%ebx, %ebx
	fread_chunk:
		jecxz	fread_ok
		movw	%fs:(STUBINFO_MINKEEP), %ax
		subl	$0x100, %eax
		cmpl	%eax, %ecx
		jae	fread_buffer
		movl	%ecx, %eax
	fread_buffer:
		movb	$0x3f, DPMI_AH
		movw	%ax, DPMI_CX
		pushl	%ecx
		pushl	%ebx
		xorl	%ecx, %ecx
		movl	$0x21, %ebx
		movl	$0x0300, %eax
		int	$0x31
		popl	%ebx
		popl	%ecx
		jc	fread_fail
		testb	$1, DPMI_Fl
		jnz	fread_fail
		movw	DPMI_AX, %ax
		pushl	%ds
		popl	%es
		pushl	%ecx
		pushl	%esi
		pushl	%edi
		xorl	%ecx, %ecx
		movw	%ax, %cx
		movl	%ebp, %edi
		rep;	movsb
		movl	%edi, %ebp
		popl	%edi
		popl	%esi
		popl	%ecx
		pushl	%fs
		popl	%es
		subl	%eax, %ecx
		addl	%eax, %ebx
		cmpw	%ax, DPMI_CX
		je	fread_chunk
	fread_ok:
		movl	%ebx, %eax
	fread_return:
		popl	%es
		popl	%ebp
		popl	%edi
		popl	%esi
		popl	%ebx
		ret
	fread_fail:
		movl	$-1, %eax
		jmp	fread_return
		.size	dos_read, .-dos_read


		.type	lib_path, @function
		.p2align 4
lib_path:
		xorl	%eax, %eax
		movw	%fs:(STUBINFO_PSP_SELECTOR), %es
		movw	%es:(0x2c), %es
		xorl	%ecx, %ecx
	0:
		cmpw	%ax, %es:(%ecx)
		je	1f
		cmpl	$0x4c5f444c, %es:(%ecx) /* LD_L */
		jne	2f
		cmpl	$0x41524249, %es:4(%ecx) /* IBRA */
		jne	2f
		cmpl	$0x505f5952, %es:8(%ecx) /* RY_P */
		jne	2f
		cmpl	$0x3d485441, %es:12(%ecx) /* ATH= */
		jne	2f
		leal	16(%ecx), %eax
		jmp	1f
	2:
		incl	%ecx
		jmp	0b
	1:
		ret
		.size	lib_path, .-lib_path


		.type	_dos_open_sfn, @function
		.p2align 4
_dos_open_sfn:
		pushl	%fs
		popl	%es
		xorl	%ecx, %ecx
		movl	$0x80, %edi
		movw	$0x3d00, DPMI_AX
		movw	$0x100, DPMI_DX
		movw	%fs:(STUBINFO_DS_SEGMENT), %ax
		movw	%ax, DPMI_DS
		movw	$0x3202, DPMI_Fl
		movl	%ecx, DPMI_St
		movl	$0x21, %ebx
		movl	$0x0300, %eax
		int	$0x31
		jc	sfn_fail
		testb	$1, DPMI_Fl
		jnz	sfn_fail
		movw	DPMI_AX, %ax
		ret
	sfn_fail:
		movl	$-1, %eax
		ret
		.size	_dos_open_sfn, .-_dos_open_sfn


		.type	_dos_open_lfn, @function
		.p2align 4
_dos_open_lfn:
		pushl	%fs
		popl	%es
		xorl	%ecx, %ecx
		movl	$0x80, %edi
		movw	$0x716c, DPMI_AX
		movw	%cx, DPMI_BX
		movw	%cx, DPMI_CX
		movw	$1, DPMI_DX
		movw	$0x100, DPMI_SI
		movw	%fs:(STUBINFO_DS_SEGMENT), %ax
		movw	%ax, DPMI_DS
		movw	$0x3202, DPMI_Fl
		movl	%ecx, DPMI_St
		movl	$0x21, %ebx
		movl	$0x0300, %eax
		int	$0x31
		jc	lfn_fail
		testb	$1, DPMI_Fl
		jnz	lfn_fail
		movw	DPMI_AX, %ax
		ret
	lfn_fail:
		movl	$-1, %eax
		ret
		.size	_dos_open_lfn, .-_dos_open_lfn


		.type	_dos_open, @function
		.p2align 4
_dos_open:
		pushl	%ebx
		pushl	%edi
		pushl	%es
		call	_dos_open_lfn
		testl	%eax, %eax
		jns	_dos_open_ret
		call	_dos_open_sfn
	_dos_open_ret:
		popl	%es
		popl	%edi
		popl	%ebx
		ret
		.size	_dos_open, .-_dos_open


	/* int dos_open (const char *path) */
		.globl	dos_open
		.type	dos_open, @function
		.p2align 4
dos_open:
		pushl	%esi
		pushl	%edi
		pushl	%es
	/* copy path down: STUBINFO_DS:0x100 */
		movl	16(%esp), %edx
		movl	$0x100, %edi
	put_simple:
		movb	(%edx), %al
		movb	%al, %fs:(%edi)
		incl	%edx
		incl	%edi
		testb	%al, %al
		jnz	put_simple
	/* try to open as-is */
		call	_dos_open
		testl	%eax, %eax
		jns	dos_open_ok
	/* check if the filespec contains a path specifier */
	0:
		movb	(%edx), %al
		testb	%al, %al
		jz	1f
		cmpb	$':', %al
		je	1f
		cmpb	$'/', %al
		je	1f
		cmpb	$'\\', %al
		je	1f
		incl	%edx
		jmp	0b
	1:
		testb	%al, %al
		jnz	dos_open_fail
	/* get LD_LIBRARY_PATH from environment */
		call	lib_path
		testl	%eax, %eax
		jz	dos_open_fail

		movl	%eax, %esi
	try:
		movl	16(%esp), %edx
		movl	$0x100, %edi
	put_path:
		movb	%es:(%esi), %al
		testb	%al, %al
		je	path_ok
		cmpb	$';', %al
		je	path_ok
		cmpb	$'/', %al
		jne	char_ok
		movb	$'\\', %al
	char_ok:
		movb	%al, %fs:(%edi)
		incl	%esi
		incl	%edi
		jmp	put_path
	path_ok:
		cmpb	$'\\', %fs:-1(%edi)
		je	put_name
		movb	$'\\', %fs:(%edi)
		incl	%edi
	put_name:
		movb	(%edx), %al
		movb	%al, %fs:(%edi)
		incl	%edx
		incl	%edi
		testb	%al, %al
		jnz	put_name

		call	_dos_open
		testl	%eax, %eax
		jns	dos_open_ok

		movb	%es:(%esi), %al
		incl	%esi
		testb	%al, %al
		jnz	try

	dos_open_fail:
		movl	$-1, %eax
	dos_open_ok:
		popl	%es
		popl	%edi
		popl	%esi
		ret
		.size	dos_open, .-dos_open
