/* ------- */
/* acosl.c */
/* ------- */
#include <errno.h>
#include <math.h>
#include <fdlibml.h>
#include <fenv.h>
/*
Written for DJGPP/GCC by KB Williams, 
kbwms@aol.com, December 2001 & October 2003
*/
long double
acosl(long double Arg)
//	0. If Arg is a NaN, set Retval to Arg.
//	1. If |Arg| > 1
//	   Set errno to EDOM, set Retval to NaN,
//	   raise invalid exception
//	2. If |Arg| == 1
//	   Retval = (Arg > 0) ? 0 : Pi
//	3. If Arg == 0
//	   Set Retval to Pi/2
//	4. Calculate acos(Arg) for
//	   x in (-1, -.5), or (+.5, +1) or [-.5, +.5]
{
    long double AbsArg, Retval;

    if (isnanl(Arg))			// Step 0
    {
    	Retval = Arg;
    }			       
    else if ((AbsArg = fabsl(Arg)) >= 1)// Steps 1 & 2
    {
	if (AbsArg > 1)
	{
	    __math_set_errno(EDOM);
	    Retval = NAN;		// Return NaN
	    __fp_raise_except(FE_INVALID);	// Raise invalid exception
	}
	else				// Arg == +- 1
	{
	    if (Arg > 0)		// acosl(1) = 0
		Retval = 0;
	    else			// acosl(-1) = pi
		Retval = PIL;
	}
    }
    else if (Arg == 0)			// Step 3
    {
	Retval = PIO2L;
    }
    else if (Arg < -0.5L)		// Step 4
    {
	Retval = (PIL - 2.0L * asinl(sqrtl(0.5L * (1.0L + Arg))));
    }
    else if (Arg > 0.5L)
    {
	Retval = (2.0L * asinl(sqrtl(0.5L * (1.0L - Arg))));
    }
    else
    {
	Retval = (PIO2L - asinl(Arg));
    }
    return Retval;
}
