/* ---------- */
/* errhndlr.c */
/* ---------- */

#include <errno.h>
#include <fenv.h>
#include <fdlibml.h>

static	int  __math_errhandling = MATH_ERRNO;
static	int  __ModeAlreadySet = 0;

// -----------------------------------------------------------------------
// __get_math_errhandling - Returns value of math_errhandling for this run
// -----------------------------------------------------------------------
int	__get_math_errhandling(void)
{
    __ModeAlreadySet = __math_errhandling;
    return  __math_errhandling;
}
// --------------------------------------------------------------
// __set_math_errhandling - Sets global variable math_errhandling
// --------------------------------------------------------------
int	__set_math_errhandling(int Value)
{
    int     Retval;

    if (__ModeAlreadySet)
    	Retval = -1;
    else if ((Value &= (MATH_ERRNO | MATH_ERREXCEPT)) == 0)
    	Retval = -1;
    else
    {
    	__math_errhandling = Value;
	Retval = __math_errhandling;
    }

    return Retval;
}
# if 0
// -----------------------------------------------------------
// __math_set_errno - Sets global variable errno when required
// -----------------------------------------------------------
void	__math_set_errno(int Value)
{
    if (__math_errhandling & MATH_ERRNO)	// Set errno when required
    {
    	errno = Value;
    }
}

// ------------------------------------------------------------------
// __fp_raise_except - Raises floating point exceptions when required
// ------------------------------------------------------------------
int __fp_raise_except(int Value)
{
    int     Retval = -1;			// Default Return Value

    if (__math_errhandling & MATH_ERREXCEPT)	// Raise exception when required
    {
    	Retval = feraiseexcept(Value);
    }

    return Retval;
}
# endif
