// Function fdiml()
//
// From ISO C99:
//
// Synopsis
//
//
//	#include <math.h>
//	long double fdiml(long double x, long double y);
//
// Description
//
// The fdiml function computes the floating-point positive
// difference, x - y.
//
// Returns
//
// For finite x and y, if x > y, fdiml() returns the value x - y.
// A value of 0 is returned otherwise.	The inexact exception
// flag is raised when either x or y is NaN or Infinite or x < y.
//
//
// Prepared for DJGPP/GNU by KB Williams, kbwms@aol.com,
// February 2002
//
#include <errno.h>
#include <fdlibml.h>
#include <fenv.h>

long double
fdiml(long double x, long double y);

long double
fdiml (long double x, long double y)
{
    long double Retval;

    if (isnanl(x) || isnanl(y))
    {
	Retval = NAN;
	__math_set_errno(EDOM);
	__fp_raise_except(FE_INEXACT);
    }
    else if (x <= y)
    {
	Retval = 0;
    }
    else				// x > y		
    {
    	feclearexcept(FE_OVERFLOW|FE_UNDERFLOW);

	Retval = x - y;

	if (fetestexcept(FE_OVERFLOW|FE_UNDERFLOW))
	{
	    __math_set_errno(ERANGE);
	}
	if (fetestexcept(FE_OVERFLOW))
	{
	    Retval = HUGE_VALL;
	}    		    		       
    }
    				       
    return Retval;
}
